/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.AbstractIndex;
import com.sapportals.trex.core.AttributeContainer;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.HttpDeIndexRequest;
import com.sapportals.trex.core.HttpIndexRequest;
import com.sapportals.trex.core.HttpIndexingRequest;
import com.sapportals.trex.core.HttpOptimizeRequest;
import com.sapportals.trex.core.HttpUpdateDocumentAttributesRequest;
import com.sapportals.trex.core.IndexDocument;
import com.sapportals.trex.core.base64.BASE64Encoder;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.util.List;

class HttpIndex
extends AbstractIndex {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$HttpIndex == null ? (class$com$sapportals$trex$core$HttpIndex = HttpIndex.class$("com.sapportals.trex.core.HttpIndex")) : class$com$sapportals$trex$core$HttpIndex).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$HttpIndex;

    HttpIndex() {
    }

    public void addDocument(IndexDocument doc) throws TrexException {
        if (this.documentList.size() > 0 && doc.getDocumentAction() != ((IndexDocument)this.documentList.get(0)).getDocumentAction()) {
            throw new TrexException(7267);
        }
        super.addDocument(doc);
    }

    public void setLastError(TrexReturn ret_) {
        this.ret = ret_;
    }

    public void formatIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 1);
        w.startElement("IndexDoc");
        w.dataElement("IndexID", this.indexID);
        if (this.queueServerFlag) {
            w.dataElement("useQueueServer", "YES");
        } else {
            w.dataElement("useQueueServer", "NO");
        }
        String contentString = null;
        w.startElement("DocList");
        int i = 0;
        while (i < this.documentList.size()) {
            String contentType;
            IndexDocument doc = (IndexDocument)this.documentList.get(i);
            w.startElement("Document");
            w.dataElement("DocID", doc.getDocumentKey());
            if (doc.getDocumentLanguage() != null) {
                w.dataElement("LAISO", doc.getDocumentLanguage());
            }
            if (doc.getContentCodepage() != null) {
                w.dataElement("CodePage", doc.getContentCodepage());
            }
            if (!doc.getClassificationRelevant()) {
                w.dataElement("ClassificationRelevantFlag", "NO");
            }
            if (!doc.getSearchRelevant()) {
                w.dataElement("SearchRelevantFlag", "NO");
            }
            String mimeType = doc.getMimeType();
            switch (doc.getDocumentType()) {
                case 1: {
                    contentType = "U";
                    contentString = doc.getUrl();
                    break;
                }
                case 4: {
                    contentType = "F";
                    contentString = doc.getFileName();
                    break;
                }
                case 2: {
                    contentType = "T";
                    break;
                }
                case 3: {
                    contentType = "B";
                    break;
                }
                default: {
                    log.warningT("Invalid document type: " + doc.getDocumentType());
                    log.warningT("Document Type is set to TEXT, Content to space");
                    log.warningT("Document Id: '" + doc.getDocumentKey() + "'");
                    log.warningT("Document language: '" + doc.getDocumentLanguage() + "'");
                    contentType = "T";
                    contentString = "";
                }
            }
            if (contentType != null) {
                w.dataElement("ContentType", contentType);
            }
            if (mimeType != null) {
                w.dataElement("MimeType", mimeType);
            }
            if (contentType.equals("B")) {
                BASE64Encoder encoder = new BASE64Encoder();
                w.startElement("Content");
                encoder.encodeBlockedIntoXMLWriter(doc.getContentBytes(), w);
                w.endElement("Content");
            } else if (contentType.equals("T")) {
                if (doc.getContentString() != null) {
                    w.dataElement("Content", doc.getContentString());
                }
            } else if (contentString != null) {
                w.dataElement("Content", contentString);
            }
            if (doc.countDocumentAttributes() > 0) {
                w.startElement("DocAttrList");
                DocAttribute attr = doc.getFirstDocAttribute();
                while (attr != null) {
                    w.startElement("DocAttr");
                    w.dataElement("Name", attr.getAttributeName());
                    w.dataElement("Value1", attr.getValue1());
                    w.dataElement("Value2", attr.getValue2());
                    w.dataElement("Operator", attr.getAttributeOperator());
                    w.dataElement("Type", attr.getAttributeType());
                    if (attr.isClassificationAttribute()) {
                        w.dataElement("ClassifyFlag", "YES");
                    } else {
                        w.dataElement("ClassifyFlag", "NO");
                    }
                    if (attr.isTextMiningRelevant()) {
                        w.dataElement("TextMiningFlag", "YES");
                    } else {
                        w.dataElement("TextMiningFlag", "NO");
                    }
                    w.endElement("DocAttr");
                    attr = doc.getNextDocAttribute();
                }
                w.endElement("DocAttrList");
            }
            w.endElement("Document");
            ++i;
        }
        w.endElement("DocList");
        w.endElement("IndexDoc");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public void formatDeIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 1);
        w.startElement("DeIndexDoc");
        w.dataElement("IndexID", this.indexID);
        if (this.queueServerFlag) {
            w.dataElement("useQueueServer", "YES");
        } else {
            w.dataElement("useQueueServer", "NO");
        }
        w.startElement("DeDocList");
        int i = 0;
        while (i < this.documentList.size()) {
            IndexDocument doc = (IndexDocument)this.documentList.get(i);
            w.startElement("DeDoc");
            w.dataElement("DocID", doc.getDocumentKey());
            if (doc.getDocumentLanguage() != null) {
                w.dataElement("LAISO", doc.getDocumentLanguage());
            }
            w.endElement("DeDoc");
            ++i;
        }
        w.endElement("DeDocList");
        w.endElement("DeIndexDoc");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public void index() throws TrexException {
        HttpIndexingRequest request = this.documentList.size() > 0 && ((IndexDocument)this.documentList.get(0)).getDocumentAction() == 68 ? new HttpDeIndexRequest() : new HttpIndexRequest();
        request.setIndexObject(this);
        request.setIndexUser(this.m_indexUser);
        request.setTicket(this.m_ticket);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        this.errorDocumentList = request.getParser().getErrorDocumentVector();
        if (request.getParser().getExceptionReturn() != null) {
            this.ret = request.getParser().getExceptionReturn();
        }
        if (this.ret != null && this.ret.getCode() != 0) {
            throw new TrexException(this.ret);
        }
    }

    public void formatOptimizeRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 1);
        w.startElement("Optimize");
        w.dataElement("IndexID", this.indexID);
        if (this.queueServerFlag) {
            w.dataElement("useQueueServer", "YES");
        } else {
            w.dataElement("useQueueServer", "NO");
        }
        if (this.language != null && this.language.length() > 0) {
            w.dataElement("Idx_LAISO", this.language);
        }
        w.endElement("Optimize");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public void optimize() throws TrexException {
        HttpOptimizeRequest request = new HttpOptimizeRequest();
        request.setIndexObject(this);
        request.setIndexUser(this.m_indexUser);
        request.setTicket(this.m_ticket);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        this.optimizeErrorDocumentList = request.getParser().getErrorDocumentVector();
        if (request.getParser().getExceptionReturn() != null) {
            this.ret = request.getParser().getExceptionReturn();
        }
        if (this.ret != null && this.ret.getCode() != 0) {
            throw new TrexException(this.ret);
        }
    }

    public void updateDocumentAttributes(List attributes) throws TrexException {
        this.m_attributes = attributes;
        HttpUpdateDocumentAttributesRequest request = new HttpUpdateDocumentAttributesRequest();
        request.setIndexObject(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        this.errorDocumentList = request.getParser().getErrorDocumentVector();
        if (request.getParser().getExceptionReturn() != null) {
            this.ret = request.getParser().getExceptionReturn();
        }
        if (this.ret != null && this.ret.getCode() != 0) {
            throw new TrexException(this.ret);
        }
    }

    public void formatUpdateDocumentAttributesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 1);
        w.startElement("UpdateDocAttributes");
        w.dataElement("IndexID", this.indexID);
        if (this.language != null && this.language.length() > 0) {
            w.dataElement("LAISO", this.language);
        }
        w.startElement("ValueChangeList");
        int i = 0;
        while (i < this.m_attributes.size()) {
            AttributeContainer attr = (AttributeContainer)this.m_attributes.get(i);
            w.startElement("ValueChange");
            w.dataElement("DocID", attr.m_docId);
            w.dataElement("AttrName", attr.m_attribute);
            w.dataElement("ChangeAction", attr.m_action);
            if (attr.m_value != null) {
                w.dataElement("Value1", attr.m_value);
            }
            w.endElement("ValueChange");
            ++i;
        }
        w.endElement("ValueChangeList");
        w.endElement("UpdateDocAttributes");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

