/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractCreateIndex;
import com.sapportals.trex.core.AttributeDefinition;
import com.sapportals.trex.core.HttpCreateIndexRequest;
import com.sapportals.trex.core.IndexList;
import com.sapportals.trex.core.MetaIndexAttribute;
import com.sapportals.trex.util.xmlwriter.XMLWriter;

class HttpCreateIndex
extends AbstractCreateIndex {
    HttpCreateIndex() {
    }

    public void createIndex() throws TrexException {
        HttpCreateIndexRequest request = new HttpCreateIndexRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        this.indexId = request.getIndexId();
    }

    public void formatCreateIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 12);
        w.startElement("CreateIndex");
        w.startElement("Index");
        w.dataElement("IndexID", this.indexId);
        w.dataElement("IndexType", String.valueOf(this.indexType));
        w.dataElement("LogicalIndexType", String.valueOf(this.logicalIndexType));
        if (this.queueServerFlag) {
            w.dataElement("useQueueServer", "YES");
        } else {
            w.dataElement("useQueueServer", "NO");
        }
        if (!this.isPublic) {
            w.dataElement("isPublic", "NO");
        }
        if (!this.autoReplication) {
            w.dataElement("AutoReplication", "NO");
        }
        if (!this.isSearchable) {
            w.dataElement("isSearchable", "NO");
        }
        if (this.keepContent) {
            w.dataElement("keepContent", "YES");
        } else {
            w.dataElement("keepContent", "NO");
        }
        if (this.precalculatedFeatures) {
            w.dataElement("precalculatedFeatures", "YES");
        }
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.dataElement("TMEngineName", this.searchEngine);
        if (this.classificationFlag) {
            w.dataElement("ClassificationFlag", "ON");
        } else {
            w.dataElement("ClassificationFlag", "OFF");
        }
        if (this.miningFlag) {
            w.dataElement("useTextMining", "YES");
        } else {
            w.dataElement("useTextMining", "NO");
        }
        if (!this.autoCreateLanguages) {
            w.dataElement("autoCreateLanguages", "NO");
        }
        if (this.description != null) {
            w.dataElement("Description", this.description);
        }
        if (this.qServerLocation != null) {
            w.startElement("QueueServerLocation");
            w.dataElement("Host", this.qServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.qServerLocation.getPort()));
            w.endElement("QueueServerLocation");
        }
        if (this.indexServerLocation != null) {
            w.startElement("IndexServerLocation");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
            w.endElement("IndexServerLocation");
        }
        if (this.strSizeForDeltaIndex != null) {
            w.dataElement("sizeForDeltaIndex", this.strSizeForDeltaIndex);
        } else {
            w.dataElement("sizeForDeltaIndex", String.valueOf(this.sizeForDeltaIndex));
        }
        this.formatDocAttributeList(w);
        this.formatTechAttributeList(w);
        this.formatPhysicalIndexList(w);
        this.formatLanguageIndexList(w);
        if (this.multiLangDocs) {
            w.dataElement("multiLangDocs", "YES");
        }
        if (this.memoryIndexFlag) {
            w.dataElement("MemoryIndexFlag", "YES");
        }
        if (this.duplicateDetectionFlag) {
            w.dataElement("DuplicateDetectionFlag", "YES");
        }
        w.endElement("Index");
        w.endElement("CreateIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    private void formatPhysicalIndexList(XMLWriter w) throws Exception {
        w.startElement("PhysicalIndexList");
        int i = 0;
        while (i < this.physicalIndexList.size()) {
            this.formatIndexList(w, "p", i);
            ++i;
        }
        w.endElement("PhysicalIndexList");
    }

    private void formatLanguageIndexList(XMLWriter w) throws Exception {
        w.startElement("LanguageIndexList");
        int i = 0;
        while (i < this.languageIndexList.size()) {
            this.formatIndexList(w, "l", i);
            ++i;
        }
        w.endElement("LanguageIndexList");
    }

    public void formatIndexList(XMLWriter w, String s, int i) throws Exception {
        w.startElement("AddIndex");
        if (s.equals("p")) {
            w.dataElement("IndexName", ((IndexList)this.physicalIndexList.get(i)).getIndexId());
            w.dataElement("IndexServerName", ((IndexList)this.physicalIndexList.get(i)).getIndexServerName());
        } else {
            w.dataElement("IndexName", ((IndexList)this.languageIndexList.get(i)).getIndexId());
            w.dataElement("IndexServerName", ((IndexList)this.languageIndexList.get(i)).getIndexServerName());
        }
    }

    private void formatDocAttributeList(XMLWriter w) throws Exception {
        w.startElement("DocAttributeList");
        int n = this.docAttributeList.size();
        int i = 0;
        while (i < n) {
            this.formatDocAttribute(w, (AttributeDefinition)this.docAttributeList.get(i));
            ++i;
        }
        w.endElement("DocAttributeList");
    }

    private void formatDocAttribute(XMLWriter w, AttributeDefinition a) throws Exception {
        w.startElement("DocAttribute");
        if (a.getName() != null) {
            w.dataElement("Name", a.getName());
        }
        if (a.getType() != null) {
            w.dataElement("Type", a.getType());
        }
        if (a.getGroup() != null) {
            w.dataElement("Group", a.getGroup());
        }
        if (a.getTextMiningRelevant()) {
            w.dataElement("TextMiningFlag", "YES");
        } else {
            w.dataElement("TextMiningFlag", "NO");
        }
        if (a.getDefaultWeight() != -1.0f) {
            w.dataElement("DefaultWeight", String.valueOf(a.getDefaultWeight()));
        }
        if (a.getImplementationFlags() > 0) {
            w.dataElement("ImplementationFlags", String.valueOf(a.getImplementationFlags()));
        }
        if (a.getImplementationParameters() != null) {
            w.dataElement("ImplementationParams", a.getImplementationParameters());
        }
        w.endElement("DocAttribute");
    }

    private void formatTechAttributeList(XMLWriter w) throws Exception {
        w.startElement("TechAttributeList");
        int n = this.techAttributeList.size();
        int i = 0;
        while (i < n) {
            this.formatMetaAttribute(w, (MetaIndexAttribute)this.techAttributeList.get(i), "TechAttribute", "TechAttrType");
            ++i;
        }
        w.endElement("TechAttributeList");
    }

    private void formatMetaAttribute(XMLWriter w, MetaIndexAttribute a, String attributeTag, String typeTag) throws Exception {
        w.startElement(attributeTag);
        if (a.name != null) {
            w.dataElement("Name", a.name);
        }
        if (a.type != null) {
            w.dataElement(typeTag, a.type);
        }
        if (a.value1 != null) {
            w.dataElement("Value1", a.value1);
        }
        if (a.value2 != null) {
            w.dataElement("Value2", a.value2);
        }
        w.endElement(attributeTag);
    }
}

