/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.HttpContent;
import com.sapportals.trex.core.TMResponseParser;
import com.sapportals.trex.core.util.HttpRequest;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.util.ArrayList;
import org.xml.sax.InputSource;

class HttpContentRequest
extends HttpRequest {
    private HttpContent content;
    private TrexReturn m_return = null;
    private ArrayList m_resultDocuments = null;
    private int m_callType;
    private int m_maxNumWords;

    public HttpContentRequest(HttpContent content_) {
        this.content = content_;
    }

    public void setCallType(int c) {
        this.m_callType = c;
    }

    public void setMaxNumWords(int n) {
        this.m_maxNumWords = n;
    }

    public void formatRequest(XMLWriter w) throws Exception {
        if (this.m_callType == 1) {
            this.content.formatGetHighlightedContentRequest(w);
        } else if (this.m_callType == 2) {
            this.content.formatGetAbstractContentRequest(w, this.m_maxNumWords);
        } else {
            this.content.formatGetOriginalContentRequest(w);
        }
    }

    public void parseResponse(InputSource inputSource) throws Exception {
        TMResponseParser parser = new TMResponseParser();
        parser.parse(inputSource);
        this.m_return = parser.getExceptionReturn();
        if (this.m_return == null || this.m_return.getCode() == 0) {
            this.m_return = parser.reactor.getReturn();
            this.m_resultDocuments = parser.reactor.getResultDocuments();
        }
    }

    public ArrayList getResultDocuments() {
        return this.m_resultDocuments;
    }

    public TrexReturn getReturn() {
        return this.m_return;
    }
}

