/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractContent;
import com.sapportals.trex.core.HttpContentRequest;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.util.xmlwriter.XMLWriter;

class HttpContent
extends AbstractContent {
    HttpContent() {
    }

    public void getOriginalContent() throws TrexException {
        HttpContentRequest request = new HttpContentRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setCallType(0);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        this.m_resultDocs = request.getResultDocuments();
    }

    public void formatGetOriginalContentRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 13);
        w.startElement("GetContent");
        w.dataElement("CallType", "0");
        this.formatDocList(w);
        w.endElement("GetContent");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void getHighlightedContent() throws TrexException {
        HttpContentRequest request = new HttpContentRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setCallType(1);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        this.m_resultDocs = request.getResultDocuments();
    }

    public void formatGetHighlightedContentRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 13);
        w.startElement("GetContent");
        w.dataElement("CallType", "1");
        this.formatDocList(w);
        this.formatQueryEntries(w);
        if (this.m_encyclopedia != null) {
            w.dataElement("Encyclopedia", this.m_encyclopedia);
        }
        w.endElement("GetContent");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void getAbstractContent(int maxNumWords) throws TrexException {
        HttpContentRequest request = new HttpContentRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setCallType(2);
        request.setMaxNumWords(maxNumWords);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        this.m_resultDocs = request.getResultDocuments();
    }

    public void formatGetAbstractContentRequest(XMLWriter w, int maxNumWords) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 13);
        w.startElement("GetContent");
        w.dataElement("CallType", "2");
        this.formatDocList(w);
        this.formatQueryEntries(w);
        w.dataElement("MaxWordCount", Integer.toString(maxNumWords));
        w.endElement("GetContent");
        w.endElement("TMRequest");
        w.endDocument();
    }

    private void formatDocList(XMLWriter w) throws Exception {
        w.startElement("DocList");
        int i = 0;
        while (i < this.m_docs.size()) {
            ResultDocument doc = (ResultDocument)this.m_docs.get(i);
            this.formatDoc(w, doc);
            ++i;
        }
        w.endElement("DocList");
    }

    void formatDoc(XMLWriter w, ResultDocument doc) throws Exception {
        w.startElement("Document");
        if (doc.getDocumentKey() != null) {
            w.dataElement("DocID", doc.getDocumentKey());
        }
        if (doc.getIndexId() != null) {
            w.dataElement("IndexID", doc.getIndexId().getIndexName());
        } else if (this.m_indexId != null) {
            w.dataElement("IndexID", this.m_indexId.getIndexName());
        }
        if (doc.getDocumentLanguage() != null) {
            w.dataElement("LAISO", doc.getDocumentLanguage());
        }
        switch (doc.getDocumentType()) {
            case 1: {
                w.dataElement("DocType", "U");
                w.dataElement("URL", doc.getUrl());
                w.dataElement("Content", doc.getUrl());
                break;
            }
            case 7: {
                w.dataElement("DocType", "D");
                w.dataElement("Content", doc.getDocumentKey());
                if (doc.getUrl() == null) break;
                w.dataElement("URL", doc.getUrl());
                break;
            }
            case 4: {
                w.dataElement("DocType", "F");
                w.dataElement("Content", doc.getFileName());
                break;
            }
            default: {
                if (doc.getDocumentKey() != null) {
                    w.dataElement("DocType", "D");
                    w.dataElement("Content", doc.getDocumentKey());
                    break;
                }
                throw new TrexException(7261);
            }
        }
        w.endElement("Document");
    }

    private void formatQueryEntries(XMLWriter w) throws Exception {
        w.startElement("Where");
        int i = 0;
        while (i < this.m_queryEntries.size()) {
            QueryEntry queryEntry = (QueryEntry)this.m_queryEntries.get(i);
            queryEntry.format(w);
            ++i;
        }
        w.endElement("Where");
    }
}

