/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.DocAttribute;
import java.util.ArrayList;

public class Document {
    public static final byte DOCUMENT_ACTION_INDEX = 73;
    public static final byte DOCUMENT_ACTION_DEINDEX = 68;
    public static final byte DOCUMENT_TYPE_URL = 1;
    public static final byte DOCUMENT_TYPE_ASCII = 2;
    public static final byte DOCUMENT_TYPE_BINARY = 3;
    public static final byte DOCUMENT_TYPE_FILE = 4;
    public static final byte DOCUMENT_TYPE_ANALYSED = 5;
    public static final byte DOCUMENT_TYPE_SAVED = 6;
    public static final byte DOCUMENT_TYPE_DOCID = 7;
    private String m_documentKey;
    private byte m_documentType;
    private String m_documentLanguage;
    private int m_documentStatus;
    private String m_url;
    private String m_fileName;
    private String m_contentString;
    private byte[] m_contentBytes;
    private String m_contentCodePage;
    private String m_mimeType;
    private ArrayList m_attributes = new ArrayList();
    private int m_attrCounter;
    private TrexReturn m_return;
    private boolean m_classificationRelevant = true;
    private boolean m_searchRelevant = true;
    static /* synthetic */ Class class$com$sapportals$trex$core$IndexDocument;

    public void setDocumentKey(String documentKey) {
        this.m_documentKey = documentKey;
    }

    public String getDocumentKey() {
        return this.m_documentKey;
    }

    public void setMimeType(String mimeType) {
        this.m_mimeType = mimeType;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public String getContentCodepage() {
        return this.m_contentCodePage;
    }

    public void setContentCodePage(String codePage) throws TrexException {
        this.m_contentCodePage = codePage;
    }

    public void setClassificationRelevant(boolean relevant) {
        this.m_classificationRelevant = relevant;
    }

    public boolean getClassificationRelevant() {
        return this.m_classificationRelevant;
    }

    public void setSearchRelevant(boolean relevant) {
        this.m_searchRelevant = relevant;
    }

    public boolean getSearchRelevant() {
        return this.m_searchRelevant;
    }

    public int getDocumentStatus() {
        return this.m_documentStatus;
    }

    public void setDocumentStatus(int status) {
        this.m_documentStatus = status;
    }

    public TrexReturn getLastError() {
        if (this.m_return == null) {
            this.m_return = new TrexReturn(0);
        }
        return this.m_return;
    }

    public void setLastError(TrexReturn ret_) {
        this.m_return = ret_;
    }

    public void setUrl(String url) throws TrexException {
        this.m_url = url;
        this.m_documentType = 1;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setFileName(String fileName) throws TrexException {
        this.m_fileName = fileName;
        this.m_documentType = (byte)4;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setContent(String content) {
        this.m_contentString = content;
        this.m_contentBytes = null;
        this.m_documentType = (byte)2;
    }

    public String getContentString() {
        return this.m_contentString;
    }

    public void setContent(byte[] content) {
        this.m_contentBytes = content;
        this.m_contentString = null;
        this.m_documentType = (byte)3;
    }

    public byte[] getContentBytes() {
        return this.m_contentBytes;
    }

    public void clearDocumentContent() {
        this.m_contentString = null;
        this.m_contentBytes = null;
        this.m_documentType = 0;
    }

    public void setDocumentType(byte docType) throws TrexException {
        this.m_documentType = docType;
    }

    public byte getDocumentType() {
        return this.m_documentType;
    }

    public boolean isContentBinary() {
        return this.m_contentBytes != null;
    }

    public boolean isContentString() {
        return this.m_contentString != null;
    }

    public int getContentLength() {
        if (this.m_documentType == 2) {
            return this.m_contentString.length();
        }
        if (this.m_documentType == 3) {
            return this.m_contentBytes.length;
        }
        return 0;
    }

    public void addDocumentAttribute(String name, String value1, String value2, String attrOperator, String type) throws TrexException {
        this.addDocumentAttribute(name, value1, value2, attrOperator, type, true, true);
    }

    public void addDocumentAttribute(String name, String value1, String value2, String attrOperator, String type, boolean textMiningRelevant, boolean classificationAttribute) throws TrexException {
        if (name == null) {
            throw new TrexException(7203, "name", name, "addDocumentAttribute", (class$com$sapportals$trex$core$IndexDocument == null ? (class$com$sapportals$trex$core$IndexDocument = Document.class$("com.sapportals.trex.core.IndexDocument")) : class$com$sapportals$trex$core$IndexDocument).getName());
        }
        if (value1 == null) {
            throw new TrexException(7203, "value1", value1, "addDocumentAttribute", (class$com$sapportals$trex$core$IndexDocument == null ? (class$com$sapportals$trex$core$IndexDocument = Document.class$("com.sapportals.trex.core.IndexDocument")) : class$com$sapportals$trex$core$IndexDocument).getName());
        }
        if (value2 == null) {
            value2 = "";
        }
        if (attrOperator == null) {
            throw new TrexException(7203, "attrOperator", attrOperator, "addDocumentAttribute", (class$com$sapportals$trex$core$IndexDocument == null ? (class$com$sapportals$trex$core$IndexDocument = Document.class$("com.sapportals.trex.core.IndexDocument")) : class$com$sapportals$trex$core$IndexDocument).getName());
        }
        if (type == null) {
            throw new TrexException(7203, "type", type, "addDocumentAttribute", (class$com$sapportals$trex$core$IndexDocument == null ? (class$com$sapportals$trex$core$IndexDocument = Document.class$("com.sapportals.trex.core.IndexDocument")) : class$com$sapportals$trex$core$IndexDocument).getName());
        }
        this.m_attributes.add(new DocAttribute(name, value1, value2, attrOperator, type, textMiningRelevant, classificationAttribute));
    }

    protected void addDocumentAttribute(DocAttribute attr) {
        this.m_attributes.add(attr);
    }

    protected void addDocumentAttributes(ArrayList attrs) {
        this.m_attributes = attrs;
    }

    public void clearDocumentAttributes() {
        this.m_attributes = new ArrayList();
    }

    public int countDocumentAttributes() {
        return this.m_attributes.size();
    }

    public DocAttribute getFirstDocumentAttribute() {
        this.m_attrCounter = 0;
        return this.getNextDocumentAttribute();
    }

    public DocAttribute getFirstDocAttribute() {
        return this.getFirstDocumentAttribute();
    }

    public DocAttribute getNextDocumentAttribute() {
        if (this.m_attrCounter < this.m_attributes.size()) {
            DocAttribute attr = (DocAttribute)this.m_attributes.get(this.m_attrCounter);
            ++this.m_attrCounter;
            return attr;
        }
        return null;
    }

    public DocAttribute getNextDocAttribute() {
        return this.getNextDocumentAttribute();
    }

    protected ArrayList getDocumentAttributes() {
        return this.m_attributes;
    }

    protected ArrayList getDocAttributes() {
        return this.m_attributes;
    }

    public String getDocumentLanguage() {
        return this.m_documentLanguage;
    }

    public void setDocumentLanguage(String documentLanguage) {
        this.m_documentLanguage = documentLanguage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

