/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractCreateIndex;
import com.sapportals.trex.core.AttributeDefinition;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.HttpCreateIndex;
import com.sapportals.trex.core.IndexList;
import com.sapportals.trex.core.MetaIndexAttribute;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.Location;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CreateIndexManager
extends BaseManager {
    private String indexName;
    private String mode;
    private String host;
    private int port;
    private String file;
    private String m_httpserverurl;
    private String m_indexId;
    private String language = "EN";
    private boolean miningFlag = true;
    private boolean classificationFlag;
    private boolean isPublic = true;
    private boolean autoCreateLanguages = true;
    private boolean autoReplication = true;
    private boolean isSearchable = true;
    private boolean keepContent = true;
    private boolean precalculateFeatures = false;
    private int indexType = 0;
    private int logicalIndexType = 0;
    private boolean queueServerFlag = true;
    private int m_sizeForDeltaIndex = 0;
    private String m_strSizeForDeltaIndex = null;
    private boolean m_multiLangDocs = false;
    private boolean m_memoryIndexFlag = false;
    private boolean m_duplicateDetectionFlag = false;
    private String searchEngine = "DRFUZZY";
    private List docAttributeList = new ArrayList();
    private List techAttributeList = new ArrayList();
    private List physicalIndexList = new ArrayList();
    private List languageIndexList = new ArrayList();
    private String description = null;
    private boolean m_httpserverManuallySet = false;
    private Location qServerLocation = null;
    private Location indexServerLocation = null;
    private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation((String)(class$com$sapportals$trex$core$CreateIndexManager == null ? (class$com$sapportals$trex$core$CreateIndexManager = CreateIndexManager.class$("com.sapportals.trex.core.CreateIndexManager")) : class$com$sapportals$trex$core$CreateIndexManager).getName());
    public static final int INDEX_TYPE_TREX_PHYSICAL_INDEX = 0;
    public static final int INDEX_TYPE_TREX_LOGICAL_INDEX = 1;
    public static final int LOG_INDEX_TYPE_TREX_SPLITTED_INDE = 0;
    public static final int LOG_INDEX_TYPE_TREX_LANGUAGE_INDEX = 1;
    static /* synthetic */ Class class$com$sapportals$trex$core$CreateIndexManager;

    public void createIndex() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CREATE");
            monitor.compAction("EP:KM:TREX:CREATE", "create index " + this.indexName);
            TrexConfigManager conf = TrexFactory.getTrexConfigManager();
            if (this.m_indexId == null) {
                throw new TrexException(7230);
            }
            AbstractCreateIndex ci = this.getNewCreateIndexInstance(conf);
            ci.setHttpServerManuallySet(this.m_httpserverManuallySet);
            ci.setIndexId(this.m_indexId);
            ci.setSearchEngine(this.searchEngine);
            ci.setLanguage(this.language);
            ci.setMiningFlag(this.miningFlag);
            ci.setAutoReplication(this.autoReplication);
            ci.setAutoCreateLanguagesFlag(this.autoCreateLanguages);
            ci.setKeepContent(this.keepContent);
            ci.useQueueServer(this.queueServerFlag);
            ci.setIsPublic(this.isPublic);
            ci.setIsSearchable(this.isSearchable);
            ci.setKeepContent(this.keepContent);
            ci.setPrecalculateFeatures(this.precalculateFeatures);
            ci.setIndexType(this.indexType);
            ci.setLogicalIndexType(this.logicalIndexType);
            if (this.m_strSizeForDeltaIndex == null && this.m_sizeForDeltaIndex > 0) {
                ci.setSizeForDeltaIndex(String.valueOf(this.m_sizeForDeltaIndex));
            } else {
                ci.setSizeForDeltaIndex(this.m_strSizeForDeltaIndex);
            }
            ci.setMultiLangDocs(this.m_multiLangDocs);
            ci.setMemoryIndexFlag(this.m_memoryIndexFlag);
            ci.setDuplicateDetectionFlag(this.m_duplicateDetectionFlag);
            Iterator dit = this.docAttributeList.iterator();
            while (dit.hasNext()) {
                ci.addDocumentAttribute((AttributeDefinition)dit.next());
            }
            dit = this.techAttributeList.iterator();
            while (dit.hasNext()) {
                ci.addTechnicalAttribute((MetaIndexAttribute)dit.next());
            }
            ci.setDescription(this.description);
            ci.setQServerLocation(this.qServerLocation);
            ci.setIndexServerLocation(this.indexServerLocation);
            if (this.m_httpserverManuallySet) {
                try {
                    ci.setUrl(HttpServerURL.getURL(this.m_httpserverurl));
                }
                catch (TrexException ex) {
                    log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                    throw new TrexException(7219, this.m_httpserverurl);
                }
            }
            ci.createIndex();
            this.indexName = ci.getIndexId();
            log.infoT("Index " + ci.getIndexId() + " was created successfully");
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:CREATE");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:CREATE");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setIndexId(String indexName) throws TrexException {
        this.m_indexId = indexName;
    }

    public void setIndexId(String indexName, String mode, String host, int port, String file) throws TrexException {
        this.m_indexId = indexName;
        this.mode = mode;
        this.host = host;
        this.port = port;
        this.file = file;
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_httpserverManuallySet = true;
        if (log.beDebug()) {
            log.debugT("Index '" + indexName + "': parameters were set manually to mode '" + mode + "', host '" + host + "', port '" + port + "', file '" + file + "'");
        }
    }

    public String getIndexId() throws TrexException {
        return this.indexName;
    }

    public void setModeAndUrl(String mode, String host, int port, String file) {
        this.mode = mode;
        this.host = host;
        this.port = port;
        this.file = file;
    }

    public void addDocumentAttribute(String name, String type, boolean textMiningRelevant, boolean classificationAttribute) throws TrexException {
        this.docAttributeList.add(new AttributeDefinition(name, type, textMiningRelevant));
    }

    public void addDocumentAttribute(String name, String type, boolean textMiningRelevant) throws TrexException {
        this.docAttributeList.add(new AttributeDefinition(name, type, textMiningRelevant));
    }

    public void addDocumentAttribute(AttributeDefinition def) throws TrexException {
        this.docAttributeList.add(def);
    }

    public void addTechnicalAttribute(String name, String type, String value1, String value2) {
        this.techAttributeList.add(new MetaIndexAttribute(name, type, value1, value2));
    }

    public void addPhysicalIndex(String indexId, String indexserver) {
        this.physicalIndexList.add(new IndexList(indexId, indexserver));
    }

    public void addLanguageIndex(String indexId, String indexserver) {
        this.languageIndexList.add(new IndexList(indexId, indexserver));
    }

    public void setLanguage(String language) throws TrexException {
        if (language != null) {
            this.language = language;
        }
    }

    public void setSearchEngine(String searchEngine) throws TrexException {
        this.searchEngine = searchEngine.equals("DRFUZZY") || searchEngine.equals("VERITY") || searchEngine.equals("FULCRUM") ? searchEngine : "DRFUZZY";
    }

    public void setFilterFlag(boolean filterFlag) throws TrexException {
    }

    public void setAutoCreateLanguagesFlag(boolean autoCreateLanguages) throws TrexException {
        this.autoCreateLanguages = autoCreateLanguages;
    }

    public void setMiningFlag(boolean miningFlag) throws TrexException {
        this.miningFlag = miningFlag;
    }

    public void setClassificationFlag(boolean classificationFlag) throws TrexException {
        this.classificationFlag = classificationFlag;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setAutoReplication(boolean autoReplication) {
        this.autoReplication = autoReplication;
    }

    public void setIsSearchable(boolean isSearchable) {
        this.isSearchable = isSearchable;
    }

    public void setKeepContent(boolean keepContent) {
        this.keepContent = keepContent;
    }

    public void setIndexType(int indexType) {
        this.indexType = indexType;
    }

    public void setLogicalIndexType(int logicalIndexType) {
        this.logicalIndexType = logicalIndexType;
    }

    public void setPrecalculateFeatures(boolean precalculateFeatures) {
        this.precalculateFeatures = precalculateFeatures;
    }

    public void setDuplicateDetectionFlag(boolean duplicateDetectionFlag) {
        this.m_duplicateDetectionFlag = duplicateDetectionFlag;
    }

    public void setMemoryIndexFlag(boolean memoryIndexFlag) {
        this.m_memoryIndexFlag = memoryIndexFlag;
    }

    public void setMultiLangDocs(boolean multiLangDocs) {
        this.m_multiLangDocs = multiLangDocs;
    }

    public void setSizeForDeltaIndex(int size) {
        this.m_sizeForDeltaIndex = size;
    }

    public void setSizeForDeltaIndex(String size) {
        this.m_strSizeForDeltaIndex = size;
    }

    public void useQueueServer(boolean queueServerFlag) {
        this.queueServerFlag = queueServerFlag;
    }

    protected String getSearchEngine() {
        return this.searchEngine;
    }

    private AbstractCreateIndex getNewCreateIndexInstance(TrexConfigManager conf) throws TrexException {
        if (this.m_indexId == null) {
            throw new TrexException(7230);
        }
        HttpCreateIndex httpcreateindex = new HttpCreateIndex();
        httpcreateindex.setSSLData(this.m_keystore, this.m_truststore);
        httpcreateindex.setIndexUser(this.m_indexUser);
        return httpcreateindex;
    }

    public void setDescription(String description_) {
        this.description = description_;
    }

    public void setQServerLocation(String host, int port) {
        this.qServerLocation = new Location(host, port);
    }

    public void setIndexServerLocation(String host, int port) {
        this.indexServerLocation = new Location(host, port);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

