/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractContent;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.HttpContent;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import java.util.ArrayList;

public class ContentManager
extends BaseManager {
    private IndexId m_indexId = null;
    private String m_encyclopedia = null;
    private ArrayList m_queryEntries = new ArrayList();
    private ArrayList m_docs = new ArrayList();
    private int m_docCounter = 0;
    private boolean m_httpserverManuallySet = false;
    private String m_httpserverurl;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$ContentManager == null ? (class$com$sapportals$trex$core$ContentManager = ContentManager.class$("com.sapportals.trex.core.ContentManager")) : class$com$sapportals$trex$core$ContentManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$ContentManager;

    public void setIndexId(String indexName) throws TrexException {
        this.m_indexId = new IndexId();
        this.m_indexId.setIndexName(indexName);
        this.m_indexId.setSearchEngine("DRFUZZY");
        this.m_indexId.setLanguage("");
    }

    public void setIndexId(String indexName, String mode, String host, int port, String file) throws TrexException {
        this.m_indexId = new IndexId();
        this.m_indexId.setIndexName(indexName);
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_httpserverManuallySet = true;
        this.m_indexId.setHttpServerUrl(mode, host, port, file);
    }

    public void setLanguage(String language) {
    }

    public void setSearchEngine(String searchEngine) throws TrexException {
    }

    public int countDocuments() {
        if (this.m_docs == null) {
            return 0;
        }
        return this.m_docs.size();
    }

    public void addDocument(ResultDocument doc) {
        this.m_docs.add(doc);
    }

    public void clear() {
        this.m_docs = new ArrayList();
        this.m_indexId = null;
    }

    public void clearResults() {
        this.m_docs = new ArrayList();
    }

    public ResultDocument getFirstDocument() {
        this.m_docCounter = 0;
        if (this.m_docCounter < this.m_docs.size()) {
            ResultDocument doc = (ResultDocument)this.m_docs.get(this.m_docCounter);
            ++this.m_docCounter;
            return doc;
        }
        return null;
    }

    public ResultDocument getNextDocument() {
        if (this.m_docCounter < this.m_docs.size()) {
            ResultDocument doc = (ResultDocument)this.m_docs.get(this.m_docCounter);
            ++this.m_docCounter;
            return doc;
        }
        return null;
    }

    public void addQueryEntry(QueryEntry queryEntry) {
        this.m_queryEntries.add(queryEntry);
    }

    public void setEncyclopedia(String theEncyclopedia) {
        this.m_encyclopedia = theEncyclopedia;
    }

    public void getOriginalContent() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CONTENT:ORIG");
            AbstractContent ac = this.getNewContentInstance();
            ac.setHttpServerManuallySet(this.m_httpserverManuallySet);
            if (this.m_indexId != null) {
                ac.setIndexId(this.m_indexId);
            }
            ac.addDocuments(this.m_docs);
            log.infoT("GetOriginalContent started.");
            ac.getOriginalContent();
            log.infoT("GetOriginalContent finished.");
            this.m_docs = ac.getResultDocuments();
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:ORIG");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:ORIG");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void getHighlightedContent() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CONTENT:HIGH");
            AbstractContent ac = this.getNewContentInstance();
            ac.addDocuments(this.m_docs);
            ac.addQueryEntries(this.m_queryEntries);
            ac.setEncyclopedia(this.m_encyclopedia);
            if (this.m_indexId != null) {
                ac.setIndexId(this.m_indexId);
            }
            ac.setHttpServerManuallySet(this.m_httpserverManuallySet);
            ac.getHighlightedContent();
            log.infoT("GetHighlighted Content started.");
            this.m_docs = ac.getResultDocuments();
            log.infoT("GetHighlighted Content finished.");
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:HIGH");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:HIGH");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void getAbstractContent(int maxNumWords) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CONTENT:ABSTR");
            AbstractContent ac = this.getNewContentInstance();
            ac.setHttpServerManuallySet(this.m_httpserverManuallySet);
            ac.addDocuments(this.m_docs);
            if (this.m_indexId != null) {
                ac.setIndexId(this.m_indexId);
            }
            ac.addQueryEntries(this.m_queryEntries);
            ac.getAbstractContent(maxNumWords);
            this.m_docs = ac.getResultDocuments();
            Object var5_4 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:ABSTR");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.endComponent("EP:KM:TREX:CONTENT:ABSTR");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    private AbstractContent getNewContentInstance() throws TrexException {
        HttpContent httpcontent = new HttpContent();
        if (this.m_httpserverManuallySet) {
            try {
                httpcontent.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        httpcontent.setTicket(this.m_ticket);
        httpcontent.setSSLData(this.m_keystore, this.m_truststore);
        httpcontent.setIndexUser(this.m_indexUser);
        return httpcontent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

