/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.CompleteTerms;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.RelatedTerms;
import com.sapportals.trex.core.SearchDocument;
import com.sapportals.trex.core.SearchTerm;
import com.sapportals.trex.core.SimilarSearchResult;
import com.sapportals.trex.core.SortAttribute;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;
import com.sapportals.trex.core.ThesaurusRelation;
import com.sapportals.trex.core.ThesaurusRole;
import com.sapportals.trex.core.base64.BASE64Encoder;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class AbstractTextMining
extends BaseManager {
    protected List searchDocuments = new ArrayList();
    protected List termList = new ArrayList();
    protected List classList = new ArrayList();
    protected List indexRefList = new ArrayList();
    protected List requestedAttributeList = new ArrayList();
    protected List sortAttributes = new ArrayList();
    protected List relations = new ArrayList();
    protected String language;
    protected int from;
    protected int to;
    protected int maxResults;
    protected float threshold = 0.0f;
    protected SearchTerm termId;
    protected int abstractLength;
    protected String classifyAttribute;
    protected String classificationMethod;
    protected Byte classificationType;
    protected boolean m_useKeywords;
    protected boolean m_httpserverManuallySet = false;
    protected URL m_httpserverurl;
    protected byte clusteringMethod = (byte)4;
    protected byte documentSimilarityMethod = 1;
    protected String clusteringAttribute = null;
    protected String m_pattern = null;
    protected String m_documentSelectionQuery = null;
    private List m_highlightAttributes = null;
    private byte m_requestFlags;
    private int m_maxSnippetWords;
    protected String m_command = null;

    AbstractTextMining() {
    }

    public abstract SimilarSearchResult searchSimilarDocuments() throws TrexException;

    public abstract TextMiningResultContainer searchSimilarTerms() throws TrexException;

    public abstract TextMiningResult searchSimilarClasses() throws TrexException;

    public abstract TextMiningResult classifyDocuments() throws TrexException;

    public abstract TextMiningResult getDocumentFeatures() throws TrexException;

    public abstract TextMiningResult getClassFeatures() throws TrexException;

    public abstract RelatedTerms getThesaurusTerms() throws TrexException;

    public abstract CompleteTerms getTermIds() throws TrexException;

    public abstract TextMiningResult calculateClusters() throws TrexException;

    public abstract TextMiningResult getDocumentLanguage() throws TrexException;

    public abstract TextMiningResult getDocumentCodepage() throws TrexException;

    public abstract TextMiningResult trexCommand(String var1) throws TrexException;

    public void setThreshold(float threshold_) throws TrexException {
        this.threshold = threshold_;
    }

    public float getThreshold() throws TrexException {
        return this.threshold;
    }

    public void setLanguage(String language) throws TrexException {
        this.language = language;
    }

    public void addIndexIds(List indexIds) throws TrexException {
        this.indexRefList = indexIds;
    }

    public void addIndexId(IndexId indexId) throws TrexException {
        this.indexRefList.add(indexId);
    }

    public void setResultFromTo(int from, int to) throws TrexException {
        this.from = from;
        if (from < 1) {
            from = 1;
        }
        this.to = to;
        this.maxResults = to - from + 1;
    }

    public void setMaxResults(int max) throws TrexException {
        this.maxResults = max;
        if (this.from < 1) {
            this.from = 1;
        }
        this.to = this.from + max - 1;
    }

    public void setTermName(String termName) throws TrexException {
        this.termList.add(new SearchTerm(termName, 1.0f));
    }

    public void setMaxSnippetWords(int maxWords) {
        this.m_maxSnippetWords = maxWords;
    }

    public void setRequestFlags(byte requestFlags) {
        this.m_requestFlags = requestFlags;
    }

    public void addSearchDocuments(List docs) throws TrexException {
        this.searchDocuments = docs;
    }

    public void addSearchTerms(List terms) throws TrexException {
        this.termList = terms;
    }

    public void setResultTermPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public void addSearchClasses(List classes) throws TrexException {
        this.classList = classes;
    }

    public void addSortAttributes(List attrs) throws TrexException {
        this.sortAttributes = attrs;
    }

    public void addRequestedAttributes(List requestedAttributes) throws TrexException {
        this.requestedAttributeList = requestedAttributes;
    }

    public void addHighlightAttributes(List highlightAttributes) throws TrexException {
        this.m_highlightAttributes = highlightAttributes;
    }

    public void setClassifyAttribute(String classifyAttribute) throws TrexException {
        this.classifyAttribute = classifyAttribute;
    }

    public void setClassificationMethod(String method) throws TrexException {
        this.classificationMethod = method;
    }

    public void setClassificationType(Byte type) throws TrexException {
        this.classificationType = type;
    }

    public void setClusteringMethod(byte method) {
        this.clusteringMethod = method;
    }

    public void setDocumentSimilarityMethod(byte method) {
        this.documentSimilarityMethod = method;
    }

    public void setClusteringAttribute(String clusteringAttribute) {
        this.clusteringAttribute = clusteringAttribute;
    }

    public void setDocumentSelectionQuery(String query) throws TrexException {
        this.m_documentSelectionQuery = query;
    }

    public void setUseKeywords(boolean useKeywords) {
        this.m_useKeywords = useKeywords;
    }

    public void setAbstractLength(int length) throws TrexException {
        this.abstractLength = length;
    }

    public void addThesaurusRelations(List relations) {
        this.relations = relations;
    }

    public void setTermId(SearchTerm term) {
        this.termId = term;
    }

    private void formatDocList(XMLWriter w) throws Exception {
        w.startElement("DocList");
        int i = 0;
        while (i < this.searchDocuments.size()) {
            SearchDocument doc = (SearchDocument)this.searchDocuments.get(i);
            this.formatDoc(w, doc);
            ++i;
        }
        w.endElement("DocList");
    }

    void formatDoc(XMLWriter w, SearchDocument doc) throws Exception {
        w.startElement("Document");
        if (doc.getDocumentGroup() != null) {
            w.dataElement("DocGroup", doc.getDocumentGroup());
        }
        if (doc.getIndexDocumentId() != null) {
            w.dataElement("DocID", doc.getIndexDocumentId());
        }
        if (doc.getLanguage() != null) {
            w.dataElement("LAISO", doc.getLanguage());
        }
        if (doc.getContentCodepage() != null) {
            w.dataElement("CodePage", doc.getContentCodepage());
        }
        if (doc.getUrl() != null) {
            w.dataElement("DocType", "U");
            w.dataElement("Content", doc.getUrl());
        } else if (doc.getFileName() != null) {
            w.dataElement("DocType", "F");
            w.dataElement("Content", doc.getFileName());
        } else if (doc.isContentBinary()) {
            w.dataElement("DocType", "B");
            BASE64Encoder encoder = new BASE64Encoder();
            w.startElement("Content");
            encoder.encodeBlockedIntoXMLWriter(doc.getContentBytes(), w);
            w.endElement("Content");
        } else if (doc.isContentString()) {
            w.dataElement("DocType", "T");
            if (doc.getContentString() != null) {
                w.dataElement("Content", doc.getContentString());
            }
        } else if (doc.getIndexDocumentId() != null) {
            w.dataElement("DocType", "D");
            w.dataElement("Content", doc.getIndexDocumentId());
        } else {
            throw new TrexException(7261);
        }
        if (doc.getMimeType() != null) {
            w.dataElement("MimeType", doc.getMimeType());
        }
        if (doc.getDocumentAttributes() != null) {
            List attributeList = doc.getDocumentAttributes();
            Iterator it = attributeList.iterator();
            w.startElement("DocumentAttrList");
            while (it.hasNext()) {
                w.startElement("DocumentAttr");
                DocAttribute attr = (DocAttribute)it.next();
                w.dataElement("Name", attr.getAttributeName());
                w.dataElement("Value1", attr.getValue1());
                if (attr.getValue2() != null) {
                    w.dataElement("Value2", attr.getValue2());
                }
                if (attr.getAttributeOperator() != null) {
                    w.dataElement("Operator", attr.getAttributeOperator());
                }
                if (attr.getAttributeType() != null) {
                    w.dataElement("Type", attr.getAttributeType());
                }
                w.endElement("DocumentAttr");
            }
            w.endElement("DocumentAttrList");
        }
        w.endElement("Document");
    }

    void formatDocId(XMLWriter w, SearchDocument doc) throws Exception {
        w.startElement("Document");
        if (doc.getIndexDocumentId() != null) {
            w.dataElement("DocID", doc.getIndexDocumentId());
        }
        if (doc.getUrl() != null) {
            w.dataElement("DocType", "U");
            w.dataElement("Content", doc.getUrl());
        } else if (doc.getFileName() != null) {
            w.dataElement("DocType", "F");
            w.dataElement("Content", doc.getFileName());
        } else if (doc.isContentBinary()) {
            w.dataElement("DocType", "B");
            BASE64Encoder encoder = new BASE64Encoder();
            w.startElement("Content");
            encoder.encodeBlockedIntoXMLWriter(doc.getContentBytes(), w);
            w.endElement("Content");
        } else if (doc.isContentString()) {
            w.dataElement("DocType", "T");
            if (doc.getContentString() != null) {
                w.dataElement("Content", doc.getContentString());
            }
        } else if (doc.getIndexDocumentId() != null) {
            w.dataElement("DocType", "D");
            w.dataElement("Content", doc.getIndexDocumentId());
        } else {
            throw new TrexException(7261);
        }
        w.endElement("Document");
    }

    void formatIndexLoc(XMLWriter w, IndexId ref) throws Exception {
        w.startElement("IndexLoc");
        w.startElement("Index");
        if (ref.getIndexName() != null) {
            w.dataElement("IndexID", ref.getIndexName());
            if (ref.getLanguage() != null) {
                w.dataElement("LAISO", ref.getLanguage());
            }
        } else {
            w.dataElement("SearchEngineExtern", ref.getSearchEngine());
        }
        w.endElement("Index");
        w.endElement("IndexLoc");
    }

    void formatIndexLoc(XMLWriter w) throws Exception {
        if (this.indexRefList.size() > 0) {
            this.formatIndexLoc(w, (IndexId)this.indexRefList.get(0));
        }
    }

    public void formatIndexList(XMLWriter w) throws Exception {
        w.startElement("IndexList");
        int i = 0;
        while (i < this.indexRefList.size()) {
            this.formatIndexLoc(w, (IndexId)this.indexRefList.get(i));
            ++i;
        }
        w.endElement("IndexList");
    }

    public void formatSearchSimilarDocumentsRequest(XMLWriter w) throws Exception {
        int i;
        w.startDocument();
        w.startElement("TMRequest", 4);
        w.startElement("GetSimilarDocs");
        this.formatIndexList(w);
        w.dataElement("MaxSimilarDocs", String.valueOf(this.maxResults));
        w.startElement("Interval");
        w.dataElement("From", String.valueOf(this.from));
        w.dataElement("To", String.valueOf(this.to));
        w.endElement("Interval");
        if (this.requestedAttributeList.size() > 0) {
            w.startElement("DocAttrList");
            i = 0;
            while (i < this.requestedAttributeList.size()) {
                w.dataElement("DocAttrName", (String)this.requestedAttributeList.get(i));
                ++i;
            }
            w.endElement("DocAttrList");
        }
        this.formatDocList(w);
        if (this.sortAttributes.size() > 0) {
            w.startElement("SortedByList");
            i = 0;
            while (i < this.sortAttributes.size()) {
                w.startElement("SortedBy");
                SortAttribute attr = (SortAttribute)this.sortAttributes.get(i);
                w.dataElement("DocAttrName", attr.getName());
                if (attr.isSortedAscending()) {
                    w.dataElement("SortAscending", "YES");
                } else {
                    w.dataElement("SortAscending", "NO");
                }
                w.endElement("SortedBy");
                ++i;
            }
            w.endElement("SortedByList");
        }
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        if (this.m_requestFlags > 0) {
            w.dataElement("TMRequestFlag", String.valueOf(this.m_requestFlags));
        }
        if (this.m_maxSnippetWords > 0) {
            w.dataElement("MaxWordCount", String.valueOf(this.m_maxSnippetWords));
        }
        if (this.m_highlightAttributes != null && this.m_highlightAttributes.size() > 0) {
            w.startElement("HighlightAttrList");
            i = 0;
            while (i < this.m_highlightAttributes.size()) {
                String name = (String)this.m_highlightAttributes.get(i);
                w.dataElement("HighlightAttr", name);
                ++i;
            }
            w.endElement("HighlightAttrList");
        }
        w.endElement("GetSimilarDocs");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatGetDocumentFeaturesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetDocFeatures");
        this.formatIndexLoc(w);
        w.dataElement("MaxFeatures", String.valueOf(this.maxResults));
        this.formatDocList(w);
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        w.endElement("GetDocFeatures");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatSearchSimilarTermsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 9);
        w.startElement("GetSimilarTerms");
        this.formatIndexList(w);
        w.dataElement("MaxTerms", String.valueOf(this.maxResults));
        w.startElement("TermList");
        int i = 0;
        while (i < this.termList.size()) {
            w.startElement("Term");
            w.dataElement("TermName", ((SearchTerm)this.termList.get(i)).getTerm());
            w.dataElement("Weight", String.valueOf(((SearchTerm)this.termList.get(i)).getWeight()));
            w.endElement("Term");
            ++i;
        }
        w.endElement("TermList");
        if (this.m_pattern != null) {
            w.dataElement("ResultTermPattern", this.m_pattern);
        }
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        w.endElement("GetSimilarTerms");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatClassifyDocumentsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("ClassifyDocs");
        this.formatIndexLoc(w);
        if (this.threshold > 0.0f) {
            w.dataElement("ThresholdRankValue", String.valueOf(this.threshold));
        }
        if (this.classificationMethod != null) {
            w.dataElement("ClassificationMethod", this.classificationMethod);
        }
        if (this.classificationType != null) {
            w.dataElement("ClassificationType", this.classificationType.toString());
        }
        if (this.maxResults > 0) {
            w.dataElement("MaxClass", String.valueOf(this.maxResults));
        }
        w.startElement("Tax");
        if (this.classifyAttribute != null) {
            w.dataElement("TaxName", this.classifyAttribute);
        }
        this.formatDocList(w);
        w.endElement("Tax");
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        if (this.m_useKeywords) {
            w.dataElement("useKeywords", "YES");
        }
        w.endElement("ClassifyDocs");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatSearchSimilarClassesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetSimilarClasses");
        this.formatIndexLoc(w);
        if (this.maxResults > 0) {
            w.dataElement("MaxClass", String.valueOf(this.maxResults));
        }
        if (this.threshold > 0.0f) {
            w.dataElement("ThresholdRankValue", String.valueOf(this.threshold));
        }
        w.startElement("ClassTax");
        if (this.classifyAttribute != null) {
            w.dataElement("TaxName", this.classifyAttribute);
        }
        w.startElement("ClassList");
        int i = 0;
        while (i < this.classList.size()) {
            w.dataElement("ClassName", (String)this.classList.get(i));
            ++i;
        }
        w.endElement("ClassList");
        w.endElement("ClassTax");
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        if (this.m_useKeywords) {
            w.dataElement("useKeywords", "YES");
        }
        w.endElement("GetSimilarClasses");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatCalculateClustersRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("CalculateClusters");
        this.formatIndexLoc(w);
        w.dataElement("MaxCluster", String.valueOf(this.maxResults));
        w.dataElement("ThresholdRankValue", String.valueOf(this.threshold));
        w.dataElement("ClusteringMethod", String.valueOf(this.clusteringMethod));
        w.dataElement("DocSimilarityMethod", String.valueOf(this.documentSimilarityMethod));
        if (this.clusteringAttribute != null) {
            w.dataElement("ClusteringAttribute", this.clusteringAttribute);
        }
        this.formatDocList(w);
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        w.endElement("CalculateClusters");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatGetClassFeaturesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetClassFeatures");
        this.formatIndexLoc(w);
        w.dataElement("MaxFeatures", String.valueOf(this.maxResults));
        w.startElement("ClassTax");
        w.dataElement("TaxName", this.classifyAttribute);
        w.startElement("ClassList");
        int i = 0;
        while (i < this.classList.size()) {
            w.dataElement("ClassName", (String)this.classList.get(i));
            ++i;
        }
        w.endElement("ClassList");
        w.endElement("ClassTax");
        if (this.m_documentSelectionQuery != null) {
            w.dataElement("DocSelectQuery", this.m_documentSelectionQuery);
        }
        if (this.m_useKeywords) {
            w.dataElement("useKeywords", "YES");
        }
        w.endElement("GetClassFeatures");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatGetThesaurusTermsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetThesaurusTerms");
        this.formatIndexLoc(w);
        w.startElement("ThesaurusTerm");
        if (this.termId != null) {
            w.dataElement("TermID", this.termId.getTerm());
            w.dataElement("Weight", String.valueOf(this.termId.getWeight()));
        }
        w.endElement("ThesaurusTerm");
        if (this.maxResults > 0) {
            w.dataElement("MaxTerms", String.valueOf(this.maxResults));
        }
        w.startElement("RelationList");
        int i = 0;
        while (i < this.relations.size()) {
            ThesaurusRelation relation = (ThesaurusRelation)this.relations.get(i);
            w.startElement("Relation");
            w.dataElement("RelationName", relation.getName());
            w.dataElement("Weight", String.valueOf(relation.getWeight()));
            List roles = relation.getRoles();
            w.startElement("RoleList");
            int j = 0;
            while (j < roles.size()) {
                ThesaurusRole role = (ThesaurusRole)roles.get(j);
                w.startElement("Role");
                w.dataElement("RoleName", role.getName());
                w.dataElement("Weight", String.valueOf(role.getWeight()));
                w.endElement("Role");
                ++j;
            }
            w.endElement("RoleList");
            w.endElement("Relation");
            ++i;
        }
        w.endElement("RelationList");
        w.endElement("GetThesaurusTerms");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatGetTermIDsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetTermIDs");
        this.formatIndexLoc(w);
        w.dataElement("TermName", ((SearchTerm)this.termList.get(0)).getTerm());
        w.endElement("GetTermIDs");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatGetDocumentLanguage(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("GetDocumentLanguage");
        w.startElement("DocList");
        Iterator it = this.searchDocuments.iterator();
        while (it.hasNext()) {
            SearchDocument doc = (SearchDocument)it.next();
            this.formatDocId(w, doc);
        }
        w.endElement("DocList");
        w.endElement("GetDocumentLanguage");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatTrexCommand(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest");
        w.startElement("TREXCommand");
        this.formatIndexLoc(w);
        w.dataElement("Command", this.m_command);
        w.endElement("TREXCommand");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void setHttpServerManuallySet(boolean ht) {
        this.m_httpserverManuallySet = ht;
    }

    public void setURL(URL u) {
        this.m_httpserverurl = u;
    }
}

