/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AttributeDistributionDefinition;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.SearchManager;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.SortAttribute;
import com.sapportals.trex.core.util.Location;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractSearch
extends BaseManager {
    protected List queryEntries = new ArrayList();
    protected List attributes = new ArrayList();
    protected List indexList = new ArrayList();
    protected List sortAttributes = new ArrayList();
    protected List m_highlightAttributes;
    protected String language;
    protected boolean m_httpserverManuallySet = false;
    protected URL m_httpserverurl;
    protected int from;
    protected int to;
    protected byte m_requestFlags;
    protected byte m_requestedSearchResults;
    protected boolean m_ignoreMissingLanguageIndex;
    protected int m_optimalNumberOfValues;
    protected int m_maxNumberOfReturnValues;
    protected List m_attributeDistributionDefinitionList;
    protected int m_maxSnippetWords;
    protected int m_oneSnippetWords;
    protected boolean m_countOnlyFlag;
    protected Location m_indexServerLocation = null;

    AbstractSearch() {
    }

    public abstract SearchResult search() throws TrexException;

    public void setLanguage(String language) throws TrexException {
        this.language = language;
    }

    public void addIndexIds(List indexIds) throws TrexException {
        this.indexList = indexIds;
    }

    public void addRequestedAttributes(List requestedAttributes) throws TrexException {
        this.attributes = requestedAttributes;
    }

    public void addQueryEntries(List queryEntries) throws TrexException {
        this.queryEntries = queryEntries;
    }

    public void addSortAttributes(List sortAttributes) throws TrexException {
        this.sortAttributes = sortAttributes;
    }

    public void addHighlightAttributes(List highlightAttributes) throws TrexException {
        this.m_highlightAttributes = highlightAttributes;
    }

    public void setResultFromTo(int from, int to) throws TrexException {
        this.from = from;
        if (from < 1) {
            from = 1;
        }
        this.to = to;
    }

    public void setMaxSnippetWords(int maxWords) {
        this.m_maxSnippetWords = maxWords;
    }

    public void setOneSnippetWords(int maxWords) {
        this.m_oneSnippetWords = maxWords;
    }

    public void setRequestFlags(byte requestFlags) {
        this.m_requestFlags = requestFlags;
    }

    public void setIndexServerLocation(Location location) {
        this.m_indexServerLocation = location;
    }

    public void setRequestedSearchResults(byte requestedResults) {
        this.m_requestedSearchResults = requestedResults;
    }

    public void setCountOnlyFlag(boolean countOnly) {
        this.m_countOnlyFlag = countOnly;
    }

    public void ignoreMissingLanguageIndex(boolean flag) {
        this.m_ignoreMissingLanguageIndex = flag;
    }

    public void setOptimalNumberOfValues(int optimalNumberOfValues) {
        this.m_optimalNumberOfValues = optimalNumberOfValues;
    }

    public void setAttributeDistributionDefinitionList(List attrDefList) {
        this.m_attributeDistributionDefinitionList = attrDefList;
    }

    public void setMaxNumberOfReturnValues(int maxNumberOfReturnValues) {
        this.m_maxNumberOfReturnValues = maxNumberOfReturnValues;
    }

    public void setHttpServerManuallySet(boolean h) {
        this.m_httpserverManuallySet = h;
    }

    public void setUrl(URL u) {
        this.m_httpserverurl = u;
    }

    public void formatSearchRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 13);
        w.startElement("Search");
        if (this.m_indexServerLocation != null) {
            w.dataElement("IndexServerLocation", this.m_indexServerLocation.toString());
        }
        w.startElement("Interval");
        w.dataElement("From", String.valueOf(this.from));
        w.dataElement("To", String.valueOf(this.to));
        w.endElement("Interval");
        if (this.language != null) {
            w.dataElement("QueryLAISO", this.language);
        }
        w.dataElement("QueryCodePage", "UTF8");
        w.startElement("Query");
        w.startElement("Select");
        w.startElement("DocAttrList");
        int i = 0;
        while (i < this.attributes.size()) {
            w.dataElement("DocAttrName", (String)this.attributes.get(i));
            ++i;
        }
        w.endElement("DocAttrList");
        w.endElement("Select");
        w.startElement("In");
        int i2 = 0;
        while (i2 < this.indexList.size()) {
            w.startElement("IndexLoc");
            IndexId index = (IndexId)this.indexList.get(i2);
            String indexName = index.getIndexName();
            if (indexName != null && indexName.length() > 0 && (index.getSearchEngine().equalsIgnoreCase("DRFUZZY") || index.getSearchEngine().equalsIgnoreCase("VERITY") || index.getSearchEngine().equalsIgnoreCase("FULCRUM"))) {
                w.startElement("Index");
                w.dataElement("IndexID", indexName);
                String myLanguage = index.getLanguage();
                if (myLanguage != null) {
                    w.dataElement("LAISO", myLanguage);
                }
                w.endElement("Index");
            } else {
                w.dataElement("SearchEngineExtern", index.getSearchEngine());
            }
            w.endElement("IndexLoc");
            ++i2;
        }
        w.endElement("In");
        w.startElement("Where");
        int i3 = 0;
        while (i3 < this.queryEntries.size()) {
            QueryEntry queryEntry = (QueryEntry)this.queryEntries.get(i3);
            queryEntry.format(w);
            ++i3;
        }
        w.endElement("Where");
        if (this.sortAttributes.size() > 0) {
            w.startElement("SortedByList");
            int i4 = 0;
            while (i4 < this.sortAttributes.size()) {
                w.startElement("SortedBy");
                SortAttribute attr = (SortAttribute)this.sortAttributes.get(i4);
                w.dataElement("DocAttrName", attr.getName());
                if (attr.isSortedAscending()) {
                    w.dataElement("SortAscending", "YES");
                } else {
                    w.dataElement("SortAscending", "NO");
                }
                w.endElement("SortedBy");
                ++i4;
            }
            w.endElement("SortedByList");
        }
        if (this.m_highlightAttributes != null && this.m_highlightAttributes.size() > 0) {
            w.startElement("HighlightAttrList");
            int i5 = 0;
            while (i5 < this.m_highlightAttributes.size()) {
                String name = (String)this.m_highlightAttributes.get(i5);
                w.dataElement("HighlightAttr", name);
                ++i5;
            }
            w.endElement("HighlightAttrList");
        }
        w.endElement("Query");
        if (this.m_requestFlags > 0) {
            w.dataElement("RequestFlag", String.valueOf(this.m_requestFlags));
        }
        if (this.m_maxSnippetWords > 0) {
            w.dataElement("MaxWordCount", String.valueOf(this.m_maxSnippetWords));
        }
        if (this.m_oneSnippetWords > 0) {
            w.dataElement("OneSnippetWords", String.valueOf(this.m_oneSnippetWords));
        }
        if (this.m_requestedSearchResults > 1) {
            w.dataElement("requestedSearchResults", String.valueOf(this.m_requestedSearchResults));
        }
        if (this.m_ignoreMissingLanguageIndex) {
            w.dataElement("ignoreMissingLanguageIndex", "YES");
        }
        if (this.m_requestedSearchResults == SearchManager.ATTRIBUTE_DISTRIBUTION_OVERVIEW_REQUESTED || this.m_requestedSearchResults == SearchManager.ATTRIBUTE_DISTRIBUTION_REQUESTED) {
            w.startElement("AttributeDistrDefGlobals");
            if (this.m_optimalNumberOfValues > 0) {
                w.dataElement("optimalNumberOfValues", String.valueOf(this.m_optimalNumberOfValues));
            }
            if (this.m_maxNumberOfReturnValues > 0) {
                w.dataElement("maxNumberOfReturnValues", String.valueOf(this.m_maxNumberOfReturnValues));
            }
            w.endElement("AttributeDistrDefGlobals");
            if (this.m_attributeDistributionDefinitionList.size() > 0) {
                w.startElement("AttributeDistrDefList");
                int i6 = 0;
                while (i6 < this.m_attributeDistributionDefinitionList.size()) {
                    AttributeDistributionDefinition def = (AttributeDistributionDefinition)this.m_attributeDistributionDefinitionList.get(i6);
                    w.startElement("AttributeDistrDef");
                    w.dataElement("attrName", def.getAttributeName());
                    w.dataElement("browsingRelevance", String.valueOf(def.getBrowsingRelevance()));
                    w.dataElement("defaultClusterSize", String.valueOf(def.getDefaultClusterSize()));
                    w.dataElement("algorithm", def.getAlgorithm());
                    w.dataElement("groupingRanges", def.getGroupingRanges());
                    w.endElement("AttributeDistrDef");
                    ++i6;
                }
                w.endElement("AttributeDistrDefList");
            }
        }
        if (this.m_countOnlyFlag) {
            w.dataElement("countOnly", "YES");
        }
        w.endElement("Search");
        w.endElement("TMRequest");
        w.endDocument();
    }
}

