/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.IndexDocument;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractIndex
extends BaseManager {
    protected List documentList = new ArrayList();
    protected List errorDocumentList = new ArrayList();
    protected List optimizeErrorDocumentList = new ArrayList();
    protected List m_attributes = new ArrayList();
    protected boolean queueServerFlag;
    protected String language;
    protected String searchEngine;
    protected String indexID;
    protected boolean m_httpserverManuallySet = false;
    protected URL m_httpserverurl;
    protected TrexReturn ret;

    AbstractIndex() {
    }

    public abstract void index() throws TrexException;

    public abstract void optimize() throws TrexException;

    public abstract void updateDocumentAttributes(List var1) throws TrexException;

    public TrexReturn getLastError() {
        if (this.ret == null) {
            this.ret = new TrexReturn(0);
        }
        return this.ret;
    }

    public void setSearchEngine(String searchEngine_) throws TrexException {
        this.searchEngine = searchEngine_;
    }

    public void addDocument(IndexDocument doc) throws TrexException {
        this.documentList.add(doc);
    }

    public void useQueueServer(boolean queueServerFlag) throws TrexException {
        this.queueServerFlag = queueServerFlag;
    }

    public void setIndexId(String indexID_) throws TrexException {
        this.indexID = indexID_;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setHttpServerManuallySet(boolean ht) {
        this.m_httpserverManuallySet = ht;
    }

    public void setURL(URL u) {
        this.m_httpserverurl = u;
    }

    public IndexDocument[] getIndexErrorDocuments() {
        int size = this.errorDocumentList.size();
        IndexDocument[] docs = new IndexDocument[size];
        if (size == 0) {
            return docs;
        }
        int i = 0;
        while (i < size) {
            docs[i] = (IndexDocument)this.errorDocumentList.get(i);
            ++i;
        }
        return docs;
    }

    public int getNoIndexErrorDocuments() {
        return this.errorDocumentList.size();
    }

    public IndexDocument[] getOptimizeErrorDocuments() {
        int size = this.optimizeErrorDocumentList.size();
        IndexDocument[] docs = new IndexDocument[size];
        if (size == 0) {
            return docs;
        }
        int i = 0;
        while (i < size) {
            docs[i] = (IndexDocument)this.optimizeErrorDocumentList.get(i);
            ++i;
        }
        return docs;
    }

    public int getNoOptimizeErrorDocuments() {
        return this.optimizeErrorDocumentList.size();
    }
}

