/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex;

import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TrexReturn
implements Serializable {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$TrexReturn == null ? (class$com$sapportals$trex$TrexReturn = TrexReturn.class$("com.sapportals.trex.TrexReturn")) : class$com$sapportals$trex$TrexReturn).getName());
    private int code = 0;
    private String msg = "";
    private static final String ERROR_MESSAGES = "com.sapportals.trex.TrexErrorMessages";
    private ResourceBundle messages = ResourceBundle.getBundle("com.sapportals.trex.TrexErrorMessages");
    private static char PLACE_HOLDER = (char)38;
    private static int MAX_ARGS = 4;
    private static final boolean CHECK_NUMBER_OF_ARGUMENTS = true;
    public static final int NO_ERROR = 0;
    public static final int CPP_INDEX_ALREADY_EXISTS = 2003;
    public static final int CPP_INDEX_DOESNOT_EXIST = 2007;
    public static final int CPP_QUEUE_DOESNOT_EXIST = 6002;
    public static final int CPP_QUEUE_ALREADY_EXISTS = 6021;
    public static final int CPP_FUNCTION_NOT_IMPLEMENTED = 2981;
    public static final int UNKNOWN_ERROR = 7201;
    public static final int EXTERNAL_ERROR = 7202;
    public static final int INVALID_PARAMETER = 7203;
    public static final int EXTERNAL_ERROR2 = 7204;
    public static final int ERROR_LOADING_CONFIGURATION = 7210;
    public static final int CANNOT_OPEN_CONFIGURATION_FILE = 7211;
    public static final int INVALID_ENTRY_IN_CONFIG_FILE = 7213;
    public static final int MISSING_ENTRY_IN_CONFIG_FILE = 7214;
    public static final int INVALID_ENTRY_IN_NAMESERVER = 7215;
    public static final int MISSING_ENTRY_IN_NAMESERVER = 7216;
    public static final int NAME_SERVER_NOT_ACCESSABLE = 7217;
    public static final int NO_ACTIVE_HTTPSERVER_AT_NAMESERVER = 7218;
    public static final int INVALID_HTTP_SERVER_URL_GIVEN = 7219;
    public static final int CANNOT_SET_SERVICE_PROPERTY = 7220;
    public static final int NO_INDEX_GIVEN = 7230;
    public static final int INVALID_ACCESS_MODE = 7231;
    public static final int NO_QUEUELIST_GIVEN = 7233;
    public static final int NO_QS_LOCATION_GIVEN = 7236;
    public static final int ERROR_JNI_ADMIN = 7240;
    public static final int ERROR_JNI_SEARCH = 7241;
    public static final int ERROR_JNI_TEXT_MINING = 7242;
    public static final int ERROR_JNI_CREATE_INDEX = 7243;
    public static final int ERROR_JNI_INDEX = 7244;
    public static final int XML_PARSE_ERROR = 7260;
    public static final int UNKNOWN_CONTENT_TYPE = 7261;
    public static final int CANNOT_SEND = 7262;
    public static final int URL_NOT_SPECIFIED = 7263;
    public static final int BAD_URL = 7264;
    public static final int BAD_URL2 = 7265;
    public static final int HTTP_SERVER_ERROR = 7266;
    public static final int DIFFERENT_DOCUMENT_ACTION = 7267;
    public static final int CANNOT_INITIALIZE_PARSER = 7268;
    public static final int CANNOT_PARSE_XML = 7269;
    public static final int SOCKET_CANNOT_OPEN = 7270;
    public static final int SOCKET_CANNOT_SEND = 7271;
    public static final int SOCKET_CONNECTION_ERROR = 7272;
    public static final int SOCKET_DATA_ERROR = 7273;
    public static final int PATH_OF_SSL_PROPERTIES_FILE_NOT_SET = 7280;
    public static final int PATH_OF_SSL_PROPERTIES_FILE_INVALID = 7281;
    public static final int SSL_NOT_CONFIGURED_PROPERLY = 7282;
    public static final int SYSTEM_PROPERTY_FOR_SSL_NOT_SET = 7283;
    public static final int CANNOT_DELETE_QUERY = 7401;
    public static final int CANNOT_DELETE_QUERY_ON_DB = 7402;
    public static final int SERVERURL_MISSING = 7501;
    public static final int PROFILINGINDEX_MISSING = 7502;
    public static final int CONFIGFILE_READ_ERROR = 7503;
    public static final int PROFMAN_INIT_ERROR = 7504;
    public static final int CONFIGFILE_LOADED = 7505;
    public static final int INVALID_DOCUMENT = 7511;
    public static final int INVALID_URL = 7512;
    public static final int INVALID_OWNERNAME = 7513;
    public static final int INVALID_KEYWORD = 7514;
    public static final int ATTRIBUTE_MISSING = 7515;
    public static final int PROFILE_NOT_INDEXED = 7520;
    public static final int SOME_PROFILE_ITEMS_NOT_INDEXED = 7521;
    public static final int INCONSISTENCE_ERROR = 7522;
    public static final int PROFILE_NOT_DELETED = 7530;
    public static final int PROFILE_NOT_SAVED = 7531;
    public static final int PROFILEID_NOT_FOUND = 7540;
    public static final int PROFILE_NOT_FOUND = 7541;
    public static final int INDEX_NOT_CLEARED = 7550;
    public static final int DB_EXECUTE_SQL_ERROR = 7600;
    public static final int DB_ROLLBACK_ERROR = 7601;
    public static final int DB_CLOSE_ERROR = 7602;
    public static final int DB_RECORDSET_ACCESS_ERROR = 7603;
    public static final int DB_DEQUEUE_ERROR = 7604;
    public static final int DB_COMMIT_ERROR = 7605;
    public static final int DB_ROLLBACK_SUCCEEDED = 7606;
    public static final int DB_ACCESS_INFO = 7607;
    public static final int CONNECTIONPOOL_INIT_ERROR = 7610;
    public static final int CONNECTIONPOOL_GET_ERROR = 7611;
    public static final int ERROR_CONNECT_TO_NAMESERVER = 7700;
    public static final int ERROR_READING_FROM_NAMESERVER = 7701;
    public static final int ERROR_WRITING_TO_NAMESERVER = 7702;
    public static final int ERROR_OLD_TREX_6_VERSION = 7703;
    public static final int EMPTY_PARAMETER_NOT_ALLOWED = 7801;
    static /* synthetic */ Class class$com$sapportals$trex$TrexReturn;

    public TrexReturn(int code_, String arg1, String arg2, String arg3, String arg4) {
        this.code = code_;
        this.setMsg(code_, arg1, arg2, arg3, arg4);
    }

    public TrexReturn(int code_, String arg1, String arg2, String arg3) {
        this.code = code_;
        this.setMsg(code_, arg1, arg2, arg3);
    }

    public TrexReturn(int code_, String arg1, String arg2) {
        this.code = code_;
        this.setMsg(code_, arg1, arg2);
    }

    public TrexReturn(int code_, String arg1) {
        this.code = code_;
        this.setMsg(code_, arg1);
    }

    public TrexReturn(int code_) {
        this.code = code_;
        this.setMsg(code_);
    }

    protected TrexReturn(int code_, int ext_code, String errorMessage) {
        this.code = ext_code;
        if (errorMessage == null) {
            this.setMsg(ext_code);
        } else {
            this.setMsg(errorMessage);
        }
    }

    public static TrexReturn createExternalError(int code_, String text) {
        TrexReturn ret = new TrexReturn(7202, code_, text);
        return ret;
    }

    private void setMsg(int code_) {
        String msgRaw = null;
        String[] args = null;
        try {
            msgRaw = this.messages.getString(Integer.toString(code_));
        }
        catch (MissingResourceException e) {
            msgRaw = this.messages.getString(Integer.toString(7201));
            args = new String[]{Integer.toString(code_)};
        }
        this.msg = this.parseMsg(code_, msgRaw, args);
    }

    private void setMsg(String errorMessage) {
        this.msg = errorMessage;
    }

    private void setMsg(int code_, String arg1) {
        String[] args = new String[]{arg1};
        this.setMsg(code_, args);
    }

    private void setMsg(int code_, String arg1, String arg2) {
        String[] args = new String[]{arg1, arg2};
        this.setMsg(code_, args);
    }

    private void setMsg(int code_, String arg1, String arg2, String arg3) {
        String[] args = new String[]{arg1, arg2, arg3};
        this.setMsg(code_, args);
    }

    private void setMsg(int code_, String arg1, String arg2, String arg3, String arg4) {
        String[] args = new String[]{arg1, arg2, arg3, arg4};
        this.setMsg(code_, args);
    }

    private void setMsg(int code_, String[] args) {
        String msgRaw = null;
        String[] args2 = args;
        try {
            msgRaw = this.messages.getString(Integer.toString(code_));
        }
        catch (MissingResourceException e) {
            msgRaw = this.messages.getString(Integer.toString(7201));
            args2 = new String[]{Integer.toString(code_)};
        }
        this.msg = this.parseMsg(code_, msgRaw, args2);
    }

    private void checkNumberOfArguments(int code_, String msgRaw, String[] args) {
        int[] placeHolder = new int[5];
        int i = 1;
        while (i <= 4) {
            int rpos;
            String pattern = PLACE_HOLDER + Integer.toString(i);
            placeHolder[i] = rpos = msgRaw.indexOf(pattern);
            ++i;
        }
        int numOfPlaceholders = 0;
        if (placeHolder[1] != -1) {
            ++numOfPlaceholders;
            if (placeHolder[2] != -1) {
                ++numOfPlaceholders;
                if (placeHolder[3] != -1) {
                    ++numOfPlaceholders;
                    if (placeHolder[4] != -1) {
                        ++numOfPlaceholders;
                    }
                }
            }
        }
        if (numOfPlaceholders < 3) {
            int i2 = numOfPlaceholders + 2;
            while (i2 <= MAX_ARGS) {
                if (placeHolder[i2] != -1) {
                    log.warningT("unused placeholder in error message; please check the text of error message number " + code_);
                }
                ++i2;
            }
        }
        int argumentCount = 0;
        if (args != null) {
            argumentCount = args.length;
        }
        if (numOfPlaceholders != argumentCount) {
            log.warningT("wrong number of arguments: " + argumentCount + " argument(s) for " + numOfPlaceholders + " placeholder(s) given; error code: " + code_);
        }
    }

    private String parseMsg(int code_, String msgRaw, String[] args) {
        String ret = "";
        StringBuffer msg = null;
        if (msgRaw == null) {
            return ret;
        }
        this.checkNumberOfArguments(code_, msgRaw, args);
        msg = new StringBuffer(msgRaw);
        int i = 1;
        while (i <= MAX_ARGS) {
            String str = new String(msg);
            String pattern = PLACE_HOLDER + Integer.toString(i);
            int index = str.indexOf(pattern);
            if (index > -1) {
                String message = "";
                if (args.length >= i && args[i - 1] != null) {
                    message = args[i - 1];
                }
                msg.replace(index, index + 2, message);
            }
            ++i;
        }
        return msg.toString();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

