/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.test;

import com.sapportals.portal.prt.component.AbstractPortalComponent;
import com.sapportals.portal.prt.component.IPortalComponentContext;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.IPortalComponentURI;
import com.sapportals.portal.prt.pom.IEvent;
import com.sapportals.portal.prt.pom.INode;
import com.sapportals.portal.prt.pom.IPortalNode;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.test.ITestable;

public abstract class AbstractTestComponent
extends AbstractPortalComponent
implements ITestable {
    private String mm_contextName = "default name";

    public void doContent(IPortalComponentRequest request, IPortalComponentResponse response) {
        IPortalComponentURI uri = request.createPortalComponentURI();
        uri.setTargetNode(request.getNode());
        response.write("<a href=\"" + uri + "/prtmode/test\">test mode (html)</a><br>");
        response.write("<a href=\"" + uri + "/prttest/components\">test mode (xml)</a>");
    }

    public String getTestName() {
        return this.mm_contextName;
    }

    public void doOnNodeReady(IPortalComponentRequest request, IEvent event) {
        IPortalNode portalNode = request.getNode().getPortalNode();
        IPortalComponentContext portalComponentContext = request.getComponentContext(NodeMode.DEFAULT_MODE);
        this.mm_contextName = portalComponentContext.getContextName();
    }

    public void putValueOnNode(INode node, String key, Object value) {
        node.putValue(key, value);
    }

    public Object getValueOnNode(INode node, String key) {
        Object value = node.getValue(key);
        node.removeValue(key);
        return value;
    }

    public Object getValueOnNode(INode node, String key, boolean clean) {
        Object value = node.getValue(key);
        if (clean) {
            node.removeValue(key);
        }
        return value;
    }

    public void putValueOnSession(IPortalComponentRequest request, String key, Object value) {
        request.getComponentSession().putValue(key, value);
    }

    public Object getValueOnSession(IPortalComponentRequest request, String key) {
        Object value = request.getComponentSession().getValue(key);
        request.getComponentSession().removeValue(key);
        return value;
    }

    public Object getValueOnSession(IPortalComponentRequest request, String key, boolean clean) {
        Object value = request.getComponentSession().getValue(key);
        if (clean) {
            request.getComponentSession().removeValue(key);
        }
        return value;
    }

    public void putValueOnSession(IPortalComponentRequest request, String key, Object value, short scope) {
        request.getComponentSession().putValue(key, value, scope);
    }

    public Object getValueOnSession(IPortalComponentRequest request, String key, short scope) {
        Object value = request.getComponentSession().getValue(key, scope);
        request.getComponentSession().removeValue(key, scope);
        return value;
    }

    public Object getValueOnSession(IPortalComponentRequest request, String key, short scope, boolean clean) {
        Object value = request.getComponentSession().getValue(key, scope);
        if (clean) {
            request.getComponentSession().removeValue(key, scope);
        }
        return value;
    }
}

