/*
 * Decompiled with CFR 0.152.
 */
package com.sap.guid;

import com.sap.guid.GUID;
import com.sap.guid.GUIDFormatException;
import com.sap.guid.GUIDVersionException;
import com.sap.guid.IGUID;
import com.sap.guid.IGUIDGenerator;
import java.util.Properties;

class GUIDGenerator
implements IGUIDGenerator {
    private Properties properties;

    public GUIDGenerator() {
    }

    public GUIDGenerator(Properties props) {
        this.setProperties(props);
    }

    public IGUID createGUID() {
        return new GUID(this.properties);
    }

    public IGUID createGUID(byte[] g) throws GUIDFormatException {
        return new GUID(g);
    }

    public IGUID createGUID(IGUID originalGUID, byte[] variantDescriptor) {
        return new GUID((GUID)originalGUID, variantDescriptor);
    }

    public IGUID createGUID(int version) throws GUIDVersionException {
        return new GUID(this.properties, version);
    }

    public IGUID createGUID(String value) {
        return new GUID(value);
    }

    public IGUID parseGUID(String guid) throws GUIDFormatException {
        return GUID.parseGUID(guid);
    }

    public IGUID parseHexGUID(String guid) throws GUIDFormatException {
        return GUID.parseHexGUID(guid);
    }

    public synchronized void setProperties(Properties props) {
        this.properties = props;
    }
}

