/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.vaclient;

import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.sldserv.SendInfo;
import com.sap.sldserv.ServiceManagementInterface;
import com.sap.sldserv.ServiceManagementResponse;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.util.ServiceUtils;
import com.sap.sldserv.vaclient.ClientDialog;
import com.sap.sldserv.vaclient.DomainTableModel;
import com.sap.sldserv.vaclient.InfoTableModel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClientManagementGui
extends JPanel {
    protected static final int MIN_NUM_ROWS = 7;
    protected static final int OPT_NUM_ROWS = 20;
    protected static final int MAX_NUM_ROWS = 30;
    protected static final int MIN_NUM_COLS = 20;
    protected static final int OPT_NUM_COLS = 50;
    protected static final int MAX_NUM_COLS = 70;
    protected static final String CONNECT_GIF = "images/connect.gif";
    protected static final String REFRESH_GIF = "images/refresh.gif";
    protected static final String ASSIGNROLES_GIF = "images/assignroles.gif";
    protected static final String PANEL_NAME_INFO = "infopanel";
    protected static final String PANEL_NAME_HTTP = "httppanel";
    protected static final String PANEL_NAME_RFC = "rfcpanel";
    protected static final String PANEL_NAME_AUTH = "authpanel";
    protected static final String PANEL_NAME_MAIN = "mainpanel";
    public static final String ID_NAME = "SAPJ2EEEngineVisualAdministrator";
    protected static final String ACTION_SEND_SLD_DATA = "SendSldData";
    protected static final String ACTION_REFRESH_SLD_SEND_INFO = "RefreshSldSendInfo";
    protected static final String ACTION_ASSIGNROLES = "AssignRoles";
    protected static final String ACTION_SAVE_HTTP_DATA = "HttpSaveData";
    protected static final String ACTION_RESET_HTTP_DATA = "HttpResetData";
    protected static final String ACTION_REFRESH_HTTP_DATA = "HttpRefreshData";
    protected static final String ACTION_DELETE_HTTP_DATA = "HttpDeleteData";
    protected static final String ACTION_TOGGLE_HTTP_HTTPS_SETTING = "ToggleHttpHttps";
    protected static final String ACTION_SAVE_RFC_DATA = "RfcSaveData";
    protected static final String ACTION_RESET_RFC_DATA = "RfcResetData";
    protected static final String ACTION_REFRESH_RFC_DATA = "RfcRefreshData";
    protected static final String ACTION_DELETE_RFC_DATA = "RfcDeleteData";
    protected static final String ACTION_SAVE_GEN_DATA = "GenSaveData";
    protected static final String ACTION_REFRESH_GEN_DATA = "GenRefreshData";
    protected static final String ACTION_TEST_GEN_DATA = "GenTestData";
    protected static final String ACTION_TOGGLE_GEN_HTTPS_SETTING = "ToggleGenHttps";
    protected static final String DEFAULT_VALUE = "<unknown>";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String INFO_PANEL_BORDER_TEXT = ResourceUtil.formatString("sld_5016");
    protected static final String HTTP_PANEL_BORDER_TEXT = ResourceUtil.formatString("sld_5017");
    protected static final String RFC_PANEL_BORDER_TEXT = ResourceUtil.formatString("sld_5029");
    protected static final String AUTH_PANEL_BORDER_TEXT = ResourceUtil.formatString("sld_5048");
    protected static final String BUTTON_TEXT_SEND = ResourceUtil.formatString("sld_5018");
    protected static final String BUTTON_TEXT_REFRESH = ResourceUtil.formatString("sld_5019");
    protected static final String BUTTON_TEXT_ASSIGNROLES = ResourceUtil.formatString("sld_5097");
    protected static final String TOOL_TIP_TEXT_SEND = ResourceUtil.formatString("sld_5004");
    protected static final String TOOL_TIP_TEXT_REFRESH = ResourceUtil.formatString("sld_5005");
    protected static final String TOOL_TIP_TEXT_ASSIGNROLES = ResourceUtil.formatString("sld_5096");
    protected static final String TOOL_TIP_TEXT_HTTP_SAVE = ResourceUtil.formatString("sld_5010");
    protected static final String TOOL_TIP_TEXT_HTTP_REFRESH = ResourceUtil.formatString("sld_5012");
    protected static final String TOOL_TIP_TEXT_HTTP_RESET = ResourceUtil.formatString("sld_5011");
    protected static final String TOOL_TIP_TEXT_HTTP_DELETE = ResourceUtil.formatString("sld_5044");
    protected static final String TOOL_TIP_TEXT_RFC_SAVE = ResourceUtil.formatString("sld_5036");
    protected static final String TOOL_TIP_TEXT_RFC_REFRESH = ResourceUtil.formatString("sld_5038");
    protected static final String TOOL_TIP_TEXT_RFC_RESET = ResourceUtil.formatString("sld_5037");
    protected static final String TOOL_TIP_TEXT_RFC_DELETE = ResourceUtil.formatString("sld_5045");
    protected static final String TOOL_TIP_TEXT_GEN_SAVE = ResourceUtil.formatString("sld_5065");
    protected static final String TOOL_TIP_TEXT_GEN_REFRESH = ResourceUtil.formatString("sld_5067");
    protected static final String TOOL_TIP_TEXT_GEN_TEST = ResourceUtil.formatString("sld_5081");
    protected static final String BUTTON_TEXT_HTTP_SAVE = ResourceUtil.formatString("sld_5013");
    protected static final String BUTTON_TEXT_HTTP_REFRESH = ResourceUtil.formatString("sld_5015");
    protected static final String BUTTON_TEXT_HTTP_RESET = ResourceUtil.formatString("sld_5014");
    protected static final String BUTTON_TEXT_HTTP_DELETE = ResourceUtil.formatString("sld_5040");
    protected static final String BUTTON_TEXT_RFC_SAVE = ResourceUtil.formatString("sld_5041");
    protected static final String BUTTON_TEXT_RFC_REFRESH = ResourceUtil.formatString("sld_5043");
    protected static final String BUTTON_TEXT_RFC_RESET = ResourceUtil.formatString("sld_5042");
    protected static final String BUTTON_TEXT_RFC_DELETE = ResourceUtil.formatString("sld_5039");
    protected static final String BUTTON_TEXT_GEN_SAVE = ResourceUtil.formatString("sld_5060");
    protected static final String BUTTON_TEXT_GEN_REFRESH = ResourceUtil.formatString("sld_5062");
    protected static final String BUTTON_TEXT_GEN_TEST = ResourceUtil.formatString("sld_5080");
    protected static final String GRAND_FIELD = ResourceUtil.formatString("sld_5063");
    protected static final String DOMAIN_FIELD = ResourceUtil.formatString("sld_5064");
    protected static final String[] domainTableHeaders = new String[]{GRAND_FIELD, DOMAIN_FIELD};
    protected static final String ATTRIBUT_FIELD = ResourceUtil.formatString("sld_5094");
    protected static final String ATTRIBUT_VALUE_FIELD = ResourceUtil.formatString("sld_5095");
    protected static final String[] infoTableHeaders = new String[]{ATTRIBUT_FIELD, ATTRIBUT_VALUE_FIELD};
    protected static final String PERSISTENCE_VALID = ResourceUtil.formatString("sld_5082");
    protected static final String PERSISTENCE_INVALID = ResourceUtil.formatString("sld_5083");
    protected Frame frame = null;
    protected JTabbedPane tabbedPane;
    protected JPanel infoPanel;
    protected JPanel httpPanel;
    protected JPanel rfcPanel;
    protected JPanel authPanel;
    protected JPanel httpButtonsPanel;
    protected JPanel rfcButtonsPanel;
    protected JPanel genButtonsPanel;
    protected JButton sendButton;
    protected JButton refreshButton;
    protected JButton assignRolesButton;
    protected JButton[] runtimeButtons;
    protected JLabel httpInfoLabel;
    protected JLabel httpHostLabel;
    protected JLabel httpPortLabel;
    protected JLabel httpUserLabel;
    protected JLabel httpPassLabel;
    protected JLabel httpsUseHttpsLabel;
    protected JLabel httpsTrustStoreLabel;
    protected JTextField httpHostField;
    protected JTextField httpPortField;
    protected JTextField httpUserField;
    protected JTextField httpPassField;
    protected JTextField httpsTrustStoreField;
    protected JCheckBox httpUseHttpsField;
    protected JButton httpSaveButton;
    protected JButton httpRefreshButton;
    protected JButton httpResetButton;
    protected JButton httpDeleteButton;
    protected JLabel rfcInfoLabel;
    protected JLabel rfcGatewayHostLabel;
    protected JLabel rfcGatewayServiceLabel;
    protected JTextField rfcGatewayHostField;
    protected JTextField rfcGatewayServiceField;
    protected JButton rfcSaveButton;
    protected JButton rfcRefreshButton;
    protected JButton rfcResetButton;
    protected JButton rfcDeleteButton;
    protected JLabel genDomainLabel;
    protected JLabel genConnectionLabel;
    protected JLabel genUserInfoLabel;
    protected JLabel genHostLabel;
    protected JLabel genPortLabel;
    protected JLabel genUserLabel;
    protected JLabel genPassLabel;
    protected JLabel genHttpsLabel;
    protected JLabel genUseHttpsLabel;
    protected JLabel genHttpsTrustStoreLabel;
    protected JTextField genHostField;
    protected JTextField genPortField;
    protected JTextField genUserField;
    protected JTextField genPassField;
    protected JTextField genHttpsTrustStoreField;
    protected JCheckBox genUseHttpsField;
    protected JScrollPane scrollPaneDomainTable;
    protected DomainTableModel domainDataTable = null;
    protected InfoTableModel infoDataTable = null;
    protected JTable domainTable = null;
    protected JTable infoTable = null;
    protected JButton genSaveButton;
    protected JButton genRefreshButton;
    protected JButton genTestButton;
    protected EditorViewManager taskManager = null;
    protected ServiceManagementAccessWrapper serviceIF = new ServiceManagementAccessWrapper();
    protected volatile boolean completionThreadStarted = false;
    protected boolean alreadyWarningShown = false;

    protected void refreshSendInfo() {
        if (this.serviceIF.isAvailable()) {
            SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
            if (sendInfo != null) {
                this.infoDataTable.setValueAt(this.getLastSendTime(), 0, 1);
                this.infoDataTable.setValueAt(sendInfo.useRfcConnection() ? ResourceUtil.formatString("sld_5007") : ResourceUtil.formatString("sld_5008"), 1, 0);
                this.infoDataTable.setValueAt(this.getUsedParams(sendInfo), 1, 1);
                this.infoDataTable.setValueAt(this.getLastSendClusterNodeInfo(), 2, 1);
                this.infoDataTable.setValueAt(this.getLastSuccessFailedInfo(), 3, 1);
                this.infoDataTable.setValueAt(this.getNextSendTime(), 4, 1);
                this.infoDataTable.setValueAt(this.getManagementRunInfo(), 5, 1);
                this.infoDataTable.setValueAt(this.getConnectConfigStatus(), 6, 1);
            }
            this.infoTable.invalidate();
            this.setSendInfoTableSize();
        } else {
            this.completeDisplay();
        }
    }

    protected ServiceManagementAccessWrapper getServiceIf() {
        return this.serviceIF;
    }

    protected boolean serviceIfIsAvaialable() {
        return this.serviceIF.isAvailable();
    }

    protected synchronized void completeDisplay() {
        if (!this.completionThreadStarted) {
            this.completionThreadStarted = true;
            new WaitForServiceIf(this).start();
        }
    }

    protected void getHttpProperties() {
        if (this.serviceIF.isAvailable()) {
            Properties props = this.serviceIF.getConfigParams(this.frame);
            if (props != null) {
                this.httpHostField.setText(props.getProperty("HttpHost"));
                this.httpPortField.setText(props.getProperty("HttpPort"));
                this.httpUserField.setText(props.getProperty("HttpUser"));
                this.httpPassField.setText(props.getProperty("HttpPassword"));
                String useHttpsStr = props.getProperty("UseHttps");
                this.httpUseHttpsField.setSelected(useHttpsStr != null && useHttpsStr.equalsIgnoreCase(TRUE));
                this.httpsTrustStoreField.setText(props.getProperty("TrustStore"));
                this.httpsTrustStoreField.setEditable(this.httpUseHttpsField.isSelected());
            } else {
                this.completeDisplay();
            }
        } else {
            this.completeDisplay();
        }
    }

    protected String getLastSendTime() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = sendInfo.getTimeString();
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getUsedParams() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = sendInfo.getParamString();
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getUsedParams(SendInfo sendInfo) {
        String rvalue = null;
        if (sendInfo != null) {
            rvalue = sendInfo.getParamString();
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getLastSendClusterNodeInfo() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = sendInfo.getHostIds();
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getLastSuccessFailedInfo() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = ResourceUtil.formatString(sendInfo.getSuccess() ? "sld_5086" : "sld_5087");
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getNextSendTime() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = sendInfo.getNextTimeString();
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getManagementRunInfo() {
        String rvalue = null;
        SendInfo sendInfo = this.serviceIF.getLastSendInfo(this.frame);
        if (sendInfo != null) {
            rvalue = sendInfo.getManagementRunInfo() ? ResourceUtil.formatString("sld_5103") : ResourceUtil.formatString("sld_5102");
        }
        return rvalue != null ? rvalue : DEFAULT_VALUE;
    }

    protected String getConnectConfigStatus() {
        Boolean rvalue = null;
        if (this.serviceIF.isAvailable()) {
            rvalue = this.serviceIF.hasValidConnectParams(this.frame);
        }
        return rvalue != null ? (rvalue.booleanValue() ? ResourceUtil.formatString("sld_5091") : ResourceUtil.formatString("sld_5092")) : DEFAULT_VALUE;
    }

    protected void setSendInfoTableSize() {
        int colWidth = 0;
        JLabel tempLabel = new JLabel();
        FontMetrics fontMetrics = ((Component)tempLabel).getFontMetrics(tempLabel.getFont());
        int i = 0;
        while (i < this.infoDataTable.getRowCount()) {
            InfoTableModel.InfoLine line = this.infoDataTable.get(i);
            String s1 = line.get(this.infoDataTable.getColumnIndex(ATTRIBUT_FIELD));
            String s2 = line.get(this.infoDataTable.getColumnIndex(ATTRIBUT_VALUE_FIELD));
            colWidth = Math.max(colWidth, SwingUtilities.computeStringWidth(fontMetrics, s1));
            colWidth = Math.max(colWidth, SwingUtilities.computeStringWidth(fontMetrics, s2));
            ++i;
        }
        this.infoTable.setAutoResizeMode(0);
        TableColumnModel columnModel = this.infoTable.getColumnModel();
        TableColumn column = columnModel.getColumn(this.infoDataTable.getColumnIndex(ATTRIBUT_FIELD));
        column.setMinWidth(colWidth);
        column.setPreferredWidth(colWidth);
        column = columnModel.getColumn(this.infoDataTable.getColumnIndex(ATTRIBUT_VALUE_FIELD));
        column.setMinWidth(colWidth);
        column.setPreferredWidth(colWidth);
        this.infoTable.setColumnModel(columnModel);
        this.infoTable.setModel(this.infoDataTable);
    }

    protected void getRfcProperties() {
        if (this.serviceIF.isAvailable()) {
            Properties props = this.serviceIF.getConfigParams(this.frame);
            if (props != null) {
                this.rfcGatewayHostField.setText(props.getProperty("GatewayHost"));
                this.rfcGatewayServiceField.setText(props.getProperty("GatewayService"));
            } else {
                this.completeDisplay();
            }
        } else {
            this.completeDisplay();
        }
    }

    protected void getProtectionDomainInfos() {
        if (this.serviceIF.isAvailable()) {
            Properties props;
            String persInfo = ResourceUtil.formatString("sld_5076") + "   " + (this.serviceIF.domainInfoIsPersistent(this.frame) ? PERSISTENCE_VALID : PERSISTENCE_INVALID);
            this.genDomainLabel.setText(persInfo);
            Set domainSldPerms = this.serviceIF.getSldPermissionsForDomains(this.frame);
            String[] domainNames = this.serviceIF.getDomainNames(this.frame);
            if (domainNames != null) {
                JLabel tempLabel = new JLabel();
                FontMetrics fontMetrics = ((Component)tempLabel).getFontMetrics(tempLabel.getFont());
                int checkBoxColWidth = SwingUtilities.computeStringWidth(fontMetrics, GRAND_FIELD);
                int maxDomainColWidth = -1;
                String[] row = null;
                ArrayList<String[]> data = new ArrayList<String[]>(domainNames.length);
                int i = 0;
                while (i < domainNames.length) {
                    row = new String[domainTableHeaders.length];
                    row[0] = domainSldPerms.contains(domainNames[i]) ? TRUE : FALSE;
                    row[1] = domainNames[i];
                    data.add(row);
                    maxDomainColWidth = Math.max(maxDomainColWidth, SwingUtilities.computeStringWidth(fontMetrics, domainNames[i]));
                    ++i;
                }
                this.domainDataTable.setData(data);
                this.domainTable.invalidate();
                this.domainTable.setAutoResizeMode(0);
                TableColumnModel columnModel = this.domainTable.getColumnModel();
                TableColumn column = columnModel.getColumn(this.domainDataTable.getColumnIndex(GRAND_FIELD));
                column.setMinWidth(checkBoxColWidth);
                column.setPreferredWidth(checkBoxColWidth);
                column = columnModel.getColumn(this.domainDataTable.getColumnIndex(DOMAIN_FIELD));
                column.setPreferredWidth(maxDomainColWidth);
                this.domainTable.setColumnModel(columnModel);
                this.domainTable.setModel(this.domainDataTable);
            }
            String host = "";
            String port = "-1";
            String user = "";
            String pass = "";
            boolean useHttps = false;
            String trustStoreValue = "TrustedCAs";
            Properties genProps = this.serviceIF.getGenerationParams(this.frame);
            if (!(genProps != null && this.isGenInfoSet(genProps) || (props = this.serviceIF.getConfigParams(this.frame)) == null || this.serviceIF.setGenerationParams(this.frame, genProps = this.generateGenInfoSet(props)))) {
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_3065"), 2);
            }
            if (genProps != null) {
                host = genProps.getProperty("HttpHost") == null ? "" : genProps.getProperty("HttpHost");
                port = genProps.getProperty("HttpPort") == null ? "" : genProps.getProperty("HttpPort");
                user = genProps.getProperty("HttpUser") == null ? "" : genProps.getProperty("HttpUser");
                pass = genProps.getProperty("HttpPassword") == null ? "" : genProps.getProperty("HttpPassword");
                String useHttpsStr = genProps.getProperty("UseHttps");
                useHttps = useHttpsStr != null && useHttpsStr.equalsIgnoreCase(TRUE);
                trustStoreValue = genProps.getProperty("TrustStore") == null || genProps.getProperty("TrustStore").length() == 0 ? "TrustedCAs" : genProps.getProperty("TrustStore").trim();
            }
            this.genHostField.setText(host);
            this.genPortField.setText(port);
            this.genUserField.setText(user);
            this.genPassField.setText(pass);
            this.genUseHttpsField.setSelected(useHttps);
            this.genHttpsTrustStoreField.setText(trustStoreValue);
            this.genHttpsTrustStoreField.setEditable(useHttps);
            if (!this.serviceIF.domainInfoIsPersistent(this.frame) && !this.alreadyWarningShown) {
                this.alreadyWarningShown = true;
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5084"), 2);
            }
        } else {
            this.completeDisplay();
        }
    }

    protected boolean isGenInfoSet(Properties genProps) {
        boolean rvalue = false;
        if (genProps != null) {
            String h = genProps.getProperty("HttpHost");
            String p = genProps.getProperty("HttpPort");
            String u = genProps.getProperty("HttpUser");
            rvalue = h != null && h.length() != 0 && p != null && p.length() != 0 && u != null && u.length() != 0;
        }
        return rvalue;
    }

    protected Properties generateGenInfoSet(Properties props) {
        Properties genProps = new Properties();
        if (props != null) {
            ((Hashtable)genProps).put("HttpHost", props.getProperty("HttpHost"));
            ((Hashtable)genProps).put("HttpPort", props.getProperty("HttpPort"));
            ((Hashtable)genProps).put("HttpUser", props.getProperty("HttpUser"));
            ((Hashtable)genProps).put("HttpPassword", props.getProperty("HttpPassword"));
            ((Hashtable)genProps).put("UseHttps", FALSE);
            ((Hashtable)genProps).put("TrustStore", "TrustedCAs");
        }
        return genProps;
    }

    protected static class ServiceManagementAccessWrapper {
        private ServiceManagementInterface serviceManagementInterface = null;

        protected ServiceManagementAccessWrapper() {
        }

        protected ServiceManagementAccessWrapper(ServiceManagementInterface serviceManagementInterface) {
            this.serviceManagementInterface = serviceManagementInterface;
        }

        protected synchronized void set(ServiceManagementInterface serviceManagementInterface) {
            this.serviceManagementInterface = serviceManagementInterface;
        }

        protected boolean isAvailable() {
            return this.serviceManagementInterface != null;
        }

        protected ServiceManagementInterface getIF() {
            return this.serviceManagementInterface;
        }

        protected SendInfo getLastSendInfo(Frame frame) {
            SendInfo rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.getLastSendInfo();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5107", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected Properties getConfigParams(Frame frame) {
            Properties rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.getConfigParams();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5108", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected Boolean hasValidConnectParams(Frame frame) {
            Boolean rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.hasValidConnectParams() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5109", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected Set getSldPermissionsForDomains(Frame frame) {
            Set rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.getSldPermissionsForDomains();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5110", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected String[] getDomainNames(Frame frame) {
            String[] rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.getDomainNames();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5111", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean domainInfoIsPersistent(Frame frame) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.domainInfoIsPersistent();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5112", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected Properties getGenerationParams(Frame frame) {
            Properties rvalue = null;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.getGenerationParams();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5113", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean setConfigParams(Frame frame, Properties props) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.setConfigParams(props);
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5118", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean setGenerationParams(Frame frame, Properties props) {
            boolean rvalue = false;
            if (props != null) {
                try {
                    if (this.serviceManagementInterface != null) {
                        rvalue = this.serviceManagementInterface.setGenerationParams(props);
                    }
                }
                catch (Exception e) {
                    ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5114", new Object[]{e.toString()}), 0);
                }
            }
            return rvalue;
        }

        protected boolean performRoleMapping(Frame frame) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.performRoleMapping();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5115", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected ServiceManagementResponse doCollect(Frame frame) {
            ServiceManagementResponse rvalue = new ServiceManagementResponse();
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.doCollect();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5116", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean validateCimClient(Frame frame) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.validateCimClient();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5117", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean deleteHttpParams(Frame frame) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.deleteHttpParams();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5119", new Object[]{"HTTP", e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean deleteRfcParams(Frame frame) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.deleteRfcParams();
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5119", new Object[]{"RFC", e.toString()}), 0);
            }
            return rvalue;
        }

        protected boolean setSldPermissionsForDomains(Frame frame, Set domains) {
            boolean rvalue = false;
            try {
                if (this.serviceManagementInterface != null) {
                    rvalue = this.serviceManagementInterface.setSldPermissionsForDomains(domains);
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(frame, ResourceUtil.formatStringNoParameterLocalization("sld_5120", new Object[]{e.toString()}), 0);
            }
            return rvalue;
        }
    }

    protected static class RefreshDisplay
    extends Thread {
        private ClientManagementGui cm = null;

        protected RefreshDisplay(ClientManagementGui cm) {
            this.cm = cm;
        }

        public void run() {
            while (true) {
                if (this.cm.serviceIfIsAvaialable()) break;
                ServiceUtils.waitSeconds(1L);
            }
            this.cm.refreshSendInfo();
            this.cm.getHttpProperties();
            this.cm.getRfcProperties();
            this.cm.getProtectionDomainInfos();
        }
    }

    protected static class WaitForServiceIf
    extends Thread {
        private ClientManagementGui cm = null;

        protected WaitForServiceIf(ClientManagementGui cm) {
            this.cm = cm;
        }

        public void run() {
            while (true) {
                if (this.cm.serviceIfIsAvaialable()) break;
                ServiceUtils.waitSeconds(1L);
            }
            SwingUtilities.invokeLater(new RefreshDisplay(this.cm));
        }
    }
}

