/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.vaclient;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.sldserv.ServiceManagementInterface;
import com.sap.sldserv.ServiceManagementResponse;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.vaclient.ClientDialog;
import com.sap.sldserv.vaclient.ClientManagementGui;
import com.sap.sldserv.vaclient.DomainTableModel;
import com.sap.sldserv.vaclient.InfoTableModel;
import com.sap.sldserv.vaclient.ProgressTaskItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ClientManagement
extends ClientManagementGui
implements VisualRuntimeControl,
ActionListener {
    public ClientManagement() {
        this.generateGui();
    }

    private void generateGui() {
        this.generateStatusBarButtons();
        this.generateInfoPanel();
        this.generateHttpPanel();
        this.getHttpProperties();
        this.generateRfcPanel();
        this.getRfcProperties();
        this.generateAuthPanel();
        this.getProtectionDomainInfos();
        this.generateMainPane();
    }

    private void generateMainPane() {
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.add(ResourceUtil.formatString("sld_5025"), this.infoPanel);
        this.tabbedPane.add(ResourceUtil.formatString("sld_5026"), this.httpPanel);
        this.tabbedPane.add(ResourceUtil.formatString("sld_5033"), this.rfcPanel);
        this.tabbedPane.add(ResourceUtil.formatString("sld_5059"), this.authPanel);
        this.tabbedPane.setName("mainpanel");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private void generateAuthPanel() {
        this.generateDomainPanel(null);
    }

    private void generateDomainPanel(ArrayList tabData) {
        this.authPanel = new JPanel();
        this.authPanel.setLayout(new GridBagLayout());
        this.authPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ClientManagementGui.AUTH_PANEL_BORDER_TEXT));
        this.genDomainLabel = new JLabel(ResourceUtil.formatString("sld_5076"));
        this.authPanel.add((Component)this.genDomainLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.domainDataTable = new DomainTableModel(tabData, ClientManagementGui.domainTableHeaders);
        this.domainTable = new JTable(this.domainDataTable);
        this.scrollPaneDomainTable = new JScrollPane(this.domainTable, 20, 30);
        FontMetrics fontMetrics = ((Component)this.scrollPaneDomainTable).getFontMetrics(this.scrollPaneDomainTable.getFont());
        this.scrollPaneDomainTable.setMinimumSize(new Dimension(20 * this.getMax(fontMetrics.getWidths()), 7 * fontMetrics.getHeight()));
        this.scrollPaneDomainTable.setPreferredSize(new Dimension(50 * this.getMax(fontMetrics.getWidths()), 20 * fontMetrics.getHeight()));
        this.scrollPaneDomainTable.setMaximumSize(new Dimension(70 * this.getMax(fontMetrics.getWidths()), 30 * fontMetrics.getHeight()));
        this.authPanel.add((Component)this.scrollPaneDomainTable, new GridBagConstraints(0, 1, 0, 2, 0.0, 0.0, 11, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.genConnectionLabel = new JLabel(ResourceUtil.formatString("sld_5068"));
        this.authPanel.add((Component)this.genConnectionLabel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 1, 1, 1), 1, 1));
        this.genHostLabel = new JLabel(ResourceUtil.formatString("sld_5069"));
        this.genHostLabel.setDisplayedMnemonic('0');
        this.authPanel.add((Component)this.genHostLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.genHostField = new JTextField();
        this.genHostLabel.setLabelFor(this.genHostField);
        this.authPanel.add((Component)this.genHostField, new GridBagConstraints(2, 5, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.genPortLabel = new JLabel(ResourceUtil.formatString("sld_5070"));
        this.genPortLabel.setDisplayedMnemonic('1');
        this.authPanel.add((Component)this.genPortLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.genPortField = new JTextField();
        this.genPortLabel.setLabelFor(this.genPortField);
        this.authPanel.add((Component)this.genPortField, new GridBagConstraints(2, 6, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.genUserInfoLabel = new JLabel(ResourceUtil.formatString("sld_5071"));
        this.authPanel.add((Component)this.genUserInfoLabel, new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 1, 1, 1), 1, 1));
        this.genUserLabel = new JLabel(ResourceUtil.formatString("sld_5072"));
        this.genUserLabel.setDisplayedMnemonic('3');
        this.authPanel.add((Component)this.genUserLabel, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.genUserField = new JTextField();
        this.genUserLabel.setLabelFor(this.genUserField);
        this.authPanel.add((Component)this.genUserField, new GridBagConstraints(2, 8, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.genPassLabel = new JLabel(ResourceUtil.formatString("sld_5073"));
        this.genPassLabel.setDisplayedMnemonic('4');
        this.authPanel.add((Component)this.genPassLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.genPassField = new JPasswordField();
        this.genPassLabel.setLabelFor(this.genPassField);
        this.authPanel.add((Component)this.genPassField, new GridBagConstraints(2, 9, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.genUseHttpsLabel = new JLabel(ResourceUtil.formatString("sld_5104"));
        this.genUseHttpsLabel.setDisplayedMnemonic('5');
        this.authPanel.add((Component)this.genUseHttpsLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.genUseHttpsField = new JCheckBox();
        this.genUseHttpsLabel.setLabelFor(this.genUseHttpsField);
        this.genUseHttpsField.setActionCommand("ToggleGenHttps");
        this.genUseHttpsField.addActionListener(this);
        this.authPanel.add((Component)this.genUseHttpsField, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.genHttpsTrustStoreLabel = new JLabel(ResourceUtil.formatString("sld_5105"));
        this.genHttpsTrustStoreLabel.setDisplayedMnemonic('6');
        this.authPanel.add((Component)this.genHttpsTrustStoreLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.genHttpsTrustStoreField = new JTextField();
        this.genHttpsTrustStoreField.setEditable(false);
        this.genHttpsTrustStoreLabel.setLabelFor(this.genHttpsTrustStoreField);
        this.authPanel.add((Component)this.genHttpsTrustStoreField, new GridBagConstraints(2, 11, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.genButtonsPanel = new JPanel();
        this.genButtonsPanel.setLayout(new GridBagLayout());
        this.genSaveButton = new JButton(ClientManagementGui.BUTTON_TEXT_GEN_SAVE);
        this.genSaveButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_GEN_SAVE);
        this.genSaveButton.setActionCommand("GenSaveData");
        this.genSaveButton.addActionListener(this);
        this.genButtonsPanel.add((Component)this.genSaveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.genRefreshButton = new JButton(ClientManagementGui.BUTTON_TEXT_GEN_REFRESH);
        this.genRefreshButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_GEN_REFRESH);
        this.genRefreshButton.setActionCommand("GenRefreshData");
        this.genRefreshButton.addActionListener(this);
        this.genButtonsPanel.add((Component)this.genRefreshButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.genTestButton = new JButton(ClientManagementGui.BUTTON_TEXT_GEN_TEST);
        this.genTestButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_GEN_TEST);
        this.genTestButton.setActionCommand("GenTestData");
        this.genTestButton.addActionListener(this);
        this.genButtonsPanel.add((Component)this.genTestButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 1, 1));
        this.authPanel.add((Component)this.genButtonsPanel, new GridBagConstraints(0, 13, 0, 1, 0.0, 0.0, 11, 2, new Insets(1, 1, 1, 1), 1, 1));
        this.authPanel.setName("authpanel");
    }

    private int getMax(int[] a) {
        int rvalue = -1;
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                rvalue = Math.max(rvalue, a[i]);
                ++i;
            }
        }
        return rvalue;
    }

    private void generateRfcPanel() {
        this.rfcPanel = new JPanel();
        this.rfcPanel.setLayout(new GridBagLayout());
        this.rfcPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ClientManagementGui.RFC_PANEL_BORDER_TEXT));
        this.rfcInfoLabel = new JLabel(ResourceUtil.formatString("sld_5030"));
        this.rfcPanel.add((Component)this.rfcInfoLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcGatewayHostLabel = new JLabel(ResourceUtil.formatString("sld_5031"));
        this.rfcGatewayHostLabel.setDisplayedMnemonic('0');
        this.rfcPanel.add((Component)this.rfcGatewayHostLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcGatewayHostField = new JTextField();
        this.rfcGatewayHostLabel.setLabelFor(this.rfcGatewayHostField);
        this.rfcPanel.add((Component)this.rfcGatewayHostField, new GridBagConstraints(2, 1, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcGatewayServiceLabel = new JLabel(ResourceUtil.formatString("sld_5032"));
        this.rfcGatewayServiceLabel.setDisplayedMnemonic('1');
        this.rfcPanel.add((Component)this.rfcGatewayServiceLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcGatewayServiceField = new JTextField();
        this.rfcGatewayServiceLabel.setLabelFor(this.rfcGatewayServiceField);
        this.rfcPanel.add((Component)this.rfcGatewayServiceField, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcButtonsPanel = new JPanel();
        this.rfcButtonsPanel.setLayout(new GridBagLayout());
        this.rfcSaveButton = new JButton(ClientManagementGui.BUTTON_TEXT_RFC_SAVE);
        this.rfcSaveButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_RFC_SAVE);
        this.rfcSaveButton.setActionCommand("RfcSaveData");
        this.rfcSaveButton.addActionListener(this);
        this.rfcButtonsPanel.add((Component)this.rfcSaveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.rfcResetButton = new JButton(ClientManagementGui.BUTTON_TEXT_RFC_RESET);
        this.rfcResetButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_RFC_RESET);
        this.rfcResetButton.setActionCommand("RfcResetData");
        this.rfcResetButton.addActionListener(this);
        this.rfcButtonsPanel.add((Component)this.rfcResetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.rfcRefreshButton = new JButton(ClientManagementGui.BUTTON_TEXT_RFC_REFRESH);
        this.rfcRefreshButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_RFC_REFRESH);
        this.rfcRefreshButton.setActionCommand("RfcRefreshData");
        this.rfcRefreshButton.addActionListener(this);
        this.rfcButtonsPanel.add((Component)this.rfcRefreshButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.rfcDeleteButton = new JButton(ClientManagementGui.BUTTON_TEXT_RFC_DELETE);
        this.rfcDeleteButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_RFC_DELETE);
        this.rfcDeleteButton.setActionCommand("RfcDeleteData");
        this.rfcDeleteButton.addActionListener(this);
        this.rfcButtonsPanel.add((Component)this.rfcDeleteButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.rfcPanel.add((Component)this.rfcButtonsPanel, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 3, 1));
        this.rfcPanel.setName("rfcpanel");
    }

    private void generateHttpPanel() {
        this.httpPanel = new JPanel();
        this.httpPanel.setLayout(new GridBagLayout());
        this.httpPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ClientManagementGui.HTTP_PANEL_BORDER_TEXT));
        this.httpInfoLabel = new JLabel(ResourceUtil.formatString("sld_5024"));
        this.httpPanel.add((Component)this.httpInfoLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpHostLabel = new JLabel(ResourceUtil.formatString("sld_5020"));
        this.httpHostLabel.setDisplayedMnemonic('1');
        this.httpPanel.add((Component)this.httpHostLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpHostField = new JTextField();
        this.httpHostLabel.setLabelFor(this.httpHostField);
        this.httpPanel.add((Component)this.httpHostField, new GridBagConstraints(2, 1, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpPortLabel = new JLabel(ResourceUtil.formatString("sld_5021"));
        this.httpPortLabel.setDisplayedMnemonic('2');
        this.httpPanel.add((Component)this.httpPortLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpPortField = new JTextField();
        this.httpPortLabel.setLabelFor(this.httpPortField);
        this.httpPanel.add((Component)this.httpPortField, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpUserLabel = new JLabel(ResourceUtil.formatString("sld_5022"));
        this.httpUserLabel.setDisplayedMnemonic('3');
        this.httpPanel.add((Component)this.httpUserLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpUserField = new JTextField();
        this.httpUserLabel.setLabelFor(this.httpUserField);
        this.httpPanel.add((Component)this.httpUserField, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpPassLabel = new JLabel(ResourceUtil.formatString("sld_5023"));
        this.httpPassLabel.setDisplayedMnemonic('4');
        this.httpPanel.add((Component)this.httpPassLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpPassField = new JPasswordField();
        this.httpPassLabel.setLabelFor(this.httpPassField);
        this.httpPanel.add((Component)this.httpPassField, new GridBagConstraints(2, 4, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpsUseHttpsLabel = new JLabel(ResourceUtil.formatString("sld_5104"));
        this.httpsUseHttpsLabel.setDisplayedMnemonic('5');
        this.httpPanel.add((Component)this.httpsUseHttpsLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpUseHttpsField = new JCheckBox();
        this.httpsUseHttpsLabel.setLabelFor(this.httpUseHttpsField);
        this.httpUseHttpsField.setActionCommand("ToggleHttpHttps");
        this.httpUseHttpsField.addActionListener(this);
        this.httpPanel.add((Component)this.httpUseHttpsField, new GridBagConstraints(2, 5, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpsTrustStoreLabel = new JLabel(ResourceUtil.formatString("sld_5105"));
        this.httpsTrustStoreLabel.setDisplayedMnemonic('6');
        this.httpPanel.add((Component)this.httpsTrustStoreLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.httpsTrustStoreField = new JTextField();
        this.httpsTrustStoreField.setEditable(false);
        this.httpsTrustStoreLabel.setLabelFor(this.httpsTrustStoreField);
        this.httpPanel.add((Component)this.httpsTrustStoreField, new GridBagConstraints(2, 6, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.httpButtonsPanel = new JPanel();
        this.httpButtonsPanel.setLayout(new GridBagLayout());
        this.httpSaveButton = new JButton(ClientManagementGui.BUTTON_TEXT_HTTP_SAVE);
        this.httpSaveButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_HTTP_SAVE);
        this.httpSaveButton.setActionCommand("HttpSaveData");
        this.httpSaveButton.addActionListener(this);
        this.httpButtonsPanel.add((Component)this.httpSaveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.httpResetButton = new JButton(ClientManagementGui.BUTTON_TEXT_HTTP_RESET);
        this.httpResetButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_HTTP_RESET);
        this.httpResetButton.setActionCommand("HttpResetData");
        this.httpResetButton.addActionListener(this);
        this.httpButtonsPanel.add((Component)this.httpResetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.httpRefreshButton = new JButton(ClientManagementGui.BUTTON_TEXT_HTTP_REFRESH);
        this.httpRefreshButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_HTTP_REFRESH);
        this.httpRefreshButton.setActionCommand("HttpRefreshData");
        this.httpRefreshButton.addActionListener(this);
        this.httpButtonsPanel.add((Component)this.httpRefreshButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.httpDeleteButton = new JButton(ClientManagementGui.BUTTON_TEXT_HTTP_DELETE);
        this.httpDeleteButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_HTTP_DELETE);
        this.httpDeleteButton.setActionCommand("HttpDeleteData");
        this.httpDeleteButton.addActionListener(this);
        this.httpButtonsPanel.add((Component)this.httpDeleteButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 2, 1));
        this.httpPanel.add((Component)this.httpButtonsPanel, new GridBagConstraints(0, 8, 0, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 3, 1));
        this.httpPanel.setName("httppanel");
    }

    private void generateInfoPanel() {
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ClientManagementGui.INFO_PANEL_BORDER_TEXT));
        this.infoDataTable = new InfoTableModel(ClientManagementGui.infoTableHeaders);
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5006"), this.getLastSendTime()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5008"), this.getUsedParams()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5009"), this.getLastSendClusterNodeInfo()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5085"), this.getLastSuccessFailedInfo()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5088"), this.getNextSendTime()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5089"), this.getManagementRunInfo()}));
        this.infoDataTable.add(new InfoTableModel.InfoLine(new String[]{ResourceUtil.formatString("sld_5090"), this.getConnectConfigStatus()}));
        this.infoTable = new JTable(this.infoDataTable);
        this.infoTable.setShowGrid(true);
        this.infoTable.setRowHeight(2 * this.infoTable.getRowHeight());
        this.infoTable.setRowMargin(2 * this.infoTable.getRowMargin());
        this.setSendInfoTableSize();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 1, 1);
        this.infoPanel.add((Component)this.infoTable, gbc);
        this.infoPanel.setName("infopanel");
    }

    private void generateStatusBarButtons() {
        this.sendButton = new JButton();
        this.sendButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_SEND);
        this.sendButton.setActionCommand("SendSldData");
        this.sendButton.addActionListener(this);
        try {
            this.sendButton.setIcon(new ImageIcon(this.getClass().getResource("images/connect.gif")));
        }
        catch (Exception e) {
            this.sendButton.setText(ClientManagementGui.BUTTON_TEXT_SEND);
        }
        this.refreshButton = new JButton();
        this.refreshButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_REFRESH);
        this.refreshButton.setActionCommand("RefreshSldSendInfo");
        this.refreshButton.addActionListener(this);
        try {
            this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("images/refresh.gif")));
        }
        catch (Exception e) {
            this.refreshButton.setText(ClientManagementGui.BUTTON_TEXT_REFRESH);
        }
        this.assignRolesButton = new JButton();
        this.assignRolesButton.setToolTipText(ClientManagementGui.TOOL_TIP_TEXT_ASSIGNROLES);
        this.assignRolesButton.setActionCommand("AssignRoles");
        this.assignRolesButton.addActionListener(this);
        try {
            this.assignRolesButton.setIcon(new ImageIcon(this.getClass().getResource("images/assignroles.gif")));
        }
        catch (Exception e) {
            this.assignRolesButton.setText(ClientManagementGui.BUTTON_TEXT_ASSIGNROLES);
        }
        this.runtimeButtons = new JButton[]{this.sendButton, this.refreshButton, this.assignRolesButton};
    }

    private void assignRoles() {
        if (this.serviceIF.isAvailable()) {
            if (ClientDialog.showQuestion(this.frame, ResourceUtil.formatString("sld_5098"))) {
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString(this.serviceIF.performRoleMapping(this.frame) ? "sld_5099" : "sld_5100"));
            }
        } else {
            this.completeDisplay();
        }
    }

    private void addProgressTask() {
        if (this.serviceIF.isAvailable() && this.taskManager != null) {
            this.taskManager.addTask((TaskItem)new ProgressTaskItem(this.serviceIF.getIF()));
        }
    }

    public void freeResources() {
    }

    public JButton[] getRuntimeButtons() {
        return this.runtimeButtons;
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setTaskManager(EditorViewManager taskManager) {
    }

    public void show(ManagementInterface serviceManagementInterface) {
        if (!this.serviceIF.isAvailable()) {
            this.serviceIF.set((ServiceManagementInterface)serviceManagementInterface);
        }
        this.addProgressTask();
        this.refreshSendInfo();
    }

    public void setEnvironment(String toolName, Object env) throws UnsupportedEditorException {
        if (!toolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("Unsupported editor: " + toolName);
        }
        this.taskManager = (EditorViewManager)env;
        this.addProgressTask();
    }

    public void actionPerformed(ActionEvent event) {
        if (this.serviceIF.isAvailable()) {
            String command = event.getActionCommand();
            if (command.equals("SendSldData")) {
                if (ClientDialog.showQuestion(this.frame, ResourceUtil.formatString("sld_5001"))) {
                    Runnable r = new Runnable(){

                        public void run() {
                            ServiceManagementResponse servResp = ClientManagement.this.serviceIF.doCollect(ClientManagement.this.frame);
                            if (servResp.getResult()) {
                                ClientDialog.showPopup(ClientManagement.this.frame, ResourceUtil.formatStringNoParameterLocalization("sld_5002", new Object[]{servResp.getMessage()}));
                            } else {
                                ClientDialog.showPopup(ClientManagement.this.frame, ResourceUtil.formatStringNoParameterLocalization("sld_5003", new Object[]{servResp.getMessage()}));
                            }
                            ClientManagement.this.refreshSendInfo();
                        }
                    };
                    Thread collectThread = new Thread(r);
                    collectThread.start();
                }
                this.refreshSendInfo();
            } else if (command.equals("RefreshSldSendInfo")) {
                this.refreshSendInfo();
            } else if (command.equals("AssignRoles")) {
                this.assignRoles();
            } else if (command.equals("HttpResetData")) {
                this.resetHttpParameters();
            } else if (command.equals("HttpSaveData")) {
                this.setHttpProperties();
            } else if (command.equals("HttpRefreshData")) {
                this.getHttpProperties();
            } else if (command.equals("RfcResetData")) {
                this.resetRfcParameters();
            } else if (command.equals("RfcSaveData")) {
                this.setRfcProperties();
            } else if (command.equals("RfcRefreshData")) {
                this.getRfcProperties();
            } else if (command.equals("RfcDeleteData")) {
                if (!this.deleteRfcProperties()) {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5046"));
                }
                this.getRfcProperties();
            } else if (command.equals("HttpDeleteData")) {
                if (!this.deleteHttpProperties()) {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5047"));
                }
                this.getHttpProperties();
            } else if (command.equals("GenSaveData")) {
                this.setProtectionDomainInfos();
            } else if (command.equals("GenRefreshData")) {
                this.getProtectionDomainInfos();
            } else if (command.equals("GenTestData")) {
                if (this.serviceIF.validateCimClient(this.frame)) {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5078"));
                } else {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5079"));
                }
            } else if (command.equals("ToggleHttpHttps")) {
                this.httpsTrustStoreField.setEditable(this.httpUseHttpsField.isSelected());
            } else if (command.equals("ToggleGenHttps")) {
                this.genHttpsTrustStoreField.setEditable(this.genUseHttpsField.isSelected());
            }
        }
    }

    private void resetHttpParameters() {
        this.httpHostField.setText(null);
        this.httpPortField.setText(null);
        this.httpUserField.setText(null);
        this.httpPassField.setText(null);
    }

    private void resetRfcParameters() {
        this.rfcGatewayHostField.setText(null);
        this.rfcGatewayServiceField.setText(null);
    }

    protected void setHttpProperties() {
        if (this.serviceIF.isAvailable()) {
            try {
                if (this.checkConnectParams(this.httpHostField.getText(), this.httpPortField.getText(), this.httpUserField.getText())) {
                    Properties genProps;
                    Properties props = new Properties();
                    ((Hashtable)props).put("HttpHost", this.httpHostField.getText().trim());
                    ((Hashtable)props).put("HttpPort", this.httpPortField.getText().trim());
                    ((Hashtable)props).put("HttpUser", this.httpUserField.getText().trim());
                    ((Hashtable)props).put("HttpPassword", this.httpPassField.getText() == null || this.httpPassField.getText().length() == 0 ? "" : this.httpPassField.getText());
                    boolean useHttps = this.httpUseHttpsField.isSelected();
                    ((Hashtable)props).put("UseHttps", useHttps ? "true" : "false");
                    if (useHttps && (this.httpsTrustStoreField.getText() == null || this.httpsTrustStoreField.getText().trim().length() == 0)) {
                        ((Hashtable)props).put("TrustStore", "TrustedCAs");
                        this.httpsTrustStoreField.setText("TrustedCAs");
                    } else {
                        ((Hashtable)props).put("TrustStore", this.httpsTrustStoreField.getText().trim());
                    }
                    if (!this.serviceIF.setConfigParams(this.frame, props)) {
                        ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5028"));
                    }
                    if ((genProps = this.serviceIF.getGenerationParams(this.frame)) == null || !this.isGenInfoSet(genProps)) {
                        genProps = this.generateGenInfoSet(props);
                        this.serviceIF.setGenerationParams(this.frame, genProps);
                    }
                } else {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5027"));
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5027"));
            }
        }
    }

    protected void setRfcProperties() {
        if (this.serviceIF.isAvailable()) {
            if (this.rfcGatewayHostField.getText() != null && this.rfcGatewayHostField.getText().length() != 0 && this.rfcGatewayServiceField.getText() != null && this.rfcGatewayServiceField.getText().length() != 0) {
                Properties props = new Properties();
                ((Hashtable)props).put("GatewayHost", this.rfcGatewayHostField.getText());
                ((Hashtable)props).put("GatewayService", this.rfcGatewayServiceField.getText());
                if (!this.serviceIF.setConfigParams(this.frame, props)) {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5035"));
                }
            } else {
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5034"));
            }
        }
    }

    protected boolean deleteHttpProperties() {
        boolean rvalue = true;
        if (this.serviceIF.isAvailable()) {
            rvalue = this.serviceIF.deleteHttpParams(this.frame);
        }
        return rvalue;
    }

    protected boolean deleteRfcProperties() {
        boolean rvalue = true;
        if (this.serviceIF.isAvailable()) {
            rvalue = this.serviceIF.deleteRfcParams(this.frame);
        }
        return rvalue;
    }

    protected boolean setProtectionDomainInfos() {
        boolean rvalue = true;
        if (this.serviceIF.isAvailable()) {
            try {
                HashSet<Object> domains = new HashSet<Object>();
                int grantFieldIdx = this.domainDataTable.indexOfField(ClientManagementGui.GRAND_FIELD);
                int domainFieldIdx = this.domainDataTable.indexOfField(ClientManagementGui.DOMAIN_FIELD);
                int i = 0;
                while (i < this.domainDataTable.getRowCount()) {
                    Boolean permGranted = (Boolean)this.domainDataTable.getValueAt(i, grantFieldIdx);
                    if (permGranted.booleanValue()) {
                        domains.add(this.domainDataTable.getValueAt(i, domainFieldIdx));
                    }
                    ++i;
                }
                if (!this.serviceIF.setSldPermissionsForDomains(this.frame, domains)) {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5077"));
                }
                if (this.checkConnectParams(this.genHostField.getText(), this.genPortField.getText(), this.genUserField.getText())) {
                    Properties genProps = new Properties();
                    ((Hashtable)genProps).put("HttpHost", this.genHostField.getText().trim());
                    ((Hashtable)genProps).put("HttpPort", this.genPortField.getText().trim());
                    ((Hashtable)genProps).put("HttpUser", this.genUserField.getText().trim());
                    ((Hashtable)genProps).put("HttpPassword", this.genPassField.getText() == null || this.genPassField.getText().length() == 0 ? "" : this.genPassField.getText().trim());
                    boolean useHttps = this.genUseHttpsField.isSelected();
                    ((Hashtable)genProps).put("UseHttps", useHttps ? "true" : "false");
                    if (useHttps && (this.genHttpsTrustStoreField.getText() == null || this.genHttpsTrustStoreField.getText().trim().length() == 0)) {
                        ((Hashtable)genProps).put("TrustStore", "TrustedCAs");
                        this.genHttpsTrustStoreField.setText("TrustedCAs");
                    } else {
                        ((Hashtable)genProps).put("TrustStore", this.genHttpsTrustStoreField.getText().trim());
                    }
                    this.serviceIF.setGenerationParams(this.frame, genProps);
                } else {
                    ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5075"));
                }
            }
            catch (Exception e) {
                ClientDialog.showPopup(this.frame, ResourceUtil.formatString("sld_5075"));
            }
        }
        return rvalue;
    }

    private boolean checkConnectParams(String host, String port, String user) {
        boolean rvalue = false;
        if (host != null && host.trim().length() != 0 && port != null && port.trim().length() != 0 && user != null && user.trim().length() != 0) {
            try {
                int portNum = Integer.valueOf(port.trim());
                if (portNum >= 0 && portNum <= 65535) {
                    rvalue = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return rvalue;
    }
}

