/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.vaclient;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ClientDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "System Landscape Directory";
    private static final String OK_COMMAND = "Ok";
    private static final String YES_ANSWER = "Yes";
    private static final String NO_ANSWER = "No";
    private boolean answer = false;

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(OK_COMMAND)) {
            this.dispose();
        } else if (event.getActionCommand().equals(YES_ANSWER)) {
            this.answer = true;
            this.dispose();
        } else if (event.getActionCommand().equals(NO_ANSWER)) {
            this.answer = false;
            this.dispose();
        }
    }

    public boolean getLastAnswer() {
        return this.answer;
    }

    public static boolean showQuestion(Frame frame, String question) {
        boolean answer = false;
        switch (JOptionPane.showConfirmDialog(frame, question, TITLE, 0)) {
            case 0: {
                answer = true;
                break;
            }
            case 1: {
                answer = false;
            }
        }
        return answer;
    }

    public static void showPopup(Frame frame, String message) {
        JOptionPane.showConfirmDialog(frame, new TextFormatMessage(message), TITLE, -1, 1);
    }

    public static void showPopup(Frame frame, String message, int popupType) {
        if (popupType != -1 && popupType != 0 && popupType != 1 && popupType != 2 && popupType != 3) {
            popupType = -1;
        }
        JOptionPane.showConfirmDialog(frame, message, TITLE, -1, popupType);
    }

    public static class TextFormatMessage {
        private StringBuffer buf;
        private int lineSize = 40;
        private boolean alreadyDone = false;

        public TextFormatMessage(String message) {
            this.buf = new StringBuffer(message);
        }

        public TextFormatMessage(String message, int lineSize) {
            this.buf = new StringBuffer(message);
            this.lineSize = lineSize;
        }

        public String toString() {
            if (!this.alreadyDone) {
                this.formatText();
            }
            return this.buf.toString();
        }

        private void formatText() {
            if (!this.alreadyDone) {
                this.alreadyDone = true;
                if (this.buf.length() > this.lineSize) {
                    int idx = this.getNextSpace(this.lineSize);
                    while (idx != -1) {
                        this.buf.replace(idx, idx + 1, "\n");
                        idx = this.getNextSpace(idx + this.lineSize);
                    }
                }
            }
        }

        private int getNextSpace(int startIdx) {
            int idx = -1;
            int i = startIdx;
            while (i < this.buf.length()) {
                if (this.buf.charAt(i) == ' ') {
                    idx = i;
                    break;
                }
                ++i;
            }
            return idx;
        }
    }
}

