/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RoleMapInfo {
    private Map configs = new HashMap();
    private String lastConfigId = null;
    private Map removeList = new HashMap();

    public void addConfigId(String configId) {
        this.configs.put(configId, new ArrayList());
        this.lastConfigId = configId;
    }

    public void addMapEntry(String roleName1, String roleName2) {
        ArrayList lst = (ArrayList)this.configs.get(this.lastConfigId);
        if (lst == null && this.lastConfigId != null) {
            this.configs.put(this.lastConfigId, new ArrayList());
            lst = (ArrayList)this.configs.get(this.lastConfigId);
        }
        lst.add(new Pair(roleName1, roleName2));
    }

    public void addMapEntry(String configId, String roleName1, String roleName2) {
        ArrayList lst = (ArrayList)this.configs.get(configId);
        if (lst == null) {
            this.addConfigId(configId);
            lst = (ArrayList)this.configs.get(configId);
        }
        lst.add(new Pair(roleName1, roleName2));
    }

    public Iterator getConfigIdIterator() {
        return this.configs.entrySet().iterator();
    }

    public void addRemove(String configId, Pair pair) {
        ArrayList lst = (ArrayList)this.removeList.get(configId);
        if (lst == null) {
            this.removeList.put(configId, new ArrayList());
            lst = (ArrayList)this.removeList.get(configId);
        }
        lst.add(pair);
    }

    public void commitRemove() {
        Iterator it = this.removeList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String removeConfigId = (String)me.getKey();
            ArrayList removeLst = (ArrayList)me.getValue();
            ArrayList foundLst = (ArrayList)this.configs.get(removeConfigId);
            if (foundLst == null) continue;
            ((AbstractCollection)foundLst).removeAll(removeLst);
        }
        this.removeList = new HashMap();
    }

    public boolean hasMappings() {
        boolean rvalue = false;
        if (!this.configs.isEmpty()) {
            Iterator it = this.configs.keySet().iterator();
            while (it.hasNext()) {
                ArrayList l = (ArrayList)this.configs.get((String)it.next());
                if (l == null || l.isEmpty()) continue;
                rvalue = true;
                break;
            }
        }
        return rvalue;
    }

    public boolean containsAbapRole(String configId, String roleName) {
        return this.containsElement(configId, roleName, true);
    }

    public boolean containsJ2eeRole(String configId, String roleName) {
        return this.containsElement(configId, roleName, false);
    }

    private boolean containsElement(String configId, String roleName, boolean first) {
        boolean rvalue = false;
        ArrayList l = (ArrayList)this.configs.get(configId);
        Iterator it = ((AbstractList)l).iterator();
        while (it.hasNext()) {
            Pair p = (Pair)it.next();
            if ((!first || !p.getFirst().equalsIgnoreCase(roleName)) && (first || !p.getSecond().equalsIgnoreCase(roleName))) continue;
            rvalue = true;
            break;
        }
        return rvalue;
    }

    public static class Pair {
        private String value1;
        private String value2;

        public Pair(String value1, String value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public String getFirst() {
            return this.value1;
        }

        public String getSecond() {
            return this.value2;
        }

        public boolean equals(Object p) {
            return p instanceof Pair && (p == this || this.value1.equals(((Pair)p).value1));
        }

        public int hashCode() {
            return (this.value1 + this.value2).hashCode();
        }
    }
}

