/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.mw.jco.JCO;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.repo.ProxyRepository;
import com.sap.sldserv.repo.RepoConst;
import com.sap.sldserv.test.DataCollConst;
import com.sap.sldserv.test.DataTab;
import com.sap.sldserv.test.SAPProxy;
import java.util.ArrayList;
import java.util.Random;

public class SAPProxyServer
extends JCO.Server
implements JCO.ServerExceptionListener,
JCO.ServerStateChangedListener,
DataCollConst,
RepoConst {
    private SAPProxy sapProxy = null;
    private boolean unicode = false;
    private boolean dataTrace = false;
    private boolean serverTrace = false;
    private String gwHost;
    private String gwServ;
    private String progId;
    private static Random rand = new Random(System.currentTimeMillis());
    private String myId;
    private static ArrayList fieldList = new ArrayList();

    public SAPProxyServer(boolean unicode, boolean dataTrace, boolean serverTrace, String gwHost, String gwServ, String progId, SAPProxy sapProxy) {
        super(gwHost, gwServ, progId, unicode ? ProxyRepository.getUnicodeRepository() : ProxyRepository.getNoneUnicodeRepository());
        super.setProperty("jco.server.unicode", unicode ? "1" : "0");
        this.sapProxy = sapProxy;
        this.unicode = unicode;
        this.dataTrace = dataTrace;
        this.serverTrace = serverTrace;
        this.gwHost = gwHost;
        this.gwServ = gwServ;
        this.progId = progId;
        if (serverTrace) {
            this.setTrace(true);
            JCO.setTraceLevel((int)10);
            this.setProperty("jco.server.trace", "1");
            JCO.addServerExceptionListener((JCO.ServerExceptionListener)this);
            JCO.addServerStateChangedListener((JCO.ServerStateChangedListener)this);
        }
        if (fieldList.size() == 0) {
            ArrayList arrayList = fieldList;
            synchronized (arrayList) {
                this.createFieldList();
            }
        }
        this.generateId();
        System.out.println("SAP Proxy constructed. Unicode=" + super.getProperty("jco.server.unicode") + " [0=NO, 1=YES]");
    }

    protected void handleRequest(JCO.Function func) {
        System.out.println("Function called: " + func.getName());
        JCO.ParameterList impList = func.getImportParameterList();
        JCO.ParameterList tableList = func.getTableParameterList();
        if (tableList != null && func.getName().equalsIgnoreCase("SET_SLD_DATA")) {
            JCO.Table tab = tableList.getTable("DATA_TAB");
            if (this.sapProxy != null) {
                String typeStr = impList.getString("TYPE");
                String versionStr = impList.getString("VERSION");
                System.out.println("Received data from system (type/version): " + typeStr + "/" + versionStr);
                this.sapProxy.handleData(typeStr, versionStr, this.getRfcData(tab));
            }
        } else {
            System.out.println("Function not served by this program: " + func.getName());
        }
    }

    public String getId() {
        return this.myId;
    }

    private DataTab getRfcData(JCO.Table tab) {
        try {
            return this.getTable(tab);
        }
        catch (SldServiceException ex) {
            System.out.println("Failed to get RFC data: " + ex.getMessage());
            return null;
        }
    }

    public void serverExceptionOccurred(JCO.Server server, Exception ex) {
        System.out.println("Server exception received: " + ex.getMessage());
    }

    public void serverStateChangeOccurred(JCO.Server server, int oldState, int newState) {
        String oldStateStr = null;
        String newStateStr = null;
        if ((oldState & 1) != 0) {
            oldStateStr = "STOPPED";
        }
        if ((oldState & 2) != 0) {
            oldStateStr = "STARTED";
        }
        if ((oldState & 8) != 0) {
            oldStateStr = "LISTENING";
        }
        if ((oldState & 0x20) != 0) {
            oldStateStr = "TRANSACTION";
        }
        if ((oldState & 4) != 0) {
            oldStateStr = "BUSY";
        }
        if ((newState & 1) != 0) {
            newStateStr = "STOPPED";
        }
        if ((newState & 2) != 0) {
            newStateStr = "STARTED";
        }
        if ((newState & 8) != 0) {
            newStateStr = "LISTENING";
        }
        if ((newState & 0x20) != 0) {
            newStateStr = "TRANSACTION";
        }
        if ((newState & 4) != 0) {
            newStateStr = "BUSY";
        }
        System.out.println("State change occurred (old state/new state/UC): " + oldStateStr + "/" + newStateStr + "/" + this.unicode);
    }

    private DataTab getTable(JCO.Table tab) throws SldServiceException {
        DataTab newDataTab = new DataTab(fieldList);
        int i = 0;
        while (i < tab.getNumRows()) {
            tab.setRow(i);
            if (this.dataTrace) {
                System.out.println(i + ". Row: ");
            }
            int j = 0;
            while (j < tab.getFieldCount()) {
                JCO.Field field = tab.getField(j);
                String fieldName = field.getName();
                String fieldValue = field.getString();
                if (this.dataTrace) {
                    System.out.println("\t" + fieldName + ":\t" + fieldValue);
                }
                newDataTab.addValue(fieldName, fieldValue);
                ++j;
            }
            newDataTab.appendHeader();
            ++i;
        }
        return newDataTab;
    }

    private void createFieldList() {
        if (fieldList.size() == 0) {
            fieldList.add("ENTRY_TYPE");
            fieldList.add("CLASS_NAME");
            fieldList.add("INST_NUMBER");
            fieldList.add("PROPERTY_ROLE");
            fieldList.add("VALUE_ID");
            fieldList.add("VALUE");
        }
    }

    private void generateId() {
        this.myId = (this.unicode ? "UC " : "NUC") + ":" + this.gwHost + "_" + this.gwServ + "_" + this.progId + "_" + Math.abs(rand.nextInt());
    }
}

