/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.test.DataCollConst;
import com.sap.sldserv.test.DataTab;
import com.sap.sldserv.test.IDataQueue;
import com.sap.sldserv.test.SAPData;
import com.sap.sldserv.test.SAPProxy;
import com.sap.sldserv.test.SAPProxyServer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SAPProxyRfc
extends SAPProxy
implements DataCollConst {
    private ArrayList rfcServerList = null;

    public SAPProxyRfc(IDataQueue dataQueue, String gwHost, String gwServ, String gwRegIdNUC, String gwRegIdUC, boolean dataTrace, boolean serverTrace) throws SldServiceException {
        super(dataQueue, gwHost, gwServ, gwRegIdNUC, gwRegIdUC, dataTrace, serverTrace);
        System.out.println("RFC proxy created.");
    }

    protected void finalize() {
        if (this.rfcServerList != null) {
            Iterator it = ((AbstractList)this.rfcServerList).iterator();
            while (it.hasNext()) {
                SAPProxyServer rfcProxy = (SAPProxyServer)it.next();
                if (!rfcProxy.isAlive()) continue;
                rfcProxy.stop();
            }
        }
    }

    public void createRfcServer() throws SldServiceException {
        System.out.println("Total number of RFC server threads (UC/NUC): " + 2 * this.serverCount);
        System.out.println("Connected to SAP gateway (host/service): " + this.gwHost + "/" + this.gwServ);
        System.out.println("Unicode / None-Unicode registration IDs: " + this.gwRegIdUC + "/" + this.gwRegIdNUC);
        this.rfcServerList = new ArrayList(2 * this.serverCount);
        int i = 0;
        while (i < this.serverCount) {
            this.rfcServerList.add(new SAPProxyServer(false, this.dataTrace, this.serverTrace, this.gwHost, this.gwServ, this.gwRegIdNUC, this));
            this.rfcServerList.add(new SAPProxyServer(true, this.dataTrace, this.serverTrace, this.gwHost, this.gwServ, this.gwRegIdUC, this));
            ++i;
        }
        System.out.println("RFC server threads created.");
    }

    public void start() {
        try {
            if (this.rfcServerList == null) {
                this.createRfcServer();
            }
            if (this.rfcServerList != null) {
                int i = 0;
                while (i < this.rfcServerList.size()) {
                    SAPProxyServer rfcServer = (SAPProxyServer)this.rfcServerList.get(i);
                    if (!rfcServer.isAlive()) {
                        rfcServer.start();
                    }
                    ++i;
                }
            } else {
                System.out.println("Failed to start RFC server threads.");
            }
        }
        catch (SldServiceException ex) {
            System.out.println("Failed to start RFC server threads: " + ex.getMessage());
        }
    }

    public void stop() {
        if (this.rfcServerList != null) {
            int i = 0;
            while (i < this.rfcServerList.size()) {
                SAPProxyServer rfcServer = (SAPProxyServer)this.rfcServerList.get(i);
                if (rfcServer.isAlive()) {
                    rfcServer.stop();
                }
                ++i;
            }
            this.rfcServerList = null;
        }
    }

    public ArrayList status() {
        ArrayList<String> status = null;
        if (this.rfcServerList != null) {
            status = new ArrayList(this.rfcServerList.size());
            int i = 0;
            while (i < this.rfcServerList.size()) {
                SAPProxyServer rfcServer = (SAPProxyServer)this.rfcServerList.get(i);
                String statusStr = rfcServer.isAlive() ? "[UP]   " + rfcServer.getId() : "[DOWN] " + rfcServer.getId();
                status.add(statusStr);
                ++i;
            }
        } else {
            status = new ArrayList<String>();
            status.add("[DOWN] RFC server threads");
        }
        return status;
    }

    public void handleData(String typeId, String versionId, DataTab inTab) {
        if (inTab == null || inTab.size() == 0) {
            System.out.println("Empty data set received. No processing!");
            return;
        }
        SAPData newData = new SAPData(typeId, versionId);
        SAPProxy.getSAPData(inTab, newData);
        inTab.write2file();
        newData.write2File();
        this.dataQueue.add(newData);
        System.out.println("Data written to queue (type/version): " + typeId + "/" + versionId);
    }
}

