/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.repo.RepoConst;
import com.sap.sldserv.test.DataCollConst;
import com.sap.sldserv.test.DataTab;
import com.sap.sldserv.test.IDataQueue;
import com.sap.sldserv.test.SAPData;
import com.sap.sldserv.test.SAPDataDir;
import java.util.ArrayList;

public abstract class SAPProxy
implements DataCollConst,
RepoConst {
    protected int commType = 0;
    protected static final SAPDataDir sapDataDir = new SAPDataDir();
    protected Object syncObj = new Object();
    protected IDataQueue dataQueue = null;
    protected String gwHost;
    protected String gwServ;
    protected String gwRegIdNUC;
    protected String gwRegIdUC;
    boolean dataTrace;
    boolean serverTrace;
    protected int serverCount = 2;

    SAPProxy(IDataQueue dataQueue, String gwHost, String gwServ, String gwRegIdNUC, String gwRegIdUC, boolean dataTrace, boolean serverTrace) throws SldServiceException {
        if (dataQueue == null || gwHost == null || gwServ == null || gwRegIdNUC == null || gwRegIdUC == null) {
            throw new SldServiceException("Parameters incomplete.");
        }
        this.dataQueue = dataQueue;
        this.gwHost = gwHost;
        this.gwServ = gwServ;
        this.gwRegIdNUC = gwRegIdNUC;
        this.gwRegIdUC = gwRegIdUC;
        this.dataTrace = dataTrace;
        this.serverTrace = serverTrace;
    }

    public abstract void handleData(String var1, String var2, DataTab var3);

    public abstract void start();

    public abstract void stop();

    public abstract ArrayList status();

    public void setServerCount(int serverCount) {
        if (serverCount > 0) {
            this.serverCount = serverCount;
        }
    }

    protected static void getSAPData(DataTab inTab, SAPData theData) {
        String currClass = null;
        String currInst = null;
        J2EEClass clazz = null;
        J2EEInst inst = null;
        int idx = 0;
        while (idx < inTab.getLineCount()) {
            block13: {
                try {
                    boolean isObjClass;
                    DataTab.DataLine dataLine = inTab.getLine(idx);
                    boolean bl = isObjClass = dataLine.getValue("ENTRY_TYPE").equals("0");
                    if (isObjClass || dataLine.getValue("ENTRY_TYPE").equals("1")) {
                        String className = dataLine.getValue("CLASS_NAME");
                        if (currClass == null || !currClass.equalsIgnoreCase(className)) {
                            if (clazz != null) {
                                if (inst != null) {
                                    inst.setValues();
                                    clazz.addInstance(inst);
                                    inst = null;
                                }
                                theData.addClass(clazz);
                            }
                            clazz = new J2EEClass(className, isObjClass);
                            currInst = null;
                            currClass = className;
                        }
                        String instNum = dataLine.getValue("INST_NUMBER").trim();
                        if (currInst == null || !currInst.equalsIgnoreCase(instNum)) {
                            if (inst != null) {
                                inst.setValues();
                                clazz.addInstance(inst);
                            }
                            inst = isObjClass ? J2EEClass.getNewObjInst(className, instNum) : J2EEClass.getNewAssocInst(className, instNum);
                            currInst = instNum;
                        }
                        String propName = dataLine.getValue("PROPERTY_ROLE");
                        String valudId = dataLine.getValue("VALUE_ID");
                        String value = dataLine.getValue("VALUE");
                        inst.addPropValue(propName, valudId, value);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Data error (class/instance): " + currClass + "/" + currInst + " Message: " + ex.getMessage());
                    int startIdx = inTab.getIdx("CLASS_NAME", currClass, "PROPERTY_ROLE", currInst);
                    int endIdx = inTab.getLastIdx("CLASS_NAME", currClass, "PROPERTY_ROLE", currInst);
                    if (startIdx == -1 || endIdx == -1) break block13;
                    System.out.println("Removing lines of instance from input table (start index/end index): " + startIdx + "/" + endIdx);
                    inTab.remove(startIdx, endIdx);
                    idx = startIdx;
                }
            }
            ++idx;
        }
        if (clazz != null && inst != null) {
            try {
                inst.setValues();
                clazz.addInstance(inst);
                if (!theData.contains(clazz)) {
                    theData.addClass(clazz);
                }
            }
            catch (Exception ex) {
                System.out.println("Data error on last instance information (class/instance): " + currClass + "/" + currInst + " Message: " + ex.getMessage());
            }
        }
    }
}

