/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.test.SAPData;
import java.util.HashMap;
import java.util.Map;

public class SAPDataDir {
    private Map dataDir = new HashMap();
    private Map dataDirLocks = new HashMap();
    private Object lockSync = new Object();

    public boolean containsId(String typeId, String versionId) {
        return this.dataDir.containsKey(this.buildId(typeId, versionId));
    }

    public synchronized SAPData getData(String typeId, String versionId) throws SldServiceException {
        String id = this.buildId(typeId, versionId);
        if (this.dataDir.containsKey(id)) {
            if (this.isLocked(typeId, versionId)) {
                throw new SldServiceException("Data is locked (type/version): " + typeId + "/" + versionId);
            }
            return (SAPData)this.dataDir.get(id);
        }
        return null;
    }

    public synchronized void putData(SAPData data) {
        this.dataDir.put(this.buildId(data.getType(), data.getVersion()), data);
    }

    public void lock(String typeId, String versionId) throws SldServiceException {
        String id = this.buildId(typeId, versionId);
        Object object = this.lockSync;
        synchronized (object) {
            if (this.dataDirLocks.containsKey(id)) {
                throw new SldServiceException("Already locked (type/version): " + typeId + "/" + versionId);
            }
            this.dataDirLocks.put(id, null);
        }
    }

    public void unlock(String typeId, String versionId) {
        String id = this.buildId(typeId, versionId);
        Object object = this.lockSync;
        synchronized (object) {
            if (this.dataDirLocks.containsKey(id)) {
                this.dataDirLocks.remove(id);
            }
        }
    }

    public boolean isLocked(String typeId, String versionId) {
        String id = this.buildId(typeId, versionId);
        Object object = this.lockSync;
        synchronized (object) {
            boolean bl = this.dataDirLocks.containsKey(id);
            return bl;
        }
    }

    private String buildId(String typeId, String versionId) {
        return typeId + versionId;
    }
}

