/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.test.IData;
import com.sap.sldserv.test.IInstance;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SAPData
implements IData,
Cloneable {
    private String typeId;
    private String versionId;
    private HashMap data = new HashMap();

    public SAPData(String typeId, String versionId) {
        this.typeId = typeId;
        this.versionId = versionId;
    }

    public Object clone() {
        SAPData o = null;
        try {
            o = (SAPData)super.clone();
            o.data = new HashMap(this.data.size());
            Iterator it = this.data.values().iterator();
            while (it.hasNext()) {
                J2EEClass clazz = (J2EEClass)it.next();
                o.data.put(clazz.getName(), (J2EEClass)clazz.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    void addClass(J2EEClass clazz) {
        this.data.put(clazz.getName(), clazz);
    }

    void removeClass(J2EEClass clazz) {
        this.data.remove(clazz);
    }

    void removeClasses(ArrayList classList) {
        Iterator it = ((AbstractList)classList).iterator();
        while (it.hasNext()) {
            this.data.remove((J2EEClass)it.next());
        }
    }

    J2EEClass getNewObjectClass(String className) throws SldServiceException {
        if (this.data.containsKey(className)) {
            throw new SldServiceException("Class already exists: " + className);
        }
        return new J2EEClass(className);
    }

    J2EEClass getNewAssocClass(String className) throws SldServiceException {
        if (this.data.containsKey(className)) {
            throw new SldServiceException("Class already exists: " + className);
        }
        return new J2EEClass(className, false);
    }

    Iterator getClassIterator() {
        return this.data.values().iterator();
    }

    J2EEClass getClass(String className) {
        return (J2EEClass)this.data.get(className);
    }

    boolean contains(J2EEClass clazz) {
        return this.data.get(clazz.getName()) != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SAPData)) {
            return false;
        }
        if (this != obj) {
            SAPData otherData = (SAPData)obj;
            if (this.data.size() != otherData.data.size()) {
                return false;
            }
            Iterator cit = otherData.getClassIterator();
            while (cit.hasNext()) {
                J2EEClass otherClass = (J2EEClass)cit.next();
                J2EEClass thisClass = this.getClass(otherClass.getName());
                if (thisClass == null) {
                    return false;
                }
                if (thisClass.equals(otherClass)) continue;
                return false;
            }
        }
        return true;
    }

    public List getClassNames() {
        ArrayList<String> l = new ArrayList<String>(this.data.size());
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            J2EEClass c = (J2EEClass)it.next();
            l.add(c.getName());
        }
        return l;
    }

    public List getInstances(String className) {
        if (this.data.containsKey(className)) {
            J2EEClass clazz = (J2EEClass)this.data.get(className);
            ArrayList l = new ArrayList(clazz.getInstanceCount());
            Iterator it = clazz.instanceIterator();
            while (it.hasNext()) {
                l.add(it.next());
            }
            return l;
        }
        return new ArrayList();
    }

    public String getType() {
        return this.typeId;
    }

    public String getVersion() {
        return this.versionId;
    }

    public void write2File() {
        try {
            DecimalFormat dff = new DecimalFormat("00");
            DecimalFormat d4f = new DecimalFormat("0000");
            StringBuffer title = new StringBuffer(30);
            GregorianCalendar cal = new GregorianCalendar();
            cal.getTime();
            title.append(d4f.format(cal.get(1)));
            title.append(dff.format(cal.get(2) + 1));
            title.append(dff.format(cal.get(5)));
            title.append(dff.format(cal.get(11)));
            title.append(dff.format(cal.get(12)));
            title.append(dff.format(cal.get(13)));
            String fileName = "SAPDATA" + title.toString() + ".xls";
            File exportfile = new File(fileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(exportfile)));
            out.println("Classname\tProperty Name\tValue");
            Iterator iter = this.getClassNames().iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                Iterator institer = this.getInstances(className).iterator();
                while (institer.hasNext()) {
                    IInstance inst = (IInstance)institer.next();
                    out.println();
                    out.println(className + " (" + inst.getID() + ")");
                    Iterator propiter = inst.getPropertyNames().iterator();
                    while (propiter.hasNext()) {
                        String propName = (String)propiter.next();
                        if (inst.isAssociation()) {
                            out.println("\t" + propName + "\t" + "class=" + inst.getAssociationClassname(propName) + " - inst#=" + inst.getAssociationID(propName));
                            continue;
                        }
                        if (inst.getProperty(propName) != null) {
                            out.println("\t" + propName + "\t" + inst.getProperty(propName));
                            continue;
                        }
                        StringBuffer propValue = new StringBuffer();
                        List propArray = inst.getPropertyArray(propName);
                        if (propArray != null) {
                            Iterator valiter = propArray.iterator();
                            while (valiter.hasNext()) {
                                if (propValue.length() != 0) {
                                    propValue.append(",");
                                }
                                propValue.append((String)valiter.next());
                            }
                        }
                        out.println("\t" + propName + "\t" + propValue.toString());
                    }
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    private int cumulateHash(int oldHash, int hash) {
        oldHash = oldHash * 31 + hash;
        return oldHash;
    }

    public int hashCode() {
        int hashCode = 0;
        Iterator iter = this.getClassNames().iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            hashCode = this.cumulateHash(hashCode, className.hashCode());
            Iterator institer = this.getInstances(className).iterator();
            while (institer.hasNext()) {
                IInstance inst = (IInstance)institer.next();
                Iterator propiter = inst.getPropertyNames().iterator();
                while (propiter.hasNext()) {
                    String propName = (String)propiter.next();
                    hashCode = this.cumulateHash(hashCode, propName.hashCode());
                    if (inst.isAssociation()) {
                        hashCode = this.cumulateHash(hashCode, inst.getAssociationClassname(propName).hashCode());
                        hashCode = this.cumulateHash(hashCode, inst.getAssociationID(propName).hashCode());
                        continue;
                    }
                    if (inst.getProperty(propName) != null) {
                        hashCode = this.cumulateHash(hashCode, inst.getProperty(propName).hashCode());
                        continue;
                    }
                    List propArray = inst.getPropertyArray(propName);
                    if (propArray == null) continue;
                    Iterator valiter = propArray.iterator();
                    while (valiter.hasNext()) {
                        hashCode = this.cumulateHash(hashCode, valiter.next().hashCode());
                    }
                }
            }
        }
        return hashCode;
    }
}

