/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.test.DataCollConst;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class DataTab
implements DataCollConst {
    private ArrayList fieldList = null;
    private HashMap fieldMap = new HashMap();
    private DataLine headerLine = null;
    private ArrayList tableLines = new ArrayList();

    DataTab(ArrayList fieldList) {
        this.fieldList = (ArrayList)fieldList.clone();
        int i = 0;
        while (i < fieldList.size()) {
            this.fieldMap.put((String)fieldList.get(i), new Integer(i));
            ++i;
        }
        this.headerLine = new DataLine(fieldList, this.fieldMap);
    }

    void addValue(String fieldName, String fieldValue) throws SldServiceException {
        this.headerLine.setValue(fieldName, fieldValue);
    }

    void appendHeader() {
        this.tableLines.add((DataLine)this.headerLine.clone());
    }

    void appendLine(DataLine line) throws SldServiceException {
        if (line == null || line.size() != this.fieldList.size()) {
            throw new SldServiceException("Invalid line specified: " + line);
        }
        this.tableLines.add(line);
    }

    DataLine getLine(int idx) throws SldServiceException {
        if (idx < 0 || idx >= this.tableLines.size()) {
            throw new SldServiceException("Invalid line index specified: " + idx);
        }
        return (DataLine)this.tableLines.get(idx);
    }

    int getLineCount() {
        return this.tableLines.size();
    }

    String getFieldValue(int lineIdx, String fieldName) throws SldServiceException {
        if (lineIdx < 0 || lineIdx >= this.tableLines.size()) {
            throw new SldServiceException("No such line: " + lineIdx);
        }
        DataLine line = (DataLine)this.tableLines.get(lineIdx);
        return line.getValue(fieldName);
    }

    ArrayList getFieldList() {
        return this.fieldList;
    }

    int size() {
        return this.tableLines.size();
    }

    void remove(int startIdx, int endIdx) {
        if (startIdx >= 0 || endIdx < this.tableLines.size()) {
            int count = endIdx - startIdx + 1;
            int i = 0;
            while (i < count) {
                this.tableLines.remove(startIdx);
                ++i;
            }
        }
    }

    int getIdx(String field1, String value1, String field2, String value2) {
        int i = 0;
        while (i < this.tableLines.size()) {
            DataLine line = (DataLine)this.tableLines.get(i);
            try {
                if (line.getValue(field1).equals(value1) && line.getValue(field2).equals(value2)) {
                    return i;
                }
            }
            catch (Exception ex) {
                break;
            }
            ++i;
        }
        return -1;
    }

    int getLastIdx(String field1, String value1, String field2, String value2) {
        int i = this.tableLines.size() - 1;
        while (i >= 0) {
            DataLine line = (DataLine)this.tableLines.get(i);
            try {
                if (line.getValue(field1).equals(value1) && line.getValue(field2).equals(value2)) {
                    return i;
                }
            }
            catch (Exception ex) {
                break;
            }
            --i;
        }
        return -1;
    }

    static void copy(DataTab source, DataTab target) throws SldServiceException {
        target.tableLines.clear();
        int i = 0;
        while (i < source.size()) {
            DataLine line = source.getLine(i);
            target.tableLines.add(line);
            ++i;
        }
    }

    void write2file() {
        try {
            DecimalFormat dff = new DecimalFormat("00");
            DecimalFormat d4f = new DecimalFormat("0000");
            StringBuffer title = new StringBuffer(30);
            GregorianCalendar cal = new GregorianCalendar();
            cal.getTime();
            title.append(d4f.format(cal.get(1)));
            title.append(dff.format(cal.get(2) + 1));
            title.append(dff.format(cal.get(5)));
            title.append(dff.format(cal.get(11)));
            title.append(dff.format(cal.get(12)));
            title.append(dff.format(cal.get(13)));
            String fileName = "DATATAB" + title.toString() + ".xls";
            File exportfile = new File(fileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(exportfile)));
            out.println("Writing raw data file: " + exportfile.getAbsolutePath());
            int fi = 0;
            while (fi < this.fieldList.size()) {
                out.print(this.fieldList.get(fi) + "\t");
                ++fi;
            }
            out.println();
            int idx = 0;
            while (idx < this.getLineCount()) {
                DataLine dataLine = this.getLine(idx);
                int i = 0;
                while (i < dataLine.size()) {
                    out.print(dataLine.getValue(i) + "\t");
                    ++i;
                }
                out.println();
                ++idx;
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    static class DataLine
    implements Cloneable {
        private ArrayList line = null;
        private HashMap fieldMap = null;

        DataLine(ArrayList fieldList, HashMap fieldMap) {
            this.line = new ArrayList(fieldList.size());
            this.allocLine(fieldList.size());
            if (fieldMap == null) {
                this.fieldMap = new HashMap();
                int i = 0;
                while (i < fieldList.size()) {
                    fieldMap.put((String)fieldList.get(i), new Integer(i));
                    ++i;
                }
            } else {
                this.fieldMap = fieldMap;
            }
        }

        protected Object clone() {
            Object newObj = null;
            try {
                newObj = super.clone();
                ((DataLine)newObj).line = (ArrayList)this.line.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return newObj;
        }

        private void allocLine(int count) {
            int i = 0;
            while (i < count) {
                this.line.add("");
                ++i;
            }
        }

        String getValue(String fieldName) throws SldServiceException {
            return (String)this.line.get(this.field2Idx(fieldName));
        }

        String getValue(int idx) throws SldServiceException {
            try {
                return (String)this.line.get(idx);
            }
            catch (Exception ex) {
                throw new SldServiceException("Invalid Field Index: " + idx);
            }
        }

        int field2Idx(String fieldName) throws SldServiceException {
            Integer idx = (Integer)this.fieldMap.get(fieldName);
            if (idx == null) {
                throw new SldServiceException("Invalid Field: " + fieldName);
            }
            return idx;
        }

        void setValue(String fieldName, String fieldValue) throws SldServiceException {
            this.line.set(this.field2Idx(fieldName), fieldValue);
        }

        int size() {
            return this.line.size();
        }
    }
}

