/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.test.IData;
import com.sap.sldserv.test.IDataQueue;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DataQueue
implements IDataQueue {
    private QueueElement first = null;
    private QueueElement last = null;
    private volatile int count = 0;
    private Object queueAccess = new Object();

    public void add(IData o) {
        Object object = this.queueAccess;
        synchronized (object) {
            if (this.count == 0) {
                this.last = this.first = new QueueElement();
                this.count = 1;
            } else {
                this.last = this.last.next = new QueueElement();
                ++this.count;
            }
            this.last.element = o;
            this.last.next = null;
            this.queueAccess.notifyAll();
        }
    }

    public IData peek() {
        Object object = this.queueAccess;
        synchronized (object) {
            IData iData = this.first != null ? this.first.element : null;
            return iData;
        }
    }

    public IData get() throws InterruptedException {
        Object object = this.queueAccess;
        synchronized (object) {
            while (this.count <= 0) {
                this.queueAccess.wait();
            }
            QueueElement el = this.first;
            --this.count;
            this.first = this.first.next;
            if (this.first == null) {
                this.last = null;
                this.count = 0;
            }
            IData iData = el.element;
            return iData;
        }
    }

    public int size() {
        Object object = this.queueAccess;
        synchronized (object) {
            int n = this.count;
            return n;
        }
    }

    public void clear() {
        Object object = this.queueAccess;
        synchronized (object) {
            while (this.first != null) {
                QueueElement tmp = this.first;
                this.first = this.first.next;
                tmp.next = null;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
        }
    }

    public synchronized Iterator iterator() {
        Object object = this.queueAccess;
        synchronized (object) {
            ArrayList<IData> tmpList = new ArrayList<IData>(this.count);
            QueueElement qe = this.first;
            while (qe != null) {
                tmpList.add(qe.element);
                qe = qe.next;
            }
            Iterator iterator = ((AbstractList)tmpList).iterator();
            return iterator;
        }
    }

    static class QueueElement {
        public IData element;
        public QueueElement next;

        QueueElement() {
        }
    }
}

