/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.test;

import com.sap.sldserv.test.DataCollConst;
import com.sap.sldserv.test.IDataColl;
import com.sap.sldserv.test.IDataQueue;
import com.sap.sldserv.test.SAPProxy;
import com.sap.sldserv.test.SAPProxyRfc;
import com.sap.sldserv.util.ServiceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DataColl
implements IDataColl,
DataCollConst {
    private static final String COLL_THREAD_NAME = "Collector";
    private Thread coll = null;
    private Object collNotify = null;
    private volatile boolean notifyPending = false;

    public static DataColl createDataCollector() {
        try {
            return new DataColl();
        }
        catch (Exception e) {
            System.out.println("Can not create data collection object.");
            return null;
        }
    }

    public static SAPProxy createSAPProxyRfc(IDataQueue dataQueue, String gwHost, String gwServ, String gwRegIdNUC, String gwRegIdUC, boolean dataTrace, boolean serverTrace) {
        try {
            return new SAPProxyRfc(dataQueue, gwHost, gwServ, gwRegIdNUC, gwRegIdUC, dataTrace, serverTrace);
        }
        catch (Exception ex) {
            System.out.println("Failed to create RFC proxy: " + ex.getMessage());
            return null;
        }
    }

    public boolean isRunning() {
        boolean runs = false;
        if (this.coll != null) {
            runs = this.coll.isAlive();
        }
        return runs;
    }

    public synchronized boolean startCollector() {
        System.out.println("Starting  collector ...");
        boolean rc = true;
        try {
            if (!this.isRunning()) {
                this.startCollectorThread();
            }
            System.out.println("Collector thread started.");
        }
        catch (Exception e) {
            StringWriter strWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(strWriter));
            System.out.println("Failed to start collector thread: Collector" + strWriter.toString());
            rc = false;
        }
        return rc;
    }

    public synchronized boolean stopCollector() {
        System.out.println("Stopping Java collector ...");
        this.sendNotify();
        int i = 0;
        while (i < 5 && this.coll.isAlive()) {
            ServiceUtils.waitSeconds(2L);
            if (this.isRunning()) {
                this.coll.interrupt();
            }
            ++i;
        }
        boolean stopped = !this.isRunning();
        System.out.println("Stop of Java collector: " + stopped);
        return stopped;
    }

    private void startCollectorThread() {
        this.collNotify = new Object();
        Runnable runable = new Runnable(){

            public void run() {
                System.out.println("This is the end!");
            }
        };
        this.coll = new Thread(runable, COLL_THREAD_NAME);
        this.coll.start();
    }

    public void collWait() {
        if (!this.notifyPending) {
            try {
                Object object = this.collNotify;
                synchronized (object) {
                    this.collNotify.wait(300000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyPending = false;
    }

    private void sendNotify() {
        Object object = this.collNotify;
        synchronized (object) {
            this.notifyPending = true;
            this.collNotify.notifyAll();
        }
    }
}

