/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.sapinst;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.lib.security.Base64;
import com.sap.sldserv.util.ServiceUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class SetParamsOffline {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int MAX_WAITING_LOOP = 10;
        int rvalue = 0;
        try {
            Args valueConnArgs = new Args(args);
            String cfgData = SetParamsOffline.getConfigString(valueConnArgs);
            ConfigurationManagerBootstrapImpl cfgMgr = new ConfigurationManagerBootstrapImpl(valueConnArgs.getDatabaseConnectFileValue());
            ConfigurationHandler cfgHandler = cfgMgr.getConfigurationHandler();
            Configuration instCfgRoot = null;
            Configuration instCfg = null;
            int cnt = 0;
            while (cnt < 10) {
                block17: {
                    Object var15_15;
                    try {
                        try {
                            instCfgRoot = cfgHandler.openConfiguration("SLDINST", 1);
                            instCfg = instCfgRoot.getSubConfiguration("SAPinst");
                            PropertySheet ips = instCfg.getPropertySheetInterface();
                            try {
                                ips.deletePropertyEntry("info");
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            PropertyEntry pe = ips.createSecurePropertyEntry("info", (Object)"", "");
                            pe.setValue((Object)cfgData);
                            var15_15 = null;
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            var15_15 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            break block17;
                        }
                        catch (NameNotFoundException e) {
                            if (instCfgRoot == null) {
                                instCfgRoot = cfgHandler.createRootConfiguration("SLDINST");
                            }
                            if (instCfgRoot != null && instCfg == null) {
                                instCfg = instCfgRoot.createSubConfiguration("SAPinst", 1);
                            }
                            PropertySheet ips = instCfg.getPropertySheetInterface();
                            try {
                                ips.deletePropertyEntry("info");
                            }
                            catch (Exception ee) {
                                // empty catch block
                            }
                            PropertyEntry pe = ips.createSecurePropertyEntry("info", (Object)"", "");
                            pe.setValue((Object)cfgData);
                            var15_15 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        var15_15 = null;
                        cfgHandler.commit();
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.commit();
                    cfgHandler.closeAllConfigurations();
                    break;
                }
                ++cnt;
            }
        }
        catch (CommandLineException e) {
            System.out.println("Invalid command line: " + e.getMessage());
            Args.printCommandLineHelp();
            rvalue = -1;
        }
        catch (Exception e) {
            System.out.println("Failed to transfer SLD configuration data to configuration manager database");
            e.printStackTrace();
            rvalue = -1;
        }
        catch (Throwable e) {
            System.out.println("Internal Error! Check for missing 'jar' files!");
            e.printStackTrace();
            rvalue = -1;
        }
        System.out.println("RC=" + rvalue);
        System.exit(rvalue);
    }

    private static String getConfigString(Args valueConnArgs) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(valueConnArgs.getHttpHost() + ":");
        sb.append(valueConnArgs.getHttpPort() + ":");
        sb.append(valueConnArgs.getHttpUser() + ":");
        sb.append(valueConnArgs.getHttpPass() + ":");
        sb.append(valueConnArgs.doHttps());
        return sb.toString();
    }

    static byte[] encode(String s) throws Exception {
        return Base64.encode((byte[])s.getBytes());
    }

    static String decode(byte[] b) throws Exception {
        return new String(Base64.decode((byte[])b));
    }

    static void testReading(ConfigurationHandler cfgHandler) throws ConfigurationException {
        try {
            cfgHandler.commit();
            Configuration instCfgRoot = cfgHandler.openConfiguration("SLDINST", 0);
            Configuration instCfg = instCfgRoot.getSubConfiguration("SAPinst");
            PropertySheet ips = instCfg.getPropertySheetInterface();
            PropertyEntry pe = ips.getPropertyEntry("info");
            String cfgData = (String)pe.getValue();
            Properties props = new Properties();
            StringTokenizer st = new StringTokenizer(cfgData, ":");
            if (st.countTokens() == 5) {
                ((Hashtable)props).put("HttpHost", (String)st.nextElement());
                ((Hashtable)props).put("HttpPort", (String)st.nextElement());
                ((Hashtable)props).put("HttpUser", (String)st.nextElement());
                ((Hashtable)props).put("HttpPassword", (String)st.nextElement());
                ((Hashtable)props).put("UseHttps", (String)st.nextElement());
                cfgHandler.closeAllConfigurations();
                instCfgRoot = cfgHandler.openConfiguration("SLDINST", 1);
                instCfgRoot.deleteConfiguration();
                cfgHandler.commit();
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            cfgHandler.closeAllConfigurations();
            throw throwable;
        }
        cfgHandler.closeAllConfigurations();
    }

    static class Args {
        private static final String CMD_OPTION_DB_CONN_FILE = "-configfile";
        private static final String DB_DEFAULT_CONN_FILE = "config.properties";
        private static final String HTTP_DEFAULT_USER = "";
        private static final String HTTP_DEFAULT_PASSWORD = "";
        private static final String HTTP_DEFAULT_HOST = "";
        private static final String HTTP_DEFAULT_PORT = "";
        private static final String CMD_OPTION_HTTPUSER = "-httpuser";
        private static final String CMD_OPTION_HTTPPASSWORD = "-httppass";
        private static final String CMD_OPTION_HTTPHOST = "-httphost";
        private static final String CMD_OPTION_HTTPPORT = "-httpport";
        private static final String CMD_OPTION_USE_HTTPS = "-usehttps";
        static final String CMD_OPTION_SHOW = "-show";
        static final String CMD_OPTION_SHOW_EXPLICIT = "-showexplicit";
        private Properties props = new Properties();

        public Args(String[] args) throws CommandLineException {
            if (args.length > 0) {
                try {
                    int i = 0;
                    while (i < args.length) {
                        if (args[i].equalsIgnoreCase(CMD_OPTION_DB_CONN_FILE)) {
                            ((Hashtable)this.props).put(CMD_OPTION_DB_CONN_FILE, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPUSER)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPUSER, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPPASSWORD)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPPASSWORD, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPHOST)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPHOST, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPPORT)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPPORT, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_USE_HTTPS)) {
                            ((Hashtable)this.props).put(CMD_OPTION_USE_HTTPS, Boolean.TRUE.toString());
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW)) {
                            ((Hashtable)this.props).put(CMD_OPTION_SHOW, Boolean.TRUE.toString());
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW_EXPLICIT)) {
                            ((Hashtable)this.props).put(CMD_OPTION_SHOW_EXPLICIT, Boolean.TRUE.toString());
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new CommandLineException("Invalid command line");
                }
                if (this.props.getProperty(CMD_OPTION_SHOW) != null) {
                    this.printSettings();
                }
                if (this.props.getProperty(CMD_OPTION_SHOW_EXPLICIT) != null) {
                    this.printExplicitSettings();
                }
            } else {
                Args.printCommandLineHelp();
                throw new CommandLineException("Mandatory command line arguments missing");
            }
        }

        static void printCommandLineHelp() {
            System.out.println("java -classpath <...> com.sap.sldserv.sapinst.SetParamsOffline <options (1)> <options (2)> [<options (3)>] [<options (4)>]");
            System.out.println();
            System.out.println("(1) DB connect parameters");
            System.out.println("-configfile <file>      : Properties file for database access (default: config.properties)");
            System.out.println();
            System.out.println("(2) HTTP configuration parameters (mandatory)");
            System.out.println("-httpuser <HTTP user>   : User name used for HTTP communication to SLD bridge");
            System.out.println("-httppass <HTTP user pw>: Password for HTTP user");
            System.out.println("-httphost <HTTP host>   : Hostname of SLD bridge used for HTTP communication");
            System.out.println("-httpport <HTTP port>   : Port number of SLD HTTP bridge used for HTTP communication");
            System.out.println();
            System.out.println("(3) Optional Settings");
            System.out.println("-usehttps               : The HTTP port specified is used as (secure) HTTPS port");
            System.out.println();
            System.out.println("(4) 'Show' options used by program (options)");
            System.out.println("-show        : Shows all parameters used by the program inclusive defaults");
            System.out.println("-showexplicit: Show only explicitly set parameters, i.e. shows no default settings");
        }

        public void printExplicitSettings() {
            Iterator i = ((Hashtable)this.props).keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = this.props.getProperty(name);
                System.out.println("name=" + name + " / value=" + value);
            }
        }

        public void printSettings() {
            System.out.println("name=-configfile / value=" + this.getDatabaseConnectFileValue());
            System.out.println("name=-httpuser / value=" + this.getHttpUser());
            System.out.println("name=-httppass / value=" + this.getHttpPass());
            System.out.println("name=-httphost / value=" + this.getHttpHost());
            System.out.println("name=-httpport / value=" + this.getHttpPort());
            System.out.println("name=-usehttps / value=" + this.doHttps());
        }

        public String getDatabaseConnectFileValue() {
            return this.props.getProperty(CMD_OPTION_DB_CONN_FILE, DB_DEFAULT_CONN_FILE);
        }

        public String getHttpUser() {
            return this.props.getProperty(CMD_OPTION_HTTPUSER, "");
        }

        public String getHttpPass() {
            return this.props.getProperty(CMD_OPTION_HTTPPASSWORD, "");
        }

        public String getHttpHost() {
            return this.props.getProperty(CMD_OPTION_HTTPHOST, "");
        }

        public String getHttpPort() {
            return this.props.getProperty(CMD_OPTION_HTTPPORT, "");
        }

        public boolean doHttps() {
            String v = this.props.getProperty(CMD_OPTION_USE_HTTPS);
            return v != null && v.equalsIgnoreCase(Boolean.TRUE.toString());
        }

        public boolean isSet(String cmdArg) {
            return this.props.getProperty(cmdArg) != null;
        }
    }

    public static class CommandLineException
    extends Exception {
        public CommandLineException(String s) {
            super(s);
        }
    }
}

