/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.sapinst;

import com.sap.sldserv.ServiceManagementRmiInterface;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class SetParams {
    private static final String P4_RMI_USER_PARAM = "java.naming.security.principal";
    private static final String P4_RMI_URL_PARAM = "java.naming.provider.url";
    private static final String P4_RMI_FACTORY_PARAM = "java.naming.factory.initial";
    private static final String P4_RMI_PW_PARAM = "java.naming.security.credentials";
    static /* synthetic */ Class class$com$sap$sldserv$ServiceManagementRmiInterface;

    public static void main(String[] args) {
        int rvalue = 0;
        try {
            Args valueConnArgs = new Args(args);
            Properties p4Props = new Properties();
            ((Hashtable)p4Props).put(P4_RMI_USER_PARAM, valueConnArgs.getP4UserValue());
            ((Hashtable)p4Props).put(P4_RMI_URL_PARAM, valueConnArgs.getP4UrlValue());
            ((Hashtable)p4Props).put(P4_RMI_FACTORY_PARAM, valueConnArgs.getP4FactoryValue());
            ((Hashtable)p4Props).put(P4_RMI_PW_PARAM, valueConnArgs.getP4PasswordValue());
            InitialContext ctx = new InitialContext(p4Props);
            System.out.println("Performing JNDI lookup for >sld<");
            Object obj1 = ctx.lookup("sld");
            if (obj1 != null) {
                System.out.println("Got remote object reference");
                ServiceManagementRmiInterface serviceManagementRmi = (ServiceManagementRmiInterface)PortableRemoteObject.narrow((Object)obj1, (Class)(class$com$sap$sldserv$ServiceManagementRmiInterface == null ? (class$com$sap$sldserv$ServiceManagementRmiInterface = SetParams.class$("com.sap.sldserv.ServiceManagementRmiInterface")) : class$com$sap$sldserv$ServiceManagementRmiInterface));
                System.out.println("Got remote service interface");
                Properties httpProps = new Properties();
                ((Hashtable)httpProps).put("HttpHost", valueConnArgs.getHttpHost());
                ((Hashtable)httpProps).put("HttpPort", valueConnArgs.getHttpPort());
                ((Hashtable)httpProps).put("UseHttps", valueConnArgs.doHttps() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                ((Hashtable)httpProps).put("HttpUser", valueConnArgs.getHttpUser());
                ((Hashtable)httpProps).put("HttpPassword", valueConnArgs.getHttpPass());
                System.out.println("Running parameters transfer " + (valueConnArgs.doCollectorRun() ? "with" : "without") + " data collector run");
                if (serviceManagementRmi.setConfigParams(valueConnArgs.doCollectorRun(), httpProps)) {
                    System.out.println("Configuration parameters successfully transfered");
                    if (valueConnArgs.doCollectorRun()) {
                        System.out.println("Data collector run triggered");
                    }
                } else {
                    System.out.println("Failed to store configuration data on J2EE server");
                }
            } else {
                System.out.println("No SLD J2EE service found via remote JNDI lookup");
                rvalue = -1;
            }
        }
        catch (CommandLineException e) {
            System.out.println("Invalid command line: " + e.getMessage());
            rvalue = -1;
        }
        catch (Exception e) {
            System.out.println("Failed to transfer configuration data to SLD J2EE Service");
            e.printStackTrace();
            rvalue = -1;
        }
        System.out.println("RC=" + rvalue);
        System.exit(rvalue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Args {
        private static final String P4_RMI_DEFAULT_USER = "Administrator";
        private static final String P4_RMI_DEFAULT_HOST = "localhost";
        private static final String P4_RMI_DEFAULT_P4PORT = "50004";
        private static final String P4_RMI_DEFAULT_FACTORY = "com.sap.engine.services.jndi.InitialContextFactoryImpl";
        private static final String P4_RMI_DEFAULT_PASSWORD = "sap";
        private static final String HTTP_DEFAULT_USER = "";
        private static final String HTTP_DEFAULT_PASSWORD = "";
        private static final String HTTP_DEFAULT_HOST = "";
        private static final String HTTP_DEFAULT_PORT = "";
        private static final String CMD_OPTION_P4USER = "-p4user";
        private static final String CMD_OPTION_P4PASSWORD = "-p4pass";
        private static final String CMD_OPTION_P4HOST = "-p4host";
        private static final String CMD_OPTION_P4PORT = "-p4port";
        private static final String CMD_OPTION_P4FACTORY = "-p4factoryclass";
        private static final String CMD_OPTION_HTTPUSER = "-httpuser";
        private static final String CMD_OPTION_HTTPPASSWORD = "-httppass";
        private static final String CMD_OPTION_HTTPHOST = "-httphost";
        private static final String CMD_OPTION_HTTPPORT = "-httpport";
        private static final String CMD_OPTION_USE_HTTPS = "-usehttps";
        private static final String CMD_OPTION_DATATRANSFER = "-runcollector";
        private static final String CMD_OPTION_SHOW = "-show";
        private static final String CMD_OPTION_SHOW_EXPLICIT = "-showexplicit";
        private Properties props = new Properties();

        public Args(String[] args) throws CommandLineException {
            if (args.length > 0) {
                try {
                    int i = 0;
                    while (i < args.length) {
                        if (args[i].equalsIgnoreCase(CMD_OPTION_P4USER)) {
                            ((Hashtable)this.props).put(CMD_OPTION_P4USER, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4PASSWORD)) {
                            ((Hashtable)this.props).put(CMD_OPTION_P4PASSWORD, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4HOST)) {
                            ((Hashtable)this.props).put(CMD_OPTION_P4HOST, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4PORT)) {
                            ((Hashtable)this.props).put(CMD_OPTION_P4PORT, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4FACTORY)) {
                            ((Hashtable)this.props).put(CMD_OPTION_P4FACTORY, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPUSER)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPUSER, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPPASSWORD)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPPASSWORD, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPHOST)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPHOST, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_HTTPPORT)) {
                            ((Hashtable)this.props).put(CMD_OPTION_HTTPPORT, args[++i]);
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_USE_HTTPS)) {
                            ((Hashtable)this.props).put(CMD_OPTION_USE_HTTPS, Boolean.TRUE.toString());
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW)) {
                            ((Hashtable)this.props).put(CMD_OPTION_SHOW, Boolean.TRUE.toString());
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW_EXPLICIT)) {
                            ((Hashtable)this.props).put(CMD_OPTION_SHOW_EXPLICIT, Boolean.TRUE.toString());
                        } else if (args[i].equalsIgnoreCase(CMD_OPTION_DATATRANSFER)) {
                            ((Hashtable)this.props).put(CMD_OPTION_DATATRANSFER, Boolean.TRUE.toString());
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new CommandLineException("Invalid command line");
                }
                if (this.props.getProperty(CMD_OPTION_SHOW) != null) {
                    this.printSettings();
                }
                if (this.props.getProperty(CMD_OPTION_SHOW_EXPLICIT) != null) {
                    this.printExplicitSettings();
                }
            } else {
                this.printCommandLineHelp();
                throw new CommandLineException("Mandatory command line arguments missing");
            }
        }

        private void printCommandLineHelp() {
            System.out.println("java -classpath <...> com.sap.sldserv.sapinst.SetParams [<options (1)>] <options (2)> [<options (3)>] [<options (4)>]");
            System.out.println();
            System.out.println("(1) P4 connect parameters (optional)");
            System.out.println("-p4user <user>   : User for P4 access (default: Administrator)");
            System.out.println("-p4pass <pw>     : Password of P4 user (default: sap)");
            System.out.println("-p4host <host>   : Hostname of J2EE server (default: localhost)");
            System.out.println("-p4port <port nr>: P4 Port number (default: 50004)");
            System.out.println();
            System.out.println("(2) HTTP configuration parameters (mandatory)");
            System.out.println("-httpuser <HTTP user>   : User name used for HTTP communication to SLD bridge");
            System.out.println("-httppass <HTTP user pw>: Password for HTTP user");
            System.out.println("-httphost <HTTP host>   : Hostname of SLD bridge used for HTTP communication");
            System.out.println("-httpport <HTTP port>   : Port number of SLD HTTP bridge used for HTTP communication");
            System.out.println("(3)");
            System.out.println("-runcollector: Triggers the immediate data collect and transfer on the connected server node");
            System.out.println("-usehttps    : The HTTP port specified is used as (secure) HTTPS port");
            System.out.println();
            System.out.println("(4) 'Show' options used by program (options)");
            System.out.println("-show        : Shows all parameters used by the program inclusive defaults");
            System.out.println("-showexplicit: Show only explicitly set parameters, i.e. shows no default settings");
        }

        public void printExplicitSettings() {
            Iterator i = ((Hashtable)this.props).keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = this.props.getProperty(name);
                System.out.println("name=" + name + " / value=" + value);
            }
        }

        public void printSettings() {
            System.out.println("name=-p4user / value=" + this.getP4UserValue());
            System.out.println("name=-p4pass / value=" + this.getP4PasswordValue());
            System.out.println("name=-p4host / value=" + this.getP4HostValue());
            System.out.println("name=-p4port / value=" + this.getP4PortValue());
            System.out.println("name=-p4factoryclass / value=" + this.getP4FactoryValue());
            System.out.println("name=-httpuser / value=" + this.getHttpUser());
            System.out.println("name=-httppass / value=" + this.getHttpPass());
            System.out.println("name=-httphost / value=" + this.getHttpHost());
            System.out.println("name=-httpport / value=" + this.getHttpPort());
            System.out.println("name=-usehttps / value=" + this.doHttps());
        }

        public String getP4UserValue() {
            return this.props.getProperty(CMD_OPTION_P4USER, P4_RMI_DEFAULT_USER);
        }

        public String getP4PasswordValue() {
            return this.props.getProperty(CMD_OPTION_P4PASSWORD, P4_RMI_DEFAULT_PASSWORD);
        }

        public String getP4HostValue() {
            return this.props.getProperty(CMD_OPTION_P4HOST, P4_RMI_DEFAULT_HOST);
        }

        public String getP4PortValue() {
            return this.props.getProperty(CMD_OPTION_P4PORT, P4_RMI_DEFAULT_P4PORT);
        }

        public String getP4UrlValue() {
            return this.getP4HostValue() + ":" + this.getP4PortValue();
        }

        public String getP4FactoryValue() {
            return this.props.getProperty(CMD_OPTION_P4FACTORY, P4_RMI_DEFAULT_FACTORY);
        }

        public String getHttpUser() {
            return this.props.getProperty(CMD_OPTION_HTTPUSER, "");
        }

        public String getHttpPass() {
            return this.props.getProperty(CMD_OPTION_HTTPPASSWORD, "");
        }

        public String getHttpHost() {
            return this.props.getProperty(CMD_OPTION_HTTPHOST, "");
        }

        public String getHttpPort() {
            return this.props.getProperty(CMD_OPTION_HTTPPORT, "");
        }

        public boolean doHttps() {
            String v = this.props.getProperty(CMD_OPTION_USE_HTTPS);
            return v != null && v.equalsIgnoreCase(Boolean.TRUE.toString());
        }

        public boolean doCollectorRun() {
            String v = this.props.getProperty(CMD_OPTION_DATATRANSFER);
            return v != null && v.equalsIgnoreCase(Boolean.TRUE.toString());
        }
    }

    public static class CommandLineException
    extends Exception {
        public CommandLineException(String s) {
            super(s);
        }
    }
}

