/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.sapinst;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.remote.RemoteAuthorization;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import com.sap.engine.services.security.roles.SecurityRoleReference;
import com.sap.sldserv.util.RoleMapInfo;
import com.sap.sldserv.util.XMLRoleParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class RoleMapping {
    private static final String P4_RMI_USER_PARAM = "java.naming.security.principal";
    private static final String P4_RMI_URL_PARAM = "java.naming.provider.url";
    private static final String P4_RMI_FACTORY_PARAM = "java.naming.factory.initial";
    private static final String P4_RMI_PW_PARAM = "java.naming.security.credentials";
    static /* synthetic */ Class class$com$sap$engine$services$security$remote$RemoteSecurity;

    public static void main(String[] args) {
        int rvalue;
        block20: {
            rvalue = 0;
            try {
                Args valueConnArgs = new Args(args);
                if (valueConnArgs.helpOutputSet()) break block20;
                String mapFileName = valueConnArgs.getMapFile();
                System.out.println("Using security role file: " + mapFileName);
                FileInputStream mapFileStream = new FileInputStream(mapFileName);
                RoleMapInfo mapInfo = XMLRoleParser.parseMapFile(mapFileStream);
                Properties p4Props = new Properties();
                ((Hashtable)p4Props).put(P4_RMI_USER_PARAM, valueConnArgs.getP4UserValue());
                ((Hashtable)p4Props).put(P4_RMI_URL_PARAM, valueConnArgs.getP4UrlValue());
                ((Hashtable)p4Props).put(P4_RMI_FACTORY_PARAM, valueConnArgs.getP4FactoryValue());
                ((Hashtable)p4Props).put(P4_RMI_PW_PARAM, valueConnArgs.getP4PasswordValue());
                InitialContext ctx = new InitialContext(p4Props);
                System.out.println("Performing remote JNDI lookup: remotesecurity [" + valueConnArgs.getP4UrlValue() + "]");
                Object securityObj = ctx.lookup("remotesecurity");
                if (securityObj != null) {
                    RemoteSecurity remoteSecurity = (RemoteSecurity)PortableRemoteObject.narrow((Object)securityObj, (Class)(class$com$sap$engine$services$security$remote$RemoteSecurity == null ? (class$com$sap$engine$services$security$remote$RemoteSecurity = RoleMapping.class$("com.sap.engine.services.security.remote.RemoteSecurity")) : class$com$sap$engine$services$security$remote$RemoteSecurity));
                    RemoteUserStoreFactory rusf = remoteSecurity.getRemoteUserStoreFactory();
                    RemoteUserStore rus = rusf.getActiveUserStore();
                    RemoteGroupContext rgc = rus.getGroupContext();
                    Iterator it = mapInfo.getConfigIdIterator();
                    while (it.hasNext()) {
                        Map.Entry me = (Map.Entry)it.next();
                        String configId = (String)me.getKey();
                        ArrayList mappings = (ArrayList)me.getValue();
                        RemoteSecurityRoles rsrs = remoteSecurity.getPolicyConfiguration(configId).getAuthorization().getSecurityRoles();
                        SecurityRole[] allRoles = rsrs.listSecurityRoles();
                        Iterator iter = ((AbstractList)mappings).iterator();
                        while (iter.hasNext()) {
                            RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                            String abapRole = pair.getFirst();
                            try {
                                rgc.getGroupInfo(abapRole);
                            }
                            catch (Exception e) {
                                System.out.println("Unknown user group removed (application, user group): " + configId + ", " + abapRole);
                                mapInfo.addRemove(configId, pair);
                                continue;
                            }
                            String j2eeRole = pair.getSecond();
                            boolean found = false;
                            int i = 0;
                            while (i < allRoles.length) {
                                if (allRoles[i].getName().equalsIgnoreCase(j2eeRole)) {
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (found) continue;
                            System.out.println("Unknown J2EE security role remove: " + j2eeRole);
                            mapInfo.addRemove(configId, pair);
                        }
                        mapInfo.commitRemove();
                        int i = 0;
                        while (i < allRoles.length) {
                            String roleName = allRoles[i].getName();
                            if (allRoles[i] instanceof SecurityRoleReference && mapInfo.containsJ2eeRole(configId, roleName)) {
                                String[] users = allRoles[i].getUsers();
                                String[] groups = allRoles[i].getGroups();
                                rsrs.removeSecurityRole(roleName);
                                rsrs.addSecurityRole(roleName);
                                SecurityRole newRole = rsrs.getSecurityRole(roleName);
                                System.out.println("Repleaced role reference with role (application, role): " + configId + ", " + roleName);
                                int j = 0;
                                while (j < users.length) {
                                    newRole.addUser(users[j]);
                                    System.out.println("Reassigning user from role reference to new role (application, role, user): " + configId + ", " + roleName + ", " + users[j]);
                                    ++j;
                                }
                                int j2 = 0;
                                while (j2 < groups.length) {
                                    newRole.addGroup(groups[j2]);
                                    System.out.println("Reassigning group from role reference to new role (application, role, group): " + configId + ", " + roleName + ", " + groups[j2]);
                                    ++j2;
                                }
                            }
                            ++i;
                        }
                    }
                    if (mapInfo.hasMappings()) {
                        Iterator it2 = mapInfo.getConfigIdIterator();
                        while (it2.hasNext()) {
                            Map.Entry me = (Map.Entry)it2.next();
                            String configId = (String)me.getKey();
                            ArrayList mappings = (ArrayList)me.getValue();
                            RemotePolicyConfiguration rpc = remoteSecurity.getPolicyConfiguration(configId);
                            RemoteAuthorization ra = rpc.getAuthorization();
                            RemoteSecurityRoles rsr = ra.getSecurityRoles();
                            Iterator iter = ((AbstractList)mappings).iterator();
                            while (iter.hasNext()) {
                                RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                                String abapRole = pair.getFirst();
                                String j2eeRole = pair.getSecond();
                                SecurityRole sr = rsr.getSecurityRole(j2eeRole);
                                try {
                                    sr.addGroup(abapRole);
                                    rsr.modifySecurityRole(sr);
                                    System.out.println("Performed role to group mapping (application, group, role): " + configId + ", " + abapRole + ", " + j2eeRole);
                                }
                                catch (Exception e) {
                                    System.out.println("Failed to add group info (application, group, role): " + configId + ", " + abapRole + ", " + j2eeRole);
                                }
                            }
                        }
                        System.out.println("All user groups processed.");
                    } else {
                        System.out.println("All roles/groups are filtered out. Nothing left to be mapped!");
                    }
                    break block20;
                }
                System.out.println("No security context found! Reference is null.");
            }
            catch (FileNotFoundException e) {
                System.out.println("Can not find file: " + e.getMessage());
                System.out.println("Current working directory: " + System.getProperty("user.dir"));
                rvalue = -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Failed to map security roles.");
                rvalue = -1;
            }
        }
        System.exit(rvalue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Args {
        private static final String P4_RMI_DEFAULT_USER = "Administrator";
        private static final String P4_RMI_DEFAULT_HOST = "localhost";
        private static final String P4_RMI_DEFAULT_P4PORT = "50004";
        private static final String P4_RMI_DEFAULT_FACTORY = "com.sap.engine.services.jndi.InitialContextFactoryImpl";
        private static final String P4_RMI_DEFAULT_PASSWORD = "sap";
        private static final String CMD_OPTION_P4USER = "-p4user";
        private static final String CMD_OPTION_P4PASSWORD = "-p4pass";
        private static final String CMD_OPTION_P4HOST = "-p4host";
        private static final String CMD_OPTION_P4PORT = "-p4port";
        private static final String CMD_OPTION_P4FACTORY = "-p4factoryclass";
        private static final String MAP_FILE_DEFAULT_FILE_NAME = "roles.xml";
        private static final String CMD_OPTION_ROLE_MAP_FILE = "-rolemapfile";
        private static final String CMD_OPTION_SHOW = "-show";
        private static final String CMD_OPTION_SHOW_EXPLICIT = "-showexplicit";
        private static final String CMD_OPTION_HELP = "-help";
        private Properties props = new Properties();

        public Args(String[] args) {
            if (args.length > 0) {
                int i = 0;
                while (i < args.length) {
                    if (args[i].equalsIgnoreCase(CMD_OPTION_P4USER)) {
                        ((Hashtable)this.props).put(CMD_OPTION_P4USER, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4PASSWORD)) {
                        ((Hashtable)this.props).put(CMD_OPTION_P4PASSWORD, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4HOST)) {
                        ((Hashtable)this.props).put(CMD_OPTION_P4HOST, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4PORT)) {
                        ((Hashtable)this.props).put(CMD_OPTION_P4PORT, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_P4FACTORY)) {
                        ((Hashtable)this.props).put(CMD_OPTION_P4FACTORY, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_ROLE_MAP_FILE)) {
                        ((Hashtable)this.props).put(CMD_OPTION_ROLE_MAP_FILE, args[++i]);
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW)) {
                        ((Hashtable)this.props).put(CMD_OPTION_SHOW, Boolean.TRUE.toString());
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_SHOW_EXPLICIT)) {
                        ((Hashtable)this.props).put(CMD_OPTION_SHOW_EXPLICIT, Boolean.TRUE.toString());
                    } else if (args[i].equalsIgnoreCase(CMD_OPTION_HELP)) {
                        ((Hashtable)this.props).put(CMD_OPTION_HELP, Boolean.TRUE.toString());
                    }
                    ++i;
                }
                if (this.props.getProperty(CMD_OPTION_SHOW) != null) {
                    this.printSettings();
                }
                if (this.props.getProperty(CMD_OPTION_SHOW_EXPLICIT) != null) {
                    this.printExplicitSettings();
                }
                if (this.props.getProperty(CMD_OPTION_HELP) != null) {
                    this.printCommandLineHelp();
                }
            }
        }

        private void printCommandLineHelp() {
            System.out.println("java -classpath ... [<options (1)>] [<options (2)>] <[options (3)]>");
            System.out.println();
            System.out.println("(1) P4 connect parameters (optional)");
            System.out.println("-p4user <user>   : User for P4 access (default: Administrator)");
            System.out.println("-p4pass <pw>     : Password of P4 user (default: sap)");
            System.out.println("-p4host <host>   : Hostname of J2EE server (default: localhost)");
            System.out.println("-p4port <port nr>: P4 Port number (default: 50004)");
            System.out.println();
            System.out.println("(2) Map file configuration parameter");
            System.out.println("-rolemapfile <map file>: Name of seurity role map XML file (default: rolemap.xml)");
            System.out.println();
            System.out.println("(3) 'Show' options used by program (options)");
            System.out.println("-show        : Shows all parameters used by the program inclusive defaults");
            System.out.println("-showexplicit: Show only explicitly set parameters, i.e. shows no default settings");
            System.out.println("-help        : Prints this help output");
        }

        public boolean helpOutputSet() {
            return this.props.getProperty(CMD_OPTION_HELP) != null;
        }

        public void printExplicitSettings() {
            Iterator i = ((Hashtable)this.props).keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = this.props.getProperty(name);
                System.out.println("name=" + name + " / value=" + value);
            }
        }

        public void printSettings() {
            System.out.println("name=-p4user / value=" + this.getP4UserValue());
            System.out.println("name=-p4pass / value=" + this.getP4PasswordValue());
            System.out.println("name=-p4host / value=" + this.getP4HostValue());
            System.out.println("name=-p4port / value=" + this.getP4PortValue());
            System.out.println("name=-p4factoryclass / value=" + this.getP4FactoryValue());
            System.out.println("name=-rolemapfile / value=" + this.getMapFile());
        }

        public String getP4UserValue() {
            return this.props.getProperty(CMD_OPTION_P4USER, P4_RMI_DEFAULT_USER);
        }

        public String getP4PasswordValue() {
            return this.props.getProperty(CMD_OPTION_P4PASSWORD, P4_RMI_DEFAULT_PASSWORD);
        }

        public String getP4HostValue() {
            return this.props.getProperty(CMD_OPTION_P4HOST, P4_RMI_DEFAULT_HOST);
        }

        public String getP4PortValue() {
            return this.props.getProperty(CMD_OPTION_P4PORT, P4_RMI_DEFAULT_P4PORT);
        }

        public String getP4UrlValue() {
            return this.getP4HostValue() + ":" + this.getP4PortValue();
        }

        public String getP4FactoryValue() {
            return this.props.getProperty(CMD_OPTION_P4FACTORY, P4_RMI_DEFAULT_FACTORY);
        }

        public String getMapFile() {
            return this.props.getProperty(CMD_OPTION_ROLE_MAP_FILE, MAP_FILE_DEFAULT_FILE_NAME);
        }
    }
}

