/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.exception;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.sldserv.exception.IResourceUtil;
import com.sap.sldserv.exception.SldResourceAccessor;
import java.util.StringTokenizer;

public class ResourceUtil
implements IResourceUtil {
    private static final char LEFT_PARAM_DELIM = '{';
    private static final char RIGHT_PARAM_DELIM = '}';
    private static ResourceAccessor resourceAccessor = SldResourceAccessor.getInstance();

    public static synchronized String formatString(String key, Object[] params) {
        try {
            return LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)key, (Object[])params);
        }
        catch (LocalizationException localizationException) {
            return null;
        }
    }

    public static synchronized String formatString(String key) {
        try {
            return LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)key, null);
        }
        catch (LocalizationException localizationException) {
            return null;
        }
    }

    public static synchronized String formatStringNoParameterLocalization(String key, Object[] params) {
        try {
            return ResourceUtil.replaceParams(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)key), params);
        }
        catch (LocalizationException localizationException) {
            return null;
        }
    }

    private static String replaceParams(String inStr, Object[] params) {
        StringBuffer rvalue = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inStr);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() > 2) {
                int i1 = t.indexOf(123);
                int i2 = t.indexOf(125);
                if (i1 != -1 && i2 != -1 && i1 < i2 - 1) {
                    String subStr = t.substring(i1 + 1, i2);
                    try {
                        int num = Integer.parseInt(subStr.trim());
                        if (num >= 0 && num <= params.length - 1) {
                            t = String.valueOf(params[num]);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            rvalue.append(t + " ");
        }
        return rvalue.length() == 0 ? inStr : rvalue.toString().trim();
    }
}

