/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data.listen;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.CollectTimeInterval;
import com.sap.sldserv.SendInfo;
import com.sap.sldserv.data.SldMessage;
import com.sap.sldserv.data.listen.SldListener;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.net.InetAddress;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SldServerListener
extends SldListener {
    static /* synthetic */ Class class$com$sap$sldserv$data$listen$SldServerListener;

    public SldServerListener(ApplicationServiceContext applServCtx) {
        super(applServCtx);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$listen$SldServerListener == null ? (class$com$sap$sldserv$data$listen$SldServerListener = SldServerListener.class$("com.sap.sldserv.data.listen.SldServerListener")) : class$com$sap$sldserv$data$listen$SldServerListener));
        this.applServCtx = applServCtx;
        this.clusterCtx = applServCtx.getClusterContext();
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] data, int offset, int length) {
        String method = "receiveWait";
        Object paramValueObj = null;
        InitialContext jndiCtx = null;
        CollectTimeInterval cti = null;
        SldMessage rrawmsg = new SldMessage();
        rrawmsg.setMsgId(0);
        MessageAnswer rmsg = new MessageAnswer();
        try {
            rmsg = new MessageAnswer(rrawmsg.toByteArray());
            SldMessage msg = SldMessage.fromByteArray(data);
            switch (msg.getMsgId()) {
                case -1: {
                    this.LOCATION.debugT("receiveWait", ResourceUtil.formatString("sld_2017"));
                    break;
                }
                case 100: {
                    String paramName = msg.getFirstCallParamName();
                    String paramValue = this.getSystemProperty(paramName);
                    rrawmsg.setMsgId(paramName == null ? 0 : 100);
                    rrawmsg.addParam(paramName, (Serializable)((Object)paramValue));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 101: {
                    String paramValue = String.valueOf(this.clusterCtx.getClusterMonitor().getCurrentParticipant().getClusterId());
                    rrawmsg.addParam(null, (Serializable)((Object)paramValue));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 104: {
                    String paramName = msg.getFirstCallParamName();
                    paramValueObj = msg.getFirstCallParamValue();
                    if (paramName.equalsIgnoreCase("LastSendInfo") && paramValueObj != null && paramValueObj instanceof SendInfo) {
                        SendInfo sendInfo = (SendInfo)paramValueObj;
                        SendInfo.setInfoLocalNode(sendInfo);
                        rrawmsg.setMsgId(1);
                        rmsg = new MessageAnswer(rrawmsg.toByteArray());
                        break;
                    }
                    rrawmsg.setMsgId(0);
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 107: {
                    try {
                        jndiCtx = new InitialContext();
                        cti = (CollectTimeInterval)jndiCtx.lookup("SLD_COLLECT_TIME_INTERVAL");
                        rrawmsg.addParam(null, cti);
                        rrawmsg.setMsgId(1);
                    }
                    catch (NamingException e) {
                        rrawmsg.setMsgId(3);
                    }
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 105: {
                    String paramName = msg.getFirstCallParamName();
                    paramValueObj = msg.getFirstCallParamValue();
                    if (paramName.equalsIgnoreCase("SetCollectTime") && paramValueObj != null && paramValueObj instanceof CollectTimeInterval) {
                        ((CollectTimeInterval)paramValueObj).setInfoJndi("SLD_COLLECT_TIME_INTERVAL");
                        rrawmsg.setMsgId(1);
                        rmsg = new MessageAnswer(rrawmsg.toByteArray());
                        break;
                    }
                    rrawmsg.setMsgId(0);
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 106: {
                    rrawmsg.setMsgId(106);
                    rrawmsg.addParam(null, (Serializable)((Object)InetAddress.getLocalHost().getHostName()));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                default: {
                    this.LOCATION.debugT("receiveWait", ResourceUtil.formatString("sld_2018", new Object[]{String.valueOf(msg.getMsgId())}));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.LOCATION.debugT("receiveWait", ResourceUtil.formatString("sld_2016"));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"receiveWait", (Throwable)e);
        }
        return rmsg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

