/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data.listen;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.data.SldMessage;
import com.sap.sldserv.data.listen.SldListener;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class SldDispatcherListener
extends SldListener {
    static /* synthetic */ Class class$com$sap$sldserv$data$listen$SldDispatcherListener;

    public SldDispatcherListener(CommunicationServiceContext commServCtx) {
        super(commServCtx);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$listen$SldDispatcherListener == null ? (class$com$sap$sldserv$data$listen$SldDispatcherListener = SldDispatcherListener.class$("com.sap.sldserv.data.listen.SldDispatcherListener")) : class$com$sap$sldserv$data$listen$SldDispatcherListener));
        this.commServCtx = commServCtx;
        this.clusterMonitor = commServCtx.getClusterContext().getClusterMonitor();
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] data, int offset, int length) {
        String method = "receiveWait";
        SldMessage rrawmsg = new SldMessage();
        rrawmsg.setMsgId(0);
        MessageAnswer rmsg = new MessageAnswer();
        try {
            rmsg = new MessageAnswer(rrawmsg.toByteArray());
            SldMessage msg = SldMessage.fromByteArray(data);
            switch (msg.getMsgId()) {
                case -1: {
                    this.LOCATION.debugT("receiveWait", ResourceUtil.formatString("sld_2017"));
                    break;
                }
                case 100: {
                    String paramName = msg.getFirstCallParamName();
                    String paramValue = this.getSystemProperty(paramName);
                    rrawmsg.setMsgId(paramName == null ? 0 : 100);
                    rrawmsg.addParam(paramName, (Serializable)((Object)paramValue));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 103: {
                    String paramName = msg.getFirstCallParamName();
                    String paramValue = this.getPort(paramName);
                    rrawmsg.setMsgId(paramValue == null ? 0 : 103);
                    if (paramValue != null) {
                        rrawmsg.setParam(paramName, (Serializable)((Object)paramValue));
                    }
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 101: {
                    String paramValue = String.valueOf(this.clusterMonitor.getCurrentParticipant().getClusterId());
                    rrawmsg.addParam(null, (Serializable)((Object)paramValue));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 2: {
                    String paramValue = String.valueOf(this.clusterMonitor.getCurrentParticipant().getClusterId());
                    rrawmsg.setMsgId(2);
                    rrawmsg.addParam("ID", (Serializable)((Object)paramValue));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                case 106: {
                    rrawmsg.setMsgId(106);
                    rrawmsg.addParam(null, (Serializable)((Object)InetAddress.getLocalHost().getHostName()));
                    rmsg = new MessageAnswer(rrawmsg.toByteArray());
                    break;
                }
                default: {
                    this.LOCATION.debugT("receiveWait", ResourceUtil.formatString("sld_2018", new Object[]{String.valueOf(msg.getMsgId())}));
                    break;
                }
            }
        }
        catch (Exception e) {
            SldListener.CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString("sld_2016"));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"receiveWait", (Throwable)e);
        }
        return rmsg;
    }

    private String getPort(String portName) {
        String port = null;
        if ("http".equalsIgnoreCase(portName)) {
            port = this.extractPort(this.commServCtx.getContainerContext().getSystemMonitor().getService("http").getProperty("Ports"), "http");
        } else if ("https".equalsIgnoreCase(portName)) {
            port = this.extractPort(this.commServCtx.getContainerContext().getSystemMonitor().getService("http").getProperty("Ports"), "ssl");
        } else if ("p4".equalsIgnoreCase(portName)) {
            port = this.commServCtx.getContainerContext().getSystemMonitor().getService("p4").getProperty("port");
        } else if ("telnet".equalsIgnoreCase(portName)) {
            port = this.commServCtx.getContainerContext().getSystemMonitor().getService("telnet").getProperty("port");
        }
        return port;
    }

    private String extractPort(String inStr, String lookupPortType) {
        String LEFT_SECTION_DELIM = "(";
        String RIGHT_SECTION_DELIM = ")";
        String PORT_TYPE_SEPARATOR = ",";
        String NAME_VALUE_SEPARATER = ":";
        String PORT_NAME = "Port";
        String TYPE_NAME = "Type";
        String portType = null;
        String portValue = null;
        String rvalue = null;
        StringTokenizer st = new StringTokenizer(inStr, ")");
        block0: while (st.hasMoreTokens() && rvalue == null) {
            String t = st.nextToken();
            int i1 = t.indexOf("(");
            if (i1 == -1) continue;
            portValue = null;
            portType = null;
            String subStr = t.substring(i1 + 1);
            StringTokenizer st2 = new StringTokenizer(subStr, ",");
            while (st2.hasMoreTokens()) {
                String t2 = st2.nextToken();
                StringTokenizer st3 = new StringTokenizer(t2, ":");
                while (st3.hasMoreTokens()) {
                    String t3 = st3.nextToken();
                    if (t3.trim().equalsIgnoreCase("Port") && st3.hasMoreTokens()) {
                        portValue = t3 = st3.nextToken();
                        continue;
                    }
                    if (!t3.trim().equalsIgnoreCase("Type") || !st3.hasMoreElements()) continue;
                    portType = t3 = st3.nextToken();
                }
                if (portType == null || !portType.equalsIgnoreCase(lookupPortType) || portValue == null) continue;
                rvalue = portValue;
                continue block0;
            }
        }
        return rvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

