/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SldMessage
implements Serializable {
    public static final long serialVersionUID = -9042735977762179816L;
    public static final int INITIAL_MESSAGE = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int SUCCESS_MESSAGE = 1;
    public static final int PING_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int GET_SINGLE_SYSTEM_PARAMETER = 100;
    public static final int GET_NODE_ID = 101;
    public static final int GET_SINGLE_PARAMETER = 102;
    public static final int GET_PORT_INFORMATION = 103;
    public static final int SET_LAST_SEND_INFO = 104;
    public static final int SET_COLLECT_TIME = 105;
    public static final int GET_LOCAL_HOSTNAME = 106;
    public static final int GET_LAST_COLLECT_TIME_INTERVAL = 107;
    private int msgId = -1;
    private ArrayList paramArray = null;
    private ArrayList callParamArray = null;

    public void init() {
        this.msgId = -1;
        this.paramArray = null;
        this.callParamArray = null;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public int getMsgId() {
        return this.msgId;
    }

    public void setCallParam(String callParamName, Serializable callParamValue) {
        if (this.callParamArray == null) {
            this.callParamArray = new ArrayList();
        } else {
            this.callParamArray.clear();
        }
        this.callParamArray.add(new ParameterElement(callParamName, callParamValue));
    }

    public void addCallParam(String callParamName, Serializable callParamValue) {
        if (this.callParamArray == null) {
            this.callParamArray = new ArrayList();
        }
        this.callParamArray.add(new ParameterElement(callParamName, callParamValue));
    }

    public Object getCallParamValue(String callParamName) {
        Serializable robj = null;
        if (!this.callParamArray.isEmpty()) {
            Iterator iter = ((AbstractList)this.callParamArray).iterator();
            while (iter.hasNext()) {
                ParameterElement element = (ParameterElement)iter.next();
                if (!element.paramName.equalsIgnoreCase(callParamName)) continue;
                robj = element.paramValue;
                break;
            }
        }
        return robj;
    }

    public void setParam(String paramName, Serializable paramValue) {
        if (this.paramArray == null) {
            this.paramArray = new ArrayList();
        } else {
            this.paramArray.clear();
        }
        this.paramArray.add(new ParameterElement(paramName, paramValue));
    }

    public void addParam(String paramName, Serializable paramValue) {
        if (this.paramArray == null) {
            this.paramArray = new ArrayList();
        }
        this.paramArray.add(new ParameterElement(paramName, paramValue));
    }

    public String getFirstParamName() {
        String rname = null;
        if (this.paramArray != null) {
            ParameterElement p = (ParameterElement)this.paramArray.get(0);
            rname = p.paramName;
        }
        return rname;
    }

    public Object getFirstParamValue() {
        Serializable rvalue = null;
        if (this.paramArray != null) {
            ParameterElement p = (ParameterElement)this.paramArray.get(0);
            rvalue = p.paramValue;
        }
        return rvalue;
    }

    public String getFirstCallParamName() {
        return this.callParamArray == null || this.callParamArray.isEmpty() ? null : ((ParameterElement)this.callParamArray.get((int)0)).paramName;
    }

    public Object getFirstCallParamValue() {
        return this.callParamArray == null || this.callParamArray.isEmpty() ? null : ((ParameterElement)this.callParamArray.get((int)0)).paramValue;
    }

    public Iterator valueParamIterator() {
        if (this.paramArray == null) {
            this.paramArray = new ArrayList();
        }
        return ((AbstractList)this.paramArray).iterator();
    }

    public Iterator callParamIterator() {
        if (this.callParamArray == null) {
            this.callParamArray = new ArrayList();
        }
        return ((AbstractList)this.callParamArray).iterator();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bufOutStream = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(bufOutStream);
        outStream.writeObject(this);
        outStream.close();
        return bufOutStream.toByteArray();
    }

    public static SldMessage fromByteArray(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bufInStream = new ByteArrayInputStream(data);
        ObjectInputStream inStream = new ObjectInputStream(bufInStream);
        return (SldMessage)inStream.readObject();
    }

    static class ParameterElement
    implements Serializable {
        public static final long serialVersionUID = -7540676558979835985L;
        String paramName = null;
        Serializable paramValue = null;

        ParameterElement(String paramName, Serializable paramValue) {
            this.paramName = paramName;
            this.paramValue = paramValue;
        }
    }
}

