/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

public final class MD5 {
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private static final byte P = -128;
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final MD5Buffer md5buffer = new MD5Buffer();
    private final int[] x = new int[16];

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int offset, int count) {
        int startIndex = offset;
        this.md5buffer.len += (long)count;
        int dataLen = this.md5buffer.bufLen + count;
        if (dataLen < 64 || dataLen < count) {
            System.arraycopy(bytes, offset, this.md5buffer.buffer, this.md5buffer.bufLen, count);
            this.md5buffer.bufLen = dataLen;
            return;
        }
        if (this.md5buffer.bufLen > 0) {
            int fill = 64 - this.md5buffer.bufLen;
            startIndex += fill;
            System.arraycopy(bytes, offset, this.md5buffer.buffer, this.md5buffer.bufLen, fill);
            this.md5buffer.bufLen = 0;
            this.process64ByteBlock(this.md5buffer.buffer, 0);
        }
        int remainder = count - startIndex + offset;
        while (remainder >= 64) {
            this.process64ByteBlock(bytes, startIndex);
            startIndex += 64;
            remainder -= 64;
        }
        if (remainder > 0) {
            this.md5buffer.bufLen = remainder;
            System.arraycopy(bytes, startIndex, this.md5buffer.buffer, 0, remainder);
        }
    }

    public byte[] finish() {
        if (this.md5buffer.bufLen >= 56) {
            System.arraycopy(padding, 0, this.md5buffer.buffer, this.md5buffer.bufLen, 64 - this.md5buffer.bufLen);
            this.process64ByteBlock(this.md5buffer.buffer, 0);
            System.arraycopy(padding, 1, this.md5buffer.buffer, 0, 56);
        } else {
            System.arraycopy(padding, 0, this.md5buffer.buffer, this.md5buffer.bufLen, 56 - this.md5buffer.bufLen);
        }
        long bitLen = this.md5buffer.len << 3;
        int i = 56;
        while (i < 64) {
            this.md5buffer.buffer[i] = (byte)(0xFFL & bitLen);
            bitLen >>>= 8;
            ++i;
        }
        this.process64ByteBlock(this.md5buffer.buffer, 0);
        byte[] result = new byte[16];
        int b = 0;
        while (b < 4) {
            int x = 0;
            switch (b) {
                case 0: {
                    x = this.md5buffer.a;
                    break;
                }
                case 1: {
                    x = this.md5buffer.b;
                    break;
                }
                case 2: {
                    x = this.md5buffer.c;
                    break;
                }
                case 3: {
                    x = this.md5buffer.d;
                    break;
                }
                default: {
                    x = 0;
                }
            }
            int i2 = 0;
            while (i2 < 4) {
                result[4 * b + i2] = (byte)(0xFF & x);
                x >>>= 8;
                ++i2;
            }
            ++b;
        }
        this.md5buffer.init();
        return result;
    }

    private void process64ByteBlock(byte[] bytes, int startIndex) {
        int idx_bytes = startIndex - 1;
        int idx_x = 0;
        while (idx_x < 16) {
            this.x[idx_x] = bytes[++idx_bytes] & 0xFF | (bytes[++idx_bytes] & 0xFF) << 8 | (bytes[++idx_bytes] & 0xFF) << 16 | (bytes[++idx_bytes] & 0xFF) << 24;
            ++idx_x;
        }
        int a = this.md5buffer.a;
        int b = this.md5buffer.b;
        int c = this.md5buffer.c;
        int d = this.md5buffer.d;
        a += (b & c | ~b & d) + this.x[0] + -680876936;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + this.x[1] + -389564586;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + this.x[2] + 606105819;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + this.x[3] + -1044525330;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + this.x[4] + -176418897;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + this.x[5] + 1200080426;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + this.x[6] + -1473231341;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + this.x[7] + -45705983;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + this.x[8] + 1770035416;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + this.x[9] + -1958414417;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + this.x[10] + -42063;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + this.x[11] + -1990404162;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + this.x[12] + 1804603682;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + this.x[13] + -40341101;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + this.x[14] + -1502002290;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + this.x[15] + 1236535329;
        b = c + (b << 22 | b >>> 10);
        a += (b & d | c & ~d) + this.x[1] + -165796510;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + this.x[6] + -1069501632;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + this.x[11] + 643717713;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + this.x[0] + -373897302;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + this.x[5] + -701558691;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + this.x[10] + 38016083;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + this.x[15] + -660478335;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + this.x[4] + -405537848;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + this.x[9] + 568446438;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + this.x[14] + -1019803690;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + this.x[3] + -187363961;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + this.x[8] + 1163531501;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + this.x[13] + -1444681467;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + this.x[2] + -51403784;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + this.x[7] + 1735328473;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + this.x[12] + -1926607734;
        b = c + (b << 20 | b >>> 12);
        a += (b ^ c ^ d) + this.x[5] + -378558;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + this.x[8] + -2022574463;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + this.x[11] + 1839030562;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + this.x[14] + -35309556;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + this.x[1] + -1530992060;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + this.x[4] + 1272893353;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + this.x[7] + -155497632;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + this.x[10] + -1094730640;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + this.x[13] + 681279174;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + this.x[0] + -358537222;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + this.x[3] + -722521979;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + this.x[6] + 76029189;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + this.x[9] + -640364487;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + this.x[12] + -421815835;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + this.x[15] + 530742520;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + this.x[2] + -995338651;
        b = c + (b << 23 | b >>> 9);
        a += (c ^ (b | ~d)) + this.x[0] + -198630844;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + this.x[7] + 1126891415;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + this.x[14] + -1416354905;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + this.x[5] + -57434055;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + this.x[12] + 1700485571;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + this.x[3] + -1894986606;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + this.x[10] + -1051523;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + this.x[1] + -2054922799;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + this.x[8] + 1873313359;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + this.x[15] + -30611744;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + this.x[6] + -1560198380;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + this.x[13] + 1309151649;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + this.x[4] + -145523070;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + this.x[11] + -1120210379;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + this.x[2] + 718787259;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + this.x[9] + -343485551;
        b = c + (b << 21 | b >>> 11);
        this.md5buffer.a += a;
        this.md5buffer.b += b;
        this.md5buffer.c += c;
        this.md5buffer.d += d;
    }

    private static class MD5Buffer {
        int a;
        int b;
        int c;
        int d;
        long len;
        final byte[] buffer = new byte[64];
        int bufLen;

        MD5Buffer() {
            this.init();
        }

        void init() {
            this.a = 1732584193;
            this.b = -271733879;
            this.c = -1732584194;
            this.d = 271733878;
            this.len = 0L;
            this.bufLen = 0;
        }
    }
}

