/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.container.monitor.ComponentMonitor;
import com.sap.engine.frame.container.monitor.InterfaceMonitor;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;
import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sldserv.J2EEAssocInst;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.J2EEObjInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.data.GetData;
import com.sap.sldserv.data.GetInstalledSoftwareComponent;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.Manifest;

public class GetSAPJ2EEDeployedObject
extends GetData {
    private static final String DEPLOY_CONTEXT = "deploy";
    private static final String SAP_MANIFEST_FILE_NAME = "SAP_MANIFEST.MF";
    private static final String DEVELOPMENT_COMPONENT_ID = "DC";
    static /* synthetic */ Class class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject;

    public GetSAPJ2EEDeployedObject(ApplicationServiceContext applServCtx, Params.Ids idParams) {
        super(applServCtx, idParams);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject));
    }

    public J2EEData getData() throws SldServiceException {
        String method = "getData";
        this.LOCATION.debugT("getData", ResourceUtil.formatString("sld_9028", new Object[]{"getData", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEData result = new J2EEData(this.idParams.getTypeId(), this.idParams.getVersionId());
        result.addClass(this.getJ2EEApplications());
        result.addClass(this.getJ2EEInterfaces());
        result.addClass(this.getJ2EELibraries());
        result.addClass(this.getJ2EEServices());
        try {
            J2EEData collectedResult = new J2EEData(this.idParams.getTypeId(), this.idParams.getVersionId());
            this.resetInstanceNumber("SAP_J2EEDeployedObjectSoftwareComponent");
            Iterator it = result.getClassIterator();
            while (it.hasNext()) {
                J2EEClass currClass = (J2EEClass)it.next();
                J2EEClass outClass = this.getDeployedObjectSoftwareComponentAssocs(currClass);
                collectedResult.mergeClass(outClass);
            }
            result.merge(collectedResult);
        }
        catch (SldServiceException e) {
            LoggingHelper.traceThrowable((int)500, (Location)this.LOCATION, (String)"getData", (Throwable)((Object)e));
        }
        return result;
    }

    public String getServedClassName() {
        return "SAP_J2EEDeployedObject";
    }

    private J2EEClass getJ2EEServices() {
        String method = "getJ2EEServices";
        this.LOCATION.debugT("getJ2EEServices", ResourceUtil.formatString("sld_9028", new Object[]{"getJ2EEServices", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEClass clazz = new J2EEClass("SAP_J2EEService");
        this.resetInstanceNumber(clazz.getName());
        J2EEObjInst inst = null;
        ServiceMonitor[] servMon = GetData.systemMonitor.getServices();
        int i = 0;
        while (i < servMon.length) {
            block6: {
                try {
                    inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                }
                catch (SldServiceException e) {
                    this.LOCATION.debugT("getJ2EEServices", ResourceUtil.formatString("sld_2008", new Object[]{clazz.getName()}));
                    LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getJ2EEServices", (Throwable)((Object)e));
                    break block6;
                }
                Manifest mf = this.getSAPManifestForComponent((ComponentMonitor)servMon[i]);
                inst.addPropValue("Name", servMon[i].getComponentName());
                inst.addPropValue("DisplayName", servMon[i].getDisplayName());
                inst.addPropValue("CreationClassName", "SAP_J2EEService");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineCluster");
                inst.addPropValue("SystemName", this.getPropertyValue("SAPSYSTEMNAME"));
                inst.addPropValue("Vendor", servMon[i].getProviderName());
                String devCompName = this.getManifestEntry("keyname", "Implementation-Title", mf);
                if (devCompName != null) {
                    inst.addPropValue("DevCompName", devCompName);
                } else {
                    this.LOCATION.debugT("getJ2EEServices", ResourceUtil.formatString("sld_3022", new Object[]{"keyname", servMon[i].getComponentName()}));
                }
                inst.addPropValue("Caption", servMon[i].getDisplayName());
                String versionStr = this.getManifestEntry("keycounter", "Implementation-Version", mf);
                if (versionStr != null) {
                    inst.addPropValue("Version", versionStr);
                }
                inst.addPropValue("CoreService", String.valueOf(servMon[i].isCore()));
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            ++i;
        }
        return clazz;
    }

    private J2EEClass getJ2EELibraries() {
        String method = "getJ2EELibraries";
        this.LOCATION.debugT("getJ2EELibraries", ResourceUtil.formatString("sld_9028", new Object[]{"getJ2EELibraries", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEClass clazz = new J2EEClass("SAP_J2EELibrary");
        this.resetInstanceNumber(clazz.getName());
        J2EEObjInst inst = null;
        LibraryMonitor[] libMon = GetData.systemMonitor.getLibraries();
        int i = 0;
        while (i < libMon.length) {
            block6: {
                try {
                    inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                }
                catch (SldServiceException e) {
                    this.LOCATION.debugT("getJ2EELibraries", ResourceUtil.formatString("sld_2008", new Object[]{clazz.getName()}));
                    LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getJ2EELibraries", (Throwable)((Object)e));
                    break block6;
                }
                Manifest mf = this.getSAPManifestForComponent((ComponentMonitor)libMon[i]);
                inst.addPropValue("Name", libMon[i].getComponentName());
                inst.addPropValue("DisplayName", libMon[i].getDisplayName());
                inst.addPropValue("CreationClassName", "SAP_J2EELibrary");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineCluster");
                inst.addPropValue("SystemName", this.getPropertyValue("SAPSYSTEMNAME"));
                inst.addPropValue("Vendor", libMon[i].getProviderName());
                String devCompName = this.getManifestEntry("keyname", "Implementation-Title", mf);
                if (devCompName != null) {
                    inst.addPropValue("DevCompName", devCompName);
                } else {
                    this.LOCATION.debugT("getJ2EELibraries", ResourceUtil.formatString("sld_3022", new Object[]{"keyname", libMon[i].getComponentName()}));
                }
                inst.addPropValue("Caption", libMon[i].getDisplayName());
                String versionStr = this.getManifestEntry("keycounter", "Implementation-Version", mf);
                if (versionStr != null) {
                    inst.addPropValue("Version", versionStr);
                }
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            ++i;
        }
        return clazz;
    }

    private J2EEClass getJ2EEInterfaces() {
        String method = "getJ2EEInterfaces";
        this.LOCATION.debugT("getJ2EEInterfaces", ResourceUtil.formatString("sld_9028", new Object[]{"getJ2EEInterfaces", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEClass clazz = new J2EEClass("SAP_J2EEInterface");
        this.resetInstanceNumber(clazz.getName());
        J2EEObjInst inst = null;
        InterfaceMonitor[] ifMon = GetData.systemMonitor.getInterfaces();
        int i = 0;
        while (i < ifMon.length) {
            block6: {
                try {
                    inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                }
                catch (SldServiceException e) {
                    this.LOCATION.debugT("getJ2EEInterfaces", ResourceUtil.formatString("sld_2008", new Object[]{clazz.getName()}));
                    LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getJ2EEInterfaces", (Throwable)((Object)e));
                    break block6;
                }
                Manifest mf = this.getSAPManifestForComponent((ComponentMonitor)ifMon[i]);
                inst.addPropValue("Name", ifMon[i].getComponentName());
                inst.addPropValue("DisplayName", ifMon[i].getDisplayName());
                inst.addPropValue("CreationClassName", "SAP_J2EEInterface");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineCluster");
                inst.addPropValue("SystemName", this.getPropertyValue("SAPSYSTEMNAME"));
                inst.addPropValue("Vendor", ifMon[i].getProviderName());
                String devCompName = this.getManifestEntry("keyname", "Implementation-Title", mf);
                if (devCompName != null) {
                    inst.addPropValue("DevCompName", devCompName);
                } else {
                    this.LOCATION.debugT("getJ2EEInterfaces", ResourceUtil.formatString("sld_3022", new Object[]{"keyname", ifMon[i].getComponentName()}));
                }
                inst.addPropValue("Caption", ifMon[i].getDisplayName());
                String versionStr = this.getManifestEntry("keycounter", "Implementation-Version", mf);
                if (versionStr != null) {
                    inst.addPropValue("Version", versionStr);
                }
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            ++i;
        }
        return clazz;
    }

    private J2EEClass getJ2EEApplications() {
        String method = "getJ2EEApplications";
        this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_9028", new Object[]{"getJ2EEApplications", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEClass clazz = new J2EEClass("SAP_J2EEApplication");
        this.resetInstanceNumber(clazz.getName());
        J2EEObjInst inst = null;
        try {
            DeployService deployService = (DeployService)GetData.applServCtx.getContainerContext().getObjectRegistry().getServiceInterface(DEPLOY_CONTEXT);
            if (deployService == null) {
                this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_3030"));
                return clazz;
            }
            String[] application = deployService.listApplications(null, null);
            int i = 0;
            while (i < application.length) {
                block12: {
                    try {
                        inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                    }
                    catch (SldServiceException e) {
                        this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_2008", new Object[]{clazz.getName()}));
                        LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getJ2EEApplications", (Throwable)((Object)e));
                        break block12;
                    }
                    Manifest mf = this.getSAPManifestForApplication(application[i]);
                    inst.addPropValue("Name", application[i]);
                    String origName = deployService.getApplicationInformation(application[i]).getOriginalAppName();
                    String devCompName = this.getManifestEntry("keyname", "Implementation-Title", mf);
                    String displayName = origName != null && origName.length() != 0 ? origName : (devCompName != null ? devCompName : application[i]);
                    inst.addPropValue("DisplayName", displayName);
                    inst.addPropValue("CreationClassName", "SAP_J2EEApplication");
                    inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineCluster");
                    inst.addPropValue("SystemName", this.getPropertyValue("SAPSYSTEMNAME"));
                    String versionStr = this.getManifestEntry("keycounter", "Implementation-Version", mf);
                    if (versionStr != null) {
                        inst.addPropValue("Version", versionStr);
                    } else {
                        this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_3022", new Object[]{"keycounter", application[i]}));
                    }
                    String vendorStr = this.getManifestEntry("keyvendor", "Implementation-Vendor-Id", mf);
                    if (vendorStr != null) {
                        inst.addPropValue("Vendor", vendorStr);
                    } else {
                        this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_3022", new Object[]{"keyvendor", application[i]}));
                    }
                    if (devCompName != null) {
                        inst.addPropValue("DevCompName", devCompName);
                    } else {
                        this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_3022", new Object[]{"keyname", application[i]}));
                    }
                    clazz.addInstance(inst);
                    this.raiseCurrInstNum(clazz.getName());
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            this.LOCATION.debugT("getJ2EEApplications", ResourceUtil.formatString("sld_3019", new Object[]{(class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject).getName()}));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getJ2EEApplications", (Throwable)e);
        }
        return clazz;
    }

    private Manifest getSAPManifestForApplication(String applName) {
        String method = "getSAPManifestForApplication";
        Manifest mf = null;
        DeployService deployService = (DeployService)GetData.applServCtx.getContainerContext().getObjectRegistry().getServiceInterface(DEPLOY_CONTEXT);
        if (deployService == null) {
            this.LOCATION.debugT("getSAPManifestForApplication", ResourceUtil.formatString("sld_3030"));
            return mf;
        }
        try {
            Configuration cfg;
            InputStream is;
            String manifestCfgPath;
            ConfigurationHandler handler = GetData.coreCtx.getConfigurationHandlerFactory().getConfigurationHandler();
            ApplicationInformation applInfo = deployService.getApplicationInformation(applName);
            if (applInfo != null && (manifestCfgPath = applInfo.getSapManifestCfgPath()) != null && (is = (cfg = handler.openConfiguration(manifestCfgPath, 0)).getFile(SAP_MANIFEST_FILE_NAME)) != null) {
                mf = new Manifest(is);
                is.close();
            }
        }
        catch (ConfigurationException e) {
            this.LOCATION.debugT("getSAPManifestForApplication", ResourceUtil.formatString("sld_3021"));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getSAPManifestForApplication", (Throwable)e);
        }
        catch (Exception e) {
            this.LOCATION.debugT("getSAPManifestForApplication", ResourceUtil.formatString("sld_3018", new Object[]{"Application"}));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getSAPManifestForApplication", (Throwable)e);
            mf = null;
        }
        return mf;
    }

    private Manifest getSAPManifestForComponent(ComponentMonitor compMon) {
        String method = "getSAPManifestForComponent";
        Manifest mf = null;
        try {
            InputStream is = compMon.getSAPManifest();
            if (is != null) {
                mf = new Manifest(is);
                is.close();
            }
        }
        catch (Exception e) {
            this.LOCATION.debugT("getSAPManifestForComponent", ResourceUtil.formatString("sld_3018", new Object[]{compMon.getComponentName()}));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getSAPManifestForComponent", (Throwable)e);
            mf = null;
        }
        return mf;
    }

    private J2EEClass getDeployedObjectSoftwareComponentAssocs(J2EEClass inClazz) {
        String method = "getDeployedObjectSoftwareComponentAssocs";
        this.LOCATION.debugT("getDeployedObjectSoftwareComponentAssocs", ResourceUtil.formatString("sld_9028", new Object[]{"getDeployedObjectSoftwareComponentAssocs", class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject == null ? (class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject = GetSAPJ2EEDeployedObject.class$("com.sap.sldserv.data.GetSAPJ2EEDeployedObject")) : class$com$sap$sldserv$data$GetSAPJ2EEDeployedObject}));
        J2EEClass clazz = new J2EEClass("SAP_J2EEDeployedObjectSoftwareComponent");
        try {
            J2EEClass softCompsClass = new GetInstalledSoftwareComponent(GetData.applServCtx, this.idParams).getData().getClass("SAP_InstalledSoftwareComponent");
            if (softCompsClass != null) {
                HashMap devComps = this.hashComponentElements(this.getComponentsIfForType(DEVELOPMENT_COMPONENT_ID));
                Iterator it = inClazz.instanceIterator();
                block2: while (it.hasNext()) {
                    String assocSC;
                    J2EEInst inst = (J2EEInst)it.next();
                    String devComp = inst.getProperty("DevCompName");
                    ComponentElementIF foundDC = (ComponentElementIF)devComps.get(devComp);
                    if (foundDC == null || (assocSC = foundDC.getSCName()) == null || assocSC.length() == 0) continue;
                    Iterator cit = softCompsClass.instanceIterator();
                    while (cit.hasNext()) {
                        J2EEInst scInst = (J2EEInst)cit.next();
                        String scName = scInst.getProperty("Name");
                        if (scName == null || !scName.equalsIgnoreCase(assocSC)) continue;
                        J2EEAssocInst assocInst = J2EEClass.getNewAssocInst(clazz.getName(), this.getCurrInstNum(clazz.getName()));
                        assocInst.addRefValue(scInst.getClassName(), "Antecedent", scInst.getInstName());
                        assocInst.addRefValue(inst.getClassName(), "Dependent", inst.getInstName());
                        clazz.addInstance(assocInst);
                        this.raiseCurrInstNum(clazz.getName());
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getDeployedObjectSoftwareComponentAssocs", (Throwable)e);
        }
        return clazz;
    }

    private String getManifestEntry(String primary, String secondary, Manifest manifest) {
        String rvalue = null;
        if (manifest != null) {
            if (primary != null) {
                rvalue = manifest.getMainAttributes().getValue(primary);
                if (rvalue == null) {
                    rvalue = manifest.getMainAttributes().getValue(secondary);
                }
            } else if (secondary != null) {
                rvalue = manifest.getMainAttributes().getValue(secondary);
            }
        }
        return rvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

