/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEObjInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.data.GetData;
import com.sap.sldserv.data.GetSAPBCCentralServiceInstance;
import com.sap.sldserv.data.SldMessage;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class GetSAPIPServicePort
extends GetData {
    private static final String CLUSTER_MANAGER = "ClusterManager";
    private static final String LOCKING_MANAGER = "LockingManager";
    private static final String HTTP_PORT = "http";
    private static final String HTTPS_PORT = "https";
    private static final String TELNET_PORT = "telnet";
    private static final String P4_PORT = "p4";
    private static final String MS_GET_PARAMS = "___MS_PROP_GET_PARAMS";
    static /* synthetic */ Class class$com$sap$sldserv$data$GetSAPIPServicePort;
    static /* synthetic */ Class class$com$sap$sldserv$data$GetJ2EEEngineCluster;

    public GetSAPIPServicePort(ApplicationServiceContext applServCtx, Params.Ids idParams) {
        super(applServCtx, idParams);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetSAPIPServicePort == null ? (class$com$sap$sldserv$data$GetSAPIPServicePort = GetSAPIPServicePort.class$("com.sap.sldserv.data.GetSAPIPServicePort")) : class$com$sap$sldserv$data$GetSAPIPServicePort));
    }

    public J2EEData getData() throws SldServiceException {
        String method = "getData";
        this.LOCATION.debugT("getData", ResourceUtil.formatStringNoParameterLocalization("sld_9028", new Object[]{"getData", class$com$sap$sldserv$data$GetJ2EEEngineCluster == null ? (class$com$sap$sldserv$data$GetJ2EEEngineCluster = GetSAPIPServicePort.class$("com.sap.sldserv.data.GetJ2EEEngineCluster")) : class$com$sap$sldserv$data$GetJ2EEEngineCluster}));
        J2EEData result = new J2EEData(this.idParams.getTypeId(), this.idParams.getVersionId());
        J2EEData currResult = this.getMessageServerPorts(this.idParams);
        result.merge(currResult);
        currResult = this.getEnqueueServerPorts(this.idParams);
        result.merge(currResult);
        currResult = this.getJ2EEServerPorts(this.idParams);
        result.merge(currResult);
        this.resetInstanceNumber("SAP_IPServicePort");
        return result;
    }

    public String getServedClassName() {
        return "SAP_IPServicePort";
    }

    private J2EEData getJ2EEServerPorts(Params.Ids idParams) throws SldServiceException {
        String method = "getJ2EEServerPorts";
        J2EEData currResult = new J2EEData(idParams.getTypeId(), idParams.getVersionId());
        J2EEClass clazz = new J2EEClass("SAP_IPServicePort");
        this.resetInstanceNumber(clazz.getName());
        J2EEObjInst inst = null;
        String sid = this.getPropertyValue("SAPSYSTEMNAME");
        if (sid == null) {
            this.LOCATION.debugT("getJ2EEServerPorts", ResourceUtil.formatString("sld_3023"));
            throw new SldServiceException(ResourceUtil.formatString("sld_3023"));
        }
        ClusterElement[] ce = this.getAllDispatcherClusterElements();
        String port = null;
        int i = 0;
        while (i < ce.length) {
            int nodeId = ce[i].getClusterId();
            port = this.getPort(nodeId, HTTP_PORT);
            if (port != null) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "httpPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineDispatcherNode");
                inst.addPropValue("SystemName", this.getSystemName(ce[i]));
                inst.addPropValue("PortNumber", port);
                inst.addPropValue("Protocol", HTTP_PORT);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
                currResult.addClass(clazz);
            } else {
                this.LOCATION.debugT("getJ2EEServerPorts", ResourceUtil.formatStringNoParameterLocalization("sld_3031", new Object[]{HTTP_PORT}));
            }
            port = this.getPort(nodeId, HTTPS_PORT);
            if (port != null) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "httpsPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineDispatcherNode");
                inst.addPropValue("SystemName", this.getSystemName(ce[i]));
                inst.addPropValue("PortNumber", port);
                inst.addPropValue("Protocol", HTTP_PORT);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
                currResult.addClass(clazz);
            } else {
                this.LOCATION.debugT("getJ2EEServerPorts", ResourceUtil.formatStringNoParameterLocalization("sld_3031", new Object[]{HTTPS_PORT}));
            }
            port = this.getPort(nodeId, TELNET_PORT);
            if (port != null) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "telnetPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineDispatcherNode");
                inst.addPropValue("SystemName", this.getSystemName(ce[i]));
                inst.addPropValue("PortNumber", port);
                inst.addPropValue("Protocol", TELNET_PORT);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
                currResult.addClass(clazz);
            } else {
                this.LOCATION.debugT("getJ2EEServerPorts", ResourceUtil.formatStringNoParameterLocalization("sld_3031", new Object[]{TELNET_PORT}));
            }
            port = this.getPort(nodeId, P4_PORT);
            if (port != null) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "p4Port");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_J2EEEngineDispatcherNode");
                inst.addPropValue("SystemName", this.getSystemName(ce[i]));
                inst.addPropValue("PortNumber", port);
                inst.addPropValue("Protocol", "other");
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
                currResult.addClass(clazz);
            } else {
                this.LOCATION.debugT("getJ2EEServerPorts", ResourceUtil.formatStringNoParameterLocalization("sld_3031", new Object[]{P4_PORT}));
            }
            ++i;
        }
        if (clazz.getInstanceCount() > 0) {
            currResult.addClass(clazz);
        }
        return currResult;
    }

    private String getPort(int nodeId, String portType) {
        String method = "getPort";
        SldMessage smsg = new SldMessage();
        smsg.setMsgId(103);
        smsg.setCallParam(portType, null);
        try {
            byte[] ba = smsg.toByteArray();
            GetData.sendReceiveBytes += ba.length;
            MessageAnswer answ = GetData.msgCtx.sendAndWaitForAnswer(nodeId, smsg.getMsgId(), ba, 0, ba.length, 0L);
            SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
            GetData.sendReceiveBytes += rmsg.toByteArray().length;
            if (rmsg.getMsgId() == 103) {
                String rpara = rmsg.getFirstParamName();
                String rvalue = (String)rmsg.getFirstParamValue();
                if (rpara.equalsIgnoreCase(portType)) {
                    return rvalue;
                }
            }
        }
        catch (Exception e) {
            this.LOCATION.debugT("getPort", ResourceUtil.formatString("sld_3031", new Object[]{String.valueOf(nodeId) + portType}));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getPort", (Throwable)e);
        }
        return null;
    }

    private J2EEData getEnqueueServerPorts(Params.Ids idParams) throws SldServiceException {
        String enqPort;
        Set keySet;
        Map props;
        J2EEData currResult = new J2EEData(idParams.getTypeId(), idParams.getVersionId());
        Properties p = GetData.coreMonitor.getManagerProperties(LOCKING_MANAGER);
        String fileName = null;
        Enumeration<?> pn = p.propertyNames();
        while (pn.hasMoreElements()) {
            String name = (String)pn.nextElement();
            if (!name.equalsIgnoreCase("enq.profile.filename")) continue;
            fileName = p.getProperty(name);
            break;
        }
        if (fileName != null && (props = this.readPropertyFile(fileName)) != null && props.size() != 0 && (keySet = props.keySet()).contains("enque/encni/port") && (enqPort = (String)props.get("enque/encni/port")) != null) {
            J2EEClass clazz = new J2EEClass("SAP_IPServicePort");
            J2EEObjInst inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
            inst.addPropValue("Name", "enqPort");
            inst.addPropValue("CreationClassName", "SAP_IPServicePort");
            inst.addPropValue("SystemCreationClassName", "SAP_BCCentralServiceInstance");
            String systemName = new GetSAPBCCentralServiceInstance(GetData.applServCtx, idParams).getName();
            if (systemName != null) {
                inst.addPropValue("SystemName", systemName);
            }
            inst.addPropValue("PortNumber", this.preparePort(enqPort));
            inst.addPropValue("Protocol", "SAPni");
            clazz.addInstance(inst);
            currResult.addClass(clazz);
        }
        return currResult;
    }

    private J2EEData getMessageServerPorts(Params.Ids idParams) throws SldServiceException {
        J2EEData currResult = new J2EEData(idParams.getTypeId(), idParams.getVersionId());
        TreeMap tree = this.getRuntimePropertiesAsTreeMap(CLUSTER_MANAGER, MS_GET_PARAMS);
        if (tree != null) {
            String serverHttpsPort;
            String serverHttpPort;
            J2EEClass clazz = new J2EEClass("SAP_IPServicePort");
            J2EEObjInst inst = null;
            String serverNiPort = this.extractParamValueFromTreeMap(tree, "server port");
            String serverNiService = this.extractParamValueFromTreeMap(tree, "server service");
            if (serverNiPort != null && serverNiPort.trim().length() != 0) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "msgPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_BCCentralServiceInstance");
                String systemName = new GetSAPBCCentralServiceInstance(GetData.applServCtx, idParams).getName();
                if (systemName != null) {
                    inst.addPropValue("SystemName", systemName);
                }
                inst.addPropValue("PortNumber", this.preparePort(serverNiPort.trim()));
                if (serverNiService != null && !this.isNumeric(serverNiService)) {
                    inst.addPropValue("OpSysServiceName", serverNiService);
                }
                inst.addPropValue("Protocol", "SAPni");
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            if ((serverHttpPort = this.extractParamValueFromTreeMap(tree, "ms/http_port")) != null && serverHttpPort.trim().length() != 0) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "msgHttpPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_BCCentralServiceInstance");
                String systemName = new GetSAPBCCentralServiceInstance(GetData.applServCtx, idParams).getName();
                if (systemName != null) {
                    inst.addPropValue("SystemName", systemName);
                }
                inst.addPropValue("PortNumber", this.preparePort(serverHttpPort));
                inst.addPropValue("Protocol", HTTP_PORT);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            if ((serverHttpsPort = this.extractParamValueFromTreeMap(tree, "ms/https_port")) != null && serverHttpsPort.trim().length() != 0) {
                inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
                inst.addPropValue("Name", "msgHttpsPort");
                inst.addPropValue("CreationClassName", "SAP_IPServicePort");
                inst.addPropValue("SystemCreationClassName", "SAP_BCCentralServiceInstance");
                String systemName = new GetSAPBCCentralServiceInstance(GetData.applServCtx, idParams).getName();
                if (systemName != null) {
                    inst.addPropValue("SystemName", systemName);
                }
                inst.addPropValue("PortNumber", this.preparePort(serverHttpsPort));
                inst.addPropValue("Protocol", HTTP_PORT);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            }
            if (clazz.getInstanceCount() > 0) {
                currResult.addClass(clazz);
            }
        }
        return currResult;
    }

    private boolean isNumeric(String inStr) {
        if (inStr == null) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < inStr.length()) {
            if (!Character.isDigit(inStr.charAt(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private String preparePort(String inPort) {
        StringBuffer outPort = new StringBuffer(inPort.trim());
        int chopIdx = -1;
        int i = outPort.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(outPort.charAt(i)) || outPort.charAt(i) == ' ') {
                chopIdx = i;
            }
            --i;
        }
        return chopIdx != -1 ? outPort.substring(0, chopIdx) : outPort.toString();
    }

    private String extractParamValueFromTreeMap(TreeMap tree, String searchKey) {
        String valueStr = null;
        Iterator it = tree.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.equalsIgnoreCase(searchKey)) continue;
            valueStr = (String)tree.get(key);
            break;
        }
        return valueStr;
    }

    private TreeMap deserializeTreeMap(String treeMap) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(treeMap.getBytes());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (TreeMap)ois.readObject();
    }

    private TreeMap getRuntimePropertiesAsTreeMap(String managerName, String key) {
        String method = "getRuntimePropertiesAsTreeMap";
        TreeMap tree = null;
        String treeAsString = GetData.coreMonitor.getManagerRuntimeProperty(managerName, key);
        try {
            tree = this.deserializeTreeMap(treeAsString);
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getRuntimePropertiesAsTreeMap", (Throwable)e);
        }
        return tree;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

