/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEObjInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.data.GetData;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class GetSAPBCCentralServiceInstance
extends GetData {
    private static final String PROPERTY_MS_HOST = "ms.host";
    private static final String PROPERTY_ENQ_PROFILE_NAME = "enq.profile.filename";
    private static final String PROPERTY_SAPSYSTEM = "SAPSYSTEM";
    static /* synthetic */ Class class$com$sap$sldserv$data$GetSAPBCCentralServiceInstance;
    static /* synthetic */ Class class$com$sap$sldserv$data$GetJ2EEEngineCluster;

    public GetSAPBCCentralServiceInstance(ApplicationServiceContext applServCtx, Params.Ids idParams) {
        super(applServCtx, idParams);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetSAPBCCentralServiceInstance == null ? (class$com$sap$sldserv$data$GetSAPBCCentralServiceInstance = GetSAPBCCentralServiceInstance.class$("com.sap.sldserv.data.GetSAPBCCentralServiceInstance")) : class$com$sap$sldserv$data$GetSAPBCCentralServiceInstance));
    }

    public J2EEData getData() throws SldServiceException {
        String centralInstanceNumber;
        String method = "getData";
        this.LOCATION.debugT("getData", ResourceUtil.formatStringNoParameterLocalization("sld_9028", new Object[]{"getData", class$com$sap$sldserv$data$GetJ2EEEngineCluster == null ? (class$com$sap$sldserv$data$GetJ2EEEngineCluster = GetSAPBCCentralServiceInstance.class$("com.sap.sldserv.data.GetJ2EEEngineCluster")) : class$com$sap$sldserv$data$GetJ2EEEngineCluster}));
        J2EEData result = new J2EEData(this.idParams.getTypeId(), this.idParams.getVersionId());
        String centralHost = this.getCentralServiceHost();
        if (centralHost == null) {
            this.LOCATION.debugT("getData", ResourceUtil.formatString(ResourceUtil.formatString("sld_3025")));
        }
        if ((centralInstanceNumber = this.getCentralServiceInstanceNumber()) == null) {
            this.LOCATION.debugT("getData", ResourceUtil.formatString(ResourceUtil.formatString("sld_3026")));
        }
        if (centralHost != null && centralInstanceNumber != null) {
            J2EEClass clazz = new J2EEClass("SAP_BCCentralServiceInstance");
            this.resetInstanceNumber(clazz.getName());
            J2EEObjInst inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
            String sid = this.getPropertyValue("SAPSYSTEMNAME");
            String nameValue = sid + ".SystemHome." + centralHost + ".ServiceInstanceID." + centralInstanceNumber;
            inst.addPropValue("Name", nameValue);
            inst.addPropValue("CreationClassName", "SAP_BCCentralServiceInstance");
            inst.addPropValue("SAPSystemName", sid);
            inst.addPropValue("SystemHome", centralHost);
            inst.addPropValue("ServiceInstanceID", centralInstanceNumber);
            clazz.addInstance(inst);
            result.addClass(clazz);
        }
        return result;
    }

    public String getServedClassName() {
        return "SAP_BCCentralServiceInstance";
    }

    String getName() {
        String nameValue = null;
        String centralHost = this.getCentralServiceHost();
        String centralInstanceNumber = this.getCentralServiceInstanceNumber();
        if (centralHost != null && centralInstanceNumber != null) {
            Properties props = System.getProperties();
            String sid = props.getProperty("SAPSYSTEMNAME");
            nameValue = sid + ".SystemHome." + centralHost + ".ServiceInstanceID." + centralInstanceNumber;
        }
        return nameValue;
    }

    String getCentralServiceHost() {
        Properties p = GetData.coreMonitor.getManagerProperties("ClusterManager");
        String centralHost = null;
        if (p != null) {
            Enumeration<?> pn = p.propertyNames();
            while (pn.hasMoreElements()) {
                String name = (String)pn.nextElement();
                if (!name.equalsIgnoreCase(PROPERTY_MS_HOST)) continue;
                centralHost = p.getProperty(name);
                break;
            }
        }
        return centralHost;
    }

    String getCentralServiceInstanceNumber() {
        String centralInstanceNumber = null;
        Properties p = GetData.coreMonitor.getManagerProperties("LockingManager");
        String fileName = null;
        if (p != null) {
            Enumeration<?> pn = p.propertyNames();
            while (pn.hasMoreElements()) {
                String name = (String)pn.nextElement();
                if (!name.equalsIgnoreCase(PROPERTY_ENQ_PROFILE_NAME)) continue;
                fileName = p.getProperty(name);
                break;
            }
        }
        if (fileName != null) {
            Map m = this.readPropertyFile(fileName);
            centralInstanceNumber = (String)m.get(PROPERTY_SAPSYSTEM);
        }
        return centralInstanceNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

