/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEObjInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.data.GetData;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sql.services.DatabaseInformation;
import com.sap.sql.services.OpenSQLServices;
import com.sap.tc.logging.Location;

public class GetDatabaseSystem
extends GetData {
    private static final String CONNECTOR_SERVICE_NAME = "dbpool";
    private static final String SCHEMA_PROPERTY_NAME = "sysDS.dataSourceName";
    private static final String VALUE_UNKNOWN = "unknown";
    private static final String VALUE_32 = "32";
    private static final String VALUE_64 = "64";
    private static final String DBTYPE_UNKNOWN = "unknown";
    private static final String DBTYPE_SAP = "SAP";
    private static final String DBTYPE_ORA = "ORA";
    private static final String DBTYPE_INF = "INF";
    private static final String DBTYPE_DB2 = "DB2";
    private static final String DBTYPE_DB4 = "DB4";
    private static final String DBTYPE_DB6 = "DB6";
    private static final String DBTYPE_MSS = "MSS";
    private static final String MANUFACTURER_UNKNOWN = "unknown";
    private static final String MANUFACTURER_SAP = "SAP";
    private static final String MANUFACTURER_ORA = "Oracle";
    private static final String MANUFACTURER_INF = "Informix";
    private static final String MANUFACTURER_DB2 = "IBM";
    private static final String MANUFACTURER_DB4 = "IBM";
    private static final String MANUFACTURER_DB6 = "IBM";
    private static final String MANUFACTURER_MSS = "Microsoft";
    static /* synthetic */ Class class$com$sap$sldserv$data$GetDatabaseSystem;

    public GetDatabaseSystem(ApplicationServiceContext applServCtx, Params.Ids idParams) {
        super(applServCtx, idParams);
        this.LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetDatabaseSystem == null ? (class$com$sap$sldserv$data$GetDatabaseSystem = GetDatabaseSystem.class$("com.sap.sldserv.data.GetDatabaseSystem")) : class$com$sap$sldserv$data$GetDatabaseSystem));
    }

    public J2EEData getData() throws SldServiceException {
        String method = "getData";
        this.LOCATION.debugT("getData", ResourceUtil.formatString("sld_9028", new Object[]{"getData", class$com$sap$sldserv$data$GetDatabaseSystem == null ? (class$com$sap$sldserv$data$GetDatabaseSystem = GetDatabaseSystem.class$("com.sap.sldserv.data.GetDatabaseSystem")) : class$com$sap$sldserv$data$GetDatabaseSystem}));
        J2EEData result = new J2EEData(this.idParams.getTypeId(), this.idParams.getVersionId());
        J2EEClass clazz = new J2EEClass("SAP_DatabaseSystem");
        this.resetInstanceNumber(clazz.getName());
        String dbSchemaName = this.getSystemDatabaseSchema();
        if (dbSchemaName != null) {
            J2EEObjInst inst = clazz.createObjectInst(this.getCurrInstNum(clazz.getName()));
            DatabaseInformation dbInfo = OpenSQLServices.getDatabaseInformation((String)dbSchemaName);
            if (dbInfo != null) {
                String dbSid = dbInfo.getDatabaseName();
                String dbType = this.getDatabaseType(dbInfo.getVendorID());
                String dbHost = dbInfo.getDatabaseHost();
                String nameValue = dbSid + "." + "DBTypeForSAP" + "." + dbType + "." + "SystemHome" + "." + dbHost;
                inst.addPropValue("Name", nameValue);
                inst.addPropValue("CreationClassName", "SAP_DatabaseSystem");
                String manufacturerValue = this.getManufacturer(dbInfo.getVendorID());
                inst.addPropValue("Manufacturer", manufacturerValue);
                String dbRelease = this.condense(dbInfo.getDatabaseProductVersion());
                inst.addPropValue("Release", dbRelease);
                Boolean b = dbInfo.isDatabaseKernel64Bit();
                String dbSysBits = b == null ? "unknown" : (b != false ? VALUE_64 : VALUE_32);
                inst.addPropValue("DBSysBits", dbSysBits);
                inst.addPropValue("DBTypeForSAP", this.getDatabaseType(dbInfo.getVendorID()));
                inst.addPropValue("SystemHome", dbHost);
                inst.addPropValue("DBName", dbSid);
                clazz.addInstance(inst);
                this.raiseCurrInstNum(clazz.getName());
            } else {
                GetData.CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString("sld_3029"));
            }
        } else {
            GetData.CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString(ResourceUtil.formatString("sld_3027")));
        }
        this.resetInstanceNumber("SAP_DatabaseSystem");
        result.addClass(clazz);
        return result;
    }

    public String getServedClassName() {
        return "SAP_DatabaseSystem";
    }

    private String getManufacturer(int vendorId) {
        String rvalue = "unknown";
        switch (vendorId) {
            case 5: {
                rvalue = MANUFACTURER_ORA;
                break;
            }
            case 6: {
                rvalue = "SAP";
                break;
            }
            case 3: {
                rvalue = MANUFACTURER_INF;
                break;
            }
            case 0: {
                rvalue = "IBM";
                break;
            }
            case 1: {
                rvalue = "IBM";
                break;
            }
            case 2: {
                rvalue = "IBM";
                break;
            }
            case 4: {
                rvalue = MANUFACTURER_MSS;
                break;
            }
            default: {
                rvalue = "unknown";
            }
        }
        return rvalue;
    }

    private String getDatabaseType(int vendorId) {
        String rvalue = "unknown";
        switch (vendorId) {
            case 5: {
                rvalue = DBTYPE_ORA;
                break;
            }
            case 6: {
                rvalue = "SAP";
                break;
            }
            case 3: {
                rvalue = DBTYPE_INF;
                break;
            }
            case 0: {
                rvalue = DBTYPE_DB6;
                break;
            }
            case 1: {
                rvalue = DBTYPE_DB4;
                break;
            }
            case 2: {
                rvalue = DBTYPE_DB2;
                break;
            }
            case 4: {
                rvalue = DBTYPE_MSS;
                break;
            }
            default: {
                rvalue = "unknown";
            }
        }
        return rvalue;
    }

    private String getSystemDatabaseSchema() {
        ServiceMonitor servMon = GetData.systemMonitor.getService(CONNECTOR_SERVICE_NAME);
        return servMon != null ? servMon.getProperty(SCHEMA_PROPERTY_NAME) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

