/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GetDataClasses {
    private static final String GETTER_METHOD = "getData";
    private static final String J2EEDATA_RETURN_TYPE_CLASS = "com.sap.sldserv.J2EEData";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetDataClasses == null ? (class$com$sap$sldserv$data$GetDataClasses = GetDataClasses.class$("com.sap.sldserv.data.GetDataClasses")) : class$com$sap$sldserv$data$GetDataClasses));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    static /* synthetic */ Class class$com$sap$sldserv$data$GetDataClasses;

    public static List getClasses() throws SldServiceException {
        return GetDataClasses.getClassesForPackage(new GetDataClasses().getClass());
    }

    private static List getClassesForPackage(Class cls) throws SldServiceException {
        ArrayList<Class> resultClasses;
        ArrayList<String> classes;
        block14: {
            String path;
            String method = "getterClassesForPackage";
            classes = new ArrayList<String>();
            resultClasses = new ArrayList<Class>();
            String clsNameSlashed = cls.getName().replace('.', '/');
            URL classUrl = cls.getClassLoader().getResource(clsNameSlashed + ".class");
            String packageNameSlashed = clsNameSlashed.substring(0, 1 + clsNameSlashed.lastIndexOf(47));
            String protocol = classUrl.getProtocol();
            if ("jar".equals(protocol)) {
                path = classUrl.getPath();
                String jarFile = path.substring(0, path.indexOf(33));
                if (jarFile.startsWith("file:")) {
                    jarFile = jarFile.substring(5);
                }
                try {
                    ZipFile zip = new ZipFile(jarFile);
                    try {
                        classes.ensureCapacity(zip.size());
                        Enumeration<? extends ZipEntry> enumeration = zip.entries();
                        while (enumeration.hasMoreElements()) {
                            ZipEntry entry = enumeration.nextElement();
                            String entryName = entry.getName();
                            if (!entryName.startsWith(packageNameSlashed) || !entryName.endsWith(".class")) continue;
                            entryName = entryName.substring(0, entryName.lastIndexOf(46));
                            classes.add(entryName);
                        }
                        Object var15_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        zip.close();
                        throw throwable;
                    }
                    zip.close();
                    {
                        break block14;
                    }
                }
                catch (IOException e) {
                    throw new SldServiceException("sld_1007", new Object[]{e.getMessage()}, e);
                }
            }
            if ("file".equals(protocol)) {
                path = classUrl.getPath();
                path = path.substring(0, path.lastIndexOf(47));
                File folder = new File(path);
                File[] classFiles = folder.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".class");
                    }
                });
                classes.ensureCapacity(classFiles.length);
                int i = 0;
                while (i < classFiles.length) {
                    String clsName = classFiles[i].getName();
                    clsName = clsName.substring(0, clsName.length() - 6);
                    classes.add(packageNameSlashed + clsName);
                    ++i;
                }
            } else {
                throw new SldServiceException("sld_1006", new Object[]{classUrl});
            }
        }
        int i = 0;
        while (i < classes.size()) {
            try {
                String className = classes.get(i).toString().replace('/', '.');
                Class clazz = null;
                if (!GetDataClasses.isLocalClass(className) && (clazz = GetDataClasses.isDataGetterClass(className)) != null) {
                    resultClasses.add(clazz);
                }
            }
            catch (Exception e) {
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getterClassesForPackage", (Throwable)e);
            }
            ++i;
        }
        return resultClasses;
    }

    private static Class isDataGetterClass(String className) {
        String method = "isDataGetterClass";
        try {
            Class<?> clazz = Class.forName(className);
            if (!clazz.isInterface() && !clazz.equals(class$com$sap$sldserv$data$GetDataClasses == null ? (class$com$sap$sldserv$data$GetDataClasses = GetDataClasses.class$("com.sap.sldserv.data.GetDataClasses")) : class$com$sap$sldserv$data$GetDataClasses)) {
                Method[] methods = clazz.getMethods();
                int i = 0;
                while (i < methods.length) {
                    Class<?> returnType;
                    if (methods[i].getName().equals(GETTER_METHOD) && (returnType = methods[i].getReturnType()).getName().equals(J2EEDATA_RETURN_TYPE_CLASS)) {
                        return clazz;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatStringNoParameterLocalization("sld_2015", new Object[]{className}));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"isDataGetterClass", (Throwable)e);
        }
        return null;
    }

    private static boolean isLocalClass(String className) {
        boolean rc = false;
        int idx = className.lastIndexOf(36);
        if (idx > 0) {
            String n = className.substring(idx + 1, className.length());
            try {
                Integer.parseInt(n);
                rc = true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return rc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

