/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.data;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.monitor.CoreMonitor;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.cvers.api.CVersAccessException;
import com.sap.sl.util.cvers.api.CVersFactoryIF;
import com.sap.sl.util.cvers.api.CVersManagerIF;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.Params;
import com.sap.sldserv.data.IGetData;
import com.sap.sldserv.data.IGetterCIMNames;
import com.sap.sldserv.data.MD5;
import com.sap.sldserv.data.SldMessage;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;

public abstract class GetData
implements IGetData,
IGetterCIMNames {
    protected static final long WITHOUT_CALL_TIMEOUT = 0L;
    protected static final long WITH_CALL_TIMEOUT = 10000L;
    protected static final String UTF8 = "UTF-8";
    protected static Properties props = System.getProperties();
    protected static ApplicationServiceContext applServCtx = null;
    protected static ApplicationContainerContext applContainerCtx = null;
    protected static ClusterContext clusterCtx = null;
    protected static ClusterMonitor clusterMonitor = null;
    protected static SystemMonitor systemMonitor = null;
    protected static MessageContext msgCtx = null;
    protected static CoreContext coreCtx = null;
    protected static CoreMonitor coreMonitor = null;
    protected Params.Ids idParams = null;
    protected Context context = null;
    private static Map instNumbers = null;
    private static Map hostNamesIPs = null;
    protected Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$data$GetData == null ? (class$com$sap$sldserv$data$GetData = GetData.class$("com.sap.sldserv.data.GetData")) : class$com$sap$sldserv$data$GetData));
    protected static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    protected static int sendReceiveBytes = 0;
    static /* synthetic */ Class class$com$sap$sldserv$data$GetData;

    protected GetData(ApplicationServiceContext applServCtx, Params.Ids idParams) {
        if (applContainerCtx == null) {
            GetData.applServCtx = applServCtx;
        }
        this.idParams = idParams;
        if (applContainerCtx == null) {
            applContainerCtx = applServCtx.getContainerContext();
        }
        if (systemMonitor == null) {
            systemMonitor = applContainerCtx.getSystemMonitor();
        }
        if (clusterCtx == null) {
            clusterCtx = applServCtx.getClusterContext();
        }
        if (msgCtx == null) {
            msgCtx = clusterCtx.getMessageContext();
        }
        if (clusterMonitor == null) {
            clusterMonitor = clusterCtx.getClusterMonitor();
        }
        if (coreCtx == null) {
            coreCtx = applServCtx.getCoreContext();
        }
        if (coreMonitor == null) {
            coreMonitor = coreCtx.getCoreMonitor();
        }
        if (instNumbers == null) {
            instNumbers = new HashMap();
        }
    }

    public abstract J2EEData getData() throws SldServiceException;

    public abstract String getServedClassName();

    public static void newCollecting() {
        sendReceiveBytes = 0;
        instNumbers = null;
        hostNamesIPs = null;
    }

    public static int getSendReceiveBytes() {
        return sendReceiveBytes;
    }

    protected String getPropertyValue(String propertyName) {
        String paramValue = null;
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String currName = enumeration.nextElement().toString();
            if (!currName.equalsIgnoreCase(propertyName)) continue;
            paramValue = System.getProperty(currName);
            break;
        }
        return paramValue;
    }

    protected String getPropertyValue(int nodeId, String propertyName) {
        String method = "getPropertyValue";
        String paramValue = null;
        if (nodeId == this.getCurrentId()) {
            paramValue = this.getPropertyValue(propertyName);
        } else {
            SldMessage smsg = new SldMessage();
            smsg.setMsgId(100);
            smsg.addCallParam(propertyName, null);
            try {
                byte[] ba = smsg.toByteArray();
                sendReceiveBytes += ba.length;
                MessageAnswer answ = msgCtx.sendAndWaitForAnswer(nodeId, smsg.getMsgId(), ba, 0, ba.length, 0L);
                SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
                sendReceiveBytes += rmsg.toByteArray().length;
                if (rmsg.getMsgId() == 0) {
                    this.LOCATION.debugT("getPropertyValue", ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)}));
                } else {
                    String rpara = rmsg.getFirstParamName();
                    String rvalue = (String)rmsg.getFirstParamValue();
                    if (rpara == null || !rpara.equalsIgnoreCase(propertyName) || rvalue == null) {
                        this.LOCATION.debugT("getPropertyValue", ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)}));
                    } else {
                        paramValue = rvalue;
                    }
                }
            }
            catch (Exception e) {
                CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)}));
                LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getPropertyValue", (Throwable)e);
            }
        }
        return paramValue;
    }

    protected String getCurrInstNum(String className) {
        String n = (String)instNumbers.get(className);
        if (n == null) {
            n = "0";
            instNumbers.put(className, n);
        }
        return n;
    }

    protected void raiseCurrInstNum(String className) {
        String n = (String)instNumbers.get(className);
        n = n == null ? "1" : String.valueOf(Integer.parseInt(n) + 1);
        instNumbers.put(className, n);
    }

    protected String getRaiseCurrInstNum(String className) {
        String n = (String)instNumbers.get(className);
        if (n == null) {
            instNumbers.put(className, "1");
            n = "0";
        } else {
            instNumbers.put(className, String.valueOf(Integer.parseInt(n) + 1));
        }
        return n;
    }

    protected void resetInstanceNumber(String className) {
        instNumbers.put(className, "0");
    }

    protected ClusterElement[] getAllClusterElements() {
        ClusterElement ce = clusterMonitor.getCurrentParticipant();
        ClusterElement[] ces = clusterMonitor.getParticipants();
        ClusterElement[] rce = new ClusterElement[ces.length + 1];
        rce[0] = ce;
        System.arraycopy(ces, 0, rce, 1, ces.length);
        return rce;
    }

    protected ClusterElement[] getAllServerClusterElements() {
        ClusterElement currentElement = clusterMonitor.getCurrentParticipant();
        ClusterElement[] clusterElements = clusterMonitor.getParticipants();
        ClusterElement[] ce = new ClusterElement[clusterElements.length];
        int count = 0;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getType() == 2) {
                ce[count++] = clusterElements[i];
            }
            ++i;
        }
        ClusterElement[] rce = new ClusterElement[count + 1];
        rce[0] = currentElement;
        int i2 = 0;
        int j = 1;
        while (i2 < count) {
            rce[j] = ce[i2];
            ++i2;
            ++j;
        }
        return rce;
    }

    protected ClusterElement[] getAllDispatcherClusterElements() {
        ClusterElement[] clusterElements = clusterMonitor.getParticipants();
        ClusterElement[] ce = new ClusterElement[clusterElements.length];
        int count = 0;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getType() == 1) {
                ce[count++] = clusterElements[i];
            }
            ++i;
        }
        ClusterElement[] rce = new ClusterElement[count];
        int i2 = 0;
        while (i2 < count) {
            rce[i2] = ce[i2];
            ++i2;
        }
        return rce;
    }

    protected int getCurrentId() {
        return clusterMonitor.getCurrentParticipant().getClusterId();
    }

    protected String getNodeId(int nodeId) {
        String method = "getNodeId";
        String rnodeId = null;
        if (nodeId == this.getCurrentId()) {
            rnodeId = String.valueOf(clusterMonitor.getCurrentParticipant().getClusterId());
        } else {
            SldMessage smsg = new SldMessage();
            smsg.setMsgId(101);
            try {
                byte[] ba = smsg.toByteArray();
                sendReceiveBytes += ba.length;
                MessageAnswer answ = msgCtx.sendAndWaitForAnswer(nodeId, smsg.getMsgId(), ba, 0, ba.length, 0L);
                SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
                sendReceiveBytes += rmsg.toByteArray().length;
                if (rmsg.getMsgId() == 0) {
                    this.LOCATION.debugT("getNodeId", ResourceUtil.formatString(ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)})));
                } else {
                    String rvalue = (String)rmsg.getFirstParamValue();
                    if (rvalue == null) {
                        this.LOCATION.debugT("getNodeId", ResourceUtil.formatString(ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)})));
                    } else {
                        rnodeId = rvalue;
                    }
                }
            }
            catch (Exception e) {
                CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)}));
                LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getNodeId", (Throwable)e);
            }
        }
        return rnodeId;
    }

    protected int getFirstCorrespondingServerId(ClusterElement dispClusterElement) {
        int rid = Integer.MIN_VALUE;
        ClusterElement[] serverClusterElement = this.getAllServerClusterElements();
        int i = 0;
        while (i < serverClusterElement.length) {
            if (serverClusterElement[i].getGroupId() == dispClusterElement.getGroupId()) {
                rid = serverClusterElement[i].getClusterId();
                break;
            }
            ++i;
        }
        return rid;
    }

    protected Map readPropertyFile(String fileName) {
        String method = "readFile";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = reader.readLine();
            while (line != null) {
                int idx = line.indexOf(61);
                if (idx >= 0) {
                    String paramName = line.substring(0, idx);
                    String paramValue = line.substring(idx + 1, line.length());
                    resultMap.put(paramName.trim(), paramValue.trim());
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable((int)400, (Location)this.LOCATION, (String)"readFile", (Throwable)e);
        }
        return resultMap;
    }

    protected String getSystemName(ClusterElement ce) throws SldServiceException {
        String systemName = null;
        String sid = this.getPropertyValue("SAPSYSTEMNAME");
        if (sid == null) {
            throw new SldServiceException("sld_3061", new Object[]{"SAPSYSTEMNAME"});
        }
        systemName = sid + ".SystemHome." + this.getHostName(ce) + ".NodeID." + String.valueOf(ce.getClusterId());
        return systemName;
    }

    protected String condense(String is) {
        StringBuffer os = new StringBuffer(is != null ? is.trim() : "");
        int size = os.length();
        int i = 0;
        while (i < size) {
            if (os.charAt(i) == ' ' && i + 1 < size && os.charAt(i + 1) == ' ') {
                int j = i + 1;
                while (j < size - 1) {
                    os.setCharAt(j, os.charAt(j + 1));
                    ++j;
                }
                os = os.deleteCharAt(--size);
                continue;
            }
            ++i;
        }
        return os.toString();
    }

    protected String generateGuid(String[] keys) throws UnsupportedEncodingException {
        MD5 md5Generator = new MD5();
        int i = 0;
        while (i < keys.length) {
            md5Generator.update(keys[i].getBytes(UTF8));
            ++i;
        }
        byte[] md5 = md5Generator.finish();
        StringBuffer buf = new StringBuffer(36);
        int i2 = 0;
        while (i2 < md5.length) {
            byte b;
            String hex;
            if (i2 == 4 || i2 == 6 || i2 == 8 || i2 == 10) {
                buf.append('-');
            }
            if ((hex = Integer.toHexString(0xFF & (b = md5[i2]))).length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
            ++i2;
        }
        return buf.toString();
    }

    protected String getHostName(ClusterElement ce) throws SldServiceException {
        String method = "getHostName";
        String hostName = ce.getAddress().getHostName();
        if (this.checkIPAddress(hostName)) {
            String ip = hostName;
            if ((hostName = this.getCacheHostName(hostName)) == null) {
                try {
                    if (ce.getClusterId() == this.getCurrentId()) {
                        hostName = InetAddress.getLocalHost().getHostName();
                        this.addCacheHostName(hostName, ip);
                    } else {
                        SldMessage smsg = new SldMessage();
                        smsg.setMsgId(106);
                        byte[] ba = smsg.toByteArray();
                        sendReceiveBytes += ba.length;
                        int nodeId = ce.getClusterId();
                        MessageAnswer answ = msgCtx.sendAndWaitForAnswer(nodeId, smsg.getMsgId(), ba, 0, ba.length, 0L);
                        SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
                        sendReceiveBytes += rmsg.toByteArray().length;
                        if (rmsg.getMsgId() == 0) {
                            this.LOCATION.debugT("getHostName", ResourceUtil.formatString("sld_3015", new Object[]{String.valueOf(this.getCurrentId()), String.valueOf(nodeId)}));
                            throw new SldServiceException("sld_3066");
                        }
                        hostName = (String)rmsg.getFirstParamValue();
                        if (!this.checkIPAddress(hostName)) {
                            this.addCacheHostName(hostName, ip);
                        }
                    }
                }
                catch (Exception e) {
                    throw new SldServiceException(e);
                }
            }
        }
        return hostName;
    }

    protected synchronized String getCacheHostName(String ip) {
        String rvalue = null;
        if (hostNamesIPs == null) {
            hostNamesIPs = new HashMap();
        } else {
            rvalue = (String)hostNamesIPs.get(ip);
        }
        return rvalue;
    }

    protected synchronized void addCacheHostName(String host, String ip) {
        if (hostNamesIPs == null) {
            hostNamesIPs = new HashMap();
        }
        hostNamesIPs.put(ip, host);
    }

    protected boolean checkIPAddress(String ip) {
        boolean rvalue = true;
        int countFrag = 0;
        StringTokenizer st = new StringTokenizer(ip, ".");
        while (st.hasMoreTokens()) {
            String ipFrag = st.nextToken().trim();
            try {
                int ipFragInt = Integer.valueOf(ipFrag);
                if (++countFrag <= 4 && ipFragInt <= 255 && ipFragInt >= 0) continue;
                rvalue = false;
            }
            catch (NumberFormatException e) {
                rvalue = false;
            }
            break;
        }
        return rvalue;
    }

    protected ComponentElementIF[] getComponentsIf() {
        String method = "getComponentsIf";
        ComponentElementIF[] ce = new ComponentElementIF[]{};
        try {
            CVersFactoryIF manFactory = CVersFactoryIF.getInstance();
            CVersManagerIF manager = manFactory.createCVersManager();
            ce = manager.readCVers();
        }
        catch (CVersAccessException e) {
            CATEGORY.warningT(this.LOCATION, ResourceUtil.formatString("sld_2013"));
            LoggingHelper.traceThrowable((int)100, (Location)this.LOCATION, (String)"getComponentsIf", (Throwable)e);
        }
        return ce;
    }

    protected ComponentElementIF[] getComponentsIfForType(String compType) {
        ComponentElementIF[] ce = this.getComponentsIf();
        ArrayList<ComponentElementIF> a = new ArrayList<ComponentElementIF>(ce.length);
        int i = 0;
        while (i < ce.length) {
            if (ce[i].getComponentType().equalsIgnoreCase(compType)) {
                a.add(ce[i]);
            }
            ++i;
        }
        return a.toArray(new ComponentElementIF[0]);
    }

    protected HashMap hashComponentElements(ComponentElementIF[] compElems) {
        HashMap<String, ComponentElementIF> rvalue = new HashMap<String, ComponentElementIF>(compElems.length);
        int i = 0;
        while (i < compElems.length) {
            rvalue.put(compElems[i].getName(), compElems[i]);
            ++i;
        }
        return rvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

