/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.comm;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.comm.IBridgeCommunication;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.repo.ProxyRepository;
import com.sap.tc.logging.Location;
import java.util.Iterator;

public class BridgeCommunicationRfc
implements IBridgeCommunication {
    private Params params = null;
    private boolean isOpen = false;
    private JCO.Function bridgeFunc = null;
    private JCO.Client rfcClient = null;
    private static IRepository nucRepository = null;
    private static IRepository ucRepository = null;
    private IRepository usedRepository = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$comm$BridgeCommunicationHTTP == null ? (class$com$sap$sldserv$comm$BridgeCommunicationHTTP = BridgeCommunicationRfc.class$("com.sap.sldserv.comm.BridgeCommunicationHTTP")) : class$com$sap$sldserv$comm$BridgeCommunicationHTTP));
    static /* synthetic */ Class class$com$sap$sldserv$comm$BridgeCommunicationHTTP;

    public BridgeCommunicationRfc(Params params) throws SldServiceException {
        String method = "BridgeCommunicationRfc(RuntimeParams)";
        try {
            this.params = params;
            this.usedRepository = nucRepository;
        }
        catch (JCO.Exception e) {
            LOCATION.errorT("BridgeCommunicationRfc(RuntimeParams)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{e.getMessage()}));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"BridgeCommunicationRfc(RuntimeParams)", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    public BridgeCommunicationRfc(Params params, boolean useUnicode) throws SldServiceException {
        String method = "BridgeCommunicationRfc(RuntimeParams,boolean)";
        try {
            this.params = params;
            this.usedRepository = useUnicode ? ucRepository : nucRepository;
        }
        catch (JCO.Exception e) {
            LOCATION.errorT("BridgeCommunicationRfc(RuntimeParams,boolean)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{e.getMessage()}));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"BridgeCommunicationRfc(RuntimeParams,boolean)", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    public void syncParams() throws SldServiceException {
        this.params.refreshConfig();
        if (!this.params.hasValidRfcParams() || !this.params.getCommunicationType().equalsIgnoreCase("jco")) {
            throw new SldServiceException(ResourceUtil.formatString("sld_9057"));
        }
    }

    public void connect() throws SldServiceException {
        block5: {
            String method = "connect(void)";
            try {
                if (this.isOpen) break block5;
                if (this.params.getCommTrace()) {
                    JCO.setTraceLevel((int)10);
                }
                this.rfcClient = JCO.createClient((String)this.params.getGatewayHost(), (String)this.params.getGatewayService(), (String)this.params.getRegId());
                if (this.rfcClient != null) {
                    if (this.params.getCommTrace()) {
                        this.rfcClient.setTrace(true);
                    }
                    this.rfcClient.connect();
                    this.isOpen = true;
                    LOCATION.debugT("connect(void)", ResourceUtil.formatString("sld_9006"));
                    break block5;
                }
                LOCATION.errorT("connect(void)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{"null"}));
                throw new SldServiceException(ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{"null"}));
            }
            catch (JCO.Exception e) {
                LOCATION.errorT("connect(void)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{e.getMessage()}));
                LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"connect(void)", (Throwable)e);
                throw new SldServiceException(e);
            }
        }
    }

    public void connect(String gwHost, String gwPort, String gwRegId) throws SldServiceException {
        block3: {
            String method = "connect(String,String,String)";
            try {
                if (this.isOpen) break block3;
                JCO.setTraceLevel((int)10);
                this.rfcClient = JCO.createClient((String)gwHost, (String)gwPort, (String)gwRegId);
                if (this.rfcClient != null) {
                    this.rfcClient.setTrace(true);
                    this.rfcClient.connect();
                    this.isOpen = true;
                    LOCATION.debugT("connect(String,String,String)", ResourceUtil.formatString("sld_9006"));
                    break block3;
                }
                LOCATION.errorT("connect(String,String,String)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{"null"}));
                throw new SldServiceException(ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{"null"}));
            }
            catch (JCO.Exception e) {
                LOCATION.errorT("connect(String,String,String)", ResourceUtil.formatStringNoParameterLocalization("sld_1001", new Object[]{e.getMessage()}));
                LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"connect(String,String,String)", (Throwable)e);
                throw new SldServiceException(e);
            }
        }
    }

    public void disconnect() throws SldServiceException {
        String method = "disconnect";
        try {
            if (this.isOpen) {
                this.rfcClient.disconnect();
                this.isOpen = false;
                this.bridgeFunc = null;
                this.rfcClient = null;
                LOCATION.debugT("disconnect", ResourceUtil.formatString("sld_9007"));
            }
        }
        catch (JCO.Exception e) {
            LOCATION.errorT("disconnect", ResourceUtil.formatStringNoParameterLocalization("sld_9008", new Object[]{e.getMessage()}));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"disconnect", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    public void send() throws SldServiceException {
        String method = "send";
        if (this.isOpen && this.bridgeFunc != null) {
            try {
                LOCATION.debugT("send", ResourceUtil.formatStringNoParameterLocalization("sld_9043", new Object[]{this.bridgeFunc.getName()}));
                this.rfcClient.execute(this.bridgeFunc);
                LOCATION.debugT("send", ResourceUtil.formatStringNoParameterLocalization("sld_9044", new Object[]{this.bridgeFunc.getName()}));
            }
            catch (JCO.Exception e) {
                LOCATION.errorT("send", ResourceUtil.formatStringNoParameterLocalization("sld_3001", new Object[]{e.getMessage()}));
                LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"send", (Throwable)e);
                throw new SldServiceException(e);
            }
        } else {
            throw new SldServiceException("sld_2001");
        }
    }

    public void prepare() throws SldServiceException {
        String method = "prepare";
        if (this.isOpen) {
            try {
                this.bridgeFunc = this.usedRepository.getFunctionTemplate("SET_SLD_DATA").getFunction();
                LOCATION.debugT("prepare", ResourceUtil.formatStringNoParameterLocalization("sld_9010", new Object[]{"SET_SLD_DATA"}));
            }
            catch (Exception e) {
                LOCATION.errorT("prepare", ResourceUtil.formatStringNoParameterLocalization("sld_2012", new Object[]{this.bridgeFunc.getName()}));
                LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"prepare", (Throwable)e);
                throw new SldServiceException(e);
            }
        } else {
            throw new SldServiceException("sld_2002");
        }
    }

    public void setData(J2EEData j2eeData) throws SldServiceException {
        String method = "setData";
        try {
            if (j2eeData != null) {
                this.bridgeFunc.getImportParameterList().setValue(j2eeData.getType(), "TYPE");
                this.bridgeFunc.getImportParameterList().setValue(j2eeData.getVersion(), "VERSION");
                JCO.Table dataTab = this.bridgeFunc.getTableParameterList().getTable("DATA_TAB");
                Iterator cit = j2eeData.getClassIterator();
                while (cit.hasNext()) {
                    J2EEClass clazz = (J2EEClass)cit.next();
                    Iterator iit = clazz.instanceIterator();
                    while (iit.hasNext()) {
                        J2EEInst inst = (J2EEInst)iit.next();
                        inst.setValueIds();
                        Iterator pit = inst.getPropertyIterator();
                        while (pit.hasNext()) {
                            J2EEInst.J2EEInstProp prop = (J2EEInst.J2EEInstProp)pit.next();
                            Iterator pvidIt = prop.getValueIdsIterator();
                            while (pvidIt.hasNext()) {
                                J2EEInst.J2EEInstProp.ValueId vid = (J2EEInst.J2EEInstProp.ValueId)pvidIt.next();
                                dataTab.appendRow();
                                if (inst.isAssociation()) continue;
                                dataTab.setValue("0", "ENTRY_TYPE");
                                dataTab.setValue(clazz.getName(), "CLASS_NAME");
                                dataTab.setValue(inst.getInstName(), "INST_NUMBER");
                                dataTab.setValue(prop.getName(), "PROPERTY_ROLE");
                                dataTab.setValue(vid.getId(), "VALUE_ID");
                                dataTab.setValue(vid.getValue(), "VALUE");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOCATION.errorT("setData", ResourceUtil.formatStringNoParameterLocalization("sld_3001", new Object[]{e.getMessage()}));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"setData", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nucRepository = ProxyRepository.getNoneUnicodeRepository();
        ucRepository = ProxyRepository.getUnicodeRepository();
    }
}

