/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.comm;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.Params;
import com.sap.sldserv.comm.IBridgeCommunication;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.ssl.IAIKSecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import java.net.URL;
import java.util.Iterator;

public class BridgeCommunicationHTTP
implements IBridgeCommunication {
    private static final String XML_TAG_SAPDATA = "sapdata";
    private static final String XML_TAG_INSTANCE = "instance";
    private static final String XML_TAG_PROPERTY = "property";
    private static final String XML_TAG_REFERENCE = "reference";
    private static final String XML_TAG_VALUE = "value";
    private static final String XML_TAG_START = "<";
    private static final String XML_TAG_END = ">";
    private static final String XML_ATTRIBUT_TYPE = "type";
    private static final String XML_ATTRIBUT_VERSION = "version";
    private static final String XML_ATTRIBUT_CLASSNAME = "classname";
    private static final String XML_ATTRIBUT_INST_ID = "inst_id";
    private static final String XML_ATTRIBUT_NAME = "name";
    private static final String XML_ATTRIBUT_ROLENAME = "rolename";
    private static final String XML_CONST_SPACE = " ";
    private static final String XML_CONST_EQUAL = "=";
    private static final String XML_CONST_DQUOTE = "\"";
    private static final String XML_CONST_SLASH = "/";
    private static final String DS_SERVLET_URL = "/sld/ds";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private Connection httpConnect;
    private String xmlmsg = null;
    private Params params = null;
    private boolean isOpen = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$comm$BridgeCommunicationHTTP == null ? (class$com$sap$sldserv$comm$BridgeCommunicationHTTP = BridgeCommunicationHTTP.class$("com.sap.sldserv.comm.BridgeCommunicationHTTP")) : class$com$sap$sldserv$comm$BridgeCommunicationHTTP));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    static /* synthetic */ Class class$com$sap$sldserv$comm$BridgeCommunicationHTTP;

    public BridgeCommunicationHTTP(Params params) {
        this.params = params;
    }

    public void syncParams() throws SldServiceException {
        this.params.refreshConfig();
        if (!this.params.hasValidHttpParams() || !this.params.getCommunicationType().equalsIgnoreCase(PROTOCOL_HTTP)) {
            throw new SldServiceException(ResourceUtil.formatString("sld_9058"));
        }
    }

    public void connect() throws SldServiceException {
        String method = "connect(void)";
        if (!this.isOpen) {
            try {
                SessionContext sessionContext = new SessionContext(this.params.getHttpUser(), this.params.getHttpPassword());
                sessionContext.setAuthenticator((IAuthenticator)new BasicAuthenticator((ISessionContext)sessionContext));
                boolean useHttps = this.params.getHttpsSetting();
                URL url = new URL(useHttps ? PROTOCOL_HTTPS : PROTOCOL_HTTP, this.params.getHttpHost(), this.params.getHttpPort(), "");
                this.httpConnect = new Connection(url.toString(), (ISessionContext)sessionContext);
                if (useHttps) {
                    String trustStore = this.params.getTrustStore();
                    IAIKSecureSocketProvider sslProvider = new IAIKSecureSocketProvider(trustStore, null);
                    this.httpConnect.setSecureSocketProvider((ISecureSocketProvider)sslProvider);
                }
                this.isOpen = true;
            }
            catch (Exception e) {
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"connect(void)", (Throwable)e);
                throw new SldServiceException("sld_1014", e);
            }
        }
    }

    public void connect(boolean useHttps, String host, String port, String user, String pass, String trustStore, String keyStore) throws SldServiceException {
        String method = "connect(boolean,String,String,String,String,String)";
        try {
            if (!this.isOpen) {
                SessionContext sessionContext = new SessionContext(user, pass);
                sessionContext.setAuthenticator((IAuthenticator)new BasicAuthenticator((ISessionContext)sessionContext));
                URL url = new URL(useHttps ? PROTOCOL_HTTPS : PROTOCOL_HTTP, host, Integer.parseInt(port), "");
                this.httpConnect = new Connection(url.toString(), (ISessionContext)sessionContext);
                if (useHttps) {
                    IAIKSecureSocketProvider sslProvider = new IAIKSecureSocketProvider(trustStore, keyStore);
                    this.httpConnect.setSecureSocketProvider((ISecureSocketProvider)sslProvider);
                }
                this.isOpen = true;
            }
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"connect(boolean,String,String,String,String,String)", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    public void disconnect() throws SldServiceException {
        String method = "disconnect";
        try {
            if (this.isOpen) {
                this.httpConnect.close();
                this.isOpen = false;
                LOCATION.debugT("disconnect", ResourceUtil.formatString("sld_9007"));
            }
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatStringNoParameterLocalization("sld_9008", new Object[]{e.getMessage()}));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"disconnect", (Throwable)e);
            throw new SldServiceException(e);
        }
    }

    public void send() throws SldServiceException {
        block6: {
            String method = "send";
            if (this.isOpen && this.xmlmsg != null) {
                try {
                    try {
                        PostRequest request = new PostRequest(DS_SERVLET_URL);
                        StringEntity msgentity = new StringEntity("text/xml", "UTF-8", this.xmlmsg);
                        request.setRequestEntity((IRequestEntity)msgentity);
                        IResponse response = request.perform((IConnection)this.httpConnect);
                        int status = response.getStatus();
                        if (status != 200) {
                            CATEGORY.errorT(LOCATION, ResourceUtil.formatString("sld_3050", new Object[]{String.valueOf(response.getStatus()), response.getStatusDescription()}));
                            throw new SldServiceException("sld_3049", new Object[]{String.valueOf(response.getStatus()), response.getStatusDescription()});
                        }
                        Object var7_7 = null;
                        this.isOpen = false;
                        break block6;
                    }
                    catch (Exception e) {
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"send", (Throwable)e);
                        throw new SldServiceException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.isOpen = false;
                    throw throwable;
                }
            }
            throw new SldServiceException("sld_3076");
        }
    }

    public void prepare() {
    }

    public void setData(J2EEData j2eeData) throws SldServiceException {
        this.xmlmsg = null;
        try {
            if (j2eeData != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("<sapdata type=\"" + j2eeData.getType() + XML_CONST_DQUOTE + XML_CONST_SPACE + XML_ATTRIBUT_VERSION + XML_CONST_EQUAL + XML_CONST_DQUOTE + j2eeData.getVersion() + XML_CONST_DQUOTE + XML_TAG_END);
                Iterator cit = j2eeData.getClassIterator();
                while (cit.hasNext()) {
                    J2EEClass clazz = (J2EEClass)cit.next();
                    Iterator iit = clazz.instanceIterator();
                    while (iit.hasNext()) {
                        J2EEInst inst = (J2EEInst)iit.next();
                        buf.append("<instance classname=\"" + clazz.getName() + XML_CONST_DQUOTE);
                        if (inst.getID() != null && inst.getID().length() != 0) {
                            buf.append(" inst_id=\"" + inst.getID() + XML_CONST_DQUOTE + XML_TAG_END);
                        } else {
                            buf.append(XML_TAG_END);
                        }
                        if (inst.isAssociation()) {
                            Iterator refIt = inst.getRefIterator();
                            while (refIt.hasNext()) {
                                J2EEInst.J2EEInstRef ref = (J2EEInst.J2EEInstRef)refIt.next();
                                buf.append("<reference rolename=\"" + ref.getRoleName() + XML_CONST_DQUOTE + XML_CONST_SPACE + XML_ATTRIBUT_CLASSNAME + XML_CONST_EQUAL + XML_CONST_DQUOTE + ref.getClassName() + XML_CONST_DQUOTE + XML_CONST_SPACE + XML_ATTRIBUT_INST_ID + XML_CONST_EQUAL + XML_CONST_DQUOTE + ref.getInstId() + XML_CONST_DQUOTE + XML_CONST_SLASH + XML_TAG_END);
                            }
                        }
                        Iterator pit = inst.getPropertyIterator();
                        while (pit.hasNext()) {
                            J2EEInst.J2EEInstProp prop = (J2EEInst.J2EEInstProp)pit.next();
                            buf.append("<property name=\"" + prop.getName() + XML_CONST_DQUOTE + XML_TAG_END);
                            Iterator pvIt = prop.getValueIterator();
                            while (pvIt.hasNext()) {
                                String val = (String)pvIt.next();
                                buf.append("<value>" + BridgeCommunicationHTTP.prepareData(val) + XML_TAG_START + XML_CONST_SLASH + XML_TAG_VALUE + XML_TAG_END);
                            }
                            buf.append("</property>");
                        }
                        buf.append("</instance>");
                    }
                }
                buf.append("</sapdata>");
                this.xmlmsg = buf.toString();
                if (this.params != null && this.params.isFullDataTrace()) {
                    LOCATION.debugT("J2EE data: " + this.xmlmsg);
                }
            }
        }
        catch (Exception e) {
            throw new SldServiceException("sld_3001", new Object[]{e.getMessage()}, e);
        }
    }

    static String prepareData(String text) {
        int wlen;
        String result = "";
        int len = text.length();
        int start = 0;
        int i = 0;
        while (i < len) {
            String escape;
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    escape = "&lt;";
                    break;
                }
                case '>': {
                    escape = "&gt;";
                    break;
                }
                case '&': {
                    escape = "&amp;";
                    break;
                }
                case '\"': {
                    escape = "&quot;";
                    break;
                }
                case '\'': {
                    escape = "&apos;";
                    break;
                }
                default: {
                    escape = null;
                }
            }
            if (escape != null) {
                wlen = i - start;
                if (wlen > 0) {
                    result = result + text.substring(start, start + wlen);
                }
                start = i + 1;
                result = result + escape;
            } else if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\ud800' && ch <= '\udfff' || ch >= '\ufffe' && ch <= '\uffff') {
                wlen = i - start;
                if (wlen > 0) {
                    result = result + text.substring(start, start + wlen);
                }
                start = i + 1;
            }
            ++i;
        }
        wlen = len - start;
        if (wlen > 0) {
            result = result + text.substring(start, start + wlen);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

