/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv.auth;

import java.security.Permission;
import java.util.StringTokenizer;

public class SldPermission
extends Permission {
    static final long serialVersionUID = 2866332818582169394L;
    public static final String PERMISSION_NAME = "com.sap.sldserv.auth.SldPermission";
    public static final String TARGET_SLD = "sld";
    public static final String[] INSTANCES = new String[]{"sld"};
    public static final String GET_ACTION = "get";
    public static final String SET_ACTION = "set";
    public static final String ALL_ACTIONS = "*";
    public static final String[] ACTIONS = new String[]{"get", "set", "*"};
    public static final String TOKEN_SEPARATOR = ":";
    public static final char[] INVALID_ACTIONS_CHARACTERS = new char[]{'\"', '$', '{', '}', ' ', '.'};
    private String actions = null;

    public SldPermission(String name, String actions) throws IllegalArgumentException {
        super(name);
        SldPermission.checkForIllegalCharacters(actions);
        this.actions = actions;
    }

    public boolean implies(Permission permission) {
        boolean rvalue = false;
        if (permission instanceof SldPermission) {
            String target = permission.getName();
            String actions = permission.getActions();
            String[] thisActions = SldPermission.parseActions(actions);
            String[] otherActions = SldPermission.parseActions(((SldPermission)permission).actions);
            if (this.getName().equals(target)) {
                if (actions.equals(ALL_ACTIONS) || SldPermission.contains(thisActions, ALL_ACTIONS)) {
                    rvalue = true;
                } else {
                    rvalue = true;
                    int i = 0;
                    while (i < otherActions.length) {
                        if (otherActions[i].equals(ALL_ACTIONS)) {
                            if (!SldPermission.contains(thisActions, GET_ACTION) || !SldPermission.contains(thisActions, SET_ACTION)) {
                                rvalue = false;
                                break;
                            }
                        } else if (!SldPermission.contains(thisActions, otherActions[i])) {
                            rvalue = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return rvalue;
    }

    public boolean equals(Object obj) {
        boolean rvalue = true;
        if (obj != this) {
            if (!(obj instanceof SldPermission)) {
                rvalue = false;
            } else {
                SldPermission otherPerm = (SldPermission)obj;
                if (!otherPerm.getName().equals(this.getName())) {
                    rvalue = false;
                } else if (!this.actions.equals(otherPerm.actions)) {
                    rvalue = false;
                }
            }
        }
        return rvalue;
    }

    public int hashCode() {
        return this.actions.hashCode();
    }

    public String getActions() {
        return this.actions;
    }

    private static String[] parseActions(String actions) {
        String[] result = null;
        StringTokenizer tokenizer = new StringTokenizer(actions, TOKEN_SEPARATOR);
        result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return result;
    }

    private static void checkForIllegalCharacters(String actions) throws IllegalArgumentException {
        char[] actionsAsChars = actions.toCharArray();
        String result = "";
        int i = 0;
        while (i < actionsAsChars.length) {
            int j = 0;
            while (j < INVALID_ACTIONS_CHARACTERS.length) {
                if (INVALID_ACTIONS_CHARACTERS[j] == actionsAsChars[i]) {
                    result = result + "pos: " + i + ", char: '" + actionsAsChars[i] + "'\n";
                }
                ++j;
            }
            ++i;
        }
        if (result.length() > 0) {
            throw new IllegalArgumentException("Invalid characters found: " + result);
        }
    }

    private static boolean contains(String[] a, String s) {
        boolean rvalue = false;
        if (a != null && s != null) {
            int i = 0;
            while (i < a.length) {
                if (a[i].equals(s)) {
                    rvalue = true;
                    break;
                }
                ++i;
            }
        }
        return rvalue;
    }
}

