/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.sldserv.DataCollector;
import com.sap.sldserv.Params;
import com.sap.sldserv.ServiceManagement;
import com.sap.sldserv.ServiceManagementInterface;
import com.sap.sldserv.ServiceManagementRmi;
import com.sap.sldserv.ServiceManagementRmiInterface;
import com.sap.sldserv.SldApplicationService;
import com.sap.sldserv.SldApplicationServiceInterface;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SldServerFrame
implements ApplicationServiceFrame {
    private ApplicationServiceContext applServCtx = null;
    private TimeoutManager timeoutMgr = null;
    private LockingContext lockCtx = null;
    private ServerInternalLocking siLocking = null;
    private DataCollector dataCollector = null;
    private Params cfgParams = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldServerFrame == null ? (class$com$sap$sldserv$SldServerFrame = SldServerFrame.class$("com.sap.sldserv.SldServerFrame")) : class$com$sap$sldserv$SldServerFrame));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private ServiceManagementInterface serviceManagement = null;
    private ServiceManagementRmiInterface serviceManagementRmi = null;
    private SldApplicationServiceInterface serviceForApplications = null;
    static /* synthetic */ Class class$com$sap$sldserv$SldServerFrame;

    public void start(ApplicationServiceContext servCtx) throws ServiceException {
        this.applServCtx = servCtx;
        this.start();
    }

    protected void start() throws ServiceException {
        String method = "start(void)";
        try {
            LOCATION.debugT("start(void)", ResourceUtil.formatString("sld_9073"));
            if (!this.setParams()) {
                LOCATION.debugT("start(void)", ResourceUtil.formatString("sld_9040"));
            }
            this.initTimer();
            this.initLocking();
            this.initDataCollector();
            this.initAdminInterface();
            this.initRmiInterface();
            this.initApplicationInterface();
            LOCATION.debugT("start(void)", ResourceUtil.formatString("sld_9011"));
        }
        catch (Exception e) {
            CATEGORY.errorT(LOCATION, ResourceUtil.formatString("sld_3012"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"start(void)", (Throwable)e);
            throw new ServiceException("sld_3012", null, e);
        }
    }

    public void stop() {
        String method = "stop";
        this.dataCollector.stopRequest();
        this.timeoutMgr.unregisterTimeoutListener((TimeoutListener)this.dataCollector);
        this.applServCtx.getServiceState().unregisterManagementInterface();
        this.applServCtx.getClusterContext().getMessageContext().unregisterListener();
        LOCATION.debugT("stop", ResourceUtil.formatString("sld_9012"));
    }

    private boolean setParams() throws ServiceException {
        this.cfgParams = new Params(this.applServCtx);
        this.cfgParams.printParametersToLog();
        return this.cfgParams.hasValidConnectParams();
    }

    private void initTimer() throws SldServiceException {
        try {
            this.timeoutMgr = (TimeoutManager)this.applServCtx.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
        }
        catch (Exception e) {
            throw new SldServiceException("sld_1004");
        }
    }

    private void initLocking() throws SldServiceException {
        try {
            this.lockCtx = this.applServCtx.getCoreContext().getLockingContext();
            this.siLocking = this.lockCtx.createServerInternalLocking("_SLD_", "SLD");
        }
        catch (Exception e) {
            throw new SldServiceException("sld_1005", e);
        }
    }

    private void initApplicationInterface() throws SldServiceException {
        String method = "start(void)";
        InitialContext applContext = null;
        try {
            applContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new SldServiceException(e);
        }
        try {
            this.serviceForApplications = (SldApplicationService)applContext.lookup("applsld");
        }
        catch (NamingException e) {
            this.serviceForApplications = new SldApplicationService(this.applServCtx);
            try {
                applContext.bind("applsld", (Object)this.serviceForApplications);
            }
            catch (NamingException e1) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3063"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"start(void)", (Throwable)e);
            }
        }
    }

    private void initRmiInterface() throws RemoteException {
        this.serviceManagementRmi = new ServiceManagementRmi(this.applServCtx, this.cfgParams, this.dataCollector);
        this.applServCtx.getContainerContext().getObjectRegistry().registerInterface((Object)this.serviceManagementRmi);
    }

    private void initAdminInterface() throws ServiceException {
        this.serviceManagement = new ServiceManagement(this.applServCtx, this.dataCollector);
        this.applServCtx.getServiceState().registerManagementInterface((ManagementInterface)this.serviceManagement);
    }

    private void initDataCollector() throws SldServiceException {
        this.dataCollector = new DataCollector(this.applServCtx, this.cfgParams, this.siLocking);
        this.timeoutMgr.registerTimeoutListener((TimeoutListener)this.dataCollector, this.cfgParams.getInitialDelayTimeMs(), this.cfgParams.getRepeatTimeMs(), 0L, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

