/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.security.SldPermission;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.sldserv.SldApplicationServiceInterface;
import com.sap.sldserv.auth.SecureStoreSld;
import com.sap.sldserv.auth.SecureStoreSldInterface;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.exception.SldServiceRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Properties;

public class SldApplicationService
implements SldApplicationServiceInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldApplicationService == null ? (class$com$sap$sldserv$SldApplicationService = SldApplicationService.class$("com.sap.sldserv.SldApplicationService")) : class$com$sap$sldserv$SldApplicationService));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private ApplicationServiceContext applServCtx;
    private SecureStoreSldInterface secureStore = null;
    static /* synthetic */ Class class$com$sap$sldserv$SldApplicationService;

    protected SldApplicationService(ApplicationServiceContext applServCtx) throws SldServiceException {
        String method = "SldApplicationService";
        this.applServCtx = applServCtx;
        try {
            this.secureStore = new SecureStoreSld(applServCtx);
        }
        catch (SldServiceException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3057"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"SldApplicationService", (Throwable)((Object)e));
            throw e;
        }
    }

    public String getProtocol() throws SldServiceRuntimeException {
        String method = "getProtocol";
        try {
            Properties genProp = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
            if (genProp != null) {
                String useHttps = genProp.getProperty("UseHttps");
                return useHttps != null && useHttps.equalsIgnoreCase("true") ? "https" : "http";
            }
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3059"));
            throw new SldServiceRuntimeException(ResourceUtil.formatString("sld_3059"));
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3077"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getProtocol", (Throwable)e);
            throw new SldServiceRuntimeException(ResourceUtil.formatString("sld_3077"));
        }
    }

    public CIMOMClient getCimClient() throws SldServiceRuntimeException {
        String method = "getCIMClient";
        try {
            Properties genProp = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
            if (genProp != null) {
                try {
                    AccessController.checkPermission((Permission)new SldPermission("SLD", "read"));
                    String host = genProp.getProperty("HttpHost");
                    int port = Integer.parseInt(genProp.getProperty("HttpPort"));
                    String user = genProp.getProperty("HttpUser");
                    String pass = genProp.getProperty("HttpPassword");
                    String useHttps = genProp.getProperty("UseHttps");
                    URL url = useHttps != null && useHttps.equalsIgnoreCase("true") ? ClientFactory.newSAPHttpsURL((String)host, (int)port) : ClientFactory.newSAPHttpURL((String)host, (int)port);
                    return ClientFactory.newInstance().createClient(url, user, pass);
                }
                catch (AccessControlException e) {
                    CATEGORY.infoT(LOCATION, ResourceUtil.formatString("sld_3058"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getCIMClient", (Throwable)e);
                    throw new SldServiceRuntimeException(ResourceUtil.formatString("sld_3058"));
                }
            }
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3059"));
            throw new SldServiceRuntimeException(ResourceUtil.formatString("sld_3059"));
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3051"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getCIMClient", (Throwable)e);
            throw new SldServiceRuntimeException(ResourceUtil.formatString("sld_3051"));
        }
    }

    private String getGenerationProperty(String propertyName) {
        String method = "getGenerationProperty";
        String rvalue = null;
        Properties genProps = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
        if (genProps != null) {
            try {
                AccessController.checkPermission((Permission)new SldPermission("SLD", "read"));
                rvalue = genProps.getProperty(propertyName);
            }
            catch (AccessControlException e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3058"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getGenerationProperty", (Throwable)e);
            }
        }
        return rvalue;
    }

    public String getCimHost() {
        return this.getGenerationProperty("HttpHost");
    }

    public int getCimPort() {
        int rvalue = -1;
        try {
            rvalue = Integer.parseInt(this.getGenerationProperty("HttpPort"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rvalue;
    }

    public String getCimUser() {
        return this.getGenerationProperty("HttpUser");
    }

    public String getCimPass() {
        return this.getGenerationProperty("HttpPassword");
    }

    public int getServerNodesCount() {
        String method = "getServerNodesCount";
        int rvalue = 1;
        try {
            ClusterElement[] clusterElements = this.applServCtx.getClusterContext().getClusterMonitor().getParticipants();
            int i = 0;
            while (i < clusterElements.length) {
                if (clusterElements[i].getType() == 2) {
                    ++rvalue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOCATION.errorT("getServerNodesCount", ResourceUtil.formatString("sld_3075"));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"getServerNodesCount", (Throwable)e);
            rvalue = -1;
        }
        return rvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

