/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.DataCollector;
import com.sap.sldserv.Params;
import com.sap.sldserv.ServiceManagementRmiInterface;
import com.sap.sldserv.auth.SecureStoreSld;
import com.sap.sldserv.auth.SecureStoreSldInterface;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class ServiceManagementRmi
extends PortableRemoteObject
implements ServiceManagementRmiInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldServerFrame == null ? (class$com$sap$sldserv$SldServerFrame = ServiceManagementRmi.class$("com.sap.sldserv.SldServerFrame")) : class$com$sap$sldserv$SldServerFrame));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private Params params = null;
    private SecureStoreSldInterface secureStore = null;
    private ApplicationServiceContext applServCtx = null;
    private DataCollector dataCollector = null;
    static /* synthetic */ Class class$com$sap$sldserv$SldServerFrame;

    public ServiceManagementRmi(ApplicationServiceContext applServCtx, Params params, DataCollector dataCollector) throws RemoteException {
        String method = "ServiceManagementRmi";
        this.params = params;
        this.applServCtx = applServCtx;
        this.dataCollector = dataCollector;
        try {
            this.secureStore = new SecureStoreSld(applServCtx);
        }
        catch (SldServiceException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3057"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"ServiceManagementRmi", (Throwable)((Object)e));
            throw new RemoteException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Properties getConfigParams() {
        Properties props = new Properties();
        props.setProperty("VersionId", this.params.getVersionId());
        props.setProperty("TypeId", this.params.getTypeId());
        this.params.refreshConfig();
        Params.RuntimeParams rtParam = this.params.getRuntimeParams().getClone();
        props.setProperty("GatewayHost", rtParam.getGatewayHost());
        props.setProperty("GatewayService", rtParam.getGatewayService());
        props.setProperty("RegistrationId", rtParam.getRegId());
        props.setProperty("RepeatTimeMinutes", String.valueOf(rtParam.getRepeatTimeMin()));
        props.setProperty("HttpHost", rtParam.getHttpHost());
        props.setProperty("HttpPort", String.valueOf(rtParam.getHttpPort()));
        props.setProperty("HttpUser", rtParam.getHttpUser());
        props.setProperty("HttpPassword", rtParam.getHttpPassword());
        return props;
    }

    public boolean setConfigParams(Properties props) {
        String method = "setConfigParams";
        Params.RuntimeParams p = this.params.getRuntimeParams().getClone();
        Iterator it = ((Hashtable)props).keySet().iterator();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            p.setParameter(keyName, (String)((Hashtable)props).get(keyName));
            if (keyName.equalsIgnoreCase("HttpPassword")) continue;
            LOCATION.debugT("setConfigParams", ResourceUtil.formatStringNoParameterLocalization("sld_9053", new Object[]{keyName, ((Hashtable)props).get(keyName)}));
        }
        this.params.getRuntimeParams().setClone(p);
        Properties genProps = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
        if (this.isInitial(genProps)) {
            genProps = new Properties();
            ((Hashtable)genProps).put("HttpHost", p.getHttpHost());
            ((Hashtable)genProps).put("HttpPort", p.getHttpPortAsString());
            ((Hashtable)genProps).put("HttpUser", p.getHttpUser());
            ((Hashtable)genProps).put("HttpPassword", p.getHttpPassword());
            ((Hashtable)genProps).put("UseHttps", String.valueOf(p.getHttpsSetting()));
        }
        boolean b1 = this.params.setSecureStoreRfcParams();
        boolean b2 = this.params.setSecureStoreHttpParams();
        boolean b3 = this.secureStore.setInSecureStore("SLD_Service_Generation_Data", genProps);
        return b1 && b2 && b3;
    }

    private boolean isInitial(Properties props) {
        boolean rvalue = true;
        if (props != null) {
            rvalue = false;
            Iterator it = ((Hashtable)props).values().iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                if (v != null && v.length() != 0 && !v.equals("-1")) continue;
                rvalue = true;
                break;
            }
        }
        return rvalue;
    }

    public boolean setConfigParams(boolean runCollector, Properties props) {
        String method = "setConfigParams";
        boolean rvalue = this.setConfigParams(props);
        if (rvalue && runCollector && this.dataCollector != null) {
            this.applServCtx.getCoreContext().getThreadSystem().startThread((Runnable)new Collect(this.dataCollector), true);
            LOCATION.debugT("setConfigParams", ResourceUtil.formatString("sld_9080"));
        }
        return rvalue;
    }

    public boolean setGenerationInfo(String host, int port, String user, String pass) {
        Properties genProps = new Properties();
        ((Hashtable)genProps).put("HttpHost", host);
        ((Hashtable)genProps).put("HttpPort", String.valueOf(port));
        ((Hashtable)genProps).put("HttpUser", user);
        ((Hashtable)genProps).put("HttpPassword", pass);
        return this.secureStore.setInSecureStore("SLD_Service_Generation_Data", genProps);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Collect
    implements Runnable {
        private DataCollector dataCollector = null;

        Collect(DataCollector dataCollector) {
            this.dataCollector = dataCollector;
        }

        public void run() {
            String method = "Collect.run";
            try {
                LOCATION.debugT("Collect.run", ResourceUtil.formatString("sld_9081"));
                this.dataCollector.timeoutProcessing();
                LOCATION.debugT("Collect.run", ResourceUtil.formatString("sld_9082"));
            }
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3074"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"Collect.run", (Throwable)e);
            }
        }
    }
}

