/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.security.domains.PRecord;
import com.sap.engine.services.security.remote.RemoteAuthorization;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import com.sap.engine.services.security.roles.SecurityRoleReference;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.sldserv.DataCollector;
import com.sap.sldserv.SendInfo;
import com.sap.sldserv.ServiceManagementInterface;
import com.sap.sldserv.ServiceManagementResponse;
import com.sap.sldserv.auth.SecureStoreSld;
import com.sap.sldserv.auth.SecureStoreSldInterface;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.util.RoleMapInfo;
import com.sap.sldserv.util.ServiceUtils;
import com.sap.sldserv.util.XMLRoleParser;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.URL;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ServiceManagement
implements ServiceManagementInterface {
    public static final int DEFAULT_READ_TIMEOUT_MS = 20000;
    private static final int MAX_ATTEMPTS = 10;
    private static final String PATH_PARA = "nr";
    private static final String PATH_PARA_DELIM = "$";
    private static final String CONFIGURATION_MANAGER_LOCAL_PATH = "cluster_data/server/ID$nr$/services/security";
    private static final String CONFIGURATION_MANAGER_GLOBAL_PATH = "cluster_data/server/cfg/services/security";
    private static final String SECURITY_CONFIGURATION_PARAM_NAME = "SynchPermissionsWithDatabase";
    private static final String PREFIX_SERVICE = "service";
    private static final String PREFIX_LIBRARY = "ext";
    private static final String PREFIX_INTERFACE = "interface";
    private static final String ROLES_FILE_NAME = "sldroles.xml";
    private static final String ROLES_ARCHIVE_PATH = "xmlroles/";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldServerFrame == null ? (class$com$sap$sldserv$SldServerFrame = ServiceManagement.class$("com.sap.sldserv.SldServerFrame")) : class$com$sap$sldserv$SldServerFrame));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private DataCollector dataCollector = null;
    private ApplicationServiceContext applServCtx = null;
    private InitialContext jndiCtx = null;
    private SecureStoreSldInterface secureStore = null;
    static /* synthetic */ Class class$com$sap$sldserv$SldServerFrame;
    static /* synthetic */ Class class$com$sap$sldserv$ServiceManagement;
    static /* synthetic */ Class class$com$sap$engine$lib$security$SldPermission;

    public ServiceManagement(ApplicationServiceContext applServCtx, DataCollector dataCollector) {
        String method = "ServiceManagement";
        this.dataCollector = dataCollector;
        this.applServCtx = applServCtx;
        try {
            this.jndiCtx = new InitialContext();
            this.secureStore = new SecureStoreSld(applServCtx);
        }
        catch (NamingException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3055"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"ServiceManagement", (Throwable)e);
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3056"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"ServiceManagement", (Throwable)e);
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public ServiceManagementResponse doCollect() {
        return this.dataCollector.doMgmCollect();
    }

    public SendInfo getLastSendInfo() {
        return this.dataCollector.getLastSendInfo();
    }

    public String getCollectorInformation() {
        return this.dataCollector.getCollectorInformation();
    }

    public int getCollectorProgress() {
        return this.dataCollector.getCollectorProgress();
    }

    public int getCollectorStatus() {
        return this.dataCollector.getCollectorStatus();
    }

    public Properties getConfigParams() {
        return this.dataCollector.getConfigParams();
    }

    public boolean hasValidConnectParams() {
        return this.dataCollector.hasValidConnectParams();
    }

    public boolean setConfigParams(Properties props) {
        return this.dataCollector.setConfigParams(props);
    }

    public boolean deleteRfcParams() {
        return this.dataCollector.deleteRfcParams();
    }

    public boolean deleteHttpParams() {
        return this.dataCollector.deleteHttpParams();
    }

    public String[] getDomainNames() {
        String method = "getDomainNames";
        Object[] domainNames = null;
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$ServiceManagement == null ? (class$com$sap$sldserv$ServiceManagement = ServiceManagement.class$("com.sap.sldserv.ServiceManagement")) : class$com$sap$sldserv$ServiceManagement).getClassLoader());
        try {
            try {
                RemoteSecurity rs = (RemoteSecurity)this.jndiCtx.lookup("remotesecurity");
                domainNames = this.filterApplicationDomains(rs.getProtectionDomains().getDomainsNames());
                Arrays.sort(domainNames);
            }
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3054"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getDomainNames", (Throwable)e);
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(savedLoader);
            throw throwable;
        }
        return domainNames;
    }

    public Set getSldPermissionsForDomains() {
        String method = "getSldPermissionsForDomains";
        HashSet<String> rvalue = new HashSet<String>();
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$ServiceManagement == null ? (class$com$sap$sldserv$ServiceManagement = ServiceManagement.class$("com.sap.sldserv.ServiceManagement")) : class$com$sap$sldserv$ServiceManagement).getClassLoader());
        try {
            try {
                RemoteSecurity rs = (RemoteSecurity)this.jndiCtx.lookup("remotesecurity");
                if (rs != null) {
                    RemoteProtectionDomains rpd = rs.getProtectionDomains();
                    try {
                        String[] domainNames = this.getDomainNames();
                        if (domainNames != null) {
                            int i = 0;
                            while (i < domainNames.length) {
                                if (this.containsSldPermissions(rpd.getPermissions(domainNames[i]))) {
                                    rvalue.add(domainNames[i]);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (RemoteException e) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3052"));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSldPermissionsForDomains", (Throwable)e);
                    }
                }
                Object var9_10 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3052"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSldPermissionsForDomains", (Throwable)e);
                Object var9_11 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Thread.currentThread().setContextClassLoader(savedLoader);
            throw throwable;
        }
        return rvalue;
    }

    public boolean setSldPermissionsForDomains(Set domains) {
        String method = "setSldPermissionsForDomains";
        boolean rvalue = true;
        String[] allDomains = this.getDomainNames();
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$ServiceManagement == null ? (class$com$sap$sldserv$ServiceManagement = ServiceManagement.class$("com.sap.sldserv.ServiceManagement")) : class$com$sap$sldserv$ServiceManagement).getClassLoader());
        try {
            try {
                RemoteSecurity rs = (RemoteSecurity)this.jndiCtx.lookup("remotesecurity");
                RemoteProtectionDomains rpd = rs.getProtectionDomains();
                int i = 0;
                while (i < allDomains.length) {
                    if (domains != null && domains.size() > 0 && domains.contains(allDomains[i])) {
                        rpd.grantPermission(allDomains[i], (class$com$sap$engine$lib$security$SldPermission == null ? ServiceManagement.class$("com.sap.engine.lib.security.SldPermission") : class$com$sap$engine$lib$security$SldPermission).getName(), "SLD", "read");
                    } else if (this.containsSldPermissions(rpd.getPermissions(allDomains[i]))) {
                        rpd.clearPermission(allDomains[i], (class$com$sap$engine$lib$security$SldPermission == null ? ServiceManagement.class$("com.sap.engine.lib.security.SldPermission") : class$com$sap$engine$lib$security$SldPermission).getName(), "SLD", "read");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3053"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSldPermissionsForDomains", (Throwable)e);
                rvalue = false;
                Object var10_11 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            Object var10_10 = null;
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            Thread.currentThread().setContextClassLoader(savedLoader);
            throw throwable;
        }
        return rvalue;
    }

    public Properties getGenerationParams() {
        return (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
    }

    public boolean setGenerationParams(Properties genInfo) {
        return this.secureStore.setInSecureStore("SLD_Service_Generation_Data", genInfo);
    }

    public boolean validateCimClient() {
        String method = "validateCimClient";
        boolean rvalue = false;
        CIMOMClient cimClient = this.getCimClient();
        if (cimClient != null) {
            try {
                ClientUtil.ping((CIMOMHandle)cimClient);
                rvalue = true;
                cimClient.getRequestSender().disconnect();
            }
            catch (Throwable e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3062"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"validateCimClient", (Throwable)e);
            }
        }
        return rvalue;
    }

    private CIMOMClient getCimClient() {
        String method = "getCimClient";
        CIMOMClient rvalue = null;
        try {
            Properties genProp = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data");
            if (genProp != null) {
                String host = genProp.getProperty("HttpHost");
                int port = Integer.parseInt(genProp.getProperty("HttpPort"));
                String user = genProp.getProperty("HttpUser");
                String pass = genProp.getProperty("HttpPassword");
                String useHttps = genProp.getProperty("UseHttps");
                URL url = useHttps != null && useHttps.equalsIgnoreCase("true") ? ClientFactory.newSAPHttpsURL((String)host, (int)port) : ClientFactory.newSAPHttpURL((String)host, (int)port);
                rvalue = ClientFactory.newInstance().createClient(url, user, pass);
                HttpRequestSender reqSender = (HttpRequestSender)rvalue.getRequestSender();
                reqSender.getConnection().setSocketReadTimeout(20000);
                return rvalue;
            }
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3059"));
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3051"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getCimClient", (Throwable)e);
        }
        return rvalue;
    }

    public boolean domainInfoIsPersistent() {
        String localConfigPath = ServiceManagement.convertConfigPath(CONFIGURATION_MANAGER_LOCAL_PATH, PATH_PARA, PATH_PARA_DELIM, this.getNodeId());
        String globalConfigPath = CONFIGURATION_MANAGER_GLOBAL_PATH;
        String propValue = null;
        boolean global = true;
        boolean local = true;
        propValue = this.getSystemProperty(globalConfigPath, SECURITY_CONFIGURATION_PARAM_NAME);
        if (propValue != null) {
            boolean bl = global = propValue.equalsIgnoreCase(Boolean.TRUE.toString());
        }
        if ((propValue = this.getSystemProperty(localConfigPath, SECURITY_CONFIGURATION_PARAM_NAME)) != null) {
            local = propValue.equalsIgnoreCase(Boolean.TRUE.toString());
        }
        return global && local || !global && local;
    }

    public boolean performRoleMapping() {
        return this.performRoleMappingRemoteIf();
    }

    public boolean performRoleMappingLocalIf() {
        boolean rvalue;
        block21: {
            String method = "performRoleMappingLocalIf";
            rvalue = false;
            InputStream is = this.getClass().getResourceAsStream("xmlroles/sldroles.xml");
            if (is != null) {
                try {
                    SecurityContext securityObj = (SecurityContext)this.applServCtx.getContainerContext().getObjectRegistry().getServiceInterface("security");
                    if (securityObj != null) {
                        UserStoreFactory usf = securityObj.getUserStoreContext();
                        UserStore us = usf.getActiveUserStore();
                        GroupContext gc = us.getGroupContext();
                        RoleMapInfo mapInfo = XMLRoleParser.parseMapFile(is);
                        Iterator it = mapInfo.getConfigIdIterator();
                        while (it.hasNext()) {
                            Map.Entry me = (Map.Entry)it.next();
                            String configId = (String)me.getKey();
                            SecurityRoleContext securityRoleContext = securityObj.getPolicyConfigurationContext(configId).getAuthorizationContext().getSecurityRoleContext();
                            SecurityRole[] allRoles = securityObj.getPolicyConfigurationContext(configId).getAuthorizationContext().getSecurityRoleContext().listSecurityRoles();
                            ArrayList mappings = (ArrayList)me.getValue();
                            Iterator iter = ((AbstractList)mappings).iterator();
                            while (iter.hasNext()) {
                                RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                                String abapRole = pair.getFirst();
                                try {
                                    gc.getGroupInfo(abapRole);
                                }
                                catch (Exception e) {
                                    LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_3070", new Object[]{configId, abapRole}));
                                    mapInfo.addRemove(configId, pair);
                                    continue;
                                }
                                String j2eeRole = pair.getSecond();
                                boolean found = false;
                                int i = 0;
                                while (i < allRoles.length) {
                                    if (allRoles[i].getName().equalsIgnoreCase(j2eeRole)) {
                                        found = true;
                                        break;
                                    }
                                    ++i;
                                }
                                if (found) continue;
                                LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_3072", new Object[]{j2eeRole}));
                                mapInfo.addRemove(configId, pair);
                            }
                            mapInfo.commitRemove();
                            int i = 0;
                            while (i < allRoles.length) {
                                String roleName = allRoles[i].getName();
                                if (allRoles[i] instanceof SecurityRoleReference && mapInfo.containsJ2eeRole(configId, roleName)) {
                                    String[] users = allRoles[i].getUsers();
                                    String[] groups = allRoles[i].getGroups();
                                    securityRoleContext.removeSecurityRole(roleName);
                                    securityRoleContext.addSecurityRole(roleName);
                                    SecurityRole newRole = securityRoleContext.getSecurityRole(roleName);
                                    LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9077", new Object[]{configId, roleName}));
                                    int j = 0;
                                    while (j < users.length) {
                                        newRole.addUser(users[j]);
                                        LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9078", new Object[]{configId, roleName, users[j]}));
                                        ++j;
                                    }
                                    int j2 = 0;
                                    while (j2 < groups.length) {
                                        newRole.addGroup(groups[j2]);
                                        LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9079", new Object[]{configId, roleName, groups[j2]}));
                                        ++j2;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (mapInfo.hasMappings()) {
                            Iterator it2 = mapInfo.getConfigIdIterator();
                            while (it2.hasNext()) {
                                Map.Entry me = (Map.Entry)it2.next();
                                String configId = (String)me.getKey();
                                ArrayList mappings = (ArrayList)me.getValue();
                                LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9075", new Object[]{configId, String.valueOf(mappings.size())}));
                                Iterator iter = ((AbstractList)mappings).iterator();
                                while (iter.hasNext()) {
                                    RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                                    String abapRole = pair.getFirst();
                                    String j2eeRole = pair.getSecond();
                                    SecurityContext sc = securityObj.getPolicyConfigurationContext(configId);
                                    AuthorizationContext ac = sc.getAuthorizationContext();
                                    SecurityRoleContext src = ac.getSecurityRoleContext();
                                    SecurityRole sr = src.getSecurityRole(j2eeRole);
                                    try {
                                        sr.addGroup(abapRole);
                                        rvalue = true;
                                        LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9076", new Object[]{configId, abapRole, j2eeRole}));
                                    }
                                    catch (Exception e) {
                                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3071", new Object[]{configId, abapRole, j2eeRole}));
                                    }
                                }
                            }
                            LOCATION.debugT("performRoleMappingLocalIf", ResourceUtil.formatString("sld_9074"));
                        } else {
                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3073"));
                        }
                        break block21;
                    }
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3068"));
                }
                catch (Exception e) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3071"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"performRoleMappingLocalIf", (Throwable)e);
                }
            } else {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3069"));
            }
        }
        return rvalue;
    }

    public boolean performRoleMappingRemoteIf() {
        String method = "performRoleMappingRemoteIf";
        boolean rvalue = false;
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$ServiceManagement == null ? (class$com$sap$sldserv$ServiceManagement = ServiceManagement.class$("com.sap.sldserv.ServiceManagement")) : class$com$sap$sldserv$ServiceManagement).getClassLoader());
        InputStream is = this.getClass().getResourceAsStream("xmlroles/sldroles.xml");
        if (is != null) {
            try {
                block22: {
                    try {
                        RemoteSecurity remoteSecurity = (RemoteSecurity)this.jndiCtx.lookup("remotesecurity");
                        if (remoteSecurity != null) {
                            RemoteUserStoreFactory rusf = remoteSecurity.getRemoteUserStoreFactory();
                            RemoteUserStore rus = rusf.getActiveUserStore();
                            RemoteGroupContext rgc = rus.getGroupContext();
                            RoleMapInfo mapInfo = XMLRoleParser.parseMapFile(is);
                            Iterator it = mapInfo.getConfigIdIterator();
                            while (it.hasNext()) {
                                Map.Entry me = (Map.Entry)it.next();
                                String configId = (String)me.getKey();
                                ArrayList mappings = (ArrayList)me.getValue();
                                RemoteSecurityRoles rsrs = remoteSecurity.getPolicyConfiguration(configId).getAuthorization().getSecurityRoles();
                                SecurityRole[] allRoles = rsrs.listSecurityRoles();
                                Iterator iter = ((AbstractList)mappings).iterator();
                                while (iter.hasNext()) {
                                    RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                                    String abapRole = pair.getFirst();
                                    try {
                                        rgc.getGroupInfo(abapRole);
                                    }
                                    catch (Exception e) {
                                        LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_3070", new Object[]{configId, abapRole}));
                                        mapInfo.addRemove(configId, pair);
                                        continue;
                                    }
                                    String j2eeRole = pair.getSecond();
                                    boolean found = false;
                                    int i = 0;
                                    while (i < allRoles.length) {
                                        if (allRoles[i].getName().equalsIgnoreCase(j2eeRole)) {
                                            found = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (found) continue;
                                    LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_3072", new Object[]{j2eeRole}));
                                    mapInfo.addRemove(configId, pair);
                                }
                                mapInfo.commitRemove();
                                int i = 0;
                                while (i < allRoles.length) {
                                    String roleName = allRoles[i].getName();
                                    if (allRoles[i] instanceof SecurityRoleReference && mapInfo.containsJ2eeRole(configId, roleName)) {
                                        String[] users = allRoles[i].getUsers();
                                        String[] groups = allRoles[i].getGroups();
                                        rsrs.removeSecurityRole(roleName);
                                        rsrs.addSecurityRole(roleName);
                                        SecurityRole newRole = rsrs.getSecurityRole(roleName);
                                        LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_9077", new Object[]{configId, roleName}));
                                        int j = 0;
                                        while (j < users.length) {
                                            newRole.addUser(users[j]);
                                            LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_9078", new Object[]{configId, roleName, users[j]}));
                                            ++j;
                                        }
                                        int j2 = 0;
                                        while (j2 < groups.length) {
                                            newRole.addGroup(groups[j2]);
                                            LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_9079", new Object[]{configId, roleName, groups[j2]}));
                                            ++j2;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            if (mapInfo.hasMappings()) {
                                Iterator it2 = mapInfo.getConfigIdIterator();
                                while (it2.hasNext()) {
                                    Map.Entry me = (Map.Entry)it2.next();
                                    String configId = (String)me.getKey();
                                    ArrayList mappings = (ArrayList)me.getValue();
                                    RemotePolicyConfiguration rpc = remoteSecurity.getPolicyConfiguration(configId);
                                    RemoteAuthorization ra = rpc.getAuthorization();
                                    RemoteSecurityRoles rsr = ra.getSecurityRoles();
                                    Iterator iter = ((AbstractList)mappings).iterator();
                                    while (iter.hasNext()) {
                                        RoleMapInfo.Pair pair = (RoleMapInfo.Pair)iter.next();
                                        String abapRole = pair.getFirst();
                                        String j2eeRole = pair.getSecond();
                                        SecurityRole sr = rsr.getSecurityRole(j2eeRole);
                                        try {
                                            sr.addGroup(abapRole);
                                            rsr.modifySecurityRole(sr);
                                            rvalue = true;
                                            LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_9076", new Object[]{configId, abapRole, j2eeRole}));
                                        }
                                        catch (Exception e) {
                                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3071", new Object[]{configId, abapRole, j2eeRole}));
                                            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"performRoleMappingRemoteIf", (Throwable)e);
                                        }
                                    }
                                }
                                LOCATION.debugT("performRoleMappingRemoteIf", ResourceUtil.formatString("sld_9074"));
                            } else {
                                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3073"));
                            }
                            break block22;
                        }
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3068"));
                    }
                    catch (Exception e) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3071"));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"performRoleMappingRemoteIf", (Throwable)e);
                        Object var25_37 = null;
                        Thread.currentThread().setContextClassLoader(savedLoader);
                    }
                }
                Object var25_36 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            catch (Throwable throwable) {
                Object var25_38 = null;
                Thread.currentThread().setContextClassLoader(savedLoader);
                throw throwable;
            }
        }
        return rvalue;
    }

    /*
     * WARNING - void declaration
     */
    private static String convertConfigPath(String inStr, String inParamStr, String delimStr, String paramValueStr) {
        int i1;
        StringBuffer result = new StringBuffer(inStr);
        String searchPattern = delimStr + inParamStr + delimStr;
        while ((i1 = result.toString().indexOf(searchPattern)) >= 0) {
            void var6_6;
            void i2 = var6_6 + searchPattern.length();
            String s1 = result.toString().substring(0, (int)var6_6);
            String s2 = result.toString().substring((int)i2, result.length());
            result = new StringBuffer(s1 + paramValueStr + s2);
        }
        return result.toString();
    }

    private String getNodeId() {
        return String.valueOf(this.applServCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId());
    }

    private boolean containsSldPermissions(Vector v) {
        boolean rvalue = false;
        int i = 0;
        while (i < v.size()) {
            PRecord p = (PRecord)v.get(i);
            if (p.getClassName().equals((class$com$sap$engine$lib$security$SldPermission == null ? ServiceManagement.class$("com.sap.engine.lib.security.SldPermission") : class$com$sap$engine$lib$security$SldPermission).getName()) && p.getActions().equals("read")) {
                rvalue = true;
                break;
            }
            ++i;
        }
        return rvalue;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSystemProperty(String cfgPath, String propName) {
        ConfigurationHandler cfgHandler;
        String rvalue;
        block14: {
            String method = "getSystemProperty";
            rvalue = null;
            cfgHandler = null;
            ConfigurationHandlerFactory cfgHdlFctry = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            cfgHandler = cfgHdlFctry.getConfigurationHandler();
            Configuration someCfg = null;
            int i = 0;
            while (i < 10) {
                try {
                    someCfg = cfgHandler.openConfiguration(cfgPath, 1);
                    break;
                }
                catch (ConfigurationLockedException e) {
                    LOCATION.debugT("getSystemProperty", ResourceUtil.formatString("sld_9059"));
                    ServiceUtils.waitSeconds(1L);
                    ++i;
                }
            }
            if (i == 10) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3064", new Object[]{propName, String.valueOf(i)}));
                break block14;
            }
            if (someCfg == null) break block14;
            PropertySheet propSheet = someCfg.getPropertySheetInterface();
            PropertyEntry propEntry = propSheet.getPropertyEntry(propName);
            rvalue = (String)propEntry.getValue();
        }
        Object var12_14 = null;
        if (cfgHandler == null) return rvalue;
        try {
            cfgHandler.closeAllConfigurations();
            return rvalue;
        }
        catch (ConfigurationException e2) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSystemProperty", (Throwable)e2);
        }
        return rvalue;
        {
            catch (NameNotFoundException e) {
                Object var12_15 = null;
                if (cfgHandler == null) return rvalue;
                try {
                    cfgHandler.closeAllConfigurations();
                    return rvalue;
                }
                catch (ConfigurationException e2) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSystemProperty", (Throwable)e2);
                }
                return rvalue;
            }
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3061", new Object[]{propName}));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSystemProperty", (Throwable)e);
                Object var12_16 = null;
                if (cfgHandler == null) return rvalue;
                try {
                    cfgHandler.closeAllConfigurations();
                    return rvalue;
                }
                catch (ConfigurationException e2) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSystemProperty", (Throwable)e2);
                }
                return rvalue;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (cfgHandler == null) throw throwable;
            try {
                cfgHandler.closeAllConfigurations();
                throw throwable;
            }
            catch (ConfigurationException e2) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getSystemProperty", (Throwable)e2);
            }
            throw throwable;
        }
    }

    private String[] filterApplicationDomains(String[] allDomains) {
        ArrayList<String> l = new ArrayList<String>(allDomains.length);
        String[] applDomains = null;
        int i = 0;
        while (i < allDomains.length) {
            if (!(allDomains[i].startsWith(PREFIX_SERVICE) || allDomains[i].startsWith(PREFIX_LIBRARY) || allDomains[i].startsWith(PREFIX_INTERFACE))) {
                l.add(allDomains[i]);
            }
            ++i;
        }
        if (l.size() > 0) {
            applDomains = new String[l.size()];
            System.arraycopy(l.toArray(), 0, applDomains, 0, l.size());
        }
        return applDomains;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

