/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.Params;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.util.ServiceUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SendInfo
implements Serializable {
    static final long serialVersionUID = -1528470864076046196L;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SendInfo == null ? (class$com$sap$sldserv$SendInfo = SendInfo.class$("com.sap.sldserv.SendInfo")) : class$com$sap$sldserv$SendInfo));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private static final boolean useDatabase4SendInfo = true;
    public static final String SEND_INFO_NAME = "SLD_LAST_SEND_INFO";
    private static final String TIME_FORMAT = "yyyy/MM/dd  HH:mm:ss:SSS";
    private static final String UNKNOWN_VALUE = "<unknown>";
    private static ApplicationServiceContext applServCtx = null;
    private Date timestamp = null;
    private Date nextTimestamp = null;
    private HttpInfo httpInfo = null;
    private RfcInfo rfcInfo = null;
    private int nodeId = -1;
    private String hostName = null;
    private boolean useRfc = true;
    private boolean success = false;
    private boolean managementRun = false;
    private boolean httpsUsed = false;
    static /* synthetic */ Class class$com$sap$sldserv$SendInfo;

    private SendInfo() {
    }

    public SendInfo(ApplicationServiceContext applServCtx, boolean useRfc, Params.RuntimeParams connectParams, int nodeId, String hostName, boolean success, boolean managementRun, boolean httpsUsed, Date nextTimestamp) {
        SendInfo.applServCtx = applServCtx;
        this.useRfc = useRfc;
        this.timestamp = new Date();
        this.nextTimestamp = nextTimestamp != null ? nextTimestamp : new Date();
        this.nodeId = nodeId;
        this.hostName = hostName;
        this.httpInfo = new HttpInfo(connectParams);
        this.rfcInfo = new RfcInfo(connectParams);
        this.success = success;
        this.httpsUsed = httpsUsed;
        this.managementRun = managementRun;
    }

    public String getTimeString() {
        String rvalue = UNKNOWN_VALUE;
        if (this.timestamp != null) {
            rvalue = new SimpleDateFormat(TIME_FORMAT).format(this.timestamp);
        }
        return rvalue;
    }

    public String getNextTimeString() {
        String rvalue = UNKNOWN_VALUE;
        if (this.nextTimestamp != null) {
            rvalue = new SimpleDateFormat(TIME_FORMAT).format(this.nextTimestamp);
        }
        return rvalue;
    }

    public Date getNextTime() {
        return this.nextTimestamp;
    }

    public boolean useRfcConnection() {
        return this.useRfc;
    }

    public String getParamString() {
        String rvalue = UNKNOWN_VALUE;
        if (this.httpInfo != null && this.httpInfo.isValid() && !this.useRfc) {
            rvalue = "[" + this.httpInfo.httpHost + ":" + this.httpInfo.httpPort + "] [" + this.httpInfo.httpUser + "] [" + (this.httpsUsed ? "https" : "http") + "]";
        } else if (this.rfcInfo != null && this.rfcInfo.isValid() && this.useRfc) {
            rvalue = "[" + this.rfcInfo.gwHost + "] [" + this.rfcInfo.gwServ + "] [" + this.rfcInfo.gwRegId + "]";
        }
        return rvalue;
    }

    public String getHostIds() {
        String rvalue = UNKNOWN_VALUE;
        if (this.nodeId != -1 && this.hostName != null && this.hostName.length() != 0) {
            rvalue = "[" + this.nodeId + "] [" + this.hostName + "]";
        }
        return rvalue;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public boolean getManagementRunInfo() {
        return this.managementRun;
    }

    public static void setInfoLocalNode(SendInfo sendInfo) throws NamingException {
        SendInfo.setInfoLocalNodeDb(sendInfo);
    }

    static void setServiceContext(ApplicationServiceContext applServCtx) {
        SendInfo.applServCtx = applServCtx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setInfoLocalNodeDb(SendInfo sendInfo) {
        String method = "setInfoLocalNodeDb";
        int MAX_WAITING_LOOP = 100;
        if (applServCtx == null) {
            CATEGORY.errorT(LOCATION, ResourceUtil.formatString("sld_2020"));
            return;
        }
        try {
            ConfigurationHandlerFactory cfgFactory = applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration tmCfgRoot = null;
            Configuration tmCfg = null;
            int cnt = 0;
            while (true) {
                block16: {
                    Object var11_10;
                    if (cnt >= 100) {
                        return;
                    }
                    try {
                        try {
                            tmCfgRoot = cfgHandler.openConfiguration("SLD", 1);
                            tmCfg = tmCfgRoot.getSubConfiguration("SendInfo");
                            tmCfg.modifyConfigEntry("ts", (Object)String.valueOf(sendInfo.timestamp.getTime()));
                            tmCfg.modifyConfigEntry("next_ts", (Object)String.valueOf(sendInfo.nextTimestamp.getTime()));
                            tmCfg.modifyConfigEntry("http", (Object)sendInfo.httpInfo.getAsString());
                            tmCfg.modifyConfigEntry("rfc", (Object)sendInfo.rfcInfo.getAsString());
                            tmCfg.modifyConfigEntry("node_id", (Object)String.valueOf(sendInfo.nodeId));
                            tmCfg.modifyConfigEntry("host", (Object)sendInfo.hostName);
                            tmCfg.modifyConfigEntry("used_rfc", (Object)String.valueOf(sendInfo.useRfc));
                            tmCfg.modifyConfigEntry("result", (Object)String.valueOf(sendInfo.success));
                            tmCfg.modifyConfigEntry("mgm", (Object)String.valueOf(sendInfo.managementRun));
                            tmCfg.modifyConfigEntry("https", (Object)String.valueOf(sendInfo.httpsUsed));
                            var11_10 = null;
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("setInfoLocalNodeDb", ResourceUtil.formatString("sld_9087"));
                            var11_10 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            break block16;
                        }
                        catch (NameNotFoundException e) {
                            if (tmCfgRoot == null) {
                                tmCfgRoot = cfgHandler.createRootConfiguration("SLD");
                            }
                            if (tmCfg == null && tmCfgRoot != null) {
                                tmCfg = tmCfgRoot.createSubConfiguration("SendInfo");
                            }
                            if (tmCfg != null && tmCfgRoot != null) {
                                tmCfg.addConfigEntry("ts", (Object)String.valueOf(sendInfo.timestamp.getTime()));
                                tmCfg.addConfigEntry("next_ts", (Object)String.valueOf(sendInfo.nextTimestamp.getTime()));
                                tmCfg.addConfigEntry("http", (Object)sendInfo.httpInfo.getAsString());
                                tmCfg.addConfigEntry("rfc", (Object)sendInfo.rfcInfo.getAsString());
                                tmCfg.addConfigEntry("node_id", (Object)String.valueOf(sendInfo.nodeId));
                                tmCfg.addConfigEntry("host", (Object)sendInfo.hostName);
                                tmCfg.addConfigEntry("used_rfc", (Object)String.valueOf(sendInfo.useRfc));
                                tmCfg.addConfigEntry("result", (Object)String.valueOf(sendInfo.success));
                                tmCfg.addConfigEntry("mgm", (Object)String.valueOf(sendInfo.managementRun));
                                tmCfg.addConfigEntry("https", (Object)String.valueOf(sendInfo.httpsUsed));
                            } else {
                                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
                            }
                            var11_10 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        cfgHandler.commit();
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.commit();
                    cfgHandler.closeAllConfigurations();
                    return;
                }
                ++cnt;
            }
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setInfoLocalNodeDb", (Throwable)e);
            return;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setInfoLocalNodeDb", (Throwable)e);
        }
    }

    public static void setInfoLocalNodeJndi(SendInfo sendInfo) throws NamingException {
        String method = "setInfoLocalNode";
        ClassLoader cl = null;
        try {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$SendInfo == null ? (class$com$sap$sldserv$SendInfo = SendInfo.class$("com.sap.sldserv.SendInfo")) : class$com$sap$sldserv$SendInfo).getClassLoader());
                InitialContext jndiCtx = new InitialContext();
                jndiCtx.rebind(SEND_INFO_NAME, (Object)sendInfo);
                LOCATION.debugT("setInfoLocalNode", ResourceUtil.formatString("sld_9083"));
            }
            catch (Exception e) {
                LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)"setInfoLocalNode", (Throwable)e);
                Object var5_6 = null;
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            Object var5_5 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
    }

    public static SendInfo getInfoLocalNode() {
        return SendInfo.getInfoLocalNodeDb();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SendInfo getInfoLocalNodeDb() {
        String method = "getInfoLocalNodeDb";
        int MAX_WAITING_LOOP = 100;
        SendInfo rvalue = null;
        if (applServCtx == null) {
            CATEGORY.errorT(LOCATION, ResourceUtil.formatString("sld_2020"));
            return rvalue;
        }
        try {
            ConfigurationHandlerFactory cfgFactory = applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration tmCfgRoot = null;
            Configuration tmCfg = null;
            int cnt = 0;
            while (true) {
                block12: {
                    Object var10_11;
                    if (cnt >= 100) {
                        return rvalue;
                    }
                    try {
                        try {
                            tmCfgRoot = cfgHandler.openConfiguration("SLD", 0);
                            tmCfg = tmCfgRoot.getSubConfiguration("SendInfo");
                            rvalue = new SendInfo();
                            rvalue.timestamp = new Date(Long.parseLong((String)tmCfg.getConfigEntry("ts")));
                            rvalue.nextTimestamp = new Date(Long.parseLong((String)tmCfg.getConfigEntry("next_ts")));
                            rvalue.httpInfo = HttpInfo.getFromString((String)tmCfg.getConfigEntry("http"));
                            rvalue.rfcInfo = RfcInfo.getFromString((String)tmCfg.getConfigEntry("rfc"));
                            rvalue.nodeId = Integer.valueOf((String)tmCfg.getConfigEntry("node_id"));
                            rvalue.hostName = (String)tmCfg.getConfigEntry("host");
                            rvalue.useRfc = Boolean.valueOf((String)tmCfg.getConfigEntry("used_rfc"));
                            rvalue.success = Boolean.valueOf((String)tmCfg.getConfigEntry("result"));
                            rvalue.managementRun = Boolean.valueOf((String)tmCfg.getConfigEntry("mgm"));
                            rvalue.httpsUsed = Boolean.valueOf((String)tmCfg.getConfigEntry("https"));
                            var10_11 = null;
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("getInfoLocalNodeDb", ResourceUtil.formatString("sld_9087"));
                            var10_11 = null;
                            cfgHandler.closeAllConfigurations();
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.closeAllConfigurations();
                    return rvalue;
                }
                ++cnt;
            }
        }
        catch (NameNotFoundException e) {
            return rvalue;
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getInfoLocalNodeDb", (Throwable)e);
            return rvalue;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getInfoLocalNodeDb", (Throwable)e);
        }
        return rvalue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteInfoLocalNodeDb() {
        String method = "deleteInfoLocalNodeDb";
        int MAX_WAITING_LOOP = 5;
        if (applServCtx == null) return;
        try {
            ConfigurationHandlerFactory cfgFactory = applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration tmCfgRoot = null;
            int cnt = 0;
            while (true) {
                block10: {
                    Object var8_10;
                    if (cnt >= 5) {
                        return;
                    }
                    try {
                        try {
                            tmCfgRoot = cfgHandler.openConfiguration("SLD", 1);
                            tmCfgRoot.deleteAllSubConfigurations();
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("deleteInfoLocalNodeDb", ResourceUtil.formatString("sld_9087"));
                            var8_10 = null;
                            cfgHandler.closeAllConfigurations();
                            break block10;
                        }
                        var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        var8_10 = null;
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.closeAllConfigurations();
                }
                ++cnt;
            }
        }
        catch (NameNotFoundException e) {
            return;
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteInfoLocalNodeDb", (Throwable)e);
            return;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteInfoLocalNodeDb", (Throwable)e);
        }
    }

    public static SendInfo getInfoLocalNodeJndi() {
        String method = "getInfoLocalNodeJndi";
        SendInfo rvalue = null;
        ClassLoader cl = null;
        try {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$sldserv$SendInfo == null ? (class$com$sap$sldserv$SendInfo = SendInfo.class$("com.sap.sldserv.SendInfo")) : class$com$sap$sldserv$SendInfo).getClassLoader());
                InitialContext jndiCtx = new InitialContext();
                rvalue = (SendInfo)jndiCtx.lookup(SEND_INFO_NAME);
                LOCATION.debugT("getInfoLocalNodeJndi", ResourceUtil.formatString("sld_9084"));
            }
            catch (Exception e) {
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getInfoLocalNodeJndi", (Throwable)e);
                Object var5_6 = null;
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            Object var5_5 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
        return rvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RfcInfo
    implements Serializable {
        static final long serialVersionUID = 3191750994843274992L;
        String gwHost;
        String gwServ;
        String gwRegId;

        RfcInfo() {
        }

        RfcInfo(Params.RuntimeParams p) {
            this.gwHost = p.getGatewayHost();
            this.gwServ = p.getGatewayService();
            this.gwRegId = p.getRegId();
        }

        boolean isValid() {
            return this.gwHost != null && this.gwServ != null && this.gwRegId != null;
        }

        String getAsString() {
            return this.isValid() ? "gwHost=" + this.gwHost + ",gwServ=" + this.gwServ + ",gwRegId=" + this.gwRegId : "";
        }

        static RfcInfo getFromString(String s) {
            StringTokenizer st = new StringTokenizer(s, ",");
            RfcInfo rfcInfo = new RfcInfo();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                int i = t.indexOf(61);
                if (i < 0) continue;
                String a = t.substring(0, i);
                String b = t.substring(i + 1);
                if (a.equals("gwHost")) {
                    rfcInfo.gwHost = b;
                    continue;
                }
                if (a.equals("gwServ")) {
                    rfcInfo.gwServ = b;
                    continue;
                }
                if (!a.equals("gwRegId")) continue;
                rfcInfo.gwRegId = b;
            }
            return rfcInfo;
        }
    }

    static class HttpInfo
    implements Serializable {
        static final long serialVersionUID = -2091291410001580448L;
        String httpHost;
        String httpPort;
        String httpUser;

        HttpInfo() {
        }

        HttpInfo(Params.RuntimeParams p) {
            this.httpHost = p.getHttpHost();
            this.httpPort = p.getHttpPortAsString();
            this.httpUser = p.getHttpUser();
        }

        boolean isValid() {
            return this.httpHost != null && this.httpPort != null && this.httpUser != null;
        }

        String getAsString() {
            return this.isValid() ? "httpHost=" + this.httpHost + ",httpPort=" + this.httpPort + ",httpUser=" + this.httpUser : "";
        }

        static HttpInfo getFromString(String s) {
            StringTokenizer st = new StringTokenizer(s, ",");
            HttpInfo httpInfo = new HttpInfo();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                int i = t.indexOf(61);
                if (i < 0) continue;
                String a = t.substring(0, i);
                String b = t.substring(i + 1);
                if (a.equals("httpHost")) {
                    httpInfo.httpHost = b;
                    continue;
                }
                if (a.equals("httpPort")) {
                    httpInfo.httpPort = b;
                    continue;
                }
                if (!a.equals("httpUser")) continue;
                httpInfo.httpUser = b;
            }
            return httpInfo;
        }
    }
}

