/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.sldserv.ServiceConst;
import com.sap.sldserv.auth.SecureStoreSld;
import com.sap.sldserv.auth.SecureStoreSldInterface;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.util.ServiceUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Params
implements Serializable {
    public static final long serialVersionUID = -7172524556099288313L;
    private static final long FACTOR = 60000L;
    private static final String PATH_PARA = "nr";
    private static final String PATH_PARA_DELIM = "$";
    private static final String CONFIGURATION_MANAGER_LOCAL_PATH = "cluster_data/server/ID$nr$/services/sld";
    private static final String CONFIGURATION_MANAGER_GLOBAL_PATH = "cluster_data/server/cfg/services/sld";
    private transient ApplicationServiceContext applServCtx = null;
    private transient SecureStoreSldInterface secureStore = null;
    private Ids idParams = null;
    private RuntimeParams processParams = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$Params == null ? (class$com$sap$sldserv$Params = Params.class$("com.sap.sldserv.Params")) : class$com$sap$sldserv$Params));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    static /* synthetic */ Class class$com$sap$sldserv$Params;

    public Params(ApplicationServiceContext applServCtx) throws ServiceException {
        this.applServCtx = applServCtx;
        this.secureStore = new SecureStoreSld(applServCtx);
        this.idParams = new Ids();
        this.processParams = new RuntimeParams(applServCtx, this.secureStore);
        this.checkSetConfigManagerInfo();
        this.checkSetGenerationInfo();
        this.refreshConfig();
    }

    public synchronized void refreshConfig() {
        Properties props = this.applServCtx.getServiceState().getProperties();
        this.setTypeVersion(props);
        this.setTimeParams(props);
        this.setOptionalParams(props);
        this.setRfcParams(props);
        this.setHttpParams(props);
        this.setCommunicationType();
    }

    public void printParametersToLog() {
        String method = "printParametersToLog";
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9023", new Object[]{this.idParams.getTypeId()}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9025", new Object[]{this.idParams.getVersionId()}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9020", new Object[]{String.valueOf(this.processParams.getRepeatTimeMin())}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9071", new Object[]{String.valueOf(this.processParams.getInitialDelayTimeMs())}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9031", new Object[]{String.valueOf(this.processParams.isFullDataTrace())}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9032", new Object[]{ServiceConst.SEND_DATA_VALUE_NAMES[this.processParams.getSendData()]}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9056", new Object[]{String.valueOf(this.processParams.getCommTrace())}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9063", new Object[]{this.processParams.getCommunicationType()}));
        LOCATION.debugT("printParametersToLog", ResourceUtil.formatString("sld_9064", new Object[]{this.getCommParamString()}));
    }

    public boolean deleteRfcParams() {
        return this.secureStore.setInSecureStore("SLD_Service_RFC_Data", null);
    }

    public boolean deleteHttpParams() {
        return this.secureStore.setInSecureStore("SLD_Service_HTTP_Data", null);
    }

    public boolean containsRfcParams(Properties props) {
        return this.containsParams(this.getRfcPropertyList(), props);
    }

    public boolean containsHttpParams(Properties props) {
        return this.containsParams(this.getHttpPropertyList(), props);
    }

    private boolean containsParams(ArrayList paramList, Properties props) {
        boolean rvalue = false;
        Iterator it = ((AbstractList)paramList).iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            if (!((Hashtable)props).containsKey(paramName)) continue;
            rvalue = true;
            break;
        }
        return rvalue;
    }

    public boolean _setSystemProperty(String propertyName, String propertyValue) {
        return this.processParams._setSystemProperty(propertyName, propertyValue);
    }

    public boolean _setSystemProperty(String cfgPath, String propertyName, String propertyValue) {
        return this.processParams._setSystemProperty(cfgPath, propertyName, propertyValue);
    }

    public boolean hasValidConnectParams() {
        return this.processParams.hasValidConnectParams();
    }

    public boolean hasValidRfcParams() {
        return this.processParams.hasValidRfcParams();
    }

    public boolean hasValidHttpParams() {
        return this.processParams.hasValidHttpParams();
    }

    public void setCommunicationType() {
        String method = "setCommunicationType";
        this.processParams.setCommunicationType();
        LOCATION.debugT("setCommunicationType", ResourceUtil.formatString("sld_9070", new Object[]{this.processParams.getCommunicationType()}));
    }

    public String getCommunicationType() {
        return this.processParams.getCommunicationType();
    }

    public boolean useHttpCommunication() {
        return this.processParams.getCommunicationType().equalsIgnoreCase("http");
    }

    public boolean useRfcCommunication() {
        return this.processParams.getCommunicationType().equalsIgnoreCase("jco");
    }

    public boolean getCommTrace() {
        return this.processParams.getCommTrace();
    }

    public String getGatewayHost() {
        return this.processParams.getGatewayHost();
    }

    public String getGatewayService() {
        return this.processParams.getGatewayService();
    }

    public String getRegId() {
        return this.processParams.getRegId();
    }

    public String getHttpHost() {
        return this.processParams.getHttpHost();
    }

    public int getHttpPort() {
        return this.processParams.getHttpPort();
    }

    public String getHttpUser() {
        return this.processParams.getHttpUser();
    }

    public String getHttpPassword() {
        return this.processParams.getHttpPassword();
    }

    public boolean getHttpsSetting() {
        return this.processParams.getHttpsSetting();
    }

    public String getTrustStore() {
        return this.processParams.getTrustStore();
    }

    public String getKeyStore() {
        return this.processParams.getKeyStore();
    }

    public long getInitialDelayTimeMs() {
        return this.processParams.getInitialDelayTimeMs();
    }

    public long getInitialDelayTimeMin() {
        return this.processParams.getInitialDelayTimeMin();
    }

    public long getRepeatTimeMin() {
        return this.processParams.getRepeatTimeMin();
    }

    public long getRepeatTimeMs() {
        return this.processParams.getRepeatTimeMs();
    }

    public boolean isFullDataTrace() {
        return this.processParams.isFullDataTrace();
    }

    public int getSendData() {
        return this.processParams.getSendData();
    }

    public String getTypeId() {
        return this.idParams.getTypeId();
    }

    public String getVersionId() {
        return this.idParams.getVersionId();
    }

    public RuntimeParams getRuntimeParams() {
        return this.processParams;
    }

    public Ids getIdParams() {
        return this.idParams;
    }

    public boolean negativeListContained(String className) {
        return this.processParams.negativeListContained(className);
    }

    public boolean setSecureStoreRfcParams() {
        return this.processParams.setSecureStoreRfcParams();
    }

    public boolean setSecureStoreHttpParams() {
        return this.processParams.setSecureStoreHttpParams();
    }

    public boolean isInitialRfc() {
        return this.processParams.isInitialRfc();
    }

    public boolean isInitialHttp() {
        return this.processParams.isInitialHttp();
    }

    private void setTypeVersion(Properties props) {
        String method = "setTypeVersion";
        String typeId = props.getProperty("TypeId");
        if (typeId == null || typeId.length() == 0) {
            LOCATION.debugT("setTypeVersion", ResourceUtil.formatString("sld_9022", new Object[]{this.idParams.getTypeId()}));
        } else {
            this.idParams.setTypeId(typeId.trim());
            LOCATION.debugT("setTypeVersion", ResourceUtil.formatString("sld_9023", new Object[]{this.idParams.getTypeId()}));
        }
        String versionId = props.getProperty("VersionId");
        if (versionId == null || versionId.length() == 0) {
            LOCATION.debugT("setTypeVersion", ResourceUtil.formatString("sld_9024", new Object[]{this.idParams.getVersionId()}));
        } else {
            this.idParams.setVersionId(versionId.trim());
            LOCATION.debugT("setTypeVersion", ResourceUtil.formatString("sld_9025", new Object[]{this.idParams.getVersionId()}));
        }
    }

    private void setRfcParams(Properties props) {
        String regIdSecStore;
        String gwServSecStore;
        String gwHostSecStore;
        String method = "setRfcParams";
        boolean setThruProp = false;
        Properties secStoreParams = this.processParams.getSecureStoreRfcParams();
        if (secStoreParams != null && ((Hashtable)secStoreParams).size() != 0) {
            LOCATION.debugT("setRfcParams", ResourceUtil.formatString("sld_9061"));
        } else {
            LOCATION.debugT("setRfcParams", ResourceUtil.formatString("sld_9062"));
        }
        String gwHost = props.getProperty("GatewayHost");
        String string = gwHostSecStore = secStoreParams != null ? secStoreParams.getProperty("GatewayHost") : null;
        if (gwHostSecStore != null && gwHostSecStore.length() != 0) {
            if (gwHost != null && gwHost.length() != 0) {
                setThruProp = true;
                this.processParams.setGatewayHost(gwHost.trim());
            } else {
                this.processParams.setGatewayHost(gwHostSecStore);
            }
        } else if (gwHost != null && gwHost.length() != 0) {
            setThruProp = true;
            this.processParams.setGatewayHost(gwHost.trim());
        } else {
            this.processParams.setGatewayHost("");
        }
        String gwServ = props.getProperty("GatewayService");
        String string2 = gwServSecStore = secStoreParams != null ? secStoreParams.getProperty("GatewayService") : null;
        if (gwServSecStore != null && gwServSecStore.length() != 0) {
            if (gwServ != null && gwServ.length() != 0) {
                setThruProp = true;
                this.processParams.setGatewayService(gwServ.trim());
            } else {
                this.processParams.setGatewayService(gwServSecStore);
            }
        } else if (gwServ != null && gwServ.length() != 0) {
            setThruProp = true;
            this.processParams.setGatewayService(gwServ.trim());
        } else {
            this.processParams.setGatewayService("");
        }
        String regId = props.getProperty("RegistrationId");
        String string3 = regIdSecStore = secStoreParams != null ? secStoreParams.getProperty("RegistrationId") : null;
        if (regIdSecStore != null && regIdSecStore.length() != 0) {
            this.processParams.setRegId(regIdSecStore);
        } else if (regId != null && regId.length() != 0) {
            setThruProp = true;
            this.processParams.setRegId(regId.trim());
        }
        if (setThruProp) {
            if (this.setSecureStoreRfcParams()) {
                String localConfigPath = RuntimeParams.convertConfigPath(CONFIGURATION_MANAGER_LOCAL_PATH, PATH_PARA, PATH_PARA_DELIM, this.processParams.getNodeId());
                this.deleteProperties(localConfigPath, this.getRfcPropertyList());
                this.deleteProperties(CONFIGURATION_MANAGER_GLOBAL_PATH, this.getRfcPropertyList());
            } else {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3044"));
            }
        }
        LOCATION.debugT("setRfcParams", ResourceUtil.formatStringNoParameterLocalization("sld_9067", new Object[]{"JCO"}));
    }

    private ArrayList getRfcPropertyList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("GatewayHost");
        l.add("GatewayService");
        l.add("RegistrationId");
        return l;
    }

    private ArrayList getHttpPropertyList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("HttpHost");
        l.add("HttpPort");
        l.add("HttpUser");
        l.add("HttpPassword");
        return l;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteProperties(String cfgPath, ArrayList propList) {
        ConfigurationHandler cfgHandler;
        block15: {
            String method = "deleteProperties";
            cfgHandler = null;
            ConfigurationHandlerFactory cfgHdlFctry = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            cfgHandler = cfgHdlFctry.getConfigurationHandler();
            Configuration sldCfg = null;
            while (true) {
                try {
                    sldCfg = cfgHandler.openConfiguration(cfgPath, 1);
                    PropertySheet propSheet = sldCfg.getPropertySheetInterface();
                    Iterator it = ((AbstractList)propList).iterator();
                    while (it.hasNext()) {
                        String currPropName = (String)it.next();
                        try {
                            propSheet.getPropertyEntry(currPropName);
                            propSheet.deletePropertyEntry(currPropName);
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                    }
                    break block15;
                }
                catch (ConfigurationLockedException e) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9059"));
                    ServiceUtils.waitSeconds(1L);
                    continue;
                }
                break;
            }
            catch (NameNotFoundException e) {}
        }
        Object var12_14 = null;
        if (cfgHandler == null) return;
        try {
            cfgHandler.commit();
            cfgHandler.closeAllConfigurations();
            return;
        }
        catch (ConfigurationException e2) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteProperties", (Throwable)e2);
        }
        return;
        {
            catch (Exception e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3048"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteProperties", (Throwable)e);
                Object var12_15 = null;
                if (cfgHandler == null) return;
                try {
                    cfgHandler.commit();
                    cfgHandler.closeAllConfigurations();
                    return;
                }
                catch (ConfigurationException e2) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteProperties", (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (cfgHandler == null) throw throwable;
            try {
                cfgHandler.commit();
                cfgHandler.closeAllConfigurations();
                throw throwable;
            }
            catch (ConfigurationException e2) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteProperties", (Throwable)e2);
            }
            throw throwable;
        }
    }

    private void setTimeParams(Properties props) {
        String initialDelayTimeStr;
        String repeatTimeStr = props.getProperty("RepeatTimeMinutes");
        if (repeatTimeStr != null && repeatTimeStr.length() != 0) {
            try {
                int repeatTimeInt = Integer.parseInt(repeatTimeStr.trim());
                this.processParams.setRepeatTimeMin(repeatTimeInt);
                if (repeatTimeInt < 5) {
                    this._setSystemProperty("RepeatTimeMinutes", String.valueOf(5));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((initialDelayTimeStr = props.getProperty("InitialDelayMinutes")) != null && initialDelayTimeStr.length() != 0) {
            try {
                this.processParams.setInitialDelayTimeMin(Integer.parseInt(initialDelayTimeStr.trim()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void setHttpParams(Properties props) {
        String secStoreTrustStore;
        String secStoreHttpPw;
        String secStoreHttpUser;
        String secStoreHttpHost;
        String method = "setHttpParams";
        boolean setThruProp = false;
        Properties secStoreParams = this.processParams.getSecureStoreHttpParams();
        if (secStoreParams != null && ((Hashtable)secStoreParams).size() != 0) {
            LOCATION.debugT("setHttpParams", ResourceUtil.formatString("sld_9047"));
        } else {
            LOCATION.debugT("setHttpParams", ResourceUtil.formatString("sld_9048"));
        }
        String propHttpHost = props.getProperty("HttpHost");
        String string = secStoreHttpHost = secStoreParams != null ? secStoreParams.getProperty("HttpHost") : null;
        if (secStoreHttpHost != null && secStoreHttpHost.length() != 0) {
            if (propHttpHost != null && propHttpHost.length() != 0) {
                setThruProp = true;
                this.processParams.setHttpHost(propHttpHost.trim());
            } else {
                this.processParams.setHttpHost(secStoreHttpHost.trim());
            }
        } else if (propHttpHost != null && propHttpHost.length() != 0) {
            setThruProp = true;
            this.processParams.setHttpHost(propHttpHost.trim());
        } else {
            this.processParams.setHttpHost("");
        }
        String propHttpPort = props.getProperty("HttpPort");
        String secStoreHttpPort = secStoreParams != null ? secStoreParams.getProperty("HttpPort") : null;
        try {
            if (secStoreHttpPort != null && secStoreHttpPort.length() != 0) {
                if (propHttpPort != null && propHttpPort.length() != 0) {
                    setThruProp = true;
                    this.processParams.setHttpPort(Integer.parseInt(propHttpPort.trim()));
                } else {
                    this.processParams.setHttpPort(Integer.parseInt(secStoreHttpPort.trim()));
                }
            } else if (propHttpPort != null && propHttpPort.length() != 0) {
                setThruProp = true;
                this.processParams.setHttpPort(Integer.parseInt(propHttpPort.trim()));
            } else {
                this.processParams.setHttpPort(-1);
            }
        }
        catch (NumberFormatException e) {
            this.processParams.setHttpPort(-1);
        }
        String propHttpUser = props.getProperty("HttpUser");
        String string2 = secStoreHttpUser = secStoreParams != null ? secStoreParams.getProperty("HttpUser") : null;
        if (secStoreHttpUser != null && secStoreHttpUser.length() != 0) {
            if (propHttpUser != null && propHttpUser.length() != 0) {
                setThruProp = true;
                this.processParams.setHttpUser(propHttpUser.trim());
            } else {
                this.processParams.setHttpUser(secStoreHttpUser.trim());
            }
        } else if (propHttpUser != null && propHttpUser.length() != 0) {
            setThruProp = true;
            this.processParams.setHttpUser(propHttpUser.trim());
        } else {
            this.processParams.setHttpUser("");
        }
        String propHttpPw = props.getProperty("HttpPassword");
        String string3 = secStoreHttpPw = secStoreParams != null ? secStoreParams.getProperty("HttpPassword") : null;
        if (secStoreHttpPw != null && secStoreHttpPw.length() != 0) {
            if (propHttpPw != null && propHttpPw.length() != 0) {
                setThruProp = true;
                this.processParams.setHttpPassword(propHttpPw.trim());
            } else {
                this.processParams.setHttpPassword(secStoreHttpPw.trim());
            }
        } else if (propHttpPw != null && propHttpPw.length() != 0) {
            setThruProp = true;
            this.processParams.setHttpPassword(propHttpPw.trim());
        } else {
            this.processParams.setHttpPassword("");
        }
        String useHttps = props.getProperty("UseHttps");
        String secStoreUseHttps = secStoreParams != null ? secStoreParams.getProperty("UseHttps") : null;
        String trustStore = props.getProperty("TrustStore");
        String string4 = secStoreTrustStore = secStoreParams != null ? secStoreParams.getProperty("TrustStore") : null;
        if (secStoreUseHttps != null && secStoreUseHttps.length() != 0) {
            if (useHttps != null && useHttps.length() != 0) {
                setThruProp = true;
                this.processParams.setUseHttp(useHttps);
                if (trustStore != null) {
                    this.processParams.setTrustStore(trustStore);
                }
            } else {
                this.processParams.setUseHttp(secStoreUseHttps);
                if (secStoreTrustStore != null) {
                    this.processParams.setTrustStore(secStoreTrustStore);
                }
            }
        } else if (useHttps != null && useHttps.length() != 0) {
            setThruProp = true;
            this.processParams.setUseHttp(useHttps.trim());
            if (trustStore != null) {
                this.processParams.setTrustStore(trustStore);
            }
        } else {
            this.processParams.setUseHttp(false);
        }
        if (setThruProp) {
            if (this.setSecureStoreHttpParams()) {
                String localConfigPath = RuntimeParams.convertConfigPath(CONFIGURATION_MANAGER_LOCAL_PATH, PATH_PARA, PATH_PARA_DELIM, this.processParams.getNodeId());
                this.deleteProperties(localConfigPath, this.getHttpPropertyList());
                this.deleteProperties(CONFIGURATION_MANAGER_GLOBAL_PATH, this.getHttpPropertyList());
            } else {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3047"));
            }
        }
        LOCATION.debugT("setHttpParams", ResourceUtil.formatStringNoParameterLocalization("sld_9067", new Object[]{"HTTP"}));
    }

    private void setOptionalParams(Properties props) {
        String commTraceStr;
        String dataSendStr;
        String fullDataTraceStr = props.getProperty("FullDataTrace");
        if (fullDataTraceStr != null && fullDataTraceStr.length() != 0) {
            this.processParams.setFullDataTrace(Boolean.valueOf(fullDataTraceStr));
        }
        if ((dataSendStr = props.getProperty("SendData")) != null && dataSendStr.length() != 0) {
            if (dataSendStr.equalsIgnoreCase("false")) {
                this.processParams.setSendData(0);
            } else if (dataSendStr.equalsIgnoreCase("always")) {
                this.processParams.setSendData(2);
            }
        }
        if ((commTraceStr = props.getProperty("CommunicationTrace")) != null && commTraceStr.length() != 0 && commTraceStr.equalsIgnoreCase("true")) {
            this.processParams.setCommTrace(Boolean.valueOf(commTraceStr));
        }
        this.processParams.setNegativeList(props.getProperty("IgnoredClasses"));
    }

    private String getCommParamString() {
        if (this.processParams.hasValidConnectParams()) {
            return this.processParams.getCommunicationType().equalsIgnoreCase("http") ? this.getHttpCommParamString() : this.getRfcCommParamString();
        }
        return ResourceUtil.formatString("sld_9065");
    }

    private String getRfcCommParamString() {
        return "GatewayHost=" + this.processParams.getGatewayHost() + "," + "GatewayService" + "=" + this.processParams.getGatewayService();
    }

    private String getHttpCommParamString() {
        return "HttpHost=" + this.processParams.getHttpHost() + "," + "HttpPort" + "=" + this.processParams.getHttpPort() + "," + "HttpUser" + "=" + this.processParams.getHttpUser();
    }

    private void checkSetGenerationInfo() {
        Properties genProps;
        if (this.secureStore != null && this.processParams != null && (genProps = (Properties)this.secureStore.getFromSecureStore("SLD_Service_Generation_Data")) == null) {
            genProps = new Properties();
            ((Hashtable)genProps).put("HttpHost", this.processParams.getHttpHost());
            ((Hashtable)genProps).put("HttpPort", String.valueOf(this.processParams.getHttpPort()));
            ((Hashtable)genProps).put("HttpUser", this.processParams.getHttpUser());
            ((Hashtable)genProps).put("HttpPassword", this.processParams.getHttpPassword());
            if (!this.secureStore.setInSecureStore("SLD_Service_Generation_Data", genProps)) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3065"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkSetConfigManagerInfo() {
        String method = "checkSetConfigManagerInfo";
        int MAX_WAITING_LOOP = 5;
        try {
            ConfigurationHandlerFactory cfgFactory = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration instCfgRoot = null;
            Configuration instCfg = null;
            int cnt = 0;
            while (true) {
                block22: {
                    Object var14_13;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            if (cnt >= 5) {
                                                return;
                                            }
                                            try {
                                                try {
                                                    instCfgRoot = cfgHandler.openConfiguration("SLDINST", 0);
                                                    if (instCfgRoot == null) {
                                                        var14_13 = null;
                                                        break block16;
                                                    }
                                                    instCfg = instCfgRoot.getSubConfiguration("SAPinst");
                                                    if (instCfg == null) {
                                                        break block17;
                                                    }
                                                    PropertySheet ips = instCfg.getPropertySheetInterface();
                                                    if (ips == null) {
                                                        break block18;
                                                    }
                                                    PropertyEntry pe = ips.getPropertyEntry("info");
                                                    if (pe == null) {
                                                        break block19;
                                                    }
                                                    String cfgData = (String)pe.getValue();
                                                    if (cfgData == null) {
                                                        break block20;
                                                    }
                                                    Properties props = new Properties();
                                                    StringTokenizer st = new StringTokenizer(cfgData, ":");
                                                    if (st.countTokens() == 5) {
                                                        ((Hashtable)props).put("HttpHost", (String)st.nextElement());
                                                        ((Hashtable)props).put("HttpPort", (String)st.nextElement());
                                                        ((Hashtable)props).put("HttpUser", (String)st.nextElement());
                                                        ((Hashtable)props).put("HttpPassword", (String)st.nextElement());
                                                        ((Hashtable)props).put("UseHttps", (String)st.nextElement());
                                                        this.setHttpParams(props);
                                                        cfgHandler.closeAllConfigurations();
                                                        instCfgRoot = cfgHandler.openConfiguration("SLDINST", 1);
                                                        instCfgRoot.deleteConfiguration();
                                                        cfgHandler.commit();
                                                    }
                                                    break block21;
                                                }
                                                catch (ConfigurationLockedException e) {
                                                    ServiceUtils.waitSeconds(1L);
                                                    LOCATION.debugT("checkSetConfigManagerInfo", ResourceUtil.formatString("sld_9087"));
                                                    var14_13 = null;
                                                    cfgHandler.closeAllConfigurations();
                                                    break block22;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                var14_13 = null;
                                                cfgHandler.closeAllConfigurations();
                                                throw throwable;
                                            }
                                        }
                                        cfgHandler.closeAllConfigurations();
                                        return;
                                    }
                                    var14_13 = null;
                                    cfgHandler.closeAllConfigurations();
                                    return;
                                }
                                var14_13 = null;
                                cfgHandler.closeAllConfigurations();
                                return;
                            }
                            var14_13 = null;
                            cfgHandler.closeAllConfigurations();
                            return;
                        }
                        var14_13 = null;
                        cfgHandler.closeAllConfigurations();
                        return;
                    }
                    var14_13 = null;
                    cfgHandler.closeAllConfigurations();
                    return;
                }
                ++cnt;
            }
        }
        catch (NameNotFoundException e) {
            return;
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3080"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"checkSetConfigManagerInfo", (Throwable)e);
            return;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3080"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"checkSetConfigManagerInfo", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RuntimeParams
    implements Cloneable,
    Serializable {
        public static final long serialVersionUID = 5775415333720053297L;
        private String commType = "http";
        private String gatewayHost = "";
        private String gatewayService = "";
        private String regId = "SLD_UC";
        private long repeatTimeMin = 720L;
        private long repeatTimeMs = 43200000L;
        private long initialDelayTimeMin = 5L;
        private long initialDelayTimeMs = 300000L;
        private boolean fullDataTrace = false;
        private int sendData = 1;
        private String httpHost = "";
        private int httpPort = -1;
        private String httpUser = "";
        private String httpPassword = "";
        private boolean useHttps = false;
        private String trustStore = "TrustedCAs";
        private String keyStore = "";
        private transient ApplicationServiceContext applServCtx = null;
        private transient SecureStoreSldInterface secureStore = null;
        private HashSet negativeList = new HashSet();
        private boolean commTrace = false;

        public RuntimeParams(ApplicationServiceContext applServCtx, SecureStoreSldInterface secureStore) throws ServiceException {
            this.applServCtx = applServCtx;
            this.secureStore = secureStore;
        }

        public Object clone() throws CloneNotSupportedException {
            try {
                RuntimeParams cloned = (RuntimeParams)super.clone();
                cloned.negativeList = (HashSet)this.negativeList.clone();
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }

        public boolean hasValidRfcParams() {
            return this.gatewayHost != null && this.gatewayHost.length() != 0 && this.gatewayService != null && this.gatewayService.length() != 0;
        }

        public boolean hasValidHttpParams() {
            return this.httpHost != null && this.httpHost.length() != 0 && this.httpPort != -1 && this.httpUser != null && this.httpUser.length() != 0;
        }

        public boolean hasValidConnectParams() {
            return this.hasValidRfcParams() || this.hasValidHttpParams();
        }

        public String getCommunicationType() {
            return this.commType;
        }

        public String getRegId() {
            return this.regId;
        }

        public long getRepeatTimeMin() {
            return this.repeatTimeMin;
        }

        public long getRepeatTimeMs() {
            return this.repeatTimeMs;
        }

        public long getInitialDelayTimeMs() {
            return this.initialDelayTimeMs;
        }

        public long getInitialDelayTimeMin() {
            return this.initialDelayTimeMin;
        }

        public boolean isFullDataTrace() {
            return this.fullDataTrace;
        }

        public String getGatewayHost() {
            return this.gatewayHost;
        }

        public String getGatewayService() {
            return this.gatewayService;
        }

        public int getSendData() {
            return this.sendData;
        }

        public boolean negativeListContained(String className) {
            return this.negativeList.contains(className);
        }

        public String getHttpHost() {
            return this.httpHost;
        }

        public String getHttpPortAsString() {
            return String.valueOf(this.httpPort);
        }

        public String getHttpUser() {
            return this.httpUser;
        }

        public String getHttpPassword() {
            return this.httpPassword;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public boolean getHttpsSetting() {
            return this.useHttps;
        }

        public boolean getCommTrace() {
            return this.commTrace;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public boolean isInitialHttp() {
            return this.httpHost == null || this.httpHost.length() == 0 || this.httpPort == -1 || this.httpUser == null || this.httpUser.length() == 0 || this.httpPassword == null;
        }

        public boolean isInitialRfc() {
            return this.gatewayHost == null || this.gatewayHost.length() == 0 || this.gatewayService == null || this.gatewayService.length() == 0;
        }

        public synchronized void setClone(RuntimeParams p) {
            this.fullDataTrace = p.fullDataTrace;
            this.gatewayHost = p.gatewayHost;
            this.gatewayService = p.gatewayService;
            this.httpHost = p.httpHost;
            this.httpPort = p.httpPort;
            this.httpUser = p.httpUser;
            this.httpPassword = p.httpPassword;
            this.useHttps = p.useHttps;
            this.trustStore = p.trustStore;
            this.keyStore = p.keyStore;
            this.regId = p.regId;
            this.repeatTimeMin = p.repeatTimeMin;
            this.sendData = p.sendData;
            this.negativeList = (HashSet)p.negativeList.clone();
        }

        public boolean setSecureStoreHttpParams() {
            boolean rvalue = true;
            if (!this.isInitialHttp()) {
                Properties props = new Properties();
                ((Hashtable)props).put("HttpHost", this.httpHost);
                ((Hashtable)props).put("HttpPort", String.valueOf(this.httpPort));
                ((Hashtable)props).put("HttpUser", this.httpUser);
                ((Hashtable)props).put("HttpPassword", this.httpPassword);
                ((Hashtable)props).put("UseHttps", String.valueOf(this.useHttps));
                ((Hashtable)props).put("TrustStore", this.trustStore);
                ((Hashtable)props).put("KeyStore", this.keyStore);
                rvalue = this.secureStore.setInSecureStore("SLD_Service_HTTP_Data", props);
            }
            return rvalue;
        }

        public boolean setSecureStoreRfcParams() {
            boolean rvalue = true;
            if (!this.isInitialRfc()) {
                Properties props = new Properties();
                ((Hashtable)props).put("GatewayHost", this.gatewayHost);
                ((Hashtable)props).put("GatewayService", this.gatewayService);
                ((Hashtable)props).put("RegistrationId", this.regId);
                rvalue = this.secureStore.setInSecureStore("SLD_Service_RFC_Data", props);
            }
            return rvalue;
        }

        public boolean _setSystemProperty(String propertyName, String propertyValue) {
            String localConfigPath = RuntimeParams.convertConfigPath(Params.CONFIGURATION_MANAGER_LOCAL_PATH, Params.PATH_PARA, Params.PATH_PARA_DELIM, this.getNodeId());
            this.setLocalNodeSystemProperty(localConfigPath, propertyName, propertyValue);
            return this._setSystemProperty(Params.CONFIGURATION_MANAGER_GLOBAL_PATH, propertyName, propertyValue);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean _setSystemProperty(String cfgPath, String propertyName, String propertyValue) {
            String method = "setSystemProperty";
            boolean rvalue = true;
            boolean createConfigEntry = false;
            boolean createSheetEntry = false;
            ConfigurationHandler cfgHandler = null;
            ConfigurationHandlerFactory cfgHdlFctry = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            cfgHandler = cfgHdlFctry.getConfigurationHandler();
            Configuration sldCfg = null;
            while (true) {
                try {
                    if (createConfigEntry) {
                        createConfigEntry = false;
                        sldCfg = cfgHandler.createSubConfiguration(cfgPath);
                        continue;
                    }
                    sldCfg = cfgHandler.openConfiguration(cfgPath, 1);
                }
                catch (ConfigurationLockedException e) {
                    LOCATION.debugT("setSystemProperty", ResourceUtil.formatString("sld_9059"));
                    ServiceUtils.waitSeconds(1L);
                    continue;
                }
                catch (NameNotFoundException e) {
                    createConfigEntry = true;
                    continue;
                }
                break;
            }
            PropertySheet propSheet = sldCfg.getPropertySheetInterface();
            PropertyEntry propEntry = null;
            while (true) {
                try {
                    if (createSheetEntry) {
                        propSheet.createPropertyEntry(propertyName, (Object)propertyValue, "");
                    }
                    propEntry = propSheet.getPropertyEntry(propertyName);
                    propEntry.setValue((Object)propertyValue);
                }
                catch (NameNotFoundException e) {
                    createSheetEntry = true;
                    continue;
                }
                break;
            }
            cfgHandler.commit();
            Object var15_17 = null;
            if (cfgHandler == null) return rvalue;
            try {
                cfgHandler.closeAllConfigurations();
                return rvalue;
            }
            catch (ConfigurationException e2) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSystemProperty", (Throwable)e2);
            }
            return rvalue;
            {
                catch (Exception e) {
                    rvalue = false;
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3040", new Object[]{propertyName, propertyValue}));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSystemProperty", (Throwable)e);
                    Object var15_18 = null;
                    if (cfgHandler == null) return rvalue;
                    try {
                        cfgHandler.closeAllConfigurations();
                        return rvalue;
                    }
                    catch (ConfigurationException e2) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSystemProperty", (Throwable)e2);
                    }
                    return rvalue;
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (cfgHandler == null) throw throwable;
                try {
                    cfgHandler.closeAllConfigurations();
                    throw throwable;
                }
                catch (ConfigurationException e2) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSystemProperty", (Throwable)e2);
                }
                throw throwable;
            }
        }

        public Properties getSecureStoreHttpParams() {
            return (Properties)this.secureStore.getFromSecureStore("SLD_Service_HTTP_Data");
        }

        public Properties getSecureStoreRfcParams() {
            return (Properties)this.secureStore.getFromSecureStore("SLD_Service_RFC_Data");
        }

        public synchronized RuntimeParams getClone() {
            try {
                return (RuntimeParams)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }

        public boolean equals(Object o) {
            return this.hashCode() == ((RuntimeParams)o).hashCode();
        }

        public int hashCode() {
            String traceParam = String.valueOf(this.fullDataTrace);
            String gwParams = this.gatewayHost + this.gatewayService + this.regId;
            String timeParams = String.valueOf(this.repeatTimeMin) + String.valueOf(this.repeatTimeMs) + String.valueOf(this.initialDelayTimeMin) + String.valueOf(this.initialDelayTimeMs);
            String httpParams = this.httpHost + String.valueOf(this.httpPort) + this.httpUser + this.httpPassword;
            String httpsParams = this.trustStore + this.keyStore;
            String negativeListParam = this.negativeList.toString();
            return (traceParam + gwParams + timeParams + httpParams + httpsParams + negativeListParam).hashCode();
        }

        public Properties getSettings() {
            Properties props = new Properties();
            props.setProperty("GatewayHost", this.getGatewayHost());
            props.setProperty("GatewayService", this.getGatewayService());
            props.setProperty("RegistrationId", this.getRegId());
            props.setProperty("RepeatTimeMinutes", String.valueOf(this.getRepeatTimeMin()));
            props.setProperty("HttpHost", this.getHttpHost());
            props.setProperty("HttpPort", String.valueOf(this.getHttpPort()));
            props.setProperty("HttpUser", this.getHttpUser());
            props.setProperty("HttpPassword", this.getHttpPassword());
            props.setProperty("UseHttps", String.valueOf(this.getHttpsSetting()));
            props.setProperty("TrustStore", this.getTrustStore());
            props.setProperty("KeyStore", this.getKeyStore());
            return props;
        }

        void setParameter(String n, String v) {
            if (n != null) {
                if (n.equalsIgnoreCase("CommunicationType")) {
                    this.setCommunicationType(v);
                } else if (n.equalsIgnoreCase("GatewayHost")) {
                    this.setGatewayHost(v);
                } else if (n.equalsIgnoreCase("GatewayService")) {
                    this.setGatewayService(v);
                } else if (n.equalsIgnoreCase("HttpHost")) {
                    this.setHttpHost(v);
                } else if (n.equalsIgnoreCase("HttpPort")) {
                    try {
                        this.setHttpPort(Integer.parseInt(v));
                    }
                    catch (NumberFormatException e) {}
                } else if (n.equalsIgnoreCase("UseHttps")) {
                    this.setUseHttp(v != null && v.equalsIgnoreCase("true"));
                } else if (n.equalsIgnoreCase("TrustStore")) {
                    this.setTrustStore(v);
                } else if (n.equalsIgnoreCase("KeyStore")) {
                    this.setKeyStore(v);
                } else if (n.equalsIgnoreCase("HttpUser")) {
                    this.setHttpUser(v);
                } else if (n.equalsIgnoreCase("HttpPassword")) {
                    this.setHttpPassword(v);
                } else if (n.equalsIgnoreCase("RepeatTimeMinutes")) {
                    try {
                        this.setRepeatTimeMin(Integer.valueOf(v));
                    }
                    catch (NumberFormatException e) {}
                } else if (n.equalsIgnoreCase("InitialDelayMinutes")) {
                    try {
                        this.setInitialDelayTimeMin(Integer.valueOf(v).intValue());
                    }
                    catch (NumberFormatException e) {}
                } else if (n.equalsIgnoreCase("RegistrationId")) {
                    this.setRegId(v);
                } else if (n.equalsIgnoreCase("FullDataTrace")) {
                    this.setFullDataTrace(Boolean.valueOf(v));
                } else if (n.equalsIgnoreCase("SendData")) {
                    try {
                        this.setDataSend(Integer.valueOf(v));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (n.equalsIgnoreCase("IgnoredClasses")) {
                    this.setNegativeList(v);
                }
            }
        }

        void setCommunicationType() {
            if (this.hasValidHttpParams()) {
                this.setCommunicationType("http");
            } else if (this.hasValidRfcParams()) {
                this.setCommunicationType("jco");
            }
        }

        void setCommunicationType(String commType) {
            if (commType.equalsIgnoreCase("http") || commType.equalsIgnoreCase("jco")) {
                this.commType = commType;
            }
        }

        void setSendData(int i) {
            this.sendData = i;
        }

        void setFullDataTrace(boolean b) {
            this.fullDataTrace = b;
        }

        void setDataSend(int i) {
            if (i == 1 || i == 0 || i == 2) {
                this.sendData = i;
            }
        }

        void setGatewayHost(String host) {
            this.gatewayHost = host;
        }

        void setGatewayService(String service) {
            this.gatewayService = service;
        }

        void setHttpUser(String user) {
            this.httpUser = user;
        }

        void setRegId(String regid) {
            this.regId = regid;
        }

        void setRepeatTimeMin(int i) {
            this.repeatTimeMin = Math.max(i, 5);
            this.repeatTimeMs = this.repeatTimeMin * 60000L;
        }

        void setInitialDelayTimeMin(long min) {
            if (min >= 5L) {
                this.initialDelayTimeMin = min;
                this.initialDelayTimeMs = min * 60000L;
            }
        }

        void setHttpHost(String httpHost) {
            this.httpHost = httpHost;
        }

        void setHttpPassword(String httpPassword) {
            this.httpPassword = httpPassword;
        }

        void setHttpPort(int httpPort) {
            this.httpPort = httpPort;
        }

        void setUseHttp(boolean useHttps) {
            this.useHttps = useHttps;
        }

        void setUseHttp(String useHttpsStr) {
            this.useHttps = Boolean.valueOf(useHttpsStr);
        }

        void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public void setCommTrace(boolean commTrace) {
            this.commTrace = commTrace;
        }

        void setNegativeList(String negativeListStr) {
            String method = "setNegativeList";
            this.negativeList.clear();
            if (negativeListStr != null && negativeListStr.length() != 0) {
                StringTokenizer st = new StringTokenizer(negativeListStr.trim(), ",");
                while (st.hasMoreTokens()) {
                    String className = st.nextToken().trim();
                    this.negativeList.add(className);
                    LOCATION.debugT("setNegativeList", ResourceUtil.formatStringNoParameterLocalization("sld_9045", new Object[]{className}));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected static String convertConfigPath(String inStr, String inParamStr, String delimStr, String paramValueStr) {
            int i1;
            StringBuffer result = new StringBuffer(inStr);
            String searchPattern = delimStr + inParamStr + delimStr;
            while ((i1 = result.toString().indexOf(searchPattern)) >= 0) {
                void var6_6;
                void i2 = var6_6 + searchPattern.length();
                String s1 = result.toString().substring(0, (int)var6_6);
                String s2 = result.toString().substring((int)i2, result.length());
                result = new StringBuffer(s1 + paramValueStr + s2);
            }
            return result.toString();
        }

        protected String getNodeId() {
            return String.valueOf(this.applServCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId());
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setLocalNodeSystemProperty(String localCfgPath, String propertyName, String propertyValue) {
            String method = "setLocalNodeSystemProperty";
            ConfigurationHandlerFactory cfgHdlFctry = null;
            ConfigurationHandler cfgHandler = null;
            cfgHdlFctry = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            cfgHandler = cfgHdlFctry.getConfigurationHandler();
            Configuration sldCfg = null;
            while (true) {
                try {
                    sldCfg = cfgHandler.openConfiguration(localCfgPath, 1);
                }
                catch (ConfigurationLockedException e) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9059"));
                    ServiceUtils.waitSeconds(1L);
                    continue;
                }
                catch (NameNotFoundException e) {
                }
                break;
            }
            if (sldCfg != null) {
                PropertySheet propSheet = sldCfg.getPropertySheetInterface();
                PropertyEntry propEntry = null;
                try {
                    propEntry = propSheet.getPropertyEntry(propertyName);
                    propEntry.setValue((Object)propertyValue);
                    cfgHandler.commit();
                }
                catch (NameNotFoundException e) {
                }
            }
            Object var12_14 = null;
            if (cfgHandler == null) return;
            try {
                cfgHandler.closeAllConfigurations();
                return;
            }
            catch (ConfigurationException e2) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setLocalNodeSystemProperty", (Throwable)e2);
            }
            return;
            {
                catch (Exception e) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3040", new Object[]{propertyName, propertyValue}));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setLocalNodeSystemProperty", (Throwable)e);
                    Object var12_15 = null;
                    if (cfgHandler == null) return;
                    try {
                        cfgHandler.closeAllConfigurations();
                        return;
                    }
                    catch (ConfigurationException e2) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setLocalNodeSystemProperty", (Throwable)e2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (cfgHandler == null) throw throwable;
                try {
                    cfgHandler.closeAllConfigurations();
                    throw throwable;
                }
                catch (ConfigurationException e2) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3041"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setLocalNodeSystemProperty", (Throwable)e2);
                }
                throw throwable;
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, NamingException, SldServiceException {
            ois.defaultReadObject();
            InitialContext ctx = new InitialContext();
            this.applServCtx = (ApplicationServiceContext)ctx.lookup("applsld");
            this.secureStore = new SecureStoreSld(this.applServCtx);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
        }
    }

    public static class Ids
    implements Cloneable,
    Serializable {
        public static final long serialVersionUID = 6649676138793823392L;
        private String typeId = "J2EESystem";
        private String versionId = "1.0";

        public String getTypeId() {
            return this.typeId;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public Object clone() throws CloneNotSupportedException {
            try {
                return (RuntimeParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }
    }
}

