/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.sldserv.ServiceConst;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.test.IInstance;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public abstract class J2EEInst
implements IInstance,
ServiceConst,
Cloneable {
    protected String className;
    protected String instName;
    protected ArrayList instProps;

    J2EEInst(String className, String instName) {
        this.className = className;
        this.instName = instName;
        this.instProps = new ArrayList();
    }

    public String getClassName() {
        return this.className;
    }

    public String getInstName() {
        return this.instName;
    }

    protected void setInstName(String instName) throws SldServiceException {
        try {
            Integer.parseInt(instName);
        }
        catch (NumberFormatException e) {
            throw new SldServiceException("sld_3013", new Object[]{this.className, e.getMessage()});
        }
        this.instName = instName;
    }

    protected void setInstName(int instNameInt) {
        this.instName = Integer.toString(instNameInt);
    }

    protected J2EEInstProp getProp(String propName) {
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            J2EEInstProp prop = (J2EEInstProp)it.next();
            if (!prop.getName().equalsIgnoreCase(propName)) continue;
            return prop;
        }
        return null;
    }

    public void addPropValue(String propName, String propValueId, String propValue) {
        if (propName != null && propValueId != null) {
            J2EEInstProp prop = this.getProp(propName);
            if (prop == null) {
                this.instProps.add(new J2EEInstProp(this.className, this.instName, propName));
                prop = this.getProp(propName);
            }
            prop.addValueId(propValueId, propValue == null ? "" : propValue);
        }
    }

    public void addPropValue(String propName, String propValue) {
        if (propName != null) {
            J2EEInstProp prop = this.getProp(propName);
            if (prop == null) {
                this.instProps.add(new J2EEInstProp(this.className, this.instName, propName));
                prop = this.getProp(propName);
            }
            prop.addValue(propValue == null ? "" : propValue);
        }
    }

    public void setValues() throws SldServiceException {
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            J2EEInstProp currProp = (J2EEInstProp)it.next();
            currProp.createValuesFromIds();
            currProp.propName = J2EEInst.stripePropName(currProp.propName);
        }
    }

    public void setValueIds() {
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            J2EEInstProp currProp = (J2EEInstProp)it.next();
            currProp.createIdsFromValues();
        }
    }

    protected static String stripePropName(String stuffedPropName) {
        StringBuffer propName = new StringBuffer(stuffedPropName);
        int idx = stuffedPropName.lastIndexOf("_");
        if (idx >= 0) {
            propName.delete(idx, propName.length());
            stuffedPropName = propName.toString();
            idx = stuffedPropName.lastIndexOf("_");
            if (idx >= 0) {
                propName.delete(idx, propName.length());
            }
        }
        return propName.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean isAssociation();

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public String getID() {
        return this.instName;
    }

    public String getProperty(String propName) {
        J2EEInstProp p = this.getProp(propName);
        if (p != null && p.valueCount() == 1) {
            try {
                return p.getFirstValue();
            }
            catch (SldServiceException sldServiceException) {
                // empty catch block
            }
        }
        return null;
    }

    public List getPropertyArray(String propName) {
        ArrayList l = new ArrayList();
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            J2EEInstProp p = (J2EEInstProp)it.next();
            if (!p.getName().equalsIgnoreCase(propName)) continue;
            Iterator pit = p.iterator();
            while (pit.hasNext()) {
                l.add(pit.next());
            }
        }
        return l;
    }

    public List getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>(this.instProps.size());
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            l.add(((J2EEInstProp)it.next()).getName());
        }
        return l;
    }

    public Iterator getPropertyIterator() {
        return ((AbstractList)this.instProps).iterator();
    }

    public int getPropertyCount() {
        return this.instProps.size();
    }

    public List getRoleNames() {
        return new ArrayList();
    }

    public String getAssociationClassname(String roleName) {
        return "";
    }

    public String getAssociationID(String roleName) {
        return "";
    }

    public Iterator getRefIterator() {
        return ((AbstractList)new ArrayList()).iterator();
    }

    public void addRefValue(String className, String roleName, String refValue) {
    }

    public static class J2EEInstRef
    implements ServiceConst,
    Cloneable,
    Comparable {
        private String className;
        private String roleName;
        private String refValue;

        public J2EEInstRef(String roleName, String rawValue) throws SldServiceException {
            this.roleName = roleName;
            StringBuffer classNameBuf = new StringBuffer();
            StringBuffer instNameBuf = new StringBuffer();
            this.getRefInfoFromValue(rawValue, instNameBuf, classNameBuf);
            this.className = classNameBuf.toString();
            this.refValue = instNameBuf.toString();
        }

        public J2EEInstRef(String className, String roleName, String refValue) {
            this.className = className;
            this.roleName = roleName;
            this.refValue = refValue;
        }

        public int compareTo(Object o) throws ClassCastException {
            int rvalue = 0;
            J2EEInstRef r = (J2EEInstRef)o;
            rvalue = this.className.compareTo(r.className) == 0 ? this.roleName.compareTo(r.roleName) : this.className.compareTo(r.className);
            return rvalue;
        }

        public Object clone() {
            J2EEInstRef ref = null;
            try {
                ref = (J2EEInstRef)super.clone();
                ref.refValue = this.refValue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return ref;
        }

        public String getClassName() {
            return this.className;
        }

        void setClassName(String className) {
            this.className = className;
        }

        public String getRoleName() {
            return this.roleName;
        }

        void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public String getInstId() {
            return this.refValue;
        }

        void getRefInfoFromValue(String rawValue, StringBuffer instName, StringBuffer className) throws SldServiceException {
            instName.delete(0, instName.length());
            className.delete(0, className.length());
            int idx = rawValue.indexOf("@");
            if (idx < 0) {
                throw new SldServiceException("sld_3010", new Object[]{rawValue});
            }
            String instNameStr = rawValue.substring(0, idx);
            String classNameStr = rawValue.substring(idx + 1);
            instNameStr = instNameStr.trim();
            classNameStr = classNameStr.trim();
            try {
                Integer.valueOf(instNameStr);
            }
            catch (NumberFormatException e) {
                throw new SldServiceException("sld_3011", new Object[]{rawValue});
            }
            instName.insert(0, instNameStr);
            className.insert(0, classNameStr);
            if (instName.length() == 0 || className.length() == 0) {
                throw new SldServiceException("sld_3011", new Object[]{rawValue});
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof J2EEInstRef)) {
                return false;
            }
            J2EEInstRef otherRef = (J2EEInstRef)obj;
            return this == obj || this.className.equalsIgnoreCase(otherRef.className) && this.roleName.equalsIgnoreCase(otherRef.roleName) && this.refValue.equalsIgnoreCase(otherRef.refValue);
        }

        public int hashCode() {
            return (this.className + this.roleName).hashCode();
        }
    }

    public static class J2EEInstProp
    implements ServiceConst,
    Cloneable,
    Comparable {
        private String className;
        private String instName;
        private String propName;
        private ArrayList propValues;
        private ArrayList propValueIds;

        J2EEInstProp(String className, String instName, String propName) {
            this.className = className;
            this.instName = instName;
            this.propName = propName;
            this.propValues = new ArrayList();
            this.propValueIds = new ArrayList();
        }

        public int compareTo(Object o) throws ClassCastException {
            int rvalue = 0;
            J2EEInstProp p = (J2EEInstProp)o;
            rvalue = this.className.compareTo(p.className) == 0 ? (this.instName.compareTo(p.instName) == 0 ? this.propName.compareTo(p.propName) : this.instName.compareTo(p.instName)) : this.className.compareTo(p.className);
            return rvalue;
        }

        public Object clone() {
            J2EEInstProp prop = null;
            try {
                prop = (J2EEInstProp)super.clone();
                prop.propValues = new ArrayList(this.propValues.size());
                Iterator it = ((AbstractList)this.propValues).iterator();
                while (it.hasNext()) {
                    prop.propValues.add((String)it.next());
                }
                prop.propValueIds = new ArrayList(this.propValueIds.size());
                Iterator it2 = ((AbstractList)this.propValueIds).iterator();
                while (it2.hasNext()) {
                    ValueId vid = (ValueId)it2.next();
                    prop.propValueIds.add((ValueId)vid.clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return prop;
        }

        public String getName() {
            return this.propName;
        }

        void setName(String propName) {
            this.propName = propName;
        }

        void addValueId(String id, String propValue) {
            this.propValueIds.add(new ValueId(this.propName, id, propValue));
        }

        void addValue(String propValue) {
            this.propValues.add(propValue);
        }

        Iterator iterator() {
            return ((AbstractList)this.propValues).iterator();
        }

        public String getFirstValue() throws SldServiceException {
            if (this.propValues == null || this.propValues.size() == 0) {
                throw new SldServiceException("sld_3009", new Object[]{this.instName, this.className});
            }
            return (String)this.propValues.get(0);
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof J2EEInstProp)) {
                return false;
            }
            J2EEInstProp otherProp = (J2EEInstProp)otherObj;
            if (this != otherProp) {
                if (!otherProp.propName.equalsIgnoreCase(this.propName)) {
                    return false;
                }
                if (otherProp.valueCount() != this.valueCount()) {
                    return false;
                }
                Iterator it = otherProp.iterator();
                while (it.hasNext()) {
                    if (!this.hasValue((String)it.next())) continue;
                    return true;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.propName.toLowerCase().hashCode();
        }

        public boolean hasMultipleValues() {
            return this.propValues.size() > 1;
        }

        public boolean hasValue(String v) {
            Iterator it = ((AbstractList)this.propValues).iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (!s.equals(v)) continue;
                return true;
            }
            return false;
        }

        int getPartNumber() {
            String subStr;
            int idx;
            if (this.propName != null && (idx = this.propName.lastIndexOf("_")) > 0 && (subStr = this.propName.substring(idx + 1)).length() != 0) {
                try {
                    Integer intVal = new Integer(subStr);
                    return intVal;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }

        String getRealName() {
            if (this.getPartNumber() == -1) {
                return this.propName;
            }
            int idx = this.propName.lastIndexOf("_");
            return this.propName.substring(0, idx);
        }

        void createValuesFromIds() {
            int sz = this.propValueIds.size();
            int i = 0;
            while (i < sz) {
                ValueId vid = (ValueId)this.propValueIds.get(i);
                if (vid.getPartNumber() == -1) {
                    this.propValues.add(vid.value);
                } else {
                    String realName = vid.getRealName();
                    StringBuffer resultValue = new StringBuffer();
                    TreeMap<Integer, String> valueParts = new TreeMap<Integer, String>();
                    int j = 0;
                    while (j < sz) {
                        int partNum;
                        ValueId vidPart = (ValueId)this.propValueIds.get(j);
                        if (vidPart.id.startsWith(realName) && (partNum = vidPart.getPartNumber()) != -1) {
                            valueParts.put(new Integer(partNum), vidPart.value);
                        }
                        ++j;
                    }
                    Iterator it = valueParts.values().iterator();
                    while (it.hasNext()) {
                        String valuePart = (String)it.next();
                        resultValue.append(valuePart);
                    }
                    this.propValues.add(resultValue.toString());
                }
                ++i;
            }
        }

        void createIdsFromValues() {
            int vc = 0;
            ArrayList vp = null;
            this.propValueIds.clear();
            Iterator it = ((AbstractList)this.propValues).iterator();
            while (it.hasNext()) {
                String propValue = (String)it.next();
                if (propValue.length() > 255) {
                    vp = this.chopValue(String.valueOf(vc), propValue);
                    Iterator iter = ((AbstractList)vp).iterator();
                    while (iter.hasNext()) {
                        this.propValueIds.add((ValueId)iter.next());
                    }
                } else {
                    this.propValueIds.add(new ValueId(this.propName, String.valueOf(vc), propValue));
                }
                ++vc;
            }
        }

        private ArrayList chopValue(String valueCount, String value) {
            ArrayList<ValueId> l = new ArrayList<ValueId>();
            if (value.length() <= 255) {
                l.add(new ValueId(this.propName, valueCount, value));
            } else {
                StringBuffer vb = new StringBuffer(value);
                int pc = 0;
                int b = 0;
                int e = 255;
                while (b < vb.length()) {
                    String ts = vb.substring(b, e);
                    l.add(new ValueId(this.propName, valueCount + "_" + String.valueOf(pc), ts));
                    b = e;
                    e = Math.min(e + 255, vb.length());
                    ++pc;
                }
            }
            return l;
        }

        int valueCount() {
            if (this.propValues == null) {
                this.propValues = new ArrayList();
            }
            return this.propValues.size();
        }

        String[] getValueArray() {
            int i = 0;
            String[] values = new String[this.valueCount()];
            Iterator it = ((AbstractList)this.propValues).iterator();
            while (it.hasNext()) {
                String val = (String)it.next();
                values[i++] = val;
            }
            return values;
        }

        public Iterator getValueIdsIterator() {
            return ((AbstractList)this.propValueIds).iterator();
        }

        public int getValudIdsCount() {
            return this.propValueIds.size();
        }

        public Iterator getValueIterator() {
            return ((AbstractList)this.propValues).iterator();
        }

        public static class ValueId
        implements Cloneable {
            private String propName;
            private String id;
            private String value;

            ValueId(String propName, String id, String value) {
                this.propName = propName;
                this.id = id;
                this.value = value;
            }

            public Object clone() {
                ValueId v = null;
                try {
                    v = (ValueId)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                return v;
            }

            public String getId() {
                return this.id;
            }

            public String getValue() {
                return this.value;
            }

            int getPartNumber() {
                String subStr;
                int idx;
                if (this.id != null && (idx = this.id.lastIndexOf("_")) > 0 && (subStr = this.id.substring(idx + 1)).length() != 0) {
                    try {
                        Integer intVal = new Integer(subStr);
                        return intVal;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return -1;
            }

            String getRealName() {
                if (this.getPartNumber() == -1) {
                    return this.propName;
                }
                int idx = this.propName.lastIndexOf("_");
                return this.propName.substring(0, idx);
            }
        }
    }
}

