/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.sldserv.J2EEClass;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.tc.logging.Location;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class J2EEData
implements Cloneable {
    private static final String FILE_BASE_NAME = "J2EEDATA";
    private String typeId;
    private String versionId;
    private HashMap data = new HashMap();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldServerFrame == null ? (class$com$sap$sldserv$SldServerFrame = J2EEData.class$("com.sap.sldserv.SldServerFrame")) : class$com$sap$sldserv$SldServerFrame));
    static /* synthetic */ Class class$com$sap$sldserv$SldServerFrame;

    public J2EEData(String typeId, String versionId) {
        this.typeId = typeId;
        this.versionId = versionId;
    }

    public Object clone() {
        J2EEData o = null;
        try {
            o = (J2EEData)super.clone();
            o.data = new HashMap(this.data.size());
            Iterator it = this.data.values().iterator();
            while (it.hasNext()) {
                J2EEClass clazz = (J2EEClass)it.next();
                o.data.put(clazz.getName(), (J2EEClass)clazz.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public void addClass(J2EEClass clazz) {
        if (clazz != null && clazz.getInstanceCount() > 0) {
            this.data.put(clazz.getName(), clazz);
        }
    }

    public void mergeClass(J2EEClass clazz) throws SldServiceException {
        if (clazz != null && clazz.getInstanceCount() > 0) {
            if (this.data.containsKey(clazz.getName())) {
                J2EEClass exClass = (J2EEClass)this.data.get(clazz.getName());
                exClass.merge(clazz);
            } else {
                this.addClass(clazz);
            }
        }
    }

    public void removeClass(J2EEClass clazz) {
        this.data.remove(clazz);
    }

    public void removeClasses(ArrayList classList) {
        Iterator it = ((AbstractList)classList).iterator();
        while (it.hasNext()) {
            this.data.remove((J2EEClass)it.next());
        }
    }

    public int classCount() {
        return this.data.size();
    }

    J2EEClass getNewObjectClass(String className) throws SldServiceException {
        if (this.data.containsKey(className)) {
            throw new SldServiceException("sld_3007", new Object[]{className});
        }
        return new J2EEClass(className);
    }

    J2EEClass getNewAssocClass(String className) throws SldServiceException {
        if (this.data.containsKey(className)) {
            throw new SldServiceException("sld_3008", new Object[]{className});
        }
        return new J2EEClass(className, false);
    }

    public Iterator getClassIterator() {
        return this.data.values().iterator();
    }

    public J2EEClass getClass(String className) {
        return (J2EEClass)this.data.get(className);
    }

    public boolean contains(String className) {
        return this.data.get(className) != null;
    }

    public boolean contains(J2EEClass clazz) {
        return this.data.get(clazz.getName()) != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof J2EEData) || obj == null) {
            return false;
        }
        if (this != obj) {
            J2EEData otherData = (J2EEData)obj;
            if (this.data.size() != otherData.data.size()) {
                return false;
            }
            Iterator cit = otherData.getClassIterator();
            while (cit.hasNext()) {
                J2EEClass otherClass = (J2EEClass)cit.next();
                J2EEClass thisClass = this.getClass(otherClass.getName());
                if (thisClass == null) {
                    return false;
                }
                if (thisClass.equals(otherClass)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashMap clonedData = (HashMap)this.data.clone();
        Arrays.sort(clonedData.values().toArray());
        return clonedData.toString().hashCode();
    }

    public List getClassNames() {
        ArrayList<String> l = new ArrayList<String>(this.data.size());
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            J2EEClass c = (J2EEClass)it.next();
            l.add(c.getName());
        }
        return l;
    }

    public int getClassCount() {
        return this.data != null ? this.data.size() : 0;
    }

    public List getInstances(String className) {
        if (this.data.containsKey(className)) {
            J2EEClass clazz = (J2EEClass)this.data.get(className);
            ArrayList l = new ArrayList(clazz.getInstanceCount());
            Iterator it = clazz.instanceIterator();
            while (it.hasNext()) {
                l.add(it.next());
            }
            return l;
        }
        return new ArrayList();
    }

    public String getType() {
        return this.typeId;
    }

    public String getVersion() {
        return this.versionId;
    }

    public boolean empty() {
        return this.data == null || this.data.size() == 0;
    }

    public void merge(J2EEData additionalData) throws SldServiceException {
        if (additionalData != null) {
            Iterator it = additionalData.getClassIterator();
            while (it.hasNext()) {
                J2EEClass clazz = (J2EEClass)it.next();
                J2EEClass exClazz = (J2EEClass)this.data.get(clazz.getName());
                if (exClazz == null) {
                    this.addClass(clazz);
                    continue;
                }
                exClazz.merge(clazz);
            }
        }
    }

    public void write2File() {
        try {
            DecimalFormat dff = new DecimalFormat("00");
            DecimalFormat d4f = new DecimalFormat("0000");
            StringBuffer title = new StringBuffer(30);
            GregorianCalendar cal = new GregorianCalendar();
            cal.getTime();
            title.append(d4f.format(cal.get(1)));
            title.append(dff.format(cal.get(2) + 1));
            title.append(dff.format(cal.get(5)));
            title.append(dff.format(cal.get(11)));
            title.append(dff.format(cal.get(12)));
            title.append(dff.format(cal.get(13)));
            String fileName = FILE_BASE_NAME + title.toString() + ".xls";
            File exportfile = new File(fileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(exportfile)));
            LOCATION.debugT("Writing J2EE data file: " + exportfile.getAbsolutePath());
            out.println("Classname\tProperty Name\tValue");
            Iterator clIt = this.data.values().iterator();
            while (clIt.hasNext()) {
                J2EEClass clazz = (J2EEClass)clIt.next();
                String className = clazz.getName();
                Iterator instIt = clazz.instanceIterator();
                while (instIt.hasNext()) {
                    J2EEInst inst = (J2EEInst)instIt.next();
                    out.println();
                    out.println(className + " (" + inst.getID() + ")");
                    Iterator propIt = inst.getPropertyIterator();
                    while (propIt.hasNext()) {
                        J2EEInst.J2EEInstProp prop = (J2EEInst.J2EEInstProp)propIt.next();
                        String propName = prop.getName();
                        if (inst.isAssociation()) {
                            out.println("\t" + propName + "\t" + "class=" + inst.getAssociationClassname(propName) + " - inst#=" + inst.getAssociationID(propName));
                            continue;
                        }
                        if (inst.getProperty(propName) != null) {
                            out.println("\t" + propName + "\t" + inst.getProperty(propName));
                            continue;
                        }
                        StringBuffer propValue = new StringBuffer();
                        List propArray = inst.getPropertyArray(propName);
                        if (propArray != null) {
                            Iterator valiter = propArray.iterator();
                            while (valiter.hasNext()) {
                                if (propValue.length() != 0) {
                                    propValue.append(",");
                                }
                                propValue.append((String)valiter.next());
                            }
                        }
                        out.println("\t" + propName + "\t" + propValue.toString());
                    }
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

